/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.api.IMetaClass;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.PluginMetricLevel;
import com.hello2morrow.sonargraph.core.api.model.PluginProgrammingElement;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.k;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.l;
import com.hello2morrow.sonargraph.core.controller.system.as;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.controller.system.c;
import com.hello2morrow.sonargraph.core.controller.system.plugin.b;
import com.hello2morrow.sonargraph.core.controllerinterface.system.p;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.PluginAnalyzer;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.InstallationModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.MetricDescriptor;
import com.hello2morrow.sonargraph.core.model.metrics.PluginMetricId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginExternal;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginMetricProvider;
import com.hello2morrow.sonargraph.core.model.plugin.PluginProviderId;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.MetricProviders;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginConfiguration;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginExtension
extends Extension
implements as.c,
m,
p {
    private static final Logger b = LoggerFactory.getLogger(PluginExtension.class);
    private final Map<String, PluginProviderId> c = new THashMap();
    private final Map<String, Set<SonargraphPlugin>> e = new THashMap();
    private final ISoftwareSystemProvider f;
    private final aa g;
    private final g h;
    private static volatile /* synthetic */ int[] i;
    private static volatile /* synthetic */ int[] j;

    public PluginExtension(ISoftwareSystemProvider softwareSystemProvider, aa accessor, g finishModelProcessor) {
        assert (softwareSystemProvider != null) : "Parameter 'softwareSystemProvider' of method 'PluginExtension' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'PluginExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'PluginExtension' must not be null";
        this.f = softwareSystemProvider;
        this.g = accessor;
        this.h = finishModelProcessor;
        this.h.a(this);
    }

    @Override
    public SonargraphPlugin a(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getPluginById' must not be empty";
        for (PluginProviderId next : this.f.getInstallation().getProviderIds(PluginProviderId.class)) {
            if (!next.getPlugin().getId().equals(id)) continue;
            return next.getPlugin();
        }
        return null;
    }

    @Override
    public List<SonargraphPlugin> getPlugins() {
        List<PluginProviderId> pluginProviderIds = this.f.getInstallation().getProviderIds(PluginProviderId.class);
        if (pluginProviderIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SonargraphPlugin> plugins = new ArrayList<SonargraphPlugin>(pluginProviderIds.size());
        for (PluginProviderId nextPluginProviderId : pluginProviderIds) {
            plugins.add(nextPluginProviderId.getPlugin());
        }
        return plugins;
    }

    private PluginExternal a(Workspace workspace, final String identifier, final Language language) {
        assert (workspace != null) : "Parameter 'workspace' of method 'findPluginExternal' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'findPluginExternal' must not be empty";
        assert (language != null) : "Parameter 'language' of method 'findPluginExternal' must not be null";
        return workspace.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof PluginExternal)) {
                    throw new AssertionError((Object)("Unexpected class in method 'findPluginExternal': " + namedElement));
                }
                return language.equals(namedElement.getLanguage()) && identifier.equals(((PluginExternal)namedElement).getIdentifier());
            }
        }, PluginExternal.class);
    }

    private void a(IWorkerContext workerContext, SonargraphPlugin plugin, IPluginModelContributor contributor, ExecutionPhase phase, l pluginContextAdapter, SoftwareSystem softwareSystem, OperationResult result) {
        block20: {
            block19: {
                assert (plugin != null) : "Parameter 'plugin' of method 'executeModelContribution' must not be null";
                assert (contributor != null) : "Parameter 'contributor' of method 'executeModelContribution' must not be null";
                assert (phase != null) : "Parameter 'phase' of method 'executeModelContribution' must not be null";
                assert (pluginContextAdapter != null) : "Parameter 'pluginContextAdapter' of method 'executeModelPlugin' must not be null";
                assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'executeModelPlugin' must not be null";
                assert (result != null) : "Parameter 'result' of method 'executeModelPlugin' must not be null";
                PluginProviderId pluginProviderId = this.c.get(plugin.getId());
                assert (pluginProviderId != null) : "'pluginProviderId' of method 'executeModelContribution' must not be null for: " + plugin.getId();
                softwareSystem.getIssueManager().removeIssues(pluginProviderId);
                Set supportedLanguages = plugin.getSupportedLanguages();
                if (supportedLanguages == null) break block19;
                if (!softwareSystem.getUsedLanguageStandardNames().stream().anyMatch(supportedLanguages::contains)) break block20;
            }
            b.debug("Execute model plugin '" + plugin.getId() + "' [" + (Object)((Object)phase) + "]");
            switch (PluginExtension.a()[phase.ordinal()]) {
                case 1: {
                    try {
                        contributor.createModelElements((IPluginContext)pluginContextAdapter);
                    }
                    catch (Throwable throwable) {
                        result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.PLUGIN_EXCEPTION, throwable, "Plugin '" + plugin.getId() + "' refresh (model elements) failed.", new Object[0]);
                        b.error(String.format("Plugin '%s' refresh (model elements) failed with an exception", plugin.getId()), throwable);
                    }
                    break;
                }
                case 2: {
                    try {
                        contributor.createDependencies((IPluginContext)pluginContextAdapter);
                    }
                    catch (Throwable throwable) {
                        result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.PLUGIN_EXCEPTION, throwable, "Plugin '" + plugin.getId() + "' refresh (dependencies) failed.", new Object[0]);
                        b.error(String.format("Plugin '%s' refresh (dependencies) failed with an exception", plugin.getId()), throwable);
                    }
                    break;
                }
                default: {
                    assert (false) : "Unsupported phase: " + (Object)((Object)phase);
                    break;
                }
            }
            b.debug("Execute model plugin '" + plugin.getId() + "' [" + (Object)((Object)phase) + "] - done");
        }
    }

    private List<StrictPair<SonargraphPlugin, IPluginModelContributor>> c() {
        List<SonargraphPlugin> plugins = this.getPlugins();
        if (plugins.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = new ArrayList<StrictPair<SonargraphPlugin, IPluginModelContributor>>();
        for (SonargraphPlugin nextPlugin : plugins) {
            IPluginModelContributor nextModelContributor;
            if (!nextPlugin.isEnabled() || (nextModelContributor = nextPlugin.getModelContributor()) == null) continue;
            modelContributors.add((StrictPair<SonargraphPlugin, IPluginModelContributor>)new StrictPair((Object)nextPlugin, (Object)nextModelContributor));
        }
        return modelContributors;
    }

    private void a(SoftwareSystem softwareSystem, List<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors, boolean removePluginExternal) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clearModelContributions' must not be null";
        assert (modelContributors != null && !modelContributors.isEmpty()) : "Parameter 'modelContributors' of method 'clearModelContributions' must not be empty";
        Installation installation = this.f.getInstallation();
        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
        for (StrictPair<SonargraphPlugin, IPluginModelContributor> next : modelContributors) {
            SonargraphPlugin nextPlugin = (SonargraphPlugin)next.getFirst();
            String nextId = nextPlugin.getId();
            List<IMetaClass> metaClasses = installation.findMetaClasses(m2 -> m2.getPluginId().equals(nextId));
            List<IParserDependencyType> dependencyTypes = installation.findFirstParserDependencyTypes(m2 -> m2.getPluginId().equals(nextId));
            if (!metaClasses.isEmpty() || !dependencyTypes.isEmpty()) {
                a visitor = new a(nextPlugin, metaClasses, dependencyTypes);
                for (ComponentContainer nextComponentContainer : workspace.getChildren(ComponentContainer.class)) {
                    nextComponentContainer.accept(visitor);
                    visitor.a();
                }
            }
            for (Language nextLanguage : softwareSystem.getUsedLanguages()) {
                PluginExternal pluginExternal = this.a(workspace, nextId, nextLanguage);
                if (pluginExternal == null) continue;
                if (removePluginExternal) {
                    pluginExternal.remove();
                    continue;
                }
                pluginExternal.forgetChildren(true);
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToModifyParserModel' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToModifyParserModel' must not be null";
        List<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = this.c();
        if (!modelContributors.isEmpty()) {
            this.a(softwareSystem, modelContributors, false);
        }
    }

    private l a(IWorkerContext workerContext, SonargraphPlugin plugin) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createPluginContextAdapter' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'createPluginContextAdapter' must not be null";
        assert (this.f.hasSoftwareSystem()) : "No system available";
        THashMap access = new THashMap();
        access.put(IPluginCoreAccess.class, new b(this.f.getInstallation(), this.f.getSoftwareSystem(), true));
        Set supportedLanguages = plugin.getSupportedLanguages();
        if (supportedLanguages != null) {
            for (String nextLanguageName : supportedLanguages) {
                Language nextLanguage = this.g.a(nextLanguageName);
                assert (nextLanguage != null) : "'nextLanguage' of method 'internalRun' must not be null";
                this.g.b(nextLanguage).a(this.f.getInstallation(), this.f.getSoftwareSystem(), (Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess>)access);
            }
        }
        return new l(workerContext, (Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess>)access);
    }

    private void a(IWorkerContext workerContext, Collection<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'executeModelContributorPlugins' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'executeModelContributorPlugins' must not be null";
        assert (modelContributors != null && !modelContributors.isEmpty()) : "Parameter 'modelContributors' of method 'executeModelContributorPlugins' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'executeModelContributorPlugins' must not be null";
        if (!modelContributors.isEmpty()) {
            l nextPluginContextAdapter;
            for (StrictPair<SonargraphPlugin, IPluginModelContributor> next : modelContributors) {
                nextPluginContextAdapter = this.a(workerContext, (SonargraphPlugin)next.getFirst());
                this.a(workerContext, (SonargraphPlugin)next.getFirst(), (IPluginModelContributor)next.getSecond(), ExecutionPhase.MODEL_ELEMENTS, nextPluginContextAdapter, softwareSystem, result);
            }
            for (StrictPair<SonargraphPlugin, IPluginModelContributor> next : modelContributors) {
                nextPluginContextAdapter = this.a(workerContext, (SonargraphPlugin)next.getFirst());
                this.a(workerContext, (SonargraphPlugin)next.getFirst(), (IPluginModelContributor)next.getSecond(), ExecutionPhase.DEPENDENCIES, nextPluginContextAdapter, softwareSystem, result);
            }
        }
    }

    @Override
    public void b(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshPerformed' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'refreshPerformed' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshPerformed' must not be null";
        List<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = this.c();
        if (!modelContributors.isEmpty()) {
            this.a(workerContext, modelContributors, softwareSystem, result);
        }
    }

    @Override
    public void b(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'aboutToClear' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'aboutToClear' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'aboutToClear' must not be null";
        assert (result != null) : "Parameter 'result' of method 'aboutToClear' must not be null";
        for (SonargraphPlugin nextPlugin : this.getPlugins()) {
            if (!nextPlugin.isEnabled()) continue;
            PluginProviderId nextPluginProviderId = this.c.get(nextPlugin.getId());
            assert (nextPluginProviderId != null) : "'nextPluginProviderId' of method 'aboutToClear' must not be null for: " + nextPlugin.getId();
            softwareSystem.getIssueManager().removeIssues(nextPluginProviderId);
            Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
            for (Language next : softwareSystem.getUsedLanguages()) {
                PluginExternal pluginExternal = this.a(workspace, nextPlugin.getId(), next);
                if (pluginExternal == null) continue;
                pluginExternal.removeChildren(new Class[0]);
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'cleared' must not be null";
        assert (result != null) : "Parameter 'result' of method 'cleared' must not be null";
        List<SonargraphPlugin> plugins = this.getPlugins();
        if (!plugins.isEmpty()) {
            Set<String> usedLanguageStandardNames = softwareSystem.getUsedLanguageStandardNames();
            for (SonargraphPlugin nextPlugin : plugins) {
                try {
                    Set nextSupportedLanguages = nextPlugin.getSupportedLanguages();
                    if (!nextPlugin.isEnabled()) continue;
                    if (nextSupportedLanguages != null) {
                        if (!usedLanguageStandardNames.stream().anyMatch(nextSupportedLanguages::contains)) continue;
                    }
                    l nextPluginContextAdapter = this.a(workerContext, nextPlugin);
                    nextPlugin.cleared((IPluginContext)nextPluginContextAdapter);
                }
                catch (Throwable e2) {
                    result.addWarning((OperationResult.IMessageCause)SoftwareSystemMessageCause.PLUGIN_EXCEPTION, e2, "Plugin '" + nextPlugin.getId() + "' clear failed.", new Object[0]);
                    b.error(String.format("Plugin '%s' clear failed with an exception", nextPlugin.getId()), e2);
                }
            }
        }
    }

    @Override
    public void a(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        List<SonargraphPlugin> plugins = this.getPlugins();
        for (SonargraphPlugin nextPlugin : plugins) {
            SonargraphPluginConfiguration pluginConfiguration = nextPlugin.getConfiguration();
            pluginConfiguration.updateValues(pluginConfiguration.getDefaultValues());
        }
    }

    private PluginAnalyzer a(Analyzers analyzers, final String pluginId) {
        assert (analyzers != null) : "Parameter 'analyzers' of method 'findPluginAnalyzer' must not be null";
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'findPluginAnalyzer' must not be empty";
        return analyzers.getFirstChild(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                if (!(a || namedElement != null && namedElement instanceof PluginAnalyzer)) {
                    throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
                }
                return pluginId.equals(((PluginAnalyzer)namedElement).getId().getStandardName());
            }
        }, PluginAnalyzer.class);
    }

    private void a(SoftwareSystem softwareSystem, SonargraphPlugin plugin, as.b info, boolean hasEnabledStateChanged, boolean isEnabled, EnumSet<Modification> modifications) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'disablePlugin' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'disableModelPlugin' must not be null";
        assert (info != null) : "Parameter 'info' of method 'disablePlugin' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'disablePlugin' must not be null";
        b.debug("Disable plugin '" + plugin.getId() + "'");
        PluginConfigurationFile pluginConfigurationFile = softwareSystem.getExtension(as.class).getPluginConfigurationFile(plugin.getId());
        assert (pluginConfigurationFile != null) : "Parameter 'pluginConfigurationFile' of method 'disablePlugin' must not be null";
        pluginConfigurationFile.removeIssues(CoreIssueId.PLUGIN_EXCEPTION);
        IPluginModelContributor modelContributor = plugin.getModelContributor();
        IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
        if (modelContributor != null || analyzerContributor != null) {
            if (modelContributor != null) {
                this.a(softwareSystem, Collections.singletonList(new StrictPair((Object)plugin, (Object)modelContributor)), true);
                modifications.add(Modification.SYSTEM_MODIFIED);
                for (Map.Entry<String, Set<SonargraphPlugin>> entry : this.e.entrySet()) {
                    Set<SonargraphPlugin> plugins = entry.getValue();
                    if (!plugins.contains(plugin)) continue;
                    for (SonargraphPlugin nextForMetaClass : plugins) {
                        IPluginModelContributor nextAffectedModelContributor = nextForMetaClass.getModelContributor();
                        assert (nextAffectedModelContributor != null) : "Not a model contributor: " + nextForMetaClass.getId();
                        if (!isEnabled && nextForMetaClass == plugin) continue;
                        info.a((StrictPair<SonargraphPlugin, IPluginModelContributor>)new StrictPair((Object)nextForMetaClass, (Object)nextAffectedModelContributor));
                    }
                }
            }
            if (analyzerContributor != null) {
                com.hello2morrow.sonargraph.core.controller.system.plugin.a pluginAnalyzerId = new com.hello2morrow.sonargraph.core.controller.system.plugin.a(plugin);
                PluginProviderId pluginProviderId = this.c.get(plugin.getId());
                if (softwareSystem.getExtension(c.class).a(pluginAnalyzerId)) {
                    b.debug("Removed plugin analyzer adapter '" + pluginAnalyzerId + "'");
                    assert (pluginProviderId != null) : "'pluginProviderId' of method 'executeModelContribution' must not be null for: " + plugin.getId();
                    softwareSystem.getIssueManager().removeIssues(pluginProviderId);
                    modifications.add(Modification.AVAILABLE_ANALYZER_PLUGINS_MODIFIED);
                }
            }
        }
        b.debug("Disable plugin '" + plugin.getId() + "' - done");
    }

    private as.a a(SoftwareSystem softwareSystem, SonargraphPlugin plugin, boolean hasEnabledStateChanged, boolean isEnabled) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cancelAndResetAffectedAnalyzers' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'cancelAndResetAffectedAnalyzers' must not be null";
        b.debug("Cancel and reset analyzers for modification of '" + plugin.getId() + "'");
        as.a restartInfo = null;
        if (softwareSystem.isClearable() && (isEnabled || hasEnabledStateChanged)) {
            IPluginModelContributor modelContributor = plugin.getModelContributor();
            IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
            if (modelContributor != null || analyzerContributor != null) {
                c analyzerExtension = softwareSystem.getExtension(c.class);
                if (modelContributor != null) {
                    restartInfo = new as.a();
                    analyzerExtension.a(ResetMode.ALL);
                } else if (analyzerContributor != null) {
                    THashSet affected = new THashSet(analyzerExtension.g());
                    com.hello2morrow.sonargraph.core.controller.system.plugin.a pluginAnalyzerId = new com.hello2morrow.sonargraph.core.controller.system.plugin.a(plugin);
                    if (isEnabled) {
                        affected.add(pluginAnalyzerId);
                    }
                    restartInfo = new as.a(analyzerExtension.a_((Set<IAnalyzerId>)affected));
                    if (!isEnabled) {
                        restartInfo.a(pluginAnalyzerId);
                    }
                }
            }
        }
        b.debug("Cancel and reset analyzers for modification of '" + plugin.getId() + "' - done [" + "Affected analyzers: " + (restartInfo == null ? "none" : restartInfo.toString()) + "]");
        return restartInfo;
    }

    IConfigurableAnalyzerId a(SoftwareSystem softwareSystem, SonargraphPlugin plugin) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getPluginAnalyzerId' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'getPluginAnalyzerId' must not be null";
        Analyzers analyzers = softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers();
        PluginAnalyzer analyzer = this.a(analyzers, plugin.getId());
        return analyzer == null ? null : analyzer.getId();
    }

    private IPluginModelContributor b(SoftwareSystem softwareSystem, SonargraphPlugin plugin) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setupModelContribution' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'setupModelContribution' must not be null";
        IPluginModelContributor modelContributor = plugin.getModelContributor();
        if (modelContributor != null) {
            Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
            for (Language next : softwareSystem.getUsedLanguages()) {
                PluginExternal pluginExternal = this.a(workspace, plugin.getId(), next);
                assert (pluginExternal == null) : "'found' of method 'setupModelContribution' must be null";
                pluginExternal = new PluginExternal(workspace, plugin.getId(), next);
                workspace.addChild(pluginExternal);
            }
            return modelContributor;
        }
        return null;
    }

    private IPluginAnalyzerContributor c(SoftwareSystem softwareSystem, SonargraphPlugin plugin) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setupAnalyzerContribution' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'setupAnalyzerContribution' must not be null";
        IPluginAnalyzerContributor analyzerContributor = plugin.getAnalyzerContributor();
        if (analyzerContributor != null) {
            Analyzers analyzers = softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers();
            assert (this.a(analyzers, plugin.getId()) == null) : "Analyzer plugin already created for: " + plugin.getId();
            com.hello2morrow.sonargraph.core.controller.system.plugin.a pluginAnalyzerId = new com.hello2morrow.sonargraph.core.controller.system.plugin.a(plugin);
            c analyzerExtension = softwareSystem.getExtension(c.class);
            PluginAnalyzer pluginAnalyzer = new PluginAnalyzer(analyzers, pluginAnalyzerId);
            analyzers.addChild(pluginAnalyzer);
            PluginProviderId pluginProviderId = this.c.get(plugin.getId());
            assert (pluginProviderId != null) : "'pluginProviderId' of method 'setupAnalyzerContribution' must not be null";
            PluginMetricProvider pmp = this.f.getInstallation().getMetricProviders().getChildren(PluginMetricProvider.class).stream().filter(c2 -> c2.getProvider() == pluginProviderId).findFirst().orElse(null);
            List<MetricDescriptor> metricDescriptors = pmp == null ? Collections.emptyList() : pmp.getChildren(MetricDescriptor.class);
            k pluginAnalyzerAdapter = new k(pluginProviderId, plugin, analyzerContributor, analyzerExtension, pluginAnalyzerId, metricDescriptors);
            boolean isLicensed = analyzerExtension.a(pluginAnalyzerAdapter);
            b.debug("Added plugin analyzer adapter '" + pluginAnalyzerId + "'");
            assert (isLicensed) : "If an analyzer plugin is added it must be licensed. Not licensed: " + pluginAnalyzerId;
            return analyzerContributor;
        }
        return null;
    }

    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'softwareSystemOpened' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'softwareSystemOpened' must not be null";
        assert (result != null) : "Parameter 'result' of method 'softwareSystemOpened' must not be null";
        List<PluginProviderId> pluginProviderIds = this.f.getInstallation().getProviderIds(PluginProviderId.class);
        if (!pluginProviderIds.isEmpty()) {
            b.debug("Install " + pluginProviderIds.size() + " plugins");
            as pluginConfigurationExtension = softwareSystem.getExtension(as.class);
            pluginProviderIds.forEach(i2 -> {
                boolean bl2 = pluginConfigurationExtension.a(i2.getPlugin(), result);
            });
            ArrayList<StrictPair> modelContributors = snapshotApplied ? new ArrayList<StrictPair>() : null;
            for (SonargraphPlugin nextPlugin : this.getPlugins()) {
                if (!nextPlugin.isEnabled()) continue;
                IPluginModelContributor nextModelContributor = this.b(softwareSystem, nextPlugin);
                if (nextModelContributor != null && modelContributors != null) {
                    modelContributors.add(new StrictPair((Object)nextPlugin, (Object)nextModelContributor));
                }
                this.c(softwareSystem, nextPlugin);
            }
            if (modelContributors != null && !modelContributors.isEmpty()) {
                l nextPluginContextAdapter;
                for (StrictPair next : modelContributors) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    nextPluginContextAdapter = this.a(workerContext, (SonargraphPlugin)next.getFirst());
                    this.a(workerContext, (SonargraphPlugin)next.getFirst(), (IPluginModelContributor)next.getSecond(), ExecutionPhase.MODEL_ELEMENTS, nextPluginContextAdapter, softwareSystem, result);
                }
                for (StrictPair next : modelContributors) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    nextPluginContextAdapter = this.a(workerContext, (SonargraphPlugin)next.getFirst());
                    this.a(workerContext, (SonargraphPlugin)next.getFirst(), (IPluginModelContributor)next.getSecond(), ExecutionPhase.DEPENDENCIES, nextPluginContextAdapter, softwareSystem, result);
                }
            }
            b.debug("Install " + pluginProviderIds.size() + " plugins - done");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OperationResult a(IWorkerContext workerContext, PluginProviderId pluginProviderId, Set<PluginIssueId> pluginIssueIds, Set<IMetaClass> metaClasses, Set<IParserDependencyType> parserDependencyTypes, Set<PluginMetricId> metricIds) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'installPlugin' must not be null";
        assert (pluginProviderId != null) : "Parameter 'pluginIssueProviderId' of method 'installPlugin' must not be null";
        assert (pluginIssueIds != null) : "Parameter 'pluginIssueIds' of method 'installPlugin' must not be null";
        assert (metaClasses != null) : "Parameter 'metaClasses' of method 'installPlugin' must not be null";
        assert (parserDependencyTypes != null) : "Parameter 'parserDependencyTypes' of method 'installPlugin' must not be null";
        assert (metricIds != null) : "Parameter 'metricIds' of method 'installPlugin' must not be null";
        SonargraphPlugin plugin = pluginProviderId.getPlugin();
        String pluginId = plugin.getId();
        OperationResult result = new OperationResult("Install plugin '" + pluginId + "'");
        PluginProviderId previous = this.c.put(pluginId, pluginProviderId);
        assert (previous == null) : "'previous' of method 'installPlugin' must be null for: " + pluginId;
        Installation installation = this.f.getInstallation();
        installation.addProviderIds(Collections.singleton(pluginProviderId));
        installation.addIssueIds(pluginIssueIds);
        installation.addMetaClasses(metaClasses);
        installation.addParserDependencyTypes(parserDependencyTypes);
        if (!metricIds.isEmpty()) {
            MetricProviders mp = installation.getMetricProviders();
            PluginMetricProvider pmp = new PluginMetricProvider((NamedElement)mp, pluginProviderId);
            mp.addChild(pmp);
            com.hello2morrow.sonargraph.core.controller.system.plugin.a analyzerId = new com.hello2morrow.sonargraph.core.controller.system.plugin.a(pluginProviderId.getPlugin());
            for (IPluginMetricId iPluginMetricId : metricIds) {
                for (PluginMetricLevel pl : iPluginMetricId.getAvailableLevels()) {
                    CoreMetricLevel level = null;
                    switch (PluginExtension.b()[pl.ordinal()]) {
                        case 1: {
                            level = CoreMetricLevel.SYSTEM;
                            break;
                        }
                        case 2: {
                            level = CoreMetricLevel.MODULE;
                            break;
                        }
                        case 3: {
                            level = CoreMetricLevel.SOURCE_FILE;
                        }
                    }
                    pmp.addChild(new MetricDescriptor(pmp, (PluginMetricId)iPluginMetricId, level, analyzerId, null, null));
                }
            }
        }
        for (IMetaClass next : metaClasses) {
            void var15_20;
            String metaClassName = next.getClass().getCanonicalName();
            Set<SonargraphPlugin> set = this.e.get(metaClassName);
            if (set == null) {
                THashSet tHashSet = new THashSet();
                this.e.put(metaClassName, (Set<SonargraphPlugin>)tHashSet);
            }
            var15_20.add(plugin);
        }
        if (this.f.hasSoftwareSystem()) {
            SoftwareSystem softwareSystem = this.f.getSoftwareSystem();
            assert (softwareSystem != null) : "'softwareSystem' of method 'installPlugin' must not be null";
            if (softwareSystem.getExtension(as.class).a(plugin, result)) {
                EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
                as.a restartInfo = this.a(softwareSystem, plugin, true, true);
                IPluginModelContributor iPluginModelContributor = this.b(softwareSystem, plugin);
                if (iPluginModelContributor != null) {
                    modifications.add(Modification.SYSTEM_MODIFIED);
                }
                if (this.c(softwareSystem, plugin) != null) {
                    modifications.add(Modification.AVAILABLE_ANALYZER_PLUGINS_MODIFIED);
                }
                if (iPluginModelContributor != null) {
                    this.a(workerContext, plugin, iPluginModelContributor, ExecutionPhase.MODEL_ELEMENTS, this.a(workerContext, plugin), softwareSystem, result);
                    this.a(workerContext, plugin, iPluginModelContributor, ExecutionPhase.DEPENDENCIES, this.a(workerContext, plugin), softwareSystem, result);
                }
                this.h.a(workerContext, softwareSystem, modifications, result);
                if (restartInfo != null) {
                    if (restartInfo.a()) {
                        softwareSystem.getExtension(c.class).b(workerContext);
                    } else {
                        softwareSystem.getExtension(c.class).b(restartInfo.b());
                    }
                }
            }
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new InstallationModifiedEvent(this.f));
        return result;
    }

    @Override
    public IIssueId getIssueId(String pluginId, String name) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'getIssueid' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'issueIdName' of method 'getIssueid' must not be empty";
        Installation installation = this.f.getInstallation();
        return installation.findFirstIssueId(id -> {
            if (id instanceof PluginIssueId) {
                PluginIssueId pid = (PluginIssueId)id;
                return pid.getPluginId().equals(pluginId) && pid.getId().equals(name);
            }
            return false;
        });
    }

    @Override
    public void a(SoftwareSystem softwareSystem, String pluginId, EnumSet<Modification> modifications, as.b info, boolean hasEnabledStateChanged, boolean isEnabled) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'configurationChanged' must not be null";
        assert (pluginId != null) : "Parameter 'pluginId' of method 'changed' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'configurationChanged' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationChanged' must not be null";
        b.debug("Configuration changed '" + pluginId + "' [" + (isEnabled ? "Enabled" : "Disabled") + "]");
        SonargraphPlugin plugin = this.a(pluginId);
        assert (plugin != null) : "'plugin' of method 'configurationChanged' must not be null";
        as.a restartInfo = this.a(softwareSystem, plugin, hasEnabledStateChanged, isEnabled);
        info.a(restartInfo);
        if (isEnabled) {
            this.a(softwareSystem, plugin, info, hasEnabledStateChanged, isEnabled, modifications);
            if (this.b(softwareSystem, plugin) != null) {
                modifications.add(Modification.SYSTEM_MODIFIED);
            }
            if (this.c(softwareSystem, plugin) != null) {
                modifications.add(Modification.AVAILABLE_ANALYZER_PLUGINS_MODIFIED);
            }
        } else {
            this.a(softwareSystem, plugin, info, hasEnabledStateChanged, isEnabled, modifications);
        }
        b.debug("Configuration changed '" + pluginId + "' [" + (isEnabled ? "Enabled" : "Disabled") + "] - done");
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, EnumSet<Modification> modifications, as.b info, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'configurationChangeFinished' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'configurationChangeFinished' must not be null";
        assert (info != null) : "Parameter 'info' of method 'configurationChangeFinished' must not be null";
        assert (result != null) : "Parameter 'result' of method 'configurationChangeFinished' must not be null";
        Set<StrictPair<SonargraphPlugin, IPluginModelContributor>> modelContributors = info.c();
        if (!modelContributors.isEmpty()) {
            this.a(workerContext, modelContributors, softwareSystem, result);
        }
        if (modifications != null) {
            this.h.a(workerContext, softwareSystem, modifications, result);
            as.a restartInfo = info.b();
            if (restartInfo != null && info.a()) {
                b.debug("Analyzers being restarted due to plugin change: " + restartInfo.toString());
                if (restartInfo.a()) {
                    softwareSystem.getExtension(c.class).b(workerContext);
                } else {
                    softwareSystem.getExtension(c.class).b(restartInfo.b());
                }
            }
        }
    }

    @Override
    public void a(IWorkerContext workerContext, SoftwareSystem softwareSystem, SonargraphPlugin plugin, EnumSet<Modification> modifications, as.b info) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'pluginConfigurationDeleted' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'pluginConfigurationDeleted' must not be null";
        assert (info != null) : "Parameter 'info' of method 'pluginConfigurationDeleted' must not be null";
        b.debug("Plugin configuration deleted '" + plugin.getId() + "'");
        if (plugin.isEnabled() && modifications != null) {
            SonargraphPluginConfiguration pluginConfiguration = plugin.getConfiguration();
            pluginConfiguration.updateValues(pluginConfiguration.getDefaultValues());
            this.a(softwareSystem, plugin, info, true, true, modifications);
        }
        b.debug("Plugin configuration deleted '" + plugin.getId() + "' - done");
    }

    static /* synthetic */ int[] a() {
        if (i != null) {
            return i;
        }
        int[] nArray = new int[ExecutionPhase.values().length];
        try {
            nArray[ExecutionPhase.DEPENDENCIES.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ExecutionPhase.MODEL_ELEMENTS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        i = nArray;
        return nArray;
    }

    static /* synthetic */ int[] b() {
        if (j != null) {
            return j;
        }
        int[] nArray = new int[PluginMetricLevel.values().length];
        try {
            nArray[PluginMetricLevel.MODULE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PluginMetricLevel.SOURCE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PluginMetricLevel.SYSTEM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        j = nArray;
        return nArray;
    }

    private static enum ExecutionPhase {
        MODEL_ELEMENTS,
        DEPENDENCIES;

    }

    private static final class a
    implements PluginProgrammingElement.IVisitor,
    ProgrammingElement.IVisitor {
        private final SonargraphPlugin b;
        private final Set<PluginProgrammingElement> c = new THashSet();
        private final Set<IMetaClass> d;
        private final Set<IParserDependencyType> e;

        a(SonargraphPlugin plugin, List<IMetaClass> metaClasses, List<IParserDependencyType> parserDependencyTypes) {
            assert (plugin != null) : "Parameter 'plugin' of method 'PluginRemovalVisitor' must not be null";
            assert (metaClasses != null) : "Parameter 'metaClasses' of method 'ModelPluginRemovalVisitor' must not be null";
            assert (parserDependencyTypes != null) : "Parameter 'parserDependencyTypes' of method 'ModelPluginRemovalVisitor' must not be null";
            this.b = plugin;
            this.d = new THashSet(metaClasses);
            this.e = new THashSet(parserDependencyTypes);
        }

        @Override
        public void visitChildrenOf(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitChildrenOf' must not be null";
            namedElement.getChildren().forEach(c2 -> c2.accept(this));
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitNamedElement' must not be null";
            this.visitChildrenOf(namedElement);
        }

        @Override
        public void visitGenericProgrammingElement(PluginProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitGenericProgrammingElement' must not be null";
            if (this.d.contains(element.getMetaClass()) || element.getMetaClass().getPluginId().equals(this.b.getId())) {
                this.c.add(element);
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (!this.e.isEmpty()) {
                Iterator<ParserDependency> iter = element.getDependencyIterator();
                while (iter.hasNext()) {
                    ParserDependency next = iter.next();
                    if (!this.e.contains(next.getDependencyType())) continue;
                    iter.remove();
                }
            }
            this.visitChildrenOf(element);
        }

        void a() {
            this.c.forEach(r2 -> r2.remove());
        }
    }
}

