/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.controller.system.base.g;
import com.hello2morrow.sonargraph.core.controller.system.base.m;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureDefinitionElement;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.ILogicalElement;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.IssueList;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IHierarchicalIssueProvider;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueModule;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueNamedElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueNamedElementProxy;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueRootElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueWorkspaceElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.NamedElementIssueTree;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.RecursiveIssueElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.StandardIssueNamedElement;
import com.hello2morrow.sonargraph.core.model.path.ArchitecturalViewsDirectory;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.LibraryPath;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.programming.ExternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.IssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class K
extends Extension
implements m,
IHierarchicalIssueProvider {
    private static final Logger b = LoggerFactory.getLogger(K.class);
    private static final List<Class<?>> c = Arrays.asList(ProgrammingElement.class, FilePath.class, PhysicalRecursiveElement.class, IComponent.class, RootDirectoryPath.class, IssueModule.class, Module.class, Workspace.class, IModifiableFile.class, ModifiableDirectory.class, Analyzers.class, Architecture.class, GroovyScripts.class, QualityGates.class, WorkspaceProfile.class, ArchitecturalViewsDirectory.class, PluginConfigurations.class, Files.class, LibraryPath.class, External.class, SoftwareSystem.class, Installation.class);
    private final NamedElementIssueTree e;

    K(Installation installation, g finishModelProcessor) {
        assert (installation != null) : "Parameter 'installation' of method 'HierarchicalIssueExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'HierarchicalIssueExtension' must not be null";
        this.e = new NamedElementIssueTree(installation);
        installation.addChild(this.e);
        finishModelProcessor.a(this);
    }

    @Override
    public void a(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        if (this.e == null) {
            return;
        }
        IssueRootElement systemRootElement = this.e.getUniqueChild(namedElement -> namedElement.getElement() == softwareSystem, IssueRootElement.class);
        if (systemRootElement != null) {
            systemRootElement.remove();
        }
    }

    @Override
    public NamedElementIssueTree computeIssueTree(IssueFilter filter, PresentationMode presentationMode, SoftwareSystem softwareSystem) {
        Object elementToIssueElementMap;
        assert (filter != null) : "Parameter 'filter' of method 'computeIssueTree' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'computeIssueTree' must not be null";
        b.debug("Compute issue tree");
        this.e.clear();
        if (softwareSystem != null) {
            elementToIssueElementMap = this.a(this.e, softwareSystem);
            IssueList issues = softwareSystem.getCurrentModel().getIssueList(filter);
            this.a(softwareSystem, issues.getIssues(), presentationMode, (Map<NamedElement, IssueNamedElement>)elementToIssueElementMap);
        } else {
            elementToIssueElementMap = new THashMap();
        }
        Installation installation = this.e.getParent(Installation.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (installation != null) : "'installation' of method 'computeIssueTree' must not be null";
        IssueList issues = installation.getCurrentModel().getIssueList(filter);
        elementToIssueElementMap.putAll(this.a(this.e, installation));
        this.a(installation, issues.getIssues(), presentationMode, (Map<NamedElement, IssueNamedElement>)elementToIssueElementMap);
        elementToIssueElementMap.values().forEach(i2 -> i2.finishModification());
        this.e.finishModification();
        b.debug("Compute issue tree - done");
        return this.e;
    }

    private Map<NamedElement, IssueNamedElement> a(NamedElementIssueTree tree, SoftwareSystem softwareSystem) {
        assert (tree != null) : "Parameter 'tree' of method 'initElementsForSoftwareSystem' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initElementsForSoftwareSystem' must not be null";
        THashMap elementToIssueElementMap = new THashMap();
        IssueRootElement<SoftwareSystem> systemIssueRoot = new IssueRootElement<SoftwareSystem>((NamedElement)tree, softwareSystem);
        tree.addChild(systemIssueRoot);
        elementToIssueElementMap.put(softwareSystem, systemIssueRoot);
        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
        IssueWorkspaceElement issueWorkspace = new IssueWorkspaceElement(systemIssueRoot, workspace);
        elementToIssueElementMap.put(workspace, issueWorkspace);
        systemIssueRoot.addChild(issueWorkspace);
        for (Module next : workspace.getChildren(Module.class)) {
            this.a(next, issueWorkspace, (Map<NamedElement, IssueNamedElement>)elementToIssueElementMap);
        }
        Files files = softwareSystem.getUniqueExistingChild(Files.class);
        StandardIssueNamedElement filesElement = new StandardIssueNamedElement(systemIssueRoot, files);
        systemIssueRoot.addChild(filesElement);
        elementToIssueElementMap.put(files, filesElement);
        return elementToIssueElementMap;
    }

    private Map<NamedElement, IssueNamedElement> a(NamedElementIssueTree tree, Installation installation) {
        assert (tree != null) : "Parameter 'tree' of method 'initElementsForInstallation' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'initElementsForInstallation' must not be null";
        THashMap result = new THashMap();
        IssueRootElement<Installation> rootElement = new IssueRootElement<Installation>((NamedElement)tree, installation);
        tree.addChild(rootElement);
        result.put(installation, rootElement);
        return result;
    }

    private void a(Module module, IssueWorkspaceElement parent, Map<NamedElement, IssueNamedElement> elementToIssueElementMap) {
        IssueModule issueModule = new IssueModule((NamedElement)parent, module);
        parent.addChild(issueModule);
        elementToIssueElementMap.put(module, issueModule);
        elementToIssueElementMap.put(issueModule, issueModule);
    }

    private <T extends Root> void a(T rootElement, List<Issue> issues, PresentationMode presentationMode, Map<NamedElement, IssueNamedElement> elementToIssueElementMap) {
        assert (rootElement != null) : "Parameter 'rootElement' of method 'computeTreeForElementsWithIssues' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'computeTreeForElementsWithIssues' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'computeTreeForElementsWithIssues' must not be null";
        assert (elementToIssueElementMap != null) : "Parameter 'elementToIssueElementMap' of method 'computeTreeForElementsWithIssues' must not be null";
        for (Issue nextIssue : issues) {
            if (b.isDebugEnabled()) {
                b.debug("Processing issue with severity {}: {}", (Object)nextIssue.getSeverity(), (Object)nextIssue);
            }
            if (nextIssue instanceof DependencyIssue) {
                DependencyIssue depIssue = (DependencyIssue)nextIssue;
                Dependency dependency = depIssue.getAffectedElement();
                ISnapshotDependency.IDependencyEndpoint startPoint = dependency.getFrom();
                if (startPoint instanceof NamedElement) {
                    if (b.isDebugEnabled()) {
                        b.debug("Create issueElement for dependency issue {}", (Object)depIssue);
                    }
                    this.a((NamedElement)((Object)startPoint), depIssue, presentationMode, elementToIssueElementMap);
                    continue;
                }
                b.warn("Omitting dependency issue {} because starting point {} is of type {}", new Object[]{depIssue, startPoint, startPoint.getClass().getCanonicalName()});
                continue;
            }
            if (!(nextIssue instanceof NamedElementIssue)) continue;
            if (nextIssue instanceof CycleGroupIssue) {
                CycleGroupIssue cycleIssue = (CycleGroupIssue)nextIssue;
                NamedElement affectedElement = cycleIssue.getAffectedElement();
                for (NamedElement element : ((CycleGroup)affectedElement).getCyclicNamedElements()) {
                    this.a(element, nextIssue, presentationMode, elementToIssueElementMap);
                }
                continue;
            }
            if (nextIssue instanceof DuplicateCodeBlockIssue) {
                DuplicateCodeBlockIssue duplicateIssue = (DuplicateCodeBlockIssue)nextIssue;
                DuplicateCodeBlock block = (DuplicateCodeBlock)duplicateIssue.getAffectedElement();
                THashSet sourceFiles = new THashSet();
                for (DuplicateCodeBlockOccurrence occurrence : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
                    SourceFile sourceFile = occurrence.getSourceFile();
                    if (sourceFiles.contains(sourceFile)) continue;
                    this.a(sourceFile, nextIssue, presentationMode, elementToIssueElementMap);
                    sourceFiles.add(sourceFile);
                }
                continue;
            }
            Element element = nextIssue.getAffectedElement();
            assert (element instanceof NamedElement) : "Not a NamedElement but of class " + element.getClass().getCanonicalName() + ", " + element.getDebugInfo();
            NamedElement elementWithIssue = (NamedElement)element;
            this.a(elementWithIssue, nextIssue, presentationMode, elementToIssueElementMap);
        }
    }

    private void a(NamedElement elementWithIssue, Issue issue, PresentationMode presentationMode, Map<NamedElement, IssueNamedElement> elementToIssueElementMap) {
        assert (elementWithIssue != null) : "Parameter 'elementWithIssue' of method 'createIssueElementForNamedElement' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'createIssueElementForNamedElement' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'createIssueElementForNamedElement' must not be null";
        assert (elementToIssueElementMap != null) : "Parameter 'elementToIssueElementMap' of method 'createIssueElementForNamedElement' must not be null";
        List<NamedElement> elementsWithIssue = elementWithIssue instanceof ILogicalElement ? this.a(elementWithIssue) : Collections.singletonList(elementWithIssue);
        for (NamedElement next : elementsWithIssue) {
            NamedElement elementForIssueElement = this.a(next, presentationMode);
            IssueNamedElement issueElement = elementToIssueElementMap.get(elementForIssueElement);
            if (issueElement == null) {
                issueElement = this.a(elementForIssueElement, presentationMode, elementToIssueElementMap);
                elementToIssueElementMap.put(elementForIssueElement, issueElement);
            }
            issueElement.addIssueAsInfo(issue);
        }
    }

    private List<NamedElement> a(NamedElement logicalElementWithIssue) {
        assert (logicalElementWithIssue != null && logicalElementWithIssue instanceof ILogicalElement) : "Unexpected class in method 'getPhysicalRepresentativesForLogicalElement': " + logicalElementWithIssue;
        if (logicalElementWithIssue instanceof LogicalNamespace) {
            LogicalNamespace namespace = (LogicalNamespace)logicalElementWithIssue;
            return namespace.getRepresentativeSourceNamespaces().stream().map(ns -> ns.getNamedElement()).collect(Collectors.toList());
        }
        if (logicalElementWithIssue instanceof LogicalProgrammingElement) {
            LogicalProgrammingElement logicalProgrammingElement = (LogicalProgrammingElement)logicalElementWithIssue;
            return logicalProgrammingElement.getLogicalGroup().stream().map(element -> element.getNamedElement()).collect(Collectors.toList());
        }
        if (logicalElementWithIssue instanceof InternalLogicalNamespaceRoot) {
            return Collections.singletonList((NamedElement)logicalElementWithIssue.getParent(SoftwareSystem.class, new Class[0]));
        }
        if (logicalElementWithIssue instanceof ModuleBasedLogicalNamespaceRoot) {
            ModuleBasedLogicalNamespaceRoot logicalRoot = (ModuleBasedLogicalNamespaceRoot)logicalElementWithIssue;
            return Collections.singletonList(logicalRoot.getPhysicalElement());
        }
        if (logicalElementWithIssue instanceof ExternalLogicalNamespaceRoot) {
            PhysicalElementBasedLogicalRoot logicalExternal = logicalElementWithIssue.getParent(PhysicalElementBasedLogicalRoot.class, new Class[0]);
            SoftwareSystem system = logicalExternal.getParent(SoftwareSystem.class, new Class[0]);
            External external = system.getUniqueExistingChild(Workspace.class).getUniqueChild(new ShortNameFilter(logicalExternal.getShortName()), External.class);
            LibraryPath library = external.getUniqueChild(new ShortNameFilter(logicalElementWithIssue.getShortName()), LibraryPath.class);
            return Collections.singletonList(library);
        }
        assert (false) : "Unhandled logical class " + logicalElementWithIssue.getClass().getCanonicalName();
        return Collections.emptyList();
    }

    private NamedElement a(NamedElement namedElement, PresentationMode presentationMode) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getElementForIssueElementCreation' must not be null";
        for (Class<?> next : c) {
            if (!next.isAssignableFrom(namedElement.getClass())) continue;
            return namedElement;
        }
        NamedElement parent = this.b(namedElement, presentationMode);
        assert (parent != null) : "parent expected of " + namedElement.getFullyQualifiedName();
        return this.a(parent, presentationMode);
    }

    private IssueNamedElement a(NamedElement namedElement, PresentationMode presentationMode, Map<NamedElement, IssueNamedElement> elementToIssueElementMap) {
        NamedElement parentElement;
        assert (namedElement != null) : "Parameter 'namedElement' of method 'createIssueElementHierarchyForElement' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationmode' of method 'createIssueElementHierarchyForElement' must not be null";
        assert (elementToIssueElementMap != null) : "Parameter 'elementToIssueElementMap' of method 'createIssueElementHierarchyForElement' must not be null";
        NamedElement parent = this.b(namedElement, presentationMode);
        assert (parent != null) : "Element '" + namedElement + "' must have a parent. IssueElements for roots must have been created before!";
        IssueNamedElement parentIssueElement = elementToIssueElementMap.get(parent);
        if (parentIssueElement == null && (parentIssueElement = elementToIssueElementMap.get(parentElement = this.a(parent, presentationMode))) == null) {
            if (b.isDebugEnabled()) {
                b.debug("creating issueElement for parent element {}", (Object)parentElement);
            }
            parentIssueElement = this.a(parentElement, presentationMode, elementToIssueElementMap);
            elementToIssueElementMap.put(parentElement, parentIssueElement);
        }
        if (b.isDebugEnabled()) {
            b.debug("creating issueElement for element {}", (Object)namedElement);
        }
        IssueNamedElementProxy issueElement = namedElement instanceof IRecursiveElement ? new RecursiveIssueElement((NamedElement)parentIssueElement, (IRecursiveElement)((Object)namedElement)) : new StandardIssueNamedElement(parentIssueElement, namedElement);
        parentIssueElement.addChild(issueElement);
        return issueElement;
    }

    private NamedElement b(NamedElement namedElement, PresentationMode presentationMode) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'determineParentFor' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'determineParentFor' must not be null";
        if (presentationMode != PresentationMode.FLAT) {
            return namedElement.getParent();
        }
        if (namedElement instanceof PhysicalRecursiveElement) {
            return namedElement.getParent(RootDirectoryPath.class, ParentMode.FIRST_PARENT);
        }
        return namedElement.getParent();
    }

    @Override
    public IssueFilter computeMatchingFilter(IssueFilter filter, List<Issue> issues) {
        assert (filter != null) : "Parameter 'filter' of method 'doesFilterMatchIssues' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'doesFilterMatchIssues' must not be null";
        THashSet severities = new THashSet();
        THashSet issueIds = new THashSet();
        THashSet providerIds = new THashSet();
        THashSet categories = new THashSet();
        THashSet affectedElementTypes = new THashSet();
        boolean anyNotAccepted = false;
        for (Issue next : issues) {
            if (!filter.accept(next)) {
                anyNotAccepted = true;
            }
            severities.add(next.getSeverity());
            issueIds.add(next.getId());
            providerIds.add(next.getProvider());
            categories.add(next.getId().getCategory());
            affectedElementTypes.add(IssueAffectedElementType.getMatchingType(next));
        }
        if (anyNotAccepted) {
            ArrayList items = new ArrayList();
            items.addAll(severities);
            items.addAll(issueIds);
            items.addAll(providerIds);
            items.addAll(categories);
            items.addAll(affectedElementTypes);
            return new IssueFilter(items.toArray(new IStandardEnumeration[0]));
        }
        return filter;
    }

    @Override
    public List<IssueNamedElement> getElementsForIssues(List<Issue> issues) {
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'getElementsForIssues' must not be empty";
        return this.e.getIssueElementsFor(issues);
    }

    private boolean a(List<String> container, String search) {
        assert (container != null) : "Parameter 'container' of method 'contains' must not be null";
        assert (search != null) : "Parameter 'search' of method 'contains' must not be null";
        for (String next : container) {
            if (!next.equalsIgnoreCase(search)) continue;
            return true;
        }
        return false;
    }

    private boolean a(Issue issue, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, ArchitectureFile architectureFile) {
        IssueCategory issueCategory;
        assert (issue != null) : "Parameter 'issue' of method 'includeIssue' must not be null";
        if (categories != null && !categories.isEmpty() && !this.a(categories, issue.getId().getCategory().getStandardName())) {
            return false;
        }
        if (issueIds != null && !issueIds.isEmpty() && !this.a(issueIds, issue.getId().getStandardName())) {
            return false;
        }
        if (providers != null && !providers.isEmpty() && !this.a(providers, issue.getProvider().getStandardName())) {
            return false;
        }
        if (severities != null && !severities.isEmpty() && !this.a(severities, issue.getSeverity().getStandardName())) {
            return false;
        }
        return architectureFile == null || !IssueCategory.ARCHITECTURE_VIOLATION.equals((Object)(issueCategory = issue.getId().getCategory())) && !IssueCategory.ARCHITECTURE_DEPRECATION.equals((Object)issue.getId().getCategory()) || architectureFile.getIssueProviderId().equals(issue.getProvider());
    }

    private final List<? extends NamedElement> b(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'getRelevantChildren' must not be null";
        List<? extends NamedElement> allChildren = element.getAllChildren();
        if (element instanceof Artifact) {
            Collection<IAssignableToArtifact> assigned = ((Artifact)element).getAssignedElements();
            ArrayList<? extends NamedElement> all = new ArrayList<NamedElement>(assigned.size() + allChildren.size());
            all.addAll(allChildren);
            for (IAssignableToArtifact nextAssigned : assigned) {
                all.add(nextAssigned.getNamedElement());
            }
            return all;
        }
        return allChildren;
    }

    private int a(ElementWithIssues element, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean recursive, Map<Element, Set<Issue>> secondaryIssues, ArchitectureFile architectureFile) {
        assert (element != null) : "Parameter 'element' of method 'countFor' must not be null";
        int count = 0;
        for (Issue nextIssue : element.getIssues()) {
            if (!this.a(nextIssue, categories, issueIds, providers, severities, architectureFile)) continue;
            ++count;
        }
        if (element instanceof NamedElement) {
            Set<Issue> secondary = secondaryIssues.get(element);
            if (secondary != null) {
                for (Issue issue : secondary) {
                    if (!this.a(issue, categories, issueIds, providers, severities, architectureFile)) continue;
                    ++count;
                }
            }
            if (recursive) {
                for (NamedElement namedElement : this.b((NamedElement)element)) {
                    count += this.a(namedElement, categories, issueIds, providers, severities, recursive, secondaryIssues, architectureFile);
                }
            }
        }
        return count;
    }

    private void a(ElementWithIssues element, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean recursive, Map<Element, Set<Issue>> secondaryIssues, ArchitectureFile architectureFile, List<StrictPair<Issue, ElementWithIssues>> collector) {
        assert (element != null) : "Parameter 'element' of method 'collectIssues' must not be null";
        assert (secondaryIssues != null) : "Parameter 'secondaryIssues' of method 'collectIssues' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectIssues' must not be null";
        for (Issue nextIssue : element.getIssues()) {
            if (!this.a(nextIssue, categories, issueIds, providers, severities, architectureFile)) continue;
            collector.add((StrictPair<Issue, ElementWithIssues>)new StrictPair((Object)nextIssue, (Object)element));
        }
        if (element instanceof NamedElement) {
            Set<Issue> secondary = secondaryIssues.get(element);
            if (secondary != null) {
                for (Issue issue : secondary) {
                    if (!this.a(issue, categories, issueIds, providers, severities, architectureFile)) continue;
                    collector.add((StrictPair<Issue, ElementWithIssues>)new StrictPair((Object)issue, (Object)element));
                }
            }
            if (recursive) {
                for (NamedElement namedElement : this.b((NamedElement)element)) {
                    this.a(namedElement, categories, issueIds, providers, severities, recursive, secondaryIssues, architectureFile, collector);
                }
            }
        }
    }

    private Map<Element, Set<Issue>> a(SoftwareSystem softwareSystem, Collection<ElementWithIssues> elements, boolean includingSecondary) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'collectSecondaryIssues' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'collectSecondaryIssues' must not be empty";
        boolean collectSecondaryIssues = false;
        if (includingSecondary) {
            for (ElementWithIssues nextElement : elements) {
                if (!(nextElement instanceof NamedElement)) continue;
                collectSecondaryIssues = true;
                break;
            }
        }
        if (!collectSecondaryIssues) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Element, Set<Issue>> secondaryIssues = new LinkedHashMap<Element, Set<Issue>>();
        softwareSystem.getCurrentModel().getIssueList(i2 -> {
            Element affectedElement;
            IssueCategory category = i2.getId().getCategory();
            if (IssueCategory.DUPLICATE_CODE.equals((Object)category)) {
                Element affectedElement2 = i2.getAffectedElement();
                if (affectedElement2 instanceof DuplicateCodeBlock) {
                    DuplicateCodeBlock block = (DuplicateCodeBlock)affectedElement2;
                    for (DuplicateCodeBlockOccurrence occurrence : block.getChildren(DuplicateCodeBlockOccurrence.class)) {
                        SourceFile sourceFile = occurrence.getSourceFile();
                        LinkedHashSet<Issue> issues = (LinkedHashSet<Issue>)secondaryIssues.get(sourceFile);
                        if (issues == null) {
                            issues = new LinkedHashSet<Issue>();
                            secondaryIssues.put(sourceFile, issues);
                        }
                        issues.add(i2);
                    }
                }
            } else if (IssueCategory.CYCLE_GROUP.equals((Object)category)) {
                Element affectedElement3 = i2.getAffectedElement();
                if (affectedElement3 instanceof CycleGroup) {
                    CycleGroup cycleGroup = (CycleGroup)affectedElement3;
                    cycleGroup.getCyclicNamedElements().forEach(c2 -> {
                        LinkedHashSet<Issue> issues = (LinkedHashSet<Issue>)secondaryIssues.get(c2);
                        if (issues == null) {
                            issues = new LinkedHashSet<Issue>();
                            secondaryIssues.put((Element)c2, (Set<Issue>)issues);
                        }
                        issues.add(i2);
                    });
                }
            } else if ((IssueCategory.ARCHITECTURE_VIOLATION.equals((Object)category) || IssueCategory.ARCHITECTURE_DEPRECATION.equals((Object)category)) && (affectedElement = i2.getAffectedElement()) instanceof ParserDependency) {
                ParserDependency parserDependency = (ParserDependency)affectedElement;
                LinkedHashSet<Issue> issues = (LinkedHashSet<Issue>)secondaryIssues.get(parserDependency.getFrom());
                if (issues == null) {
                    issues = new LinkedHashSet<Issue>();
                    secondaryIssues.put(parserDependency.getFrom(), issues);
                }
                issues.add(i2);
            }
            return false;
        });
        return secondaryIssues;
    }

    @Override
    public int getNumberOfIssues(SoftwareSystem softwareSystem, Collection<ElementWithIssues> elements, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean includingSecondary, boolean recursive) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getIssues' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getNumberOfIssues' must not be null";
        if (elements.isEmpty()) {
            return 0;
        }
        Map<Element, Set<Issue>> secondaryIssues = this.a(softwareSystem, elements, includingSecondary);
        int numberOfIssues = 0;
        for (ElementWithIssues nextElement : elements) {
            ArchitectureFile nextArchitectureFile = null;
            if (nextElement instanceof IArchitectureDefinitionElement) {
                nextArchitectureFile = ((IArchitectureDefinitionElement)((Object)nextElement)).getNamedElement().getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT);
            }
            numberOfIssues += this.a(nextElement, categories, issueIds, providers, severities, recursive, secondaryIssues, nextArchitectureFile);
        }
        return numberOfIssues;
    }

    @Override
    public List<StrictPair<Issue, ElementWithIssues>> getIssues(SoftwareSystem softwareSystem, Collection<ElementWithIssues> elements, List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean includingSecondary, boolean recursive) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getIssues' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'getIssues' must not be null";
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Element, Set<Issue>> secondaryIssues = this.a(softwareSystem, elements, includingSecondary);
        ArrayList<StrictPair<Issue, ElementWithIssues>> issues = new ArrayList<StrictPair<Issue, ElementWithIssues>>();
        for (ElementWithIssues nextElement : elements) {
            ArchitectureFile nextArchitectureFile = null;
            if (nextElement instanceof IArchitectureDefinitionElement) {
                nextArchitectureFile = ((IArchitectureDefinitionElement)((Object)nextElement)).getNamedElement().getParent(ArchitectureFile.class, ParentMode.SELF_OR_FIRST_PARENT);
            }
            this.a(nextElement, categories, issueIds, providers, severities, recursive, secondaryIssues, nextArchitectureFile, issues);
        }
        return issues;
    }
}

