/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.H;
import com.hello2morrow.sonargraph.core.controller.system.base.b;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ModifiableFileIdFilter;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.script.ScriptPersistence;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public final class J
extends b {
    private final SoftwareSystem c;

    J(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'GroovyScriptUndoRedoProvider' must not be null";
        this.c = softwareSystem;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(GroovyScript.class);
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream stream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeContentToStream' must not be null";
        assert (file instanceof GroovyScript) : "Unexpected class: " + file.getClass().getName();
        assert (stream != null) : "Parameter 'stream' of method 'writeContentToStream' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeModifiableFileToStream' must not be null";
        this.c.getExtension(H.class).g().storeScriptToStream(stream, (GroovyScript)file, result);
    }

    public OperationResultWithOutcome<IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreFile' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreFile' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreFile' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreFile' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restore Groovy script '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "'");
        GroovyScript script = this.c.getUniqueExistingChild(Files.class).getGroovyScripts().getFirstChildRecursively(new ModifiableFileIdFilter(dto.getModifiableFileId()), GroovyScript.class, new Class[0]);
        assert (script != null) : "Script '" + dto.getCurrentStateFileEntry().getIdentifyingPath() + "' must exist!";
        H groovyExtension = this.c.getExtension(H.class);
        ScriptPersistence scriptPersistence = groovyExtension.g();
        Pair<ScriptContent, List<String>> scriptContentAndLanguageIssueInfo = scriptPersistence.loadScriptFromStream(inputStream, (OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        assert (scriptContentAndLanguageIssueInfo != null) : "'scriptContentAndLanguageIssueInfo' of method 'restoreFile' must not be null";
        ScriptContent scriptContent = (ScriptContent)scriptContentAndLanguageIssueInfo.getFirst();
        assert (scriptContent != null) : "'scriptContent' of method 'restoreFile' must not be null";
        TFile restoredPath = null;
        if (!script.getIdentifyingPath().equals(dto.getCurrentStateFileEntry().getIdentifyingPath())) {
            restoredPath = new TFile((File)script.getParent(GroovyScripts.class, new Class[0]).getFile(), dto.getCurrentStateFileEntry().getIdentifyingPath()).getNormalizedAbsoluteFile();
            try {
                script.getFile().mv((File)restoredPath);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
        }
        groovyExtension.a(script, restoredPath, scriptContent, (List)scriptContentAndLanguageIssueInfo.getSecond());
        result.setOutcome((Object)script);
        return result;
    }
}

