/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.controller.system.H;
import com.hello2morrow.sonargraph.core.controller.system.base.b;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

public final class I
extends b {
    private final SoftwareSystem c;

    public I(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'GroovyScriptRunConfigurationUndoRedoProvider' must not be null";
        this.c = softwareSystem;
    }

    @Override
    public List<Class<? extends IModifiableFile>> getModifiableFileClasses() {
        return Collections.singletonList(FileBasedRunConfiguration.class);
    }

    @Override
    public void writeModifiableFileToStream(IModifiableFile file, OutputStream outputStream, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'writeModifiableFileToStream' must not be null";
        assert (file instanceof FileBasedRunConfiguration) : "Unexpected class: " + file.getClass().getName();
        assert (outputStream != null) : "Parameter 'outputStream' of method 'writeModifiableFileToStream' must not be null";
        this.c.getExtension(H.class).h().save(outputStream, (FileBasedRunConfiguration)file, result);
    }

    @Override
    public OperationResultWithOutcome<? extends IModifiableFile> restoreModifiableFileFromStream(InputStream inputStream, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherFilesOfTx) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'restoreModifiableFileFromStream' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreModifiableFileFromStream' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreModifiableFileFromStream' must not be null";
        assert (otherFilesOfTx != null) : "Parameter 'otherFilesOfTx' of method 'restoreModifiableFileFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Restore run configuration '" + dto.getModifiableFilePath() + "'");
        Files files = this.c.getUniqueExistingChild(Files.class);
        Optional<IModifiableFile> match = files.findById(dto.getModifiableFileId());
        assert (match.isPresent()) : "Run configuration '" + dto.getModifiableFilePath() + "' must exist!";
        FileBasedRunConfiguration toBeRestored = (FileBasedRunConfiguration)match.get();
        H groovyExtension = this.c.getExtension(H.class);
        result.addMessagesFrom(groovyExtension.h().load(inputStream, toBeRestored));
        if (result.isFailure()) {
            return result;
        }
        if (!toBeRestored.getIdentifyingPath().equals(dto.getCurrentStateFileEntry().getIdentifyingPath())) {
            TFile newPath = new TFile((File)toBeRestored.getParent(GroovyScripts.class, new Class[0]).getFile(), dto.getCurrentStateFileEntry().getIdentifyingPath()).getNormalizedAbsoluteFile();
            try {
                toBeRestored.getFile().mv((File)newPath);
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
                return result;
            }
            String previousName = toBeRestored.getRunConfigurationName();
            toBeRestored.setPath(newPath);
            GroovyScript script = toBeRestored.getParent(GroovyScript.class, new Class[0]);
            assert (script != null) : "'script' of method 'restoreModifiableFileFromStream' must not be null";
            groovyExtension.a(script.getIdentifyingPath(), previousName, toBeRestored.getRunConfigurationName());
        }
        result.setOutcome((Object)toBeRestored);
        return result;
    }
}

