/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.Result;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.api.script.model.ResultAccess;
import com.hello2morrow.sonargraph.core.api.script.model.ScriptAccess;
import com.hello2morrow.sonargraph.core.controller.system.Z;
import com.hello2morrow.sonargraph.core.controller.system.aa;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.g;
import com.hello2morrow.sonargraph.core.controller.system.parser.c;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.ScriptAutoCompletionProposalsCollector;
import com.hello2morrow.sonargraph.core.controller.system.script.ScriptFormatter;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.a;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.d;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.programming.CoreKeywords;
import com.hello2morrow.sonargraph.core.model.script.AutomatedScriptRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.DefaultRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FullGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterNameValidator;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationNameValidator;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.script.ScriptDirectory;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.persistence.script.ScriptPersistence;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.RunConfigurationPersistence;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class GroovyProvider
extends Extension
implements IGroovyProvider {
    private final Map<String, ScriptContent> a = new THashMap();
    private final aa c;
    private final Installation d;
    private final SoftwareSystem e;
    private final d f;

    GroovyProvider(aa accessor, Installation installation, SoftwareSystem softwareSystem, ScriptOutputStreamProvider outputStreamProvider) {
        assert (accessor != null) : "Parameter 'accessor' of method 'GroovyExtension' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'GroovyProvider' must not be null";
        assert (softwareSystem != null) : "'softwareSystem' must not be null";
        assert (outputStreamProvider != null) : "Parameter 'outputStreamProvider' of method 'GroovyExtension' must not be null";
        this.c = accessor;
        this.d = installation;
        this.e = softwareSystem;
        this.f = new d(this.getFileOutputBaseDirectory(), this.e.getClassLoader(), outputStreamProvider);
    }

    protected final ScriptOutputStreamProvider a() {
        return this.f.a();
    }

    protected final SoftwareSystem b() {
        return this.e;
    }

    protected final d c() {
        return this.f;
    }

    protected final GroovyScripts d() {
        return this.e.getUniqueExistingChild(Files.class).getGroovyScripts();
    }

    protected final ScriptPersistence g() {
        return new ScriptPersistence(this.d(), this.d.getVersion(), this.getAvailableLanguages(), this.e.getMode() == SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT);
    }

    protected final RunConfigurationPersistence h() {
        return new RunConfigurationPersistence(this.d(), this.d.getVersion());
    }

    @Override
    public final IFormatter getFormatter(FormatterOptions options) {
        assert (options != null) : "Parameter 'options' of method 'getFormatter' must not be null";
        return new ScriptFormatter(options);
    }

    protected final ScriptContent a(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAutomatedScriptContent' must not be empty";
        return this.a.get(identifyingPath);
    }

    protected final void b(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'removeAllScripts' must not be null";
        this.d().removeAll(result);
        this.a.clear();
    }

    protected final ScriptContent a(String identifyingPath, ScriptContent scriptContent) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'addAutomatedScriptContent' must not be empty";
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'addAutomatedScriptContent' must not be null";
        ScriptContent automatedScriptContent = new ScriptContent.Builder(scriptContent).build();
        assert (!scriptContent.hasChildren(false, AutomatedScriptRunConfiguration.class)) : "Must not have automated script run configuration children: " + scriptContent;
        for (FileBasedRunConfiguration next : scriptContent.getChildren(FileBasedRunConfiguration.class)) {
            automatedScriptContent.addChild(new AutomatedScriptRunConfiguration(automatedScriptContent, next.getRunConfigurationName(), new RunConfigurationParameters(next.getRunConfigurationParameters()), automatedScriptContent));
        }
        return this.a.put(identifyingPath, automatedScriptContent);
    }

    protected final void a(String oldIdentifyingPath, String newIdentifyingPath) {
        assert (oldIdentifyingPath != null && oldIdentifyingPath.length() > 0) : "Parameter 'oldIdentifyingPath' of method 'changeIdentifyingPathOfAutomatedScriptContent' must not be empty";
        assert (newIdentifyingPath != null && newIdentifyingPath.length() > 0) : "Parameter 'newIdentifyingPath' of method 'changeIdentifyingPathOfAutomatedScriptContent' must not be empty";
        ScriptContent found = this.a.remove(oldIdentifyingPath);
        assert (found != null) : "'found' of method 'changeIdentifyingPathOfAutomatedScriptContent' must not be null";
        ScriptContent replaced = this.a.put(newIdentifyingPath, found);
        assert (replaced == null) : "'replaced' of method 'changeIdentifyingPathOfAutomatedScriptContent' must be null";
    }

    protected final void a(String identifyingPath, String oldRunConfigurationName, String newRunConfigurationName) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'changeRunConfigurationName' must not be empty";
        assert (oldRunConfigurationName != null && oldRunConfigurationName.length() > 0) : "Parameter 'oldRunConfigurationName' of method 'changeRunConfigurationName' must not be empty";
        assert (newRunConfigurationName != null && newRunConfigurationName.length() > 0) : "Parameter 'newRunConfigurationName' of method 'changeRunConfigurationName' must not be empty";
        ScriptContent scriptContent = this.a.get(identifyingPath);
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'changeRunConfigurationName' must not be null";
        for (AutomatedScriptRunConfiguration next : scriptContent.getChildren(AutomatedScriptRunConfiguration.class)) {
            if (!next.getRunConfigurationName().equals(oldRunConfigurationName)) continue;
            next.setRunConfigurationName(newRunConfigurationName);
        }
    }

    protected final ScriptContent b(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'removeAutomatedScriptContent' must not be empty";
        return this.a.remove(identifyingPath);
    }

    @Override
    public final TFile getFileOutputBaseDirectory() {
        TFile systemParentDirectory = this.e.getUniqueChild(Files.class).getSystemDirectory().getDirectoryFile().getParentFile();
        if (this.e.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) {
            return systemParentDirectory;
        }
        return systemParentDirectory.getParentFile();
    }

    @Override
    public final boolean isScriptDirectory(DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isScriptDirectory' must not be null";
        return directoryPath instanceof GroovyScripts || directoryPath instanceof ScriptDirectory;
    }

    @Override
    public final boolean isModifiableScriptDirectory(DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isModifiableScriptDirectory' must not be null";
        return directoryPath instanceof ScriptDirectory;
    }

    @Override
    public final String getScriptRunnerConfigurationFileName() {
        return AnalyzerConfigurationFile.getFileName(CoreAnalyzerId.SCRIPT_RUNNER);
    }

    public final AnalyzerConfigurationFile i() {
        return this.e.getExtension(g.class).a(CoreAnalyzerId.SCRIPT_RUNNER);
    }

    protected final boolean c(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isFileNameAJavaIdentifier' must not be empty";
        String nameToCheck = Arrays.stream(CoreFileType.GROOVY_SCRIPT.getExtensions()).anyMatch(ext -> name.endsWith((String)ext)) ? name.substring(0, name.lastIndexOf(".")) : name;
        if (!Character.isJavaIdentifierStart(nameToCheck.charAt(0))) {
            return false;
        }
        int index = 1;
        while (index < nameToCheck.length()) {
            if (!Character.isJavaIdentifierPart(nameToCheck.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public final ITextValidator getScriptNameValidator(final DirectoryPath parentDirectoryPath) {
        assert (parentDirectoryPath != null) : "Parameter 'parentDirectoryPath' of method 'getScriptNameValidator' must not be null";
        assert (this.isScriptDirectory(parentDirectoryPath)) : "Not a script directory: " + parentDirectoryPath;
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (newInput.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput.endsWith(CoreFileType.GROOVY_SCRIPT.getDefaultExtension())) {
                    result.addError("Extension will be added automatically");
                } else if (result.inputModified()) {
                    if (!GroovyProvider.this.c(newInput)) {
                        result.addError("Must be a valid Java identifier");
                    } else {
                        String newInputWithExtension = String.valueOf(newInput) + CoreFileType.GROOVY_SCRIPT.getDefaultExtension();
                        for (GroovyScript next : parentDirectoryPath.getChildren(GroovyScript.class)) {
                            if (!next.getShortName().equalsIgnoreCase(newInputWithExtension)) continue;
                            result.addError("Groovy script with name '" + newInput + "' already exists");
                            break;
                        }
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final IPathValidator getDirectoryPathValidator() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null) {
                    result.addError("Null input");
                    return result;
                }
                if (!newInput.isDirectory() || !newInput.isDirectory()) {
                    result.addError("Not a directory");
                    return result;
                }
                if (FileUtility.areEqual((TFile)newInput, (TFile)GroovyProvider.this.d().getFile())) {
                    return result;
                }
                for (ScriptDirectory nextPath : GroovyProvider.this.e.getUniqueExistingChild(Files.class).getChildrenRecursively(ScriptDirectory.class, new Class[0])) {
                    if (!FileUtility.areEqual((TFile)currentInput, (TFile)nextPath.getFile())) continue;
                    return result;
                }
                result.addError("Not a Scripts directory");
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    @Override
    public final ITextValidator getDirectoryNameValidator(final DirectoryPath parentDirectoryPath) {
        assert (parentDirectoryPath != null) : "Parameter 'parentDirectoryPath' of method 'getDirectoryNameValidator' must not be null";
        assert (this.isScriptDirectory(parentDirectoryPath)) : "Not a script directory: " + parentDirectoryPath;
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                if ((newInput = newInput.trim()).isEmpty()) {
                    result.addError("Must not be empty");
                } else if (result.inputModified()) {
                    if (!GroovyProvider.this.c(newInput)) {
                        result.addError("Invalid directory name");
                    } else {
                        for (ScriptDirectory next : parentDirectoryPath.getChildren(ScriptDirectory.class)) {
                            if (!next.getShortName().equalsIgnoreCase(newInput)) continue;
                            result.addError("Directory with name '" + newInput + "' already exists");
                            break;
                        }
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final ITextValidator getRunConfigurationNameValidator(GroovyScript script, FileBasedRunConfiguration runConfiguration) {
        assert (script != null) : "Parameter 'script' of method 'getRunConfigurationValidator' must not be null";
        THashSet existingRunConfigurationNames = new THashSet();
        for (IRunConfiguration next : script.getRunConfigurations()) {
            if (runConfiguration != null && next.getRunConfigurationName().equals(runConfiguration.getRunConfigurationName())) continue;
            existingRunConfigurationNames.add(next.getRunConfigurationName());
        }
        return new RunConfigurationNameValidator((Set<String>)existingRunConfigurationNames, script.getScriptContent().getParameterDefinitions());
    }

    @Override
    public final ITextValidator getParameterValueValidator(final IGroovyProvider.IParameterDefinitionInfoProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getParameterDefinitionDefaultValueValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                if (!b && newInput == null) {
                    throw new AssertionError((Object)"Parameter 'newInput' of method 'isValid' must not be null");
                }
                boolean modified = !StringUtility.areEqual((String)initialInput, (String)newInput);
                ValidationResult result = new ValidationResult(modified);
                newInput = newInput.trim();
                if (!provider.getCurrentParameterType().isConversionIntoTargetTypePossible(newInput)) {
                    result.addError("Not of type '" + provider.getCurrentParameterType().getPresentationName() + "'");
                } else if (provider.getCurrentPossibleValuesAsString() != null && !provider.getCurrentPossibleValuesAsString().isEmpty()) {
                    if (!provider.getCurrentParameterType().splitPossibleValues(provider.getCurrentPossibleValuesAsString()).contains(newInput)) {
                        result.addError("Default value not allowed. Must be one of the possible values.");
                    }
                } else if ("output".equals(provider.getCurrentParameterName()) && !newInput.isEmpty()) {
                    if (!FileUtility.normalizedPathMightDenoteFilePath((String)newInput)) {
                        result.addError("Does not represent a possible file path.");
                    } else if (FileUtility.isNormalizedPathAbsolute((String)newInput)) {
                        result.addWarning("Consider not to use an absolute path - it might not be cross-platform compatible.");
                    }
                } else if ("timeout".equals(provider.getCurrentParameterName()) && !newInput.isEmpty()) {
                    Object timeout = provider.getCurrentParameterType().convertIntoTargetType(newInput);
                    if (!(b || timeout != null && timeout instanceof Integer)) {
                        throw new AssertionError((Object)("Unexpected class in method 'isValid': " + timeout));
                    }
                    if ((Integer)timeout < 1) {
                        result.addError("The value must be greater than '0'");
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final ITextValidator getParameterPossibleValuesValidator(final IGroovyProvider.IParameterDefinitionInfoProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getParameterDefinitionPossibleValuesValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                if (!b && newInput == null) {
                    throw new AssertionError((Object)"Parameter 'newInput' of method 'isValid' must not be null");
                }
                boolean modified = !StringUtility.areEqual((String)initialInput, (String)newInput);
                ValidationResult result = new ValidationResult(modified);
                LinkedHashSet<String> values = new LinkedHashSet<String>();
                for (String next : provider.getCurrentParameterType().splitPossibleValues(newInput)) {
                    if (!provider.getCurrentParameterType().isConversionIntoTargetTypePossible(next)) {
                        result.addError("Not of type '" + provider.getCurrentParameterType().getPresentationName() + "'");
                        continue;
                    }
                    if (values.add(next)) continue;
                    result.addError("Contains duplicate");
                }
                return result;
            }
        };
    }

    @Override
    public final ITextValidator getParameterNameValidator(List<ParameterDefinition.Builder> parameters, ParameterDefinition.Builder parameterToBeEdited) {
        assert (parameters != null) : "Parameter 'parameters' of method 'getParameterNameValidator' must not be null";
        return parameterToBeEdited != null ? new ParameterNameValidator(parameters, parameterToBeEdited) : new ParameterNameValidator(parameters);
    }

    @Override
    public final String getNameForEdit(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'getNameForEdit' must not be null";
        assert (script.isValid()) : "No valid: " + script;
        return FileUtility.removeExtension((String)script.getShortName());
    }

    public final GroovyScript d(final String identifyingPath) {
        assert (identifyingPath != null) : "Parameter 'identifyingPath' of method 'getScript' must not be null";
        return this.d().getFirstChildRecursively(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                GroovyScript script = (GroovyScript)namedElement;
                return identifyingPath.equalsIgnoreCase(script.getIdentifyingPath());
            }
        }, GroovyScript.class, new Class[0]);
    }

    protected final IScriptApi a(IGroovyScript script, ScriptResultSet resultSet, IMetricIdProvider metricIdProvider) {
        assert (script != null) : "Parameter 'script' of method 'getScriptApi' must not be null";
        assert (resultSet != null) : "Parameter 'resultSet' of method 'getScriptApi' must not be null";
        ArrayList<CoreAccess> systemAccesses = new ArrayList<CoreAccess>();
        a api = new a(script.getIdentifyingPath(), new ScriptAccess(script), new ResultAccess(resultSet));
        systemAccesses.add(new CoreAccess(this.d, this.b(), metricIdProvider, api));
        for (Z nextLanguageProvider : this.c.d()) {
            CoreAccess nextSystemAccess;
            if (!script.getScriptContent().getLanguages().contains(nextLanguageProvider.getLanguage()) || (nextSystemAccess = nextLanguageProvider.a(this.d, this.b(), metricIdProvider, api)) == null) continue;
            systemAccesses.add(nextSystemAccess);
        }
        return api;
    }

    @Override
    public final void accept(ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'accept' must not be null";
        assert (fileType.equals((Object)CoreFileType.GROOVY_SCRIPT)) : "Unexpected 'fileType' " + fileType.getPresentationName();
        com.hello2morrow.sonargraph.core.controller.system.parser.c.a(visitor, content, CoreKeywords.getGroovyKeywords());
    }

    @Override
    public final boolean editRequiresSave(GroovyScript script, String newName) {
        assert (script != null) : "Parameter 'script' of method 'editRequiresSave' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'editRequiresSave' must not be empty";
        return !newName.equals(FileUtility.getFileNameWithoutExtension((TFile)script.getFile())) && script.needsSave();
    }

    @Override
    public boolean editRequiresSave(FileBasedRunConfiguration runConfiguration, String newName) {
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'editRequiresSave' must not be null";
        return !runConfiguration.getRunConfigurationName().equals(newName);
    }

    @Override
    public final boolean areDeletableScriptElements(List<? extends Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'areDeletableScriptElements' must not be empty";
        for (Element element : elements) {
            if (element instanceof GroovyScript || element instanceof ScriptDirectory || element instanceof FileBasedRunConfiguration) continue;
            return false;
        }
        return true;
    }

    protected final Set<NamedElement> a(List<? extends Element> scriptElements, OperationResult result) {
        assert (scriptElements != null && !scriptElements.isEmpty()) : "Parameter 'scriptElements' of method 'getNormalizedScriptElementsToDelete' must not be empty";
        ArrayList<NamedElement> namedElements = new ArrayList<NamedElement>(scriptElements.size());
        for (Element element : scriptElements) {
            if (!(element instanceof NamedElement)) continue;
            namedElements.add((NamedElement)element);
        }
        Set<NamedElement> set = NamedElementUtility.normalize(namedElements, true, new Class[0]);
        if (result != null) {
            for (NamedElement nextNamedElement : set) {
                if (nextNamedElement instanceof GroovyScript) {
                    GroovyScript script = (GroovyScript)nextNamedElement;
                    if (!SoftwareSystemFilesDirectory.isOutOfSync(script)) continue;
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, script.getIdentifyingPath(), new Object[0]);
                    continue;
                }
                if (nextNamedElement instanceof FileBasedRunConfiguration) {
                    FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)nextNamedElement;
                    if (!SoftwareSystemFilesDirectory.isOutOfSync(runConfiguration)) continue;
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, runConfiguration.getIdentifyingPath(), new Object[0]);
                    continue;
                }
                if (nextNamedElement instanceof ScriptDirectory) {
                    ScriptDirectory directoryPath = (ScriptDirectory)nextNamedElement;
                    TFile file = directoryPath.getFile();
                    if (!file.exists()) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, directoryPath.getIdentifyingPath(), new Object[0]);
                    }
                    for (GroovyScript next : directoryPath.getChildrenRecursively(GroovyScript.class, GroovyScript.class)) {
                        if (!SoftwareSystemFilesDirectory.isOutOfSync(next)) continue;
                        result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, next.getIdentifyingPath(), new Object[0]);
                    }
                    continue;
                }
                assert (false) : "Unhandled script element type: " + nextNamedElement;
            }
        }
        return set;
    }

    @Override
    public final Set<String> scriptElementsDeletionAffectsScriptRunner(List<? extends Element> scriptElements) {
        assert (this.areDeletableScriptElements(scriptElements)) : "Not deletable script elements";
        ScriptRunnerConfiguration configuration = this.j();
        if (configuration != null) {
            TreeSet<String> toBeDeleted = new TreeSet<String>();
            for (Element element : this.a(scriptElements, null)) {
                if (element instanceof GroovyScript) {
                    String identifyingPath = ((GroovyScript)element).getIdentifyingPath();
                    List<String> automated = configuration.getAutomatedRunConfigurations(identifyingPath);
                    for (String nextRunConfiguration : automated) {
                        toBeDeleted.add(String.valueOf(identifyingPath) + ":" + nextRunConfiguration);
                    }
                    continue;
                }
                if (element instanceof FileBasedRunConfiguration) {
                    FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)element;
                    GroovyScript script = runConfiguration.getParent(GroovyScript.class, new Class[0]);
                    assert (script != null) : "'script' of method 'scriptElementsDeletionAffectsScriptRunner' must not be null";
                    if (!configuration.isAutomated(script.getIdentifyingPath(), runConfiguration.getRunConfigurationName())) continue;
                    toBeDeleted.add(String.valueOf(script.getIdentifyingPath()) + ":" + runConfiguration.getRunConfigurationName());
                    continue;
                }
                if (!(element instanceof ScriptDirectory)) continue;
                for (GroovyScript nextScript : ((ScriptDirectory)element).getChildrenRecursively(GroovyScript.class, GroovyScript.class)) {
                    String identifyingPath = nextScript.getIdentifyingPath();
                    List<String> automated = configuration.getAutomatedRunConfigurations(identifyingPath);
                    for (String nextRunConfiguration : automated) {
                        toBeDeleted.add(String.valueOf(identifyingPath) + ":" + nextRunConfiguration);
                    }
                }
            }
            return toBeDeleted;
        }
        return Collections.emptySet();
    }

    protected final ScriptRunnerConfiguration j() {
        AnalyzerConfiguration configuration = this.e.getExtension(g.class).b(CoreAnalyzerId.SCRIPT_RUNNER);
        if (configuration != null) {
            assert (configuration instanceof ScriptRunnerConfiguration) : "Unexpected class in method 'getScriptRunnerConfiguration': " + configuration;
            return (ScriptRunnerConfiguration)configuration;
        }
        return null;
    }

    @Override
    public boolean isAutomated(IRunConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'isAutomated' must not be null";
        if (configuration instanceof DefaultRunConfiguration) {
            GroovyScript script = ((DefaultRunConfiguration)configuration).getParent(GroovyScript.class, new Class[0]);
            return this.a(script, configuration);
        }
        if (configuration instanceof FileBasedRunConfiguration) {
            GroovyScript script = ((FileBasedRunConfiguration)configuration).getParent(GroovyScript.class, new Class[0]);
            return this.a(script, configuration);
        }
        return false;
    }

    protected final boolean a(GroovyScript script, IRunConfiguration runConfiguration) {
        assert (script != null) : "Parameter 'script' of method 'isAutomatedScriptWithRunConfiguration' must not be null";
        ScriptRunnerConfiguration configuration = this.j();
        if (configuration == null) {
            return false;
        }
        String runConfigurationName = runConfiguration != null ? runConfiguration.getRunConfigurationName() : null;
        return configuration.isAutomated(script.getIdentifyingPath(), runConfigurationName);
    }

    private final EnumSet<ScriptDiff> a(GroovyScript script, ScriptContent currentContent, String newName, ScriptContent newContent, DiffMode mode) {
        assert (script != null) : "Parameter 'script' of method 'getDifferences' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'getDifferences' must not be null";
        assert (currentContent != null) : "Parameter 'currentContent' of method 'getDifferences' must not be null";
        assert (newContent != null) : "Parameter 'newContent' of method 'getDifferences' must not be null";
        assert (script != null) : "Parameter 'script' of method 'getDifferencesWithAutomatedScript' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'getDifferences' must not be null";
        EnumSet<ScriptDiff> diff = EnumSet.noneOf(ScriptDiff.class);
        if (!newName.equals(FileUtility.getFileNameWithoutExtension((TFile)script.getFile()))) {
            diff.add(ScriptDiff.NAME);
        }
        if (!newContent.getDescription().equals(currentContent.getDescription())) {
            diff.add(ScriptDiff.DESCRIPTION);
        }
        if (!newContent.getLanguages().equals(currentContent.getLanguages())) {
            diff.add(ScriptDiff.LANGUAGES);
        }
        if (mode != DiffMode.AUTOMATED) {
            if (!newContent.getParameterDefinitions().equals(currentContent.getParameterDefinitions())) {
                diff.add(ScriptDiff.PARAMETER_DEFINITIONS);
            }
        } else {
            THashSet currentParameterDefinitions;
            THashSet newParameterDefinitions = new THashSet(newContent.getParameterDefinitions());
            if (!newParameterDefinitions.equals(currentParameterDefinitions = new THashSet(currentContent.getParameterDefinitions()))) {
                diff.add(ScriptDiff.PARAMETER_DEFINITIONS);
            }
            THashSet newRunConfigurationParameters = new THashSet();
            for (IRunConfiguration next : newContent.getRunConfigurations()) {
                if (!this.a(script, next)) continue;
                newRunConfigurationParameters.add(next.getDefinedParameters());
            }
            THashSet currentRunConfigurationParameters = new THashSet();
            for (IRunConfiguration next : currentContent.getRunConfigurations()) {
                if (!this.a(script, next)) continue;
                currentRunConfigurationParameters.add(next.getDefinedParameters());
            }
            if (!newRunConfigurationParameters.equals(currentRunConfigurationParameters)) {
                diff.add(ScriptDiff.RUN_CONFIGURATION_PARAMETERS);
            }
            if (!newContent.getSource().equals(currentContent.getSource())) {
                diff.add(ScriptDiff.SOURCE);
            }
        }
        return diff;
    }

    protected final EnumSet<ScriptDiff> a(GroovyScript script, String newName, ScriptContent newContent) {
        assert (script != null) : "Parameter 'script' of method 'getDifferences' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'getDifferences' must not be null";
        assert (newContent != null) : "Parameter 'newContent' of method 'getDifferences' must not be null";
        return this.a(script, script.getScriptContent(), newName, newContent, DiffMode.SCRIPT_CONFIGURATION);
    }

    @Override
    public final boolean hasScriptConfigurationChanged(GroovyScript script, String newName, ScriptContent newContent) {
        return !this.a(script, newName, newContent).isEmpty();
    }

    @Override
    public final Set<Language> getAvailableLanguages() {
        return this.c.c();
    }

    @Override
    public List<GroovyScript> getAvailableScripts() {
        return this.d().getChildrenRecursively(GroovyScript.class, ScriptContent.class);
    }

    @Override
    public final FullGroovyScript getFullScript(GroovyScript script, IMetricIdProvider metricIdProvider, String source, int offset) {
        return this.f.a((IGroovyScript)script, this.a((IGroovyScript)script, script.getResultSet(), metricIdProvider), source, offset);
    }

    protected final EnumSet<ScriptDiff> b(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'getDifferencesOfAutmatedScript' must not be null";
        assert (this.a(script, null)) : "Not automated: " + script;
        ScriptContent automatedScriptContent = this.a.get(script.getIdentifyingPath());
        assert (automatedScriptContent != null) : "Script '" + script.getIdentifyingPath() + "' has no automated content";
        return this.a(script, script.getScriptContent(), FileUtility.getFileNameWithoutExtension((TFile)script.getFile()), automatedScriptContent, DiffMode.AUTOMATED);
    }

    @Override
    public final Result canContentBeTransferedToAutomatedScript(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'canContentBeTransferedToAutomatedScript' must not be null";
        Result result = new Result();
        if (!this.a(script, null)) {
            result.addErrorMessage("Script is not configured to be run automatically");
            return result;
        }
        if (!script.isExecutable()) {
            result.addErrorMessage("Script must be compiled successfully first");
            return result;
        }
        if (script.needsSave()) {
            result.addErrorMessage("Script must be saved first");
            return result;
        }
        EnumSet<ScriptDiff> diff = this.b(script);
        if (diff.isEmpty()) {
            result.addErrorMessage("Script does not differ from automated script");
        }
        return result;
    }

    @Override
    public boolean mayBeAddedToScriptRunnerExecution(List<Element> elements) {
        return this.a(elements, false);
    }

    @Override
    public boolean mayBeRemovedFromScriptRunner(List<Element> elements) {
        return this.a(elements, true);
    }

    private boolean a(List<Element> elements, boolean mustBeAutomated) {
        assert (elements != null && elements.size() > 0) : "Parameter 'elements' of method 'mayBeAddedToAutomatedExecution' must not be empty";
        long numberOfValidElements = elements.stream().filter(e2 -> e2 != null).filter(e2 -> e2 instanceof DefaultRunConfiguration || e2 instanceof FileBasedRunConfiguration).count();
        if ((long)elements.size() != numberOfValidElements) {
            return false;
        }
        for (Element next : elements) {
            NamedElementContainer runConfig;
            GroovyScript script;
            if (next instanceof DefaultRunConfiguration) {
                DefaultRunConfiguration defaultRunConfig = (DefaultRunConfiguration)next;
                script = defaultRunConfig.getParent(GroovyScript.class, new Class[0]);
                runConfig = defaultRunConfig;
            } else {
                assert (next != null && next instanceof FileBasedRunConfiguration) : "Unexpected class in method 'addToAutomated': " + next;
                FileBasedRunConfiguration fileBasedRunConfig = (FileBasedRunConfiguration)next;
                script = fileBasedRunConfig.getParent(GroovyScript.class, new Class[0]);
                runConfig = fileBasedRunConfig;
            }
            if (!(mustBeAutomated ? !this.a(script, (IRunConfiguration)((Object)runConfig)) : this.a(script, (IRunConfiguration)((Object)runConfig)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<AutoCompletionProposal> getAutoCompletionProposals(GroovyScript script, String text, int offset, int line) {
        assert (script != null) : "Parameter 'script' of method 'getAutoCompletionProposals' must not be null";
        assert (text != null) : "Parameter 'text' of method 'getAutoCompletionProposals' must not be null";
        assert (offset >= 0) : "'offset' must not be negative";
        assert (line >= 0) : "'line' must not be negative";
        if (script.getScriptApi() != null) {
            assert (script.getClassLoader() != null) : "'classLoader' must not be null";
            return ScriptAutoCompletionProposalsCollector.getAutoCompletionProposals(script.getCompiledScript(), script.getScriptApi(), script.getClassLoader(), text, offset, line);
        }
        return Collections.emptyList();
    }

    @Override
    public /* synthetic */ IModifiableFile getScriptRunnerConfigurationFile() {
        return this.i();
    }

    private static enum DiffMode {
        SCRIPT_CONFIGURATION,
        AUTOMATED;

    }

    public static enum ScriptDiff {
        NAME,
        DESCRIPTION,
        LANGUAGES,
        PARAMETER_DEFINITIONS,
        RUN_CONFIGURATION_PARAMETERS,
        SOURCE;

    }
}

