/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.foundation.export.ColumnDatatype;
import com.hello2morrow.foundation.export.ExportData;
import com.hello2morrow.foundation.export.Sort;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.controller.system.au;
import com.hello2morrow.sonargraph.core.controller.system.bm;
import com.hello2morrow.sonargraph.core.controllerinterface.system.n;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.INamedElementNode;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.event.ExportFinishedEvent;
import com.hello2morrow.sonargraph.core.model.event.ExportStartedEvent;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingLink;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.MetricAccessKey;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapRepresentation;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapType;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class B
extends Extension
implements com.hello2morrow.sonargraph.core.controllerinterface.system.a.a {
    private static final String b = "Element";
    private static final String c = "Dependency";
    private static final String d = "Workspace Dependency";
    private final Installation e;
    private final au f;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode g;

    public B(Installation installation, au propertiesExtension, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode) {
        assert (installation != null) : "Parameter 'installation' of method 'ExportExtension' must not be null";
        assert (propertiesExtension != null) : "Parameter 'propertiesExtension' of method 'ExportExtension' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'ExportExtension' must not be null";
        this.e = installation;
        this.f = propertiesExtension;
        this.g = backgroundTaskExecutionMode;
    }

    private String a(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getIdentification' must not be null";
        if (element instanceof Issue) {
            element = ((Issue)element).getAffectedElement();
        }
        if (element instanceof INamedElementNode) {
            element = ((INamedElementNode)((Object)element)).getNamedElement();
        }
        if (element instanceof IParserDependenciesProvidingEdge) {
            IParserDependenciesProvidingEdge dependency = (IParserDependenciesProvidingEdge)((Object)element);
            return String.valueOf(dependency.getFromEndPoint().getFullyQualifiedName()) + "->" + dependency.getToEndPoint().getFullyQualifiedName();
        }
        if (element instanceof Dependency) {
            Dependency dependency = (Dependency)element;
            return String.valueOf(dependency.getUnderlyingFrom().getFullyQualifiedName()) + "->" + dependency.getUnderlyingTo().getFullyQualifiedName();
        }
        assert (element != null && element instanceof NamedElement) : "Unexpected class in method 'getIdentification': " + element;
        return ((NamedElement)element).getFullyQualifiedName();
    }

    private List<NamedElementIssuePattern> a(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getNamedElementIssuePattern' must not be null";
        ArrayList<NamedElementIssuePattern> namedElementIssuePatterns = new ArrayList<NamedElementIssuePattern>(resolution.getChildren(NamedElementIssuePattern.class));
        Collections.sort(namedElementIssuePatterns, new Comparator<NamedElementIssuePattern>(){

            public int a(NamedElementIssuePattern ip1, NamedElementIssuePattern ip2) {
                if (!a && ip1 == null) {
                    throw new AssertionError((Object)"Parameter 'ip1' of method 'compare' must not be null");
                }
                if (!a && ip2 == null) {
                    throw new AssertionError((Object)"Parameter 'ip2' of method 'compare' must not be null");
                }
                return ip1.getPattern().compareTo(ip2.getPattern());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((NamedElementIssuePattern)object, (NamedElementIssuePattern)object2);
            }
        });
        return namedElementIssuePatterns;
    }

    private List<DependencyIssuePattern> b(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getDependencyIssuePatterns' must not be null";
        ArrayList<DependencyIssuePattern> dependencyIssuePatterns = new ArrayList<DependencyIssuePattern>(resolution.getChildren(DependencyIssuePattern.class));
        Collections.sort(dependencyIssuePatterns, new Comparator<DependencyIssuePattern>(){

            public int a(DependencyIssuePattern ip1, DependencyIssuePattern ip2) {
                if (!a && ip1 == null) {
                    throw new AssertionError((Object)"Parameter 'ip1' of method 'compare' must not be null");
                }
                if (!a && ip2 == null) {
                    throw new AssertionError((Object)"Parameter 'ip2' of method 'compare' must not be null");
                }
                int compared = ip1.getFromPattern().compareTo(ip2.getFromPattern());
                if (compared == 0) {
                    compared = ip1.getToPattern().compareTo(ip2.getToPattern());
                }
                return compared;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((DependencyIssuePattern)object, (DependencyIssuePattern)object2);
            }
        });
        return dependencyIssuePatterns;
    }

    private void a(IWorkerContext workerContext, IThresholdProvider thresholdProvider, IMetricAccessor metricsAccessor, SoftwareSystem softwareSystem, ExportData exportData, List<IMetricDescriptor> metrics) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'populateSystemMetrics' must not be null";
        assert (exportData != null) : "Parameter 'exportData' of method 'populateSystemMetrics' must not be null";
        workerContext.setNumberOfSteps(1);
        exportData.addColumn("Metric Name");
        exportData.addColumn("Description");
        exportData.addColumn("Min", ColumnDatatype.NUMBER);
        exportData.addColumn("Max", ColumnDatatype.NUMBER);
        exportData.addColumn("Value", ColumnDatatype.NUMBER);
        Collections.sort(metrics, new Comparator<IMetricDescriptor>(){

            public int a(IMetricDescriptor o1, IMetricDescriptor o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((IMetricDescriptor)object, (IMetricDescriptor)object2);
            }
        });
        workerContext.beginBlockOfWork(metrics.size());
        for (IMetricDescriptor metric : metrics) {
            Number value = metricsAccessor.getMetricValue(softwareSystem, softwareSystem, metric.getMetricId());
            if (value != null) {
                String name = metric.getName();
                String description = metric.getDescription();
                IMetricThreshold th = thresholdProvider.getThreshold(metric);
                Number lowerThreshold = th != null ? (Number)th.getLowerThreshold() : (Number)null;
                Number upperThreshold = th != null ? (Number)th.getUpperThreshold() : (Number)null;
                exportData.addRow(new Object[]{name, description, lowerThreshold, upperThreshold, value});
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    private String a(NamedElement element, Map<NamedElement, String> elementToFullyQualifiedName) {
        assert (element != null) : "Parameter 'element' of method 'getFullyQualifiedName' must not be null";
        assert (elementToFullyQualifiedName != null) : "Parameter 'elementToFullyQualifiedName' of method 'getFullyQualifiedName' must not be null";
        String fqName = elementToFullyQualifiedName.get(element);
        if (fqName == null) {
            fqName = element.getFullyQualifiedName();
            elementToFullyQualifiedName.put(element, fqName);
        }
        return fqName;
    }

    private String a(NamedElement element, Number metricValue, IMetricThreshold threshold, ThresholdViolationIssue issue) {
        assert (element != null) : "Parameter 'element' of method 'getInfo' must not be null";
        if (metricValue != null) {
            if (issue != null) {
                String type;
                assert (threshold != null) : "Parameter 'threshold' of method 'getInfo' must not be null";
                double lowerThreshold = threshold.getLowerThreshold().doubleValue();
                double upperThreshold = threshold.getUpperThreshold().doubleValue();
                double value = metricValue.doubleValue();
                if (value < lowerThreshold) {
                    type = "Lower threshold violation";
                } else {
                    assert (value > upperThreshold) : "Not an upper threshold violation: " + threshold + " - " + metricValue;
                    type = "Upper threshold violation";
                }
                IResolution resolution = issue.getResolution();
                if (resolution != null) {
                    return resolution.ignores() ? String.valueOf(type) + " ignored by ignore definition" : String.valueOf(type) + " converted to task";
                }
                return type;
            }
            IComponent component = element.getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (component != null && component.ignoreIssues()) {
                if (threshold != null) {
                    double lowerThreshold = threshold.getLowerThreshold().doubleValue();
                    double upperThreshold = threshold.getUpperThreshold().doubleValue();
                    double value = metricValue.doubleValue();
                    if (value < lowerThreshold) {
                        return "Lower threshold violation ignored by issue filter";
                    }
                    if (value > upperThreshold) {
                        return "Upper threshold violation ignored by issue filter";
                    }
                }
                return "Ignored by issue filter";
            }
        }
        return "";
    }

    private void a(IWorkerContext workerContext, IThresholdProvider thresholdProvider, n metricsExtension, SoftwareSystem softwareSystem, ExportData exportData, IMetricLevel metricLevel, final Map<NamedElement, String> elementToFullyQualifiedName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'populateLevelMetrics' must not be null";
        assert (thresholdProvider != null) : "Parameter 'thresholdProvider' of method 'populateLevelMetrics' must not be null";
        assert (metricsExtension != null) : "Parameter 'metricsExtension' of method 'populateLevelMetrics' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'populateLevelMetrics' must not be null";
        assert (exportData != null) : "Parameter 'exportData' of method 'populateLevelMetrics' must not be null";
        assert (elementToFullyQualifiedName != null) : "Parameter 'elementToFullyQualifiedName' of method 'populateLevelMetrics' must not be null";
        workerContext.setNumberOfSteps(1);
        exportData.addColumn("Metric Name");
        exportData.addColumn("Description");
        exportData.addColumn("Min", ColumnDatatype.NUMBER);
        exportData.addColumn("Max", ColumnDatatype.NUMBER);
        exportData.addColumn(b);
        exportData.addColumn("Value", ColumnDatatype.NUMBER);
        exportData.addColumn("Info");
        List<IMetricDescriptor> metrics = metricsExtension.getAvailableMetricDescriptorsForLevel(metricLevel, true);
        Collections.sort(metrics, new Comparator<IMetricDescriptor>(){

            public int a(IMetricDescriptor o1, IMetricDescriptor o2) {
                return o1.getShortName().compareTo(o2.getShortName());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((IMetricDescriptor)object, (IMetricDescriptor)object2);
            }
        });
        workerContext.beginBlockOfWork(metrics.size());
        for (IMetricDescriptor metric : metrics) {
            String name = metric.getName();
            String description = metric.getDescription();
            IMetricThreshold nextMetricThreshold = thresholdProvider.getThreshold(metric);
            Number lowerThreshold = nextMetricThreshold != null ? (Number)nextMetricThreshold.getLowerThreshold() : (Number)null;
            Number upperThreshold = nextMetricThreshold != null ? (Number)nextMetricThreshold.getUpperThreshold() : (Number)null;
            exportData.addRow(new Object[]{name, description, lowerThreshold, upperThreshold, "", null, ""});
            List<? extends IMetricValue> metricValues = metricsExtension.getMetricValues(softwareSystem, metric, true);
            Collections.sort(metricValues, new Comparator<IMetricValue>(){

                public int a(IMetricValue o1, IMetricValue o2) {
                    Number n1 = o1.getValue();
                    Number n2 = o2.getValue();
                    if (n1 instanceof Comparable && n2 instanceof Comparable) {
                        Comparable c2 = (Comparable)((Object)n2);
                        Comparable c1 = (Comparable)((Object)n1);
                        int comp = c2.compareTo(c1);
                        if (comp == 0) {
                            return B.this.a(o1.getAssociatedElement(), elementToFullyQualifiedName).compareTo(B.this.a(o2.getAssociatedElement(), elementToFullyQualifiedName));
                        }
                        return comp;
                    }
                    return 0;
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((IMetricValue)object, (IMetricValue)object2);
                }
            });
            for (IMetricValue iMetricValue : metricValues) {
                NamedElement nextAssociatedElement = iMetricValue.getAssociatedElement();
                ThresholdViolationIssue thresholdViolationIssue = null;
                if (nextMetricThreshold != null) {
                    List<Issue> nextIssues = nextAssociatedElement.getIssues(CoreIssueId.THRESHOLD_VIOLATION);
                    for (Issue nextIssue : nextIssues) {
                        if (!(nextIssue instanceof ThresholdViolationIssue) || ((ThresholdViolationIssue)nextIssue).getThreshold() != nextMetricThreshold) continue;
                        thresholdViolationIssue = (ThresholdViolationIssue)nextIssue;
                        break;
                    }
                }
                exportData.addRow(new Object[]{null, null, null, null, this.a(nextAssociatedElement, elementToFullyQualifiedName), iMetricValue.getValue(), this.a(nextAssociatedElement, iMetricValue.getValue(), nextMetricThreshold, thresholdViolationIssue)});
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
    }

    private List<Issue> a(List<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'getIssues' must not be null";
        ArrayList<Issue> sortedIssues = new ArrayList<Issue>(issues.size());
        for (Issue next : issues) {
            if (next.getResolution() != null) continue;
            sortedIssues.add(next);
        }
        Collections.sort(sortedIssues, new Comparator<Issue>(){

            public int a(Issue i1, Issue i2) {
                if (!a && i1 == null) {
                    throw new AssertionError((Object)"Parameter 'i1' of method 'compare' must not be null");
                }
                if (!a && i2 == null) {
                    throw new AssertionError((Object)"Parameter 'i2' of method 'compare' must not be null");
                }
                int compared = i1.getSeverity().ordinal() - i2.getSeverity().ordinal();
                if (compared == 0) {
                    compared = i1.getKey().compareTo(i2.getKey());
                }
                return compared;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Issue)object, (Issue)object2);
            }
        });
        return sortedIssues;
    }

    private void a(ExportData exportData, List<Issue> issues) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populate' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'populate' must not be null";
        exportData.addColumn("Issue Key");
        exportData.addColumn("Description");
        exportData.addColumn("Severity");
        exportData.addColumn("Category");
        exportData.addColumn(b);
        exportData.addColumn("To Element");
        exportData.addColumn("Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Provider");
        for (Issue issue : this.a(issues)) {
            String issueKey = issue.getKey();
            String description = issue.getDescription();
            String severity = issue.getSeverity().getStandardName();
            String category = issue.getId().getCategory().getStandardName();
            int lineNumber = issue.getLineNumber();
            String provider = issue.getProvider().getStandardName();
            Element affected = issue.getAffectedElement();
            String elementFQN = "n/a";
            String elementToFQN = "n/a";
            if (affected instanceof NamedElement) {
                elementFQN = ((NamedElement)affected).getFullyQualifiedName();
                elementToFQN = "n/a";
            } else if (affected instanceof Dependency) {
                Dependency dependency = (Dependency)affected;
                elementFQN = dependency.getUnderlyingFrom().getFullyQualifiedName();
                elementToFQN = dependency.getUnderlyingTo().getFullyQualifiedName();
            } else assert (false) : "Unexpected affected element: " + affected;
            exportData.addRow(new Object[]{issueKey, description, severity, category, elementFQN, elementToFQN, lineNumber, provider});
        }
    }

    private List<IIssue> c(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getAssociatedIssues' must not be null";
        ArrayList<IIssue> associatedIssues = new ArrayList<IIssue>(resolution.getAssociatedIssues());
        Collections.sort(associatedIssues, new Comparator<IIssue>(){

            public int a(IIssue ia1, IIssue ia2) {
                String element1 = B.this.c(ia1);
                String element2 = B.this.c(ia2);
                return element1.compareTo(element2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((IIssue)object, (IIssue)object2);
            }
        });
        return associatedIssues;
    }

    private void b(ExportData exportData, List<IgnoreDefinition> resolutions) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populateIgnoreDefinitions' must not be null";
        assert (resolutions != null) : "Parameter 'resolutions' of method 'populateIgnoreDefinitions' must not be null";
        exportData.addColumn("Ignore Definition");
        exportData.addColumn("Description");
        exportData.addColumn("Crated", ColumnDatatype.DATE);
        exportData.addColumn("Matched", ColumnDatatype.NUMBER);
        exportData.addColumn("Matching Element Type");
        exportData.addColumn(b);
        exportData.addColumn("Element To");
        exportData.addColumn("Issue Key");
        exportData.addColumn("Issue Description");
        exportData.addColumn("Issue Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Pattern");
        exportData.addColumn("Pattern To");
        Collections.sort(resolutions, new a());
        for (IgnoreDefinition next : resolutions) {
            String type = String.valueOf(next.getPresentationName(true)) + " '" + next.getInformation() + "'";
            String description = next.getDescription();
            Date created = next.getDate();
            int matched = next.getMatchingElementsCount();
            exportData.addRow(new Object[]{type, description, created, matched, null, null, null, null, null, null, null, null});
            for (IIssue issue : this.c(next)) {
                String elementType = this.b(issue);
                String element = this.c(issue);
                String elementTo = this.a(issue);
                String issueKey = issue.getKey();
                String issueDescription = issue.getDescription();
                int issueLineNumber = issue.getLineNumber();
                exportData.addRow(new Object[]{null, null, null, null, elementType, element, elementTo, issueKey, issueDescription, issueLineNumber, null, null});
            }
            for (NamedElementIssuePattern nextNamedElementIssuePattern : this.a(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, nextNamedElementIssuePattern.getName(), "n/a"});
            }
            for (DependencyIssuePattern nextDependencyIssuePattern : this.b(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, nextDependencyIssuePattern.getFromPattern(), nextDependencyIssuePattern.getToPattern()});
            }
        }
    }

    private void c(ExportData exportData, List<RefactoringDefinition> resolutions) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populateRefactoringDefinitions' must not be null";
        assert (resolutions != null) : "Parameter 'resolutions' of method 'populateRefactoringDefinitions' must not be null";
        exportData.addColumn("Refactoring Definition");
        exportData.addColumn("Provider");
        exportData.addColumn("Status");
        exportData.addColumn("Description");
        exportData.addColumn("Information");
        exportData.addColumn("Priority");
        exportData.addColumn("Assignee");
        exportData.addColumn("Created", ColumnDatatype.DATE);
        exportData.addColumn("Matching Element Type");
        exportData.addColumn(b);
        exportData.addColumn("Element To");
        exportData.addColumn("Issue Key");
        exportData.addColumn("Issue Description");
        exportData.addColumn("Issue Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Potentially Done Element");
        exportData.addColumn("Pattern");
        exportData.addColumn("Pattern To");
        Collections.sort(resolutions, new a());
        for (RefactoringDefinition next : resolutions) {
            String type = next.getName();
            String provider = next.getProvider();
            String status = next.getStatus().getStandardName();
            String description = next.getDescription();
            String information = next.getInformation();
            String priority = next.getPriority().getStandardName();
            String assignee = next.getAssignee();
            Date date = next.getDate();
            exportData.addRow(new Object[]{type, provider, status, description, information, priority, assignee, date, null, null, null, null, null, null, null, null, null});
            for (IIssue issue : this.c(next)) {
                String elementType = this.b(issue);
                String element = this.c(issue);
                String elementTo = this.a(issue);
                String issueKey = issue.getKey();
                String issueDescription = issue.getDescription();
                int issueLineNumber = issue.getLineNumber();
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, elementType, element, elementTo, issueKey, issueDescription, issueLineNumber, null, null, null});
            }
            ArrayList<NamedElement> potentiallyDoneElements = new ArrayList<NamedElement>(next.getPotentiallyDoneElements());
            Collections.sort(potentiallyDoneElements, new Comparator<NamedElement>(){

                public int a(NamedElement ne1, NamedElement ne2) {
                    if (!a && ne1 == null) {
                        throw new AssertionError((Object)"Parameter 'ne1' of method 'compare' must not be null");
                    }
                    if (!a && ne2 == null) {
                        throw new AssertionError((Object)"Parameter 'ne2' of method 'compare' must not be null");
                    }
                    return ne1.getFullyQualifiedName().compareTo(ne2.getFullyQualifiedName());
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((NamedElement)object, (NamedElement)object2);
                }
            });
            for (NamedElement nextPotentiallyDone : potentiallyDoneElements) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, nextPotentiallyDone.getFullyQualifiedName(), null, null});
            }
            for (NamedElementIssuePattern nextNamedElementIssuePattern : this.a(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, nextNamedElementIssuePattern.getName(), "n/a"});
            }
            for (DependencyIssuePattern nextDependencyIssuePattern : this.b(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, nextDependencyIssuePattern.getFromPattern(), nextDependencyIssuePattern.getToPattern()});
            }
        }
    }

    private void d(ExportData exportData, List<TaskDefinition> resolutions) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populateTaskDefinitions' must not be null";
        assert (resolutions != null) : "Parameter 'resolutions' of method 'populateTaskDefinitions' must not be null";
        exportData.addColumn("Task Definition");
        exportData.addColumn("Description");
        exportData.addColumn("Information");
        exportData.addColumn("Priority");
        exportData.addColumn("Assignee");
        exportData.addColumn("Created", ColumnDatatype.DATE);
        exportData.addColumn("Matched", ColumnDatatype.NUMBER);
        exportData.addColumn("Matching Element Type");
        exportData.addColumn(b);
        exportData.addColumn("Element To");
        exportData.addColumn("Issue Key");
        exportData.addColumn("Issue Description");
        exportData.addColumn("Issue Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Pattern");
        exportData.addColumn("Pattern To");
        Collections.sort(resolutions, new a());
        for (TaskDefinition next : resolutions) {
            String type = next.getPresentationName(true);
            String description = next.getDescription();
            String information = next.getInformation();
            String priority = next.getPriority().getStandardName();
            String assignee = next.getAssignee();
            Date created = next.getDate();
            int matched = next.getMatchingElementsCount();
            exportData.addRow(new Object[]{type, description, information, priority, assignee, created, matched, null, null, null, null, null, null, null, null});
            for (IIssue issue : this.c(next)) {
                String elementType = this.b(issue);
                String element = this.c(issue);
                String elementTo = this.a(issue);
                String issueKey = issue.getKey();
                String issueDescription = issue.getDescription();
                int issueLineNumber = issue.getLineNumber();
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, elementType, element, elementTo, issueKey, issueDescription, issueLineNumber, null, null});
            }
            for (NamedElementIssuePattern nextNamedElementIssuePattern : this.a(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, nextNamedElementIssuePattern.getName(), "n/a"});
            }
            for (DependencyIssuePattern nextDependencyIssuePattern : this.b(next)) {
                exportData.addRow(new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, nextDependencyIssuePattern.getFromPattern(), nextDependencyIssuePattern.getToPattern()});
            }
        }
    }

    private String a(IIssue issue) {
        IWorkspaceDependencyElement to;
        assert (issue != null) : "'issue' of method 'getElementTo' must not be null";
        Element affectedElement = issue.getAffectedElement();
        if (affectedElement instanceof ParserDependency) {
            ParserDependency dependency = (ParserDependency)affectedElement;
            return dependency.getTo().getFullyQualifiedName();
        }
        if (affectedElement instanceof WorkspaceDependency && (to = ((WorkspaceDependency)affectedElement).getTo()) != null) {
            return ((NamedElement)to.getUnderlyingObject()).getFullyQualifiedName();
        }
        return "n/a";
    }

    private String b(IIssue issue) {
        assert (issue != null) : "'issue' of method 'getElementType' must not be null";
        Element affectedElement = issue.getAffectedElement();
        if (affectedElement instanceof NamedElement) {
            return b;
        }
        if (affectedElement instanceof WorkspaceDependency) {
            return d;
        }
        assert (affectedElement instanceof ParserDependency) : "Unexpected class: " + affectedElement.getClass().getName();
        return c;
    }

    private String c(IIssue issue) {
        assert (issue != null) : "'issue' of method 'getElement' must not be null";
        Element affectedElement = issue.getAffectedElement();
        if (affectedElement instanceof NamedElement) {
            return ((NamedElement)affectedElement).getFullyQualifiedName();
        }
        if (affectedElement instanceof WorkspaceDependency) {
            return ((NamedElement)((WorkspaceDependency)affectedElement).getFrom().getUnderlyingObject()).getFullyQualifiedName();
        }
        assert (affectedElement instanceof ParserDependency) : "Unexpected class: " + affectedElement.getClass().getName();
        ParserDependency dependency = (ParserDependency)affectedElement;
        return dependency.getFrom().getFullyQualifiedName();
    }

    private void a(IContext context, ExportData exportData, List<ContextParserDependency> dependencies) {
        assert (context != null) : "Parameter 'context' of method 'populateParserDependencies' must not be null";
        assert (exportData != null) : "Parameter 'exportData' of method 'populateParserDependencies' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'populateParserDependencies' must not be null";
        exportData.addColumn("From Module");
        exportData.addColumn("From File");
        exportData.addColumn("Line", ColumnDatatype.NUMBER, Sort.DESCENDING);
        exportData.addColumn("From");
        exportData.addColumn(c);
        exportData.addColumn("To Module");
        exportData.addColumn("To File");
        exportData.addColumn("To");
        exportData.addColumn("Violation Info");
        for (ContextParserDependency next : dependencies) {
            ComponentContainer fromModule = next.getFrom().getParent(ComponentContainer.class, new Class[0]);
            ComponentContainer toModule = next.getFrom().getParent(ComponentContainer.class, new Class[0]);
            FilePath fromFilePath = next.getFrom().getParent(FilePath.class, ParentMode.FIRST_PARENT);
            String fromFile = fromFilePath != null ? fromFilePath.getIdentifyingPath() : null;
            int line = next.getLineNumber();
            String from = next.getFrom().getPresentationName(false);
            String dependency = next.getDependencyInfo();
            String to = next.getTo().getPresentationName(false);
            FilePath toFilePath = next.getTo().getParent(FilePath.class, ParentMode.FIRST_PARENT);
            String toFile = toFilePath != null ? toFilePath.getIdentifyingPath() : null;
            String violation = next.isViolation() ? context.getViolationInfo(next.getElement()) : "";
            exportData.addRow(new Object[]{fromModule.getShortName(), fromFile, line, from, dependency, toModule.getShortName(), toFile, to, violation});
        }
    }

    private void e(ExportData exportData, List<Pair<String, String>> propertiesList) {
        assert (exportData != null) : "Parameter 'exportData' of method 'populatePairs' must not be null";
        assert (propertiesList != null) : "Parameter 'propertiesList' of method 'populatePairs' must not be null";
        exportData.addColumn("Property");
        exportData.addColumn("Value");
        for (Pair<String, String> property : propertiesList) {
            exportData.addRow(new Object[]{property.getFirst(), property.getSecond()});
        }
    }

    @Override
    public void a(TFile file, List<ExportData> exportDataList) {
        List<ExportData> exportDataToUse;
        assert (file != null) : "Parameter 'file' of method 'export' must not be null";
        assert (exportDataList != null) : "Parameter 'exportDataList' of method 'export' must not be null";
        ISoftwareSystemProvider provider = this.e.getExtension(ISoftwareSystemProvider.class);
        if (provider.hasSoftwareSystem()) {
            SoftwareSystem system = provider.getSoftwareSystem();
            ExportData systemInfo = new ExportData("System Info");
            systemInfo.addColumn("System");
            systemInfo.addColumn("Virtual Model");
            systemInfo.addColumn("Absolute Path");
            systemInfo.addColumn("Exported", ColumnDatatype.DATE);
            ModifiableModel modifiableModel = system.getCurrentModel(ModifiableModel.class);
            systemInfo.addRow(new Object[]{system.getFullyQualifiedName(), modifiableModel != null ? modifiableModel.getIdentifyingPath() : "Parser", system.getAbsolutePath(), new Date()});
            exportDataToUse = new ArrayList<ExportData>(exportDataList.size() + 1);
            exportDataToUse.add(systemInfo);
            exportDataToUse.addAll(exportDataList);
        } else {
            exportDataToUse = exportDataList;
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new ExportStartedEvent(provider));
        bm exportExecutor = new bm();
        exportExecutor.a(file, exportDataToUse, new bm.a(){

            @Override
            public void a(OperationResultWithOutcome<TFile> result) {
                EventManager.getInstance().dispatch((Object)this, (Event)new ExportFinishedEvent(B.this.e.getExtension(ISoftwareSystemProvider.class), result));
            }
        });
        if (this.g == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            exportExecutor.c();
        }
    }

    @Override
    public List<ExportData> getMetrics(Collection<NamedElement> elements, Set<IMetricDescriptor> metricDescriptors, Map<MetricAccessKey, IMetricValue> keyToValue, String scope) {
        assert (elements != null) : "Parameter 'elements' of method 'getMetrics' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'getMetrics' must not be null";
        assert (keyToValue != null) : "Parameter 'keyToValue' of method 'getMetrics' must not be null";
        assert (scope != null && scope.length() > 0) : "Parameter 'scope' of method 'getMetrics' must not be empty";
        if (metricDescriptors.isEmpty() || keyToValue.isEmpty()) {
            return Collections.emptyList();
        }
        ExportData exportData = new ExportData("Metrics", "Scope: " + scope);
        exportData.addColumn(b, ColumnDatatype.TEXT);
        Sort sort = Sort.DESCENDING;
        for (IMetricDescriptor descriptor : metricDescriptors) {
            exportData.addColumn(descriptor.getShortName(), ColumnDatatype.NUMBER, sort);
            sort = Sort.NONE;
        }
        for (NamedElement element : elements) {
            Object[] rowData = new Object[1 + metricDescriptors.size()];
            int i2 = 0;
            rowData[i2++] = element.getName();
            for (IMetricDescriptor metric : metricDescriptors) {
                MetricAccessKey key = new MetricAccessKey(element, metric.getShortName());
                IMetricValue value = keyToValue.get(key);
                Object object = rowData[i2++] = value == null ? (Number)null : (Number)value.getValue();
            }
            exportData.addRow(rowData);
        }
        return List.of(exportData);
    }

    @Override
    public List<ExportData> getAllMetrics(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getAllMetrics' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = this.e.getExtension(ISoftwareSystemProvider.class);
        if (!softwareSystemProvider.hasSoftwareSystem()) {
            return Collections.emptyList();
        }
        SoftwareSystem softwareSystem = softwareSystemProvider.getSoftwareSystem();
        n metricsExtension = this.e.getExtension(n.class);
        IThresholdProvider thresholdProvider = softwareSystem.getExtension(IThresholdProvider.class);
        THashMap elementToFullyQualifiedName = new THashMap();
        workerContext.setNumberOfSteps(2, new int[]{5, 95});
        workerContext.beginSubTask("Get all System Level Metrics");
        ArrayList<ExportData> result = new ArrayList<ExportData>();
        ExportData systemLevel = new ExportData("System");
        List<IMetricDescriptor> systemMetrics = metricsExtension.getAvailableSystemMetrics(true);
        this.a(workerContext, thresholdProvider, metricsExtension, softwareSystem, systemLevel, systemMetrics);
        result.add(systemLevel);
        workerContext.endSubTask();
        workerContext.beginSubTask("Get all Element Level Metrics");
        List<IMetricLevel> levels = metricsExtension.getAvailableElementMetricLevels(false, true);
        workerContext.setNumberOfSteps(levels.size());
        for (IMetricLevel metricLevel : levels) {
            workerContext.beginSubTask("Get all Element Level Metrics - " + metricLevel.getPresentationName());
            ExportData elementLevelExportData = new ExportData(metricLevel.getStandardName());
            this.a(workerContext, thresholdProvider, metricsExtension, softwareSystem, elementLevelExportData, metricLevel, (Map<NamedElement, String>)elementToFullyQualifiedName);
            result.add(elementLevelExportData);
            workerContext.endSubTask();
        }
        workerContext.endSubTask();
        return result;
    }

    @Override
    public List<ExportData> getIgnoreDefinitions(Collection<IgnoreDefinition> ignoreDefinitions) {
        assert (ignoreDefinitions != null) : "Parameter 'ignoreDefinitions' of method 'getIgnoreDefinitions' must not be null";
        ExportData exportData = new ExportData("Ignore Definitions");
        this.b(exportData, new ArrayList<IgnoreDefinition>(ignoreDefinitions));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getTaskDefinitions(Collection<TaskDefinition> taskDefinitions) {
        assert (taskDefinitions != null) : "Parameter 'taskDefinitions' of method 'getTaskDefinitions' must not be null";
        ExportData exportData = new ExportData("Task Definitions");
        this.d(exportData, new ArrayList<TaskDefinition>(taskDefinitions));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getRefactoringDefintions(Collection<RefactoringDefinition> refactoringDefinitions) {
        assert (refactoringDefinitions != null) : "Parameter 'refactoringDefinitions' of method 'getRefactoringDefintions' must not be null";
        ExportData exportData = new ExportData("Refactoring Definitions");
        this.c(exportData, new ArrayList<RefactoringDefinition>(refactoringDefinitions));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getParserDependencies(IContext context, Collection<ContextParserDependency> dependencies) {
        assert (context != null) : "Parameter 'context' of method 'getParserDependencies' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getParserDependencies' must not be null";
        ExportData exportData = new ExportData("Parser Dependencies");
        this.a(context, exportData, new ArrayList<ContextParserDependency>(dependencies));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getIssues(Collection<Issue> issues) {
        assert (issues != null) : "Parameter 'issues' of method 'getIssues' must not be null";
        ExportData exportData = new ExportData("Issues", "Issues");
        this.a(exportData, new ArrayList<Issue>(issues));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getProperties(IContext context, Element element) {
        assert (context != null) : "Parameter 'context' of method 'getProperties' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getProperties' must not be null";
        ExportData exportData = new ExportData("Properties", this.a(element));
        this.e(exportData, this.f.getProperties(context, element));
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getRankedIssues(Collection<IssueRank> rankedIssues) {
        assert (rankedIssues != null) : "Parameter 'rankedIssues' of method 'getRankedIssues' must not be null";
        ExportData exportData = new ExportData("Ranked Issues", "Ranked Issues");
        exportData.addColumn("Score", ColumnDatatype.NUMBER, Sort.DESCENDING);
        exportData.addColumn("Urgency", ColumnDatatype.NUMBER);
        exportData.addColumn("Importance", ColumnDatatype.NUMBER);
        exportData.addColumn("Issue Key");
        exportData.addColumn("Description");
        exportData.addColumn("Severity");
        exportData.addColumn("Category");
        exportData.addColumn(b);
        exportData.addColumn("To Element");
        exportData.addColumn("Line Number", ColumnDatatype.NUMBER);
        exportData.addColumn("Provider");
        for (IssueRank next : rankedIssues) {
            Float score = Float.valueOf(next.getScoreValue());
            Float urgency = Float.valueOf(next.getUrgencyValue());
            Float importance = Float.valueOf(next.getImportanceValue());
            Issue issue = (Issue)next.getRankedElement();
            String issueKey = issue.getKey();
            String description = issue.getDescription();
            String severity = issue.getSeverity().getStandardName();
            String category = issue.getId().getCategory().getStandardName();
            int lineNumber = issue.getLineNumber();
            String provider = issue.getProvider().getStandardName();
            Element affected = issue.getAffectedElement();
            String elementFQN = "n/a";
            String elementToFQN = "n/a";
            if (affected instanceof NamedElement) {
                elementFQN = ((NamedElement)affected).getFullyQualifiedName();
                elementToFQN = "n/a";
            } else if (affected instanceof Dependency) {
                Dependency dependency = (Dependency)affected;
                elementFQN = dependency.getUnderlyingFrom().getFullyQualifiedName();
                elementToFQN = dependency.getUnderlyingTo().getFullyQualifiedName();
            } else assert (false) : "Unexpected affected element: " + affected;
            exportData.addRow(new Object[]{score, urgency, importance, issueKey, description, severity, category, elementFQN, elementToFQN, lineNumber, provider});
        }
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getLeafElementData(TreeMapRepresentation treeMap, Collection<TreeMapNode<NamedElement, TreeMapNodeData>> leafs) {
        assert (treeMap != null) : "Parameter 'treeMap' of method 'getLeafElementData' must not be null";
        assert (leafs != null) : "Parameter 'leafs' of method 'getLeafElementData' must not be null";
        ExportData exportData = new ExportData(treeMap.getParent().getPresentationName(true), "Leaf Elements");
        exportData.addColumn(treeMap.getLeafElement());
        exportData.addColumn(treeMap.getColorAttribute(), ColumnDatatype.NUMBER);
        exportData.addColumn(treeMap.getSizeAttribute(), ColumnDatatype.NUMBER);
        if (treeMap.getType() == TreeMapType.THREE_DIMENSIONAL) {
            exportData.addColumn(treeMap.getHeightAttribute(), ColumnDatatype.NUMBER);
        }
        ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>> sorted = new ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>>(leafs);
        Collections.sort(sorted, (l1, l2) -> {
            int value1 = ((TreeMapNodeData)l1.getAssociatedData()).getLeafColorInfoProvider().getValue();
            int value2 = ((TreeMapNodeData)l2.getAssociatedData()).getLeafColorInfoProvider().getValue();
            return Integer.compare(value2, value1);
        });
        for (TreeMapNode treeMapNode : sorted) {
            String name = ((NamedElement)treeMapNode.getAssociatedElement()).getPresentationName(false);
            Integer colorValue = ((TreeMapNodeData)treeMapNode.getAssociatedData()).getLeafColorInfoProvider().getValue();
            Integer sizeValue = Math.round(treeMapNode.getSize());
            if (treeMap.getType() == TreeMapType.THREE_DIMENSIONAL) {
                Integer heightValue = ((TreeMapNodeData)treeMapNode.getAssociatedData()).getLeafHeightInfoProvider().getValue();
                exportData.addRow(new Object[]{name, colorValue, sizeValue, heightValue});
                continue;
            }
            exportData.addRow(new Object[]{name, colorValue, sizeValue});
        }
        return Collections.singletonList(exportData);
    }

    @Override
    public List<ExportData> getTemporalCouplingLinks(SourceFile from, Collection<TemporalCouplingLink> links) {
        assert (from != null) : "Parameter 'from' of method 'getTemporalCouplingLinks' must not be null";
        assert (links != null && links.size() > 0) : "Parameter 'links' of method 'getTemporalCouplingLinks' must not be empty";
        ExportData data = new ExportData("Temporal Coupling", "From: " + from.getIdentifyingPath());
        data.addColumn("Path");
        data.addColumn("Weight", ColumnDatatype.NUMBER);
        for (TemporalCouplingLink link : links) {
            data.addRow(new Object[]{link.getSource().getIdentifyingPath(), link.getWeight()});
        }
        return Collections.singletonList(data);
    }

    private static final class a
    implements Comparator<Resolution> {
        a() {
        }

        public int a(Resolution r1, Resolution r2) {
            assert (r1 != null) : "Parameter 'r1' of method 'compare' must not be null";
            assert (r2 != null) : "Parameter 'r2' of method 'compare' must not be null";
            return r1.getDate().compareTo(r2.getDate());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((Resolution)object, (Resolution)object2);
        }
    }
}

