/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.event.Event;
import com.hello2morrow.foundation.event.EventManager;
import com.hello2morrow.sonargraph.core.controller.system.a.a;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramDeletedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramModifiedEvent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramRepresentation;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IArchitectureDiagramProvider;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponentElement;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentConnector;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentInterface;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.Representations;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;

abstract class ArchitectureDiagramProvider
extends OptionalExtension
implements IArchitectureDiagramProvider {
    private final SoftwareSystem a;
    private static volatile /* synthetic */ int[] c;

    ArchitectureDiagramProvider(SoftwareSystem softwareSystem, boolean enabled) {
        super(enabled);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ArchitectureDiagramProvider' must not be null";
        this.a = softwareSystem;
    }

    protected final SoftwareSystem a() {
        return this.a;
    }

    protected final ArchitectureFile a(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'isCheckedAndLoaded' must not be null";
        return architectureFile.isChecked() && architectureFile.modelLoaded() ? architectureFile : null;
    }

    @Override
    public final boolean hasBeenCreated(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'hasBeenLoaded' must not be null";
        for (ArchitectureDiagramRepresentation next : this.a().getUniqueExistingChild(Representations.class).getChildren(ArchitectureDiagramRepresentation.class)) {
            if (next.getArchitectureFile() != file) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isCreatePossible(ArchitectureFile file) {
        assert (file != null) : "Parameter 'file' of method 'isLoadable' must not be null";
        ArchitectureFile architectureFile = this.a(file);
        return architectureFile != null && com.hello2morrow.sonargraph.core.controller.system.a.a.a(architectureFile);
    }

    protected final void a(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'performDelete' must not be null";
        representation.setInvalid();
        representation.remove();
    }

    @Override
    public final void delete(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'delete' must not be null";
        this.a(representation);
        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitectureDiagramDeletedEvent(this.a.getExtension(ISoftwareSystemProvider.class), representation.getArchitectureFile(), representation));
    }

    private boolean b(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'resetSelectionRelatedFlags' must not be null";
        boolean updateNeeded = false;
        for (UmlComponent nextUmlComponent : representation.getChildrenRecursively(UmlComponent.class, new Class[0])) {
            for (UmlComponentAnchor umlComponentAnchor : nextUmlComponent.getChildren(UmlComponentAnchor.class)) {
                if (umlComponentAnchor.isSelected() || umlComponentAnchor.isHighlighted()) {
                    updateNeeded = true;
                }
                umlComponentAnchor.setSelected(false);
                umlComponentAnchor.setHighlighted(false);
            }
            for (UmlComponent.Uses uses : nextUmlComponent.getOutgoingUses()) {
                if (uses.isSelected() || uses.isHighlighted() || uses.isHidden()) {
                    updateNeeded = true;
                }
                uses.setSelected(false);
                uses.setHighlighted(false);
                uses.setHidden(false);
            }
            for (UmlComponent.AnchorBased anchorBased : nextUmlComponent.getAnchorBased()) {
                if (anchorBased.isSelected() || anchorBased.isHighlighted() || anchorBased.isHidden()) {
                    updateNeeded = true;
                }
                anchorBased.setSelected(false);
                anchorBased.setHighlighted(false);
                anchorBased.setHidden(false);
            }
            if (nextUmlComponent.isSelected() || nextUmlComponent.isHighlighted()) {
                updateNeeded = true;
            }
            nextUmlComponent.setSelected(false);
            nextUmlComponent.setHighlighted(false);
        }
        return updateNeeded;
    }

    @Override
    public void deselectAll(ArchitectureDiagramRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'deselectAll' must not be null";
        if (this.b(representation)) {
            EventManager.getInstance().dispatch((Object)this, (Event)new ArchitectureDiagramModifiedEvent(this.a.getExtension(ISoftwareSystemProvider.class), representation.getArchitectureFile(), representation, ArchitectureDiagramModifiedEvent.Mode.UPDATE));
        }
    }

    private boolean a(UmlComponent.UmlComponentDependency dependency, Selection selection) {
        assert (dependency != null) : "Parameter 'dependency' of method 'setHidden' must not be null";
        assert (selection != null) : "Parameter 'selection' of method 'setHidden' must not be null";
        switch (ArchitectureDiagramProvider.b()[selection.ordinal()]) {
            case 3: {
                if (dependency.getSourceAnchor().isSelected()) {
                    return false;
                }
                if (!dependency.getSourceAnchor().isHighlighted()) break;
                return false;
            }
            case 4: {
                if (dependency.getTargetAnchor().isSelected()) {
                    return false;
                }
                if (!dependency.getTargetAnchor().isHighlighted()) break;
                return false;
            }
            case 2: {
                return !dependency.isSelected();
            }
            case 1: {
                if (!dependency.getSourceAnchor().isSelected() && !dependency.getSourceAnchor().isHighlighted() || !dependency.getTargetAnchor().isSelected() && !dependency.getTargetAnchor().isHighlighted()) break;
                return false;
            }
            case 5: {
                break;
            }
            default: {
                assert (false) : "Unhandled selection: " + (Object)((Object)selection);
                break;
            }
        }
        return true;
    }

    private void a(UmlComponent umlComponent) {
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'selectIncludedBy' must not be null";
        for (UmlComponent.AnchorBased nextAnchorBased : umlComponent.getAnchorBased()) {
            if (nextAnchorBased.getType() != UmlComponent.DependencyType.INCLUDED_BY) continue;
            UmlComponentAnchor<? extends ArchitectureElement> nextTargetAnchor = nextAnchorBased.getTargetAnchor();
            nextTargetAnchor.setSelected(true);
            UmlComponent nextUmlComponent = nextTargetAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "Parameter 'nextUmlComponent' of method 'selectExportedBy' must not be null";
            this.a(nextUmlComponent);
        }
    }

    private void b(UmlComponent umlComponent) {
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'selectExportedBy' must not be null";
        for (UmlComponent.AnchorBased nextAnchorBased : umlComponent.getAnchorBased()) {
            if (nextAnchorBased.getType() != UmlComponent.DependencyType.EXPORTED_BY) continue;
            UmlComponentAnchor<? extends ArchitectureElement> nextTargetAnchor = nextAnchorBased.getTargetAnchor();
            nextTargetAnchor.setSelected(true);
            UmlComponent nextUmlComponent = nextTargetAnchor.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (nextUmlComponent != null) : "Parameter 'nextUmlComponent' of method 'selectExportedBy' must not be null";
            this.b(nextUmlComponent);
        }
    }

    @Override
    public final void select(IUmlComponentElement element, ArchitectureDiagramRepresentation representation) {
        UmlComponent umlComponent;
        assert (element != null) : "Parameter 'element' of method 'select' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'select' must not be null";
        this.b(representation);
        Selection selection = Selection.NONE;
        if (element instanceof UmlComponent) {
            selection = Selection.COMPONENT;
            UmlComponent umlComponent2 = (UmlComponent)element;
            umlComponent2.setSelected(true);
            this.a(umlComponent2);
            this.b(umlComponent2);
            for (UmlComponentConnector nextConnector : umlComponent2.getChildren(UmlComponentConnector.class)) {
                nextConnector.setSelected(true);
                for (UmlComponentInterface nextInterface : representation.getAllowedInterfaces(nextConnector)) {
                    nextInterface.setHighlighted(true);
                }
            }
            for (UmlComponentInterface nextInterface : umlComponent2.getChildren(UmlComponentInterface.class)) {
                nextInterface.setSelected(true);
                for (UmlComponentConnector nextConnector : representation.getAllowedConnectors(nextInterface)) {
                    nextConnector.setHighlighted(true);
                }
            }
        } else if (element instanceof UmlComponent.UmlComponentDependency) {
            UmlComponent.UmlComponentDependency umlComponentDependency = (UmlComponent.UmlComponentDependency)element;
            if (umlComponentDependency.getType() == UmlComponent.DependencyType.USES) {
                selection = Selection.USES;
                umlComponentDependency.setSelected(true);
                umlComponentDependency.getSourceAnchor().setHighlighted(true);
                umlComponentDependency.getTargetAnchor().setHighlighted(true);
            }
        } else if (element instanceof UmlComponentConnector) {
            UmlComponentConnector connector = (UmlComponentConnector)element;
            connector.setSelected(true);
            umlComponent = connector.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (umlComponent != null) : "Parameter 'umlComponent' of method 'select' must not be null";
            this.a(umlComponent);
            for (UmlComponentInterface umlComponentInterface : representation.getAllowedInterfaces(connector)) {
                umlComponentInterface.setHighlighted(true);
            }
            selection = Selection.CONNECTOR;
        } else if (element instanceof UmlComponentInterface) {
            UmlComponentInterface inter = (UmlComponentInterface)element;
            inter.setSelected(true);
            umlComponent = inter.getParent(UmlComponent.class, ParentMode.ONLY_DIRECT_PARENT);
            assert (umlComponent != null) : "Parameter 'umlComponent' of method 'select' must not be null";
            this.b(umlComponent);
            for (UmlComponentConnector umlComponentConnector : representation.getAllowedConnectors(inter)) {
                umlComponentConnector.setHighlighted(true);
            }
            selection = Selection.INTERFACE;
        }
        if (selection != Selection.NONE) {
            for (UmlComponent nextUmlComponent : representation.getChildrenRecursively(UmlComponent.class, new Class[0])) {
                for (UmlComponent.Uses uses : nextUmlComponent.getOutgoingUses()) {
                    uses.setHidden(this.a(uses, selection));
                }
                for (UmlComponent.AnchorBased anchorBased : nextUmlComponent.getAnchorBased()) {
                    anchorBased.setHidden(this.a(anchorBased, selection));
                }
            }
        }
        EventManager.getInstance().dispatch((Object)this, (Event)new ArchitectureDiagramModifiedEvent(this.a.getExtension(ISoftwareSystemProvider.class), representation.getArchitectureFile(), representation, ArchitectureDiagramModifiedEvent.Mode.UPDATE));
    }

    static /* synthetic */ int[] b() {
        if (c != null) {
            return c;
        }
        int[] nArray = new int[Selection.values().length];
        try {
            nArray[Selection.COMPONENT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Selection.CONNECTOR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Selection.INTERFACE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Selection.NONE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Selection.USES.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        c = nArray;
        return nArray;
    }

    private static enum Selection {
        COMPONENT,
        USES,
        CONNECTOR,
        INTERFACE,
        NONE;

    }
}

