/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.Root;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class A
implements INamedElementResolver {
    private static final Logger b = LoggerFactory.getLogger(A.class);
    private static final String c = "I";
    private static final String d = "N";
    private static final String e = "W";
    private static final String f = "P";
    private final Map<String, Root> g = new HashMap<String, Root>(2);
    private final Map<Root, String> h = new HashMap<Root, String>(2);

    A(Root root) {
        assert (root != null) : "Parameter 'root' of method 'CoreNamedElementResolver' must not be null";
        String name = root.getClass().getSimpleName();
        this.g.put(name, root);
        this.h.put(root, name);
    }

    void a(Root root) {
        assert (root != null) : "Parameter 'root' of method 'add' must not be null";
        String name = root.getClass().getSimpleName();
        Root previous = this.g.put(name, root);
        assert (previous == null) : "Root for resolver already present: " + root.getClass().getSimpleName();
        this.h.put(root, name);
    }

    void b(Root root) {
        assert (root != null) : "Parameter 'root' of method 'remove' must not be null";
        String name = root.getClass().getSimpleName();
        Root removed = this.g.remove(name);
        if (removed != null) {
            this.h.remove(root);
        }
    }

    private String a(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getNamedElementDescriptor' must not be null";
        if (namedElement instanceof Root) {
            return "";
        }
        String originalFullyQualifiedName = namedElement.getOriginalFullyQualifiedName();
        return originalFullyQualifiedName != null ? originalFullyQualifiedName : namedElement.getFullyQualifiedName();
    }

    private NamedElement a(Root root, List<String> splitDescriptor, boolean originalOnly) {
        assert (root != null) : "Parameter 'root' of method 'resolveNamedElement' must not be null";
        assert (splitDescriptor != null) : "Parameter 'splitDescriptor' of method 'resolveNamedElement' must not be null";
        NamedElement resolved = root;
        if (!splitDescriptor.isEmpty()) {
            for (String nextNamePart : splitDescriptor) {
                NamedElement currentResolved;
                NamedElement namedElement = currentResolved = originalOnly ? resolved.resolveOriginalByFullyQualifiedNamePart(nextNamePart) : resolved.resolveByFullyQualifiedNamePart(nextNamePart);
                if (currentResolved == null) {
                    return null;
                }
                resolved = currentResolved;
            }
        }
        return resolved;
    }

    private Root a(NamedElement ... involvedNamedElements) {
        assert (involvedNamedElements != null && involvedNamedElements.length > 0) : "Parameter 'involvedNamedElements' of method 'initDescriptor' must not be empty";
        Root root = null;
        NamedElement[] namedElementArray = involvedNamedElements;
        int n2 = involvedNamedElements.length;
        int n3 = 0;
        while (n3 < n2) {
            NamedElement nextInvolved = namedElementArray[n3];
            Root nextRoot = nextInvolved.getParent(Root.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (nextRoot == null) {
                b.warn("Named element not contained in root class: [" + nextInvolved.getClass().getName() + "] " + nextInvolved.getName());
                return null;
            }
            if (root != null && nextRoot != root) {
                b.warn("Named element provides different root: [" + nextInvolved.getClass().getName() + "] " + nextInvolved.getName() + " in root: " + nextRoot);
                return null;
            }
            if (root == null) {
                root = nextRoot;
            }
            ++n3;
        }
        if (root != null && !this.h.containsKey(root)) {
            b.error("'root' of method 'getRoot' is not a recognized root: " + root + ". Involved elements are: " + Arrays.toString(involvedNamedElements));
            root = null;
        }
        return root;
    }

    private a a(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'getDescriptor' must not be null";
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            Root root = this.a(new NamedElement[]{namedElement});
            if (root != null) {
                a descriptorRequest = new a(this.h.get(root));
                descriptorRequest.a(d);
                String descriptor = this.a(namedElement);
                if (descriptor != null) {
                    if (!descriptor.isEmpty()) {
                        descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                        descriptorRequest.a(descriptor);
                    }
                    return descriptorRequest;
                }
            }
        } else if (element instanceof ParserDependency) {
            ProgrammingElement to;
            ParserDependency dependency = (ParserDependency)element;
            ProgrammingElement from = dependency.getFrom();
            Root root = this.a(from, to = dependency.getTo());
            if (root != null) {
                String fromDescriptor = this.a((NamedElement)from);
                String toDescriptor = this.a((NamedElement)to);
                if (fromDescriptor != null && !fromDescriptor.isEmpty() && toDescriptor != null && !toDescriptor.isEmpty()) {
                    IParserDependencyType dependencyType = dependency.getDependencyType();
                    String dependencyContribution = dependency.getDescriptorContribution();
                    int lineNumber = dependency.getLineNumber();
                    a descriptorRequest = new a(this.h.get(root));
                    descriptorRequest.a(f);
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(dependencyType.getStandardName());
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(dependencyContribution);
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(Integer.toString(lineNumber));
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(fromDescriptor);
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(toDescriptor);
                    return descriptorRequest;
                }
            }
        } else if (element instanceof WorkspaceDependency) {
            NamedElement to;
            NamedElement from;
            Root root;
            WorkspaceDependency workspaceDependency = (WorkspaceDependency)element;
            assert (workspaceDependency.getFrom() != null) : "'from' of workspaceDependency must not be null";
            if (workspaceDependency.getTo() != null && (root = this.a(from = (NamedElement)workspaceDependency.getFrom().getUnderlyingObject(), to = (NamedElement)workspaceDependency.getTo().getUnderlyingObject())) != null) {
                String fromDescriptor = this.a(from);
                String toDescriptor = this.a(to);
                if (fromDescriptor != null && !fromDescriptor.isEmpty() && toDescriptor != null && !toDescriptor.isEmpty()) {
                    a descriptorRequest = new a(this.h.get(root));
                    descriptorRequest.a(e);
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(fromDescriptor);
                    descriptorRequest.a(Element.DESCRIPTOR_SEPARATOR);
                    descriptorRequest.a(toDescriptor);
                    return descriptorRequest;
                }
            }
        }
        return null;
    }

    private int a(List<String> list, String of, int numberOfOccurrence) {
        assert (list != null && !list.isEmpty()) : "Parameter 'list' of method 'getPos' must not be empty";
        assert (of != null) : "Parameter 'of' of method 'getPos' must not be null";
        int currentNumberOfOccurrence = 0;
        int i2 = 0;
        while (i2 < list.size()) {
            String next = list.get(i2);
            if (next.equals(of) && ++currentNumberOfOccurrence == numberOfOccurrence) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private Pair<NamedElement, NamedElement> a(Root root, List<String> remainingDescriptor, String descriptor, String descriptorType, boolean originalOnly) {
        assert (root != null) : "Parameter 'root' of method 'resolveNamedElementDependencyEndpoints' must not be null";
        assert (remainingDescriptor != null) : "Parameter 'remainingDescriptor' of method 'resolveNamedElementDependencyEndpoints' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'resolveNamedElementDependencyEndpoints' must not be empty";
        assert (descriptorType != null) : "Parameter 'descriptorType' of method 'resolveNamedElementDependencyEndpoints' must not be null";
        assert (descriptorType.equals(f) || descriptorType.equals(e)) : "Unexpected descriptor type " + descriptorType;
        int numberOfOccurrence = descriptorType.equals(e) ? 1 : 4;
        int initialPositionforFromDescriptor = descriptorType.equals(e) ? 0 : 6;
        int pos = this.a(remainingDescriptor, Element.DESCRIPTOR_SEPARATOR, numberOfOccurrence);
        if (pos == -1) {
            b.warn("Descriptor not valid: " + descriptor);
            return null;
        }
        List<String> fromDescriptor = remainingDescriptor.subList(initialPositionforFromDescriptor, pos);
        List<String> toDescriptor = remainingDescriptor.subList(pos + 1, remainingDescriptor.size());
        NamedElement from = this.a(root, fromDescriptor, originalOnly);
        NamedElement to = this.a(root, toDescriptor, originalOnly);
        if (from != null && to != null) {
            return new Pair((Object)from.getRepresentative(), (Object)to.getRepresentative());
        }
        return null;
    }

    private ElementWithIssues a(Root root, String type, List<String> splitDescriptor, String descriptor, boolean originalOnly) {
        assert (root != null) : "Parameter 'root' of method 'resolve' must not be null";
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'resolve' must not be empty";
        assert (splitDescriptor != null) : "Parameter 'splitDescriptor' of method 'resolve' must not be null";
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'resolve' must not be empty";
        switch (type) {
            case "N": {
                NamedElement resolveNamedElement = this.a(root, splitDescriptor, originalOnly);
                if (resolveNamedElement != null) {
                    resolveNamedElement.getRepresentative();
                }
                return resolveNamedElement;
            }
            case "P": {
                Pair<NamedElement, NamedElement> dependencyEndpoints = this.a(root, splitDescriptor, descriptor, type, originalOnly);
                if (dependencyEndpoints == null) break;
                NamedElement from = (NamedElement)dependencyEndpoints.getFirst();
                NamedElement to = (NamedElement)dependencyEndpoints.getSecond();
                if (!(from instanceof ProgrammingElement) || !(to instanceof ProgrammingElement)) break;
                String dependencyType = splitDescriptor.get(0);
                String dependencyContribution = splitDescriptor.get(2);
                String lineAsString = splitDescriptor.get(4);
                int lineNumber = -1;
                try {
                    lineNumber = Integer.parseInt(lineAsString);
                }
                catch (Throwable t2) {
                    b.warn("Descriptor not valid (not a valid dependency line number): " + descriptor);
                    return null;
                }
                List<ParserDependency> outgoingDependencies = ((ProgrammingElement)from).getOutgoingDependencies(new IParserDependencyType[0]);
                ArrayList<ParserDependency> matchingDependencies = new ArrayList<ParserDependency>();
                for (ParserDependency next : outgoingDependencies) {
                    if (next.getTo() != to || !next.getDependencyType().getStandardName().equals(dependencyType) || !next.getDescriptorContribution().equals(dependencyContribution) || lineNumber != next.getLineNumber()) continue;
                    matchingDependencies.add(next);
                }
                if (matchingDependencies.size() == 1) {
                    return (ElementWithIssues)matchingDependencies.get(0);
                }
                if (matchingDependencies.isEmpty()) break;
                b.warn("Descriptor name not unique: '" + descriptor + "' for endpoints from: " + from + " and to: " + to);
                break;
            }
            case "W": {
                Pair<NamedElement, NamedElement> workspaceDependencyEndpoints = this.a(root, splitDescriptor, descriptor, type, originalOnly);
                if (workspaceDependencyEndpoints == null) break;
                NamedElement from = (NamedElement)workspaceDependencyEndpoints.getFirst();
                NamedElement to = (NamedElement)workspaceDependencyEndpoints.getSecond();
                if (!(from instanceof IWorkspaceDependencyElement) || !(to instanceof IWorkspaceDependencyElement)) break;
                return ((IWorkspaceDependencyElement)((Object)from)).getOutgoingWorkspaceDependency((IWorkspaceDependencyElement)((Object)to));
            }
            default: {
                assert (false) : "Unhandled element with issues type: " + type;
                break;
            }
        }
        return null;
    }

    @Override
    public String getDescriptor(Element element) {
        a descriptorRequest;
        assert (element != null) : "Parameter 'element' of method 'getDescriptor' must not be null";
        if (element instanceof Issue) {
            Issue issue = (Issue)element;
            Element affectedElement = issue.getAffectedElement();
            assert (affectedElement instanceof ElementWithIssues) : "Unexpected class: " + affectedElement;
            a descriptorRequest2 = this.a((ElementWithIssues)affectedElement);
            if (descriptorRequest2 != null) {
                descriptorRequest2.b(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.b(issue.getDescriptorContribution());
                descriptorRequest2.b(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.b(Integer.toString(issue.getColumn()));
                descriptorRequest2.b(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.b(Integer.toString(issue.getLineNumber()));
                descriptorRequest2.b(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.b(Element.escapeSpecialCharacters(issue.getProvider().getStandardName()));
                descriptorRequest2.b(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.b(Element.escapeSpecialCharacters(issue.getId().getStandardName()));
                descriptorRequest2.b(Element.DESCRIPTOR_SEPARATOR);
                descriptorRequest2.b(c);
                return String.valueOf(descriptorRequest2.a()) + Element.DESCRIPTOR_SEPARATOR + descriptorRequest2.b();
            }
        } else if (element instanceof ElementWithIssues && (descriptorRequest = this.a((ElementWithIssues)element)) != null) {
            return String.valueOf(descriptorRequest.a()) + Element.DESCRIPTOR_SEPARATOR + descriptorRequest.b();
        }
        return null;
    }

    @Override
    public Element resolve(String descriptor) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'splitDescriptor' must not be null";
        List<String> splitDescriptor = Element.splitDescriptor(descriptor);
        if (splitDescriptor.size() < 3) {
            b.warn("Descriptor not valid: " + descriptor);
            return null;
        }
        String rootIdentifier = splitDescriptor.get(0);
        Root root = this.g.get(rootIdentifier);
        if (root == null) {
            b.warn("Root not available in resolver: " + rootIdentifier);
            return null;
        }
        if (splitDescriptor.size() == 3) {
            splitDescriptor.add("");
        }
        String type = splitDescriptor.get(2);
        List<String> remainingDescriptor = splitDescriptor.subList(4, splitDescriptor.size());
        if (c.equals(type)) {
            String affectedElementType = remainingDescriptor.get(10);
            ElementWithIssues resolvedAffectedElement = root;
            if (remainingDescriptor.size() > 12) {
                List<String> splitAffectedElementDescriptor = remainingDescriptor.subList(12, remainingDescriptor.size());
                resolvedAffectedElement = this.a(root, affectedElementType, splitAffectedElementDescriptor, descriptor, true);
            }
            if (resolvedAffectedElement != null) {
                String issueIdStandardName = remainingDescriptor.get(0);
                String issueProviderStandardName = remainingDescriptor.get(2);
                String lineAsString = remainingDescriptor.get(4);
                String columnAsString = remainingDescriptor.get(6);
                String descriptorContribution = remainingDescriptor.get(8);
                int lineNumber = -1;
                int columnNumber = -1;
                try {
                    lineNumber = Integer.parseInt(lineAsString);
                    columnNumber = Integer.parseInt(columnAsString);
                }
                catch (Throwable t2) {
                    b.warn("Descriptor not valid (not a valid issue line number): " + descriptor);
                    return null;
                }
                for (Issue nextIssue : resolvedAffectedElement.getIssues()) {
                    if (!nextIssue.getId().getStandardName().equals(issueIdStandardName) || !nextIssue.getProvider().getStandardName().equals(issueProviderStandardName) || nextIssue.getLineNumber() != lineNumber || nextIssue.getColumn() != columnNumber || !descriptorContribution.equals(nextIssue.getDescriptorContribution())) continue;
                    return nextIssue;
                }
            }
            return null;
        }
        return this.a(root, type, remainingDescriptor, descriptor, true);
    }

    @Override
    public NamedElement resolve(Root root, String fqName) {
        assert (root != null) : "Parameter 'root' of method 'resolve' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'resolve' must not be null";
        List<String> split = Element.splitDescriptor(fqName);
        if (split.isEmpty()) {
            return null;
        }
        return this.a(root, split, false);
    }

    @Override
    public NamedElement resolveOriginal(Root root, String fqName) {
        List<String> split = Element.splitDescriptor(fqName);
        if (split.isEmpty()) {
            return null;
        }
        return this.a(root, split, true);
    }

    @Override
    public <T> T resolve(Root root, String fqName, Class<T> namedElementClass) {
        assert (root != null) : "Parameter 'root' of method 'resolve' must not be null";
        assert (fqName != null) : "Parameter 'fqName' of method 'resolve' must not be null";
        assert (namedElementClass != null) : "Parameter 'namedElementClass' of method 'resolve' must not be null";
        NamedElement resolved = this.resolve(root, fqName);
        if (resolved != null && namedElementClass.isAssignableFrom(resolved.getClass())) {
            return (T)resolved;
        }
        return null;
    }

    private static final class a {
        private final String b;
        private final StringBuilder c = new StringBuilder();

        a(String root) {
            assert (root != null && root.length() > 0) : "Parameter 'root' of method 'DescriptorRequest' must not be empty";
            this.b = root;
        }

        void a(String append) {
            assert (append != null && append.length() > 0) : "Parameter 'append' of method 'appendToDescriptor' must not be empty";
            this.c.append(append);
        }

        String a() {
            return this.b;
        }

        public void b(String prepend) {
            assert (prepend != null && prepend.length() > 0) : "Parameter 'prepend' of method 'prepend' must not be empty";
            this.c.insert(0, prepend);
        }

        String b() {
            assert (this.c.length() > 0) : "'m_descriptor' of method 'getDescriptor' must not be empty";
            return this.c.toString();
        }

        public String toString() {
            return "[" + this.b + "] " + this.c.toString();
        }
    }
}

