/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.foundation.activity.ActivityMode;
import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.command.common.j;
import com.hello2morrow.sonargraph.core.command.system.aq;
import com.hello2morrow.sonargraph.core.command.system.base.d;
import com.hello2morrow.sonargraph.core.command.system.c;
import com.hello2morrow.sonargraph.core.command.system.i;
import com.hello2morrow.sonargraph.core.controllerinterface.system.F;
import com.hello2morrow.sonargraph.core.controllerinterface.system.y;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class RefreshCommand
extends d<IRefreshInteraction> {
    public RefreshCommand(ISoftwareSystemProvider provider, IRefreshInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final boolean d() {
        return true;
    }

    @Override
    public final ActivityMode c() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    @Override
    public final boolean m() {
        return false;
    }

    protected abstract boolean o();

    @Override
    protected final void a(IWorkerContext workerContext) {
        y controller = this.y();
        IRefreshInteraction interaction = (IRefreshInteraction)this.r();
        a refreshData = new a();
        interaction.a(refreshData);
        workerContext.setNumberOfSteps(2, new int[]{3, 97});
        workerContext.beginSubTask("Prepare Refresh");
        PrepareRefreshResult prepareRefresh = controller.a(workerContext, refreshData.a(), refreshData.b());
        interaction.a(prepareRefresh);
        workerContext.endSubTask();
        if (prepareRefresh.isSuccess()) {
            PrepareRefreshResult.SoftwareSystemFileModification softwareSystemFileModification = prepareRefresh.getSoftwareSystemFileModification();
            if (softwareSystemFileModification != PrepareRefreshResult.SoftwareSystemFileModification.NONE) {
                IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse response = interaction.a(softwareSystemFileModification);
                switch (response) {
                    case CONTINUE: {
                        prepareRefresh.setIgnoreSoftwareSystemFileModification();
                        break;
                    }
                    case CLOSE: {
                        workerContext.beginSubTask("Close Software System");
                        this.a(new i((ISoftwareSystemProvider)this.y(), interaction), workerContext);
                        workerContext.endSubTask();
                        return;
                    }
                    case RELOAD: {
                        workerContext.beginSubTask("Reload Software System");
                        this.a(new aq(this.y(), interaction, this.o()), workerContext);
                        workerContext.endSubTask();
                        return;
                    }
                    default: {
                        assert (false) : "Unhandled software system file modification response:" + (Object)((Object)response);
                        break;
                    }
                }
            }
            if (prepareRefresh.confirmationRequired() && !interaction.b(prepareRefresh)) {
                return;
            }
            OperationResult saveResult = new OperationResult("Confirm save for external changes");
            SoftwareSystem softwareSystem = this.y().getSoftwareSystem();
            if (softwareSystem.getUniqueExistingChild(Workspace.class).isExternalConfigurationChanged() && !this.a(workerContext, saveResult)) {
                return;
            }
            for (PrepareRefreshResult.Question question : prepareRefresh.getQuestions()) {
                if (!interaction.a(question)) continue;
                question.recordAnswer(true);
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Refresh");
            OperationResult refreshResult = controller.a(workerContext, prepareRefresh);
            workerContext.endSubTask();
            boolean isRefreshSuccess = refreshResult.isSuccess();
            if (softwareSystem.getUniqueExistingChild(Workspace.class).isExternalConfigurationChanged()) {
                saveResult.reset();
                this.a(workerContext, saveResult);
            }
            refreshResult.addMessagesFrom(saveResult);
            refreshResult.setIsSuccess(isRefreshSuccess);
            interaction.d(refreshResult);
        }
    }

    private boolean a(IWorkerContext workerContext, OperationResult result) {
        boolean historyAvailable;
        SoftwareSystem softwareSystem = this.y().getSoftwareSystem();
        F undoRedoExtension = softwareSystem.getExtension(F.class);
        SoftwareSystemFile systemFile = this.y().getSoftwareSystem().getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        boolean originalNeedsSave = systemFile.needsSave();
        boolean bl2 = historyAvailable = undoRedoExtension.a(softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile()) > 0;
        if (((IRefreshInteraction)this.r()).a(historyAvailable)) {
            if (!originalNeedsSave) {
                systemFile.setNeedsSave(true);
            }
            OperationResult saveResult = this.y().a(workerContext);
            result.addMessagesFrom(saveResult);
            if (saveResult.isFailure() && originalNeedsSave != systemFile.needsSave()) {
                systemFile.setNeedsSave(originalNeedsSave);
            }
            return true;
        }
        return false;
    }

    public static interface IRefreshInteraction
    extends c.a {
        public static final /* synthetic */ boolean c;

        public void a(a var1);

        default public void a(PrepareRefreshResult result) {
            assert (result != null) : "Parameter 'result' of method 'processRefreshPrepareResult' must not be null";
        }

        public PreRefreshSoftwareSystemFileModificationResponse a(PrepareRefreshResult.SoftwareSystemFileModification var1);

        public boolean b(PrepareRefreshResult var1);

        public boolean a(PrepareRefreshResult.Question var1);

        default public void d(OperationResult result) {
            assert (result != null) : "Parameter 'result' of method 'processRefreshResult' must not be null";
        }

        public static enum PreRefreshSoftwareSystemFileModificationResponse {
            CONTINUE,
            CLOSE,
            RELOAD;

        }
    }

    public static final class a
    implements j {
        private final Set<ISoftwareSystemProvider.IRefreshOption> b = new LinkedHashSet<ISoftwareSystemProvider.IRefreshOption>();
        private final Set<Language> c = new LinkedHashSet<Language>();

        public void a(ISoftwareSystemProvider.IRefreshOption ... options) {
            assert (options != null) : "Parameter 'options' of method 'addOptions' must not be null";
            this.b.addAll(Arrays.asList(options));
        }

        public void b(ISoftwareSystemProvider.IRefreshOption ... options) {
            assert (options != null) : "Parameter 'options' of method 'removeOptions' must not be null";
            this.b.removeAll(Arrays.asList(options));
        }

        Set<ISoftwareSystemProvider.IRefreshOption> a() {
            return Collections.unmodifiableSet(this.b);
        }

        public void a(Language language) {
            assert (language != null) : "Parameter 'language' of method 'addLimitTo' must not be null";
            this.c.add(language);
        }

        Set<Language> b() {
            return Collections.unmodifiableSet(this.c);
        }

        public String toString() {
            return "Refresh options: " + this.b.toString() + ", limit to languages: " + this.c.toString();
        }
    }
}

