/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.Platform;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.license.controller.a;
import com.hello2morrow.sonargraph.core.command.common.ProductProperty;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseMessageCause;
import com.hello2morrow.sonargraph.core.command.common.g;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class q {
    static final int a = -1;
    private static final Logger c = LoggerFactory.getLogger(q.class);
    private static final String d = ",";
    private static final String e = "Any";
    private static final String f = "Never";
    private static final String g = ".";
    private static final String h = "yyyy-MM-dd";
    private static final String i = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final int j = 14;
    private static final String k = "Language-";
    private final List<String> l = new ArrayList<String>();
    private final SonargraphProduct m;
    private final Version n;
    private final Map<String, String> o;
    private final Map<String, Language> p;
    private final a q;
    private static volatile /* synthetic */ int[] r;

    q(SonargraphProduct product, Version version, Map<String, String> productProperties, Map<String, Language> availableLanguages, a licenseProvider) {
        assert (product != null) : "Parameter 'product' of method 'SonargraphLicenseValidator' must not be null";
        assert (version != null) : "Parameter 'version' of method 'SonargraphLicenseValidator' must not be null";
        assert (productProperties != null) : "Parameter 'productProperties' of method 'SonargraphLicenseValidator' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'SonargraphLicenseValidator' must not be null";
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'SonargraphLicenseValidator' must not be null";
        this.m = product;
        this.n = version;
        this.o = productProperties;
        this.p = availableLanguages;
        this.q = licenseProvider;
    }

    static final boolean a(Version productVersion, Version licenseVersion) {
        assert (licenseVersion != null) : "Parameter 'licensedVersion' of method 'isLicensedVersionValid' must not be null";
        assert (productVersion != null) : "Parameter 'productVersion' of method 'isLicensedVersionValid' must not be null";
        assert (productVersion.getMajor() != -1) : "Invalid product version (major): " + productVersion;
        assert (licenseVersion.getMajor() != -1) : "Invalid license version: " + productVersion;
        if (licenseVersion.getMajor() > productVersion.getMajor()) {
            return true;
        }
        if (productVersion.getMajor() > licenseVersion.getMajor()) {
            return false;
        }
        if (licenseVersion.getMinor() != -1) {
            assert (productVersion.getMinor() != -1) : "Invalid product version (minor): " + productVersion;
            if (licenseVersion.getMinor() > productVersion.getMinor()) {
                return true;
            }
            if (productVersion.getMinor() > licenseVersion.getMinor()) {
                return false;
            }
        }
        if (licenseVersion.getIncrement() != -1) {
            assert (productVersion.getIncrement() != -1) : "Invalid product version (increment): " + productVersion;
            if (licenseVersion.getIncrement() > productVersion.getIncrement()) {
                return true;
            }
            if (productVersion.getIncrement() > licenseVersion.getIncrement()) {
                return false;
            }
        }
        if (licenseVersion.getBuild() != -1) {
            assert (productVersion.getBuild() != -1) : "Invalid product version (build): " + productVersion;
            if (licenseVersion.getBuild() > productVersion.getBuild()) {
                return true;
            }
            if (productVersion.getBuild() > licenseVersion.getBuild()) {
                return false;
            }
        }
        return true;
    }

    void a(SonargraphLicense license, String key, String value, Map<Language, Integer> licensedLanguageToSize) {
        assert (license != null) : "Parameter 'license' of method 'processLanguae' must not be null";
        assert (key != null) : "Parameter 'key' of method 'processLanguae' must not be null";
        assert (value != null) : "Parameter 'value' of method 'processLanguae' must not be null";
        assert (licensedLanguageToSize != null) : "Parameter 'licensedLanguageToSize' of method 'validateLanguage' must not be null";
        Language availableLanguage = this.p.get(key);
        if (availableLanguage != null) {
            if (availableLanguage.needsLicense()) {
                try {
                    Integer size = Integer.valueOf(value);
                    if (size != -1) {
                        licensedLanguageToSize.put(availableLanguage, size);
                    }
                }
                catch (NumberFormatException ex) {
                    license.a().addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.INVALID_LANGUAGE_SIZE_FORMAT, "For language '" + key + "'", new Object[0]);
                }
            }
        } else {
            license.a().addWarning((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LANGUAGE_NOT_AVAILABLE_IN_INSTALLATION, "'" + key + "'", new Object[0]);
        }
    }

    private void a(SonargraphLicense license, String version) {
        assert (license != null) : "Parameter 'license' of method 'validateVersion' must not be null";
        assert (version != null) : "Parameter 'version' of method 'processVersion' must not be null";
        if (e.equalsIgnoreCase(version)) {
            return;
        }
        if (version.contains(g)) {
            String[] licenseVersionParts = version.split("\\.");
            try {
                int major = Integer.parseInt(licenseVersionParts[0]);
                int minor = licenseVersionParts.length >= 2 ? Integer.parseInt(licenseVersionParts[1]) : -1;
                int increment = licenseVersionParts.length >= 3 ? Integer.parseInt(licenseVersionParts[2]) : -1;
                int build = licenseVersionParts.length == 4 ? Integer.parseInt(licenseVersionParts[3]) : -1;
                Version licenseVersion = Version.create((int)major, (int)minor, (int)increment, (int)build);
                if (!com.hello2morrow.sonargraph.core.command.common.q.a(this.n, licenseVersion)) {
                    license.a(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.VERSION_NOT_LICENSED);
                }
            }
            catch (NumberFormatException ex) {
                license.a(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.INVALID_VERSION_FORMAT);
            }
        } else {
            try {
                int major = Integer.parseInt(version);
                Version licenseVersion = Version.create((int)major, (int)-1, (int)-1, (int)-1);
                if (!com.hello2morrow.sonargraph.core.command.common.q.a(this.n, licenseVersion)) {
                    license.a(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.VERSION_NOT_LICENSED);
                }
            }
            catch (NumberFormatException ex) {
                license.a(SonargraphLicense.Property.VERSION, SonargraphLicenseMessageCause.INVALID_VERSION_FORMAT);
            }
        }
    }

    private void b(SonargraphLicense license, String product) {
        assert (license != null) : "Parameter 'license' of method 'validateProduct' must not be null";
        if (product != null && !product.isEmpty()) {
            HashSet<String> products = new HashSet<String>();
            String[] stringArray = product.split(d);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String nextProduct = stringArray[n3];
                if (nextProduct.equals("SonargraphExplorer")) {
                    products.add("Sonargraph");
                } else {
                    products.add(nextProduct);
                }
                ++n3;
            }
            if (!products.contains(this.m.getStandardName())) {
                license.a(SonargraphLicense.Property.PRODUCT, SonargraphLicenseMessageCause.PRODUCT_DOES_NOT_MATCH);
            }
        } else {
            license.a(SonargraphLicense.Property.PRODUCT, SonargraphLicenseMessageCause.PRODUCT_NOT_SPECIFIED);
        }
    }

    private void c(SonargraphLicense license, String macAddresses) {
        assert (license != null) : "Parameter 'license' of method 'validateMacAddresses' must not be null";
        assert (macAddresses != null) : "Parameter 'macAddresses' of method 'validateMacAddresses' must not be empty";
        if (e.equalsIgnoreCase(macAddresses)) {
            return;
        }
        HashSet<String> splitMacAddresses = new HashSet<String>();
        String[] stringArray = macAddresses.split(d);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String nextMacAddress = stringArray[n3];
            splitMacAddresses.add(nextMacAddress);
            ++n3;
        }
        OperationResult.IMessageCause errorCause = this.q.a(splitMacAddresses);
        if (errorCause != null) {
            license.a(SonargraphLicense.Property.MAC_ADDRESSES, errorCause);
        }
    }

    private void d(SonargraphLicense license, String date) {
        boolean checkDateOnly;
        SimpleDateFormat parserSDF;
        assert (license != null) : "Parameter 'license' of method 'validateTicketExpirationDate' must not be null";
        assert (date != null) : "Parameter 'date' of method 'validateTicketExpirationDate' must not be null";
        if (f.equalsIgnoreCase(date)) {
            license.c(com.hello2morrow.sonargraph.core.command.common.g.a);
            return;
        }
        if (date.indexOf(84) > 0) {
            parserSDF = new SimpleDateFormat(i);
            checkDateOnly = false;
        } else {
            parserSDF = new SimpleDateFormat(h);
            checkDateOnly = true;
        }
        parserSDF.setLenient(false);
        Date dateObj = null;
        try {
            dateObj = parserSDF.parse(date);
            license.c(dateObj);
        }
        catch (ParseException ex) {
            license.a(SonargraphLicense.Property.TICKET_EXPIRATION, SonargraphLicenseMessageCause.INVALID_DATE_FORMAT);
            return;
        }
        if (checkDateOnly) {
            if (this.q.a(dateObj) < 0) {
                license.a(SonargraphLicense.Property.TICKET_EXPIRATION, SonargraphLicenseMessageCause.LICENSE_TICKET_EXPIRED);
            }
        } else {
            Date now = new Date();
            if (now.compareTo(dateObj) > 0) {
                license.a(SonargraphLicense.Property.TICKET_EXPIRATION, SonargraphLicenseMessageCause.LICENSE_TICKET_EXPIRED);
            }
        }
    }

    private void e(SonargraphLicense license, String date) {
        assert (license != null) : "Parameter 'license' of method 'validateExpirationDate' must not be null";
        assert (date != null) : "Parameter 'date' of method 'validateExpirationDate' must not be null";
        if (f.equalsIgnoreCase(date)) {
            license.a(com.hello2morrow.sonargraph.core.command.common.g.a);
            return;
        }
        SimpleDateFormat parserSDF = new SimpleDateFormat(h);
        parserSDF.setLenient(false);
        Date dateObj = null;
        try {
            dateObj = parserSDF.parse(date);
            license.a(dateObj);
        }
        catch (ParseException ex) {
            license.a(SonargraphLicense.Property.EXPIRATION, SonargraphLicenseMessageCause.INVALID_DATE_FORMAT);
            return;
        }
        int daysLeft = this.q.a(dateObj);
        if (daysLeft <= 0) {
            license.a(SonargraphLicense.Property.EXPIRATION, SonargraphLicenseMessageCause.LICENSE_EXPIRED);
        } else if (daysLeft < 14) {
            String msg = license.a().addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_CONTRACT_WILL_EXPIRE_SOON, CoreResourceProviderAdapter.getInstance().getString("core.message.license.contractWillExpire", new Object[]{daysLeft}));
            this.l.add(msg);
        }
    }

    private void f(SonargraphLicense license, String date) {
        assert (license != null) : "Parameter 'license' of method 'validateSupportExpirationDate' must not be null";
        assert (date != null) : "Parameter 'date' of method 'validateSupportExpirationDate' must not be null";
        if (f.equalsIgnoreCase(date)) {
            license.b(com.hello2morrow.sonargraph.core.command.common.g.a);
            return;
        }
        SimpleDateFormat parserSDF = new SimpleDateFormat(h);
        parserSDF.setLenient(false);
        Date dateObj = null;
        Date buildDate = null;
        try {
            dateObj = parserSDF.parse(date);
            buildDate = parserSDF.parse(this.o.get(ProductProperty.BUILD_DATE.getStandardName()));
            license.b(dateObj);
            if (buildDate.after(dateObj)) {
                license.a(SonargraphLicense.Property.SUPPORT_EXPIRATION, SonargraphLicenseMessageCause.SUPPORT_EXPIRED);
                return;
            }
        }
        catch (ParseException ex) {
            license.a(SonargraphLicense.Property.SUPPORT_EXPIRATION, SonargraphLicenseMessageCause.INVALID_DATE_FORMAT);
            return;
        }
        int daysLeft = this.q.a(dateObj);
        if (daysLeft < 0) {
            String msg = license.a().addWarning((OperationResult.IMessageCause)SonargraphLicenseMessageCause.SUPPORT_EXPIRED, "Support expired " + -1 * daysLeft + " days ago.", new Object[0]);
            this.l.add(msg);
        } else if (daysLeft < 14) {
            String msg = license.a().addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.SUPPORT_WILL_EXPIRE_SOON, CoreResourceProviderAdapter.getInstance().getString("core.message.license.supportWillExpire", new Object[]{daysLeft}));
            this.l.add(msg);
        }
    }

    private void g(SonargraphLicense license, String featuresString) {
        assert (license != null) : "Parameter 'license' of method 'validateSpecialFeatures' must not be null";
        assert (featuresString != null) : "Parameter 'featuresString' of method 'validateFeatures' must not be null";
        EnumSet<SonargraphFeature> features = EnumSet.noneOf(SonargraphFeature.class);
        if (!featuresString.isEmpty()) {
            String[] splitFeatures;
            String[] stringArray = splitFeatures = featuresString.split(d);
            int n2 = splitFeatures.length;
            int n3 = 0;
            while (n3 < n2) {
                String nextFeature = stringArray[n3];
                try {
                    features.add(SonargraphFeature.fromStandardName(nextFeature.trim()));
                }
                catch (IllegalArgumentException iae) {
                    c.info("Ignoring unknown feature: " + nextFeature.trim());
                }
                ++n3;
            }
        }
        license.a(features);
    }

    private void h(SonargraphLicense license, String input) {
        assert (license != null) : "Parameter 'license' of method 'validateDisabledCategories' must not be null";
        assert (input != null) : "Parameter 'disabledCategories' of method 'validateDisabledCategories' must not be null";
        EnumSet<SonargraphCategory> disabledCategories = EnumSet.noneOf(SonargraphCategory.class);
        if (!input.isEmpty()) {
            String[] splitDisabledCategories;
            String[] stringArray = splitDisabledCategories = input.split(d);
            int n2 = splitDisabledCategories.length;
            int n3 = 0;
            while (n3 < n2) {
                String nextDisabeldCategory = stringArray[n3];
                try {
                    disabledCategories.add(SonargraphCategory.fromStandardName(nextDisabeldCategory.trim()));
                }
                catch (IllegalArgumentException iae) {
                    c.info("Ignoring unknown category: " + nextDisabeldCategory.trim());
                }
                ++n3;
            }
        }
        license.b(disabledCategories);
    }

    private static void i(SonargraphLicense license, String licensedLogin) {
        assert (license != null) : "Parameter 'license' of method 'validateLogin' must not be null";
        assert (licensedLogin != null) : "Parameter 'licensedLogin' of method 'validateLogin' must not be null";
        String login = Platform.getUserName();
        if (licensedLogin.equalsIgnoreCase(e)) {
            return;
        }
        if (!licensedLogin.equalsIgnoreCase(login)) {
            license.a(SonargraphLicense.Property.LOGIN, SonargraphLicenseMessageCause.INVALID_LOGIN);
        }
    }

    private void j(SonargraphLicense license, String activationCode) {
        assert (activationCode != null) : "Parameter 'activationCode' of method 'validateActivationCode' must not be null";
        if (!this.q.a(activationCode)) {
            license.a(SonargraphLicense.Property.ACTIVATION_CODE, SonargraphLicenseMessageCause.INVALID_FORMAT_ACTIVATION_CODE);
        }
    }

    private boolean b(SonargraphLicense license) {
        assert (license != null) : "Parameter 'license' of method 'isSupportExpirationRequired' must not be null";
        String version = license.a(SonargraphLicense.Property.VERSION);
        return version == null || version.equalsIgnoreCase(e);
    }

    void a(SonargraphLicense license) {
        assert (license != null) : "Parameter 'license' of method 'validate' must not be null";
        LinkedHashMap<Language, Integer> licensedLanguageToSize = new LinkedHashMap<Language, Integer>();
        block13: for (Map.Entry<String, String> nextEntry : license.b().entrySet()) {
            String nextPropertyKey = nextEntry.getKey();
            String nextPropertyValue = nextEntry.getValue();
            if (nextPropertyValue.isEmpty()) continue;
            if (nextPropertyKey.startsWith(k)) {
                String nextLanguage = nextPropertyKey.substring(k.length());
                this.a(license, nextLanguage, nextPropertyValue, licensedLanguageToSize);
                continue;
            }
            SonargraphLicense.Property property = SonargraphLicense.Property.fromStandardName(nextPropertyKey);
            if (property != null) {
                switch (com.hello2morrow.sonargraph.core.command.common.q.c()[property.ordinal()]) {
                    case 1: {
                        this.b(license, nextPropertyValue);
                        continue block13;
                    }
                    case 13: {
                        this.a(license, nextPropertyValue);
                        continue block13;
                    }
                    case 16: {
                        this.c(license, nextPropertyValue);
                        continue block13;
                    }
                    case 11: {
                        this.j(license, nextPropertyValue);
                        continue block13;
                    }
                    case 15: {
                        com.hello2morrow.sonargraph.core.command.common.q.i(license, nextPropertyValue);
                        continue block13;
                    }
                    case 17: {
                        this.g(license, nextPropertyValue);
                        continue block13;
                    }
                    case 18: {
                        this.h(license, nextPropertyValue);
                        continue block13;
                    }
                    case 9: {
                        this.e(license, nextPropertyValue);
                        continue block13;
                    }
                    case 10: {
                        if (!this.b(license)) continue block13;
                        this.f(license, nextPropertyValue);
                        continue block13;
                    }
                    case 12: {
                        this.d(license, nextPropertyValue);
                        continue block13;
                    }
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 19: 
                    case 20: 
                    case 21: {
                        continue block13;
                    }
                    default: {
                        assert (false) : "Unhandled property: " + (Object)((Object)property);
                        continue block13;
                    }
                }
            }
            if ("Signature".equals(nextPropertyKey)) continue;
            c.info("Ignoring unknown property: " + nextPropertyKey);
        }
        for (Language nextAvailableLanguage : this.p.values()) {
            if (licensedLanguageToSize.containsKey(nextAvailableLanguage) || nextAvailableLanguage.needsLicense()) continue;
            licensedLanguageToSize.put(nextAvailableLanguage, 0);
        }
        license.a(licensedLanguageToSize);
        boolean noLanguagesLicensed = licensedLanguageToSize.entrySet().stream().allMatch(entry -> (Integer)entry.getValue() == -1);
        if (licensedLanguageToSize.isEmpty() || noLanguagesLicensed) {
            license.a().addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.NO_LANGUAGES_LICENSED);
        }
        HashSet<SonargraphLicense.Property> mandatoryProperties = new HashSet<SonargraphLicense.Property>();
        mandatoryProperties.add(SonargraphLicense.Property.PRODUCT);
        mandatoryProperties.add(SonargraphLicense.Property.EXPIRATION);
        if (this.b(license)) {
            mandatoryProperties.add(SonargraphLicense.Property.SUPPORT_EXPIRATION);
        }
        mandatoryProperties.add(SonargraphLicense.Property.LOGIN);
        mandatoryProperties.add(SonargraphLicense.Property.VERSION);
        if (license.a(SonargraphLicense.Property.TICKET_ID) == null) {
            mandatoryProperties.add(SonargraphLicense.Property.MAC_ADDRESSES);
        }
        if (license.a(SonargraphLicense.Property.ACTIVATION_CODE) != null) {
            mandatoryProperties.add(SonargraphLicense.Property.TICKET_EXPIRATION);
        } else if (license.a(SonargraphLicense.Property.TICKET_EXPIRATION) == null) {
            license.c(com.hello2morrow.sonargraph.core.command.common.g.a);
        }
        for (SonargraphLicense.Property nextMandatoryProperty : mandatoryProperties) {
            if (license.a(nextMandatoryProperty) != null && !license.a(nextMandatoryProperty).isEmpty()) continue;
            license.a().addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.MISSING_MANDATORY_PROPERTY, "'" + nextMandatoryProperty.getStandardName() + "'", new Object[0]);
        }
        if (license.o() != com.hello2morrow.sonargraph.core.command.common.g.a) {
            this.q.a(license.a(), new Date(), license.o());
        }
        if (this.b(license) && license.p() != com.hello2morrow.sonargraph.core.command.common.g.a) {
            this.q.a(license.a(), new Date(), license.p());
        }
        if (license.q() != com.hello2morrow.sonargraph.core.command.common.g.a) {
            this.q.a(license.a(), new Date(), license.q());
        }
    }

    List<String> a() {
        return Collections.unmodifiableList(this.l);
    }

    void b() {
        this.l.clear();
    }

    static /* synthetic */ int[] c() {
        if (r != null) {
            return r;
        }
        int[] nArray = new int[SonargraphLicense.Property.values().length];
        try {
            nArray[SonargraphLicense.Property.ACTIVATION_CODE.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.BUILD_DATE.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.CONTRACT.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.COPYRIGHT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.CREATION.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.DISABLED_CATEGORIES.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.EXPIRATION.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.HEART_BEAT_SECONDS.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.LICENSE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.LICENSEE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.LICENSOR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.LOGIN.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.MAC_ADDRESSES.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.PRODUCT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.SPECIAL_LICENSE_FEATURES.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.SUPPORT_EXPIRATION.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.TICKET_EXPIRATION.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.TICKET_ID.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.TICKET_MAGIC.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.USER.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SonargraphLicense.Property.VERSION.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        r = nArray;
        return nArray;
    }
}

