/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.HttpConnectionCheck;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.PropertiesParser;
import com.hello2morrow.foundation.utilities.ProxySettings;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.httpclient.model.ServerInfo;
import com.hello2morrow.license.model.LicenseServerHost;
import com.hello2morrow.license.model.ProductDescriptor;
import com.hello2morrow.sonargraph.core.command.common.ProductPropertiesCause;
import com.hello2morrow.sonargraph.core.command.common.ProductProperty;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseMessageCause;
import com.hello2morrow.sonargraph.core.command.common.b;
import com.hello2morrow.sonargraph.core.command.common.h;
import com.hello2morrow.sonargraph.core.command.common.q;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class o
implements com.hello2morrow.sonargraph.core.controllerinterface.common.a {
    private static final Logger d = LoggerFactory.getLogger(o.class);
    private static final List<String> e = new ArrayList<String>(ServerInfo.HTTPS_AND_HTTP_HOSTS);
    private static final String f = "sonargraph.licenseFilePath";
    private final com.hello2morrow.license.controller.a g;
    private final SonargraphProduct h;
    private final Map<String, String> i;
    private final Version j;
    private final ProductDescriptor k;
    private final q l;
    private ProxySettings m;
    private LicenseServerHost n;
    private SonargraphLicense o;
    private SonargraphLicense p;
    private boolean q;
    private final a r;

    public static final List<String> a() {
        return Collections.unmodifiableList(e);
    }

    public static final void a(List<String> hosts) {
        assert (hosts != null && !hosts.isEmpty()) : "Parameter 'hosts' of method 'setLicenseServerHosts' must not be empty";
        e.clear();
        e.addAll(hosts);
    }

    public static final boolean a(String url, ProxySettings proxySettings) {
        return HttpConnectionCheck.canConnect((String)com.hello2morrow.license.controller.a.b((String)url), (String)"OK\n", (ProxySettings)proxySettings);
    }

    protected o(SonargraphProduct product, Set<Language> availableLanguages, a licenseLosthandler) {
        this(product, availableLanguages, licenseLosthandler, null);
    }

    protected o(SonargraphProduct product, Set<Language> availableLanguages, a licenseLosthandler, String productPropertiesContent) {
        String content;
        assert (product != null) : "Parameter 'product' of method 'SonargraphLicenseHandler' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'SonargraphLicenseHandler' must not be null";
        this.g = new com.hello2morrow.license.controller.a();
        this.h = product;
        this.r = licenseLosthandler;
        HashMap<String, Language> nameToAvailableLanguage = new HashMap<String, Language>(availableLanguages.size());
        for (Language nextLanguage : availableLanguages) {
            Language previousLanguage = nameToAvailableLanguage.put(nextLanguage.getStandardName(), nextLanguage);
            assert (previousLanguage == null) : "'previousLanguage' of method 'SonargraphLicenseProvider' must be null";
        }
        OperationResult result = new OperationResult("Read and validate product properties");
        Map productProperties = null;
        Version version = null;
        String string = content = productPropertiesContent == null ? this.a(result) : productPropertiesContent;
        if (result.isSuccess()) {
            String versionAsString;
            assert (content != null && content.length() > 0) : "Parameter 'content' of method 'SonargraphLicenseHandler' must not be empty";
            productProperties = PropertiesParser.parse((String)content);
            this.g.a(result, productProperties);
            assert (productProperties != null);
            ProductProperty[] productPropertyArray = ProductProperty.values();
            int n2 = productPropertyArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ProductProperty nextProductProperty = productPropertyArray[n3];
                if (!productProperties.containsKey(nextProductProperty.getStandardName())) {
                    result.addError((OperationResult.IMessageCause)ProductPropertiesCause.MISSING_PROPERTY, nextProductProperty.getStandardName(), new Object[0]);
                }
                ++n3;
            }
            if (result.isSuccess() && (version = Version.create((String)(versionAsString = (String)productProperties.get(ProductProperty.VERSION.getStandardName())))) == null) {
                result.addError((OperationResult.IMessageCause)ProductPropertiesCause.UNRECOGNIZED_VERSION, versionAsString, new Object[0]);
            }
        }
        assert (result.isSuccess()) : result.toString();
        if (result.isSuccess()) {
            this.i = productProperties;
            this.j = version;
            this.k = new ProductDescriptor(this.i.get(ProductProperty.LICENSOR.getStandardName()), this.h.getStandardName(), this.i.get(ProductProperty.VERSION.getStandardName()), this.i.get(ProductProperty.BUILD_DATE.getStandardName()), this.i.get(ProductProperty.COPYRIGHT.getStandardName()), this.h == SonargraphProduct.SONARGRAPH_BUILD ? 2 : 1);
            this.l = new q(product, version, productProperties, nameToAvailableLanguage, this.g);
        } else {
            d.error("Failed to initialize license handler: {}", (Object)result.toString());
            this.i = null;
            this.j = null;
            this.k = null;
            this.l = null;
        }
    }

    private String a(OperationResult result) {
        try {
            return FileUtility.getContentFromResourceOnClassPath(this.getClass(), (String)"/Sonargraph.properties");
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)ProductPropertiesCause.FAILED_TO_READ_PROPERTIES, (Throwable)ex);
            return null;
        }
    }

    public final boolean b() {
        return this.i != null && this.j != null && this.k != null && this.l != null;
    }

    @Override
    public final SonargraphProduct c() {
        return this.h;
    }

    public final ProductDescriptor d() {
        return this.k;
    }

    public final String a(ProductProperty property) {
        assert (this.b()) : "Not properly initialized";
        assert (property != null) : "Parameter 'property' of method 'getValue' must not be null";
        String value = this.i.get(property.getStandardName());
        assert (value != null) : "'value' of method 'getValue' must not be null";
        return value;
    }

    @Override
    public final Version e() {
        assert (this.b()) : "Not properly initialized";
        return this.j;
    }

    public final void a(ProxySettings proxySettings) {
        this.m = proxySettings;
    }

    public final ProxySettings f() {
        return this.m != null ? this.m.copy() : null;
    }

    public final void a(LicenseServerHost licenseServer) {
        this.n = licenseServer;
    }

    private void b(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'tryLicenseTicketRenewalIfNecessaryAndPossible' must not be null";
        assert (this.o != null) : "'m_license' of method 'tryLicenseTicketRenewal' must not be null";
        if (this.o.m() || !this.o.n() && (this.o.k() || this.q)) {
            String activationCode = this.o.a(SonargraphLicense.Property.ACTIVATION_CODE);
            String ticketId = this.o.a(SonargraphLicense.Property.TICKET_ID);
            String ticketMagic = this.o.a(SonargraphLicense.Property.TICKET_MAGIC);
            if (activationCode != null && !activationCode.isEmpty()) {
                assert (this.l != null) : "'m_validator' of method 'tryLicenseTicketRenewalIfNecessaryAndPossible' must not be null";
                this.l.b();
                this.o = null;
                OperationResult innerResult = this.a(activationCode, ticketId, ticketMagic);
                if (innerResult.isSuccess()) {
                    if (this.p != null && this.p.n()) {
                        this.a(false);
                    }
                } else {
                    result.addMessagesFrom(innerResult);
                }
            }
        }
    }

    public final void g() {
        this.g.a();
    }

    private String w() {
        String licenseFilePath = System.getProperty(f);
        if (licenseFilePath != null) {
            d.info("Loading license file from path specified via system property: {}", (Object)licenseFilePath);
            return licenseFilePath;
        }
        return String.valueOf(CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir().getAbsolutePath()) + "/" + this.h.getDirectoryName() + "/" + this.h.getStandardName() + ".license";
    }

    private void a(SonargraphLicense license) {
        if (license != null && !license.n() && license.k()) {
            license.a().addWarning((OperationResult.IMessageCause)SonargraphLicenseMessageCause.SONARGRAPH_7_LICENSE_FILE_INCOMPATIBLE, "Please contact support@hello2morrow.com to obtain a compatible license.", new Object[0]);
        }
    }

    private void c(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkLicense' must not be null";
        if (this.o != null) {
            if (!this.o.n()) {
                for (OperationResult next : this.o.d()) {
                    if (!next.isFailure()) continue;
                    result.addMessagesFrom(next);
                }
                result.setIsSuccess(false);
            }
        } else {
            result.setIsSuccess(false);
        }
    }

    private void d(String serverReply) {
        assert (serverReply != null && serverReply.length() > 0) : "Parameter 'serverReply' of method 'handleLicenseLost' must not be empty";
        if (this.r != null) {
            this.r.handleLicenseLostEvent(serverReply);
        }
    }

    public final boolean h() {
        return this.g.b();
    }

    public final OperationResult a(String activationCode) {
        assert (activationCode != null && activationCode.length() > 0) : "Parameter 'activationCode' of method 'initializeFromActivationCode' must not be empty";
        OperationResult result = new OperationResult("Initialize from activation code");
        OperationResult licenseContentResult = new OperationResult("Initialize from activation code");
        Map signedContent = this.g.a(e, this.n, this.m, this.k, activationCode, null, null, this::d, licenseContentResult);
        if (licenseContentResult.isSuccess()) {
            this.o = this.a(signedContent, result);
            if (result.isSuccess()) {
                assert (this.o != null) : "'m_license' of method 'initializeFromActivationCode' must not be null";
                this.a(this.p);
                this.c(result);
            }
        } else {
            result.addMessagesFrom(licenseContentResult);
            result.setIsSuccess(false);
        }
        return result;
    }

    private void a(String licenseFilePath, OperationResult result) {
        assert (licenseFilePath != null && licenseFilePath.length() > 0) : "Parameter 'licenseFilePath' of method 'initializeFromLicenseFile' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'initializeFromLicenseFile' must not be null";
        if (FileUtility.pathExists((String)licenseFilePath)) {
            try {
                String signedContent = FileUtility.getFileContent((TFile)new TFile(licenseFilePath));
                OperationResult innerResult = this.c(signedContent);
                result.setIsSuccess(innerResult.isSuccess());
                result.addMessagesFrom(innerResult);
            }
            catch (IOException ioe) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "License file '" + licenseFilePath + "' :" + ioe, new Object[0]);
            }
        } else {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "License file not found: " + licenseFilePath, new Object[0]);
        }
    }

    public final OperationResult b(String licenseFilePath) {
        assert (licenseFilePath != null && licenseFilePath.length() > 0) : "Parameter 'licenseFilePath' of method 'initializeFromLicenseFile' must not be empty";
        OperationResult result = new OperationResult("Initialize from license file");
        this.a(licenseFilePath, result);
        return result;
    }

    public OperationResult i() {
        OperationResult result = new OperationResult("Initialize from 'default' license file location");
        String licenseFilePath = this.w();
        this.a(licenseFilePath, result);
        return result;
    }

    public OperationResult j() {
        OperationResult result = new OperationResult("Initialize default license");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream licenseInput = this.getClass().getClassLoader().getResourceAsStream("default.license");){
                int c2;
                assert (licenseInput != null) : "'licenseInput' of method 'initializeFromDefaultLicense' must not be null";
                StringBuilder sb = new StringBuilder(1024);
                while ((c2 = licenseInput.read()) > 0) {
                    sb.append((char)c2);
                }
                OperationResult innerResult = this.c(sb.toString());
                if (innerResult.isFailure()) {
                    result.addMessagesFrom(innerResult);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e2);
        }
        return result;
    }

    protected final OperationResult c(String signedContent) {
        assert (signedContent != null) : "Parameter 'signedContent' of method 'initializeFromSignedContent' must not be null";
        OperationResult result = new OperationResult("Initialize from signed content");
        this.o = this.a(PropertiesParser.parse((String)signedContent), result);
        if (result.isSuccess()) {
            assert (this.o != null) : "'m_license' of method 'initialize' must not be null";
            this.b(result);
            this.a(this.o);
            this.c(result);
        }
        return result;
    }

    public final OperationResult a(String activationCode, String ticketId, String ticketMagic) {
        d.debug("Load license from activation code" + (this.n == null ? "" : " using license server [" + this.n + "]"));
        this.p = null;
        OperationResult result = new OperationResult("Resolve activation code");
        Map signedContent = this.g.a(e, this.n, this.m, this.k, activationCode, ticketId, ticketMagic, reply -> this.d((String)reply), result);
        if (result.isSuccess()) {
            this.p = this.a(signedContent, result);
            if (result.isSuccess()) {
                this.a(this.p);
            }
        }
        d.debug("Load license from activation code" + (this.n == null ? " with result" : " using license server [" + this.n + "] with result: " + result) + " - done");
        return result;
    }

    public final OperationResult a(TFile licenseFile) {
        assert (licenseFile != null) : "Parameter 'licenseFile' of method 'loadLicenseFromFile' must not be null";
        this.p = null;
        OperationResult result = new OperationResult("Read from license file");
        try {
            String content = FileUtility.getFileContent((TFile)licenseFile);
            Map licenseProperties = PropertiesParser.parse((String)content);
            this.p = this.a(licenseProperties, result);
            if (result.isSuccess()) {
                this.a(this.p);
            }
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.FAILED_READING_LICENSE_FILE, (Throwable)ioe);
        }
        return result;
    }

    private SonargraphLicense a(Map<String, String> properties, OperationResult contentStructureValidationResult) {
        assert (properties != null) : "Parameter 'signedContent' of method 'create' must not be null";
        assert (contentStructureValidationResult != null) : "Parameter 'contentStructureValidationResult' of method 'create' must not be null";
        String signedContent = this.g.a(contentStructureValidationResult, properties);
        if (contentStructureValidationResult.isSuccess()) {
            assert (this.l != null) : "'m_validator' of method 'create' must not be null";
            SonargraphLicense license = new SonargraphLicense(signedContent, properties, contentStructureValidationResult);
            this.l.a(license);
            return license;
        }
        return null;
    }

    public final OperationResult a(boolean forceInstall) {
        OperationResult result;
        block11: {
            assert (this.p != null) : "'m_licenseInValidation' of method 'installLicenseInValidation' must not be null";
            assert (this.p.n()) : "Not a valid license: " + this.p;
            result = new OperationResult("Installing license");
            try {
                try {
                    String licenseFilePath = this.w();
                    FileUtility.writeFile((String)licenseFilePath, (Charset)StandardCharsets.UTF_8, (String)this.p.r(), (boolean)false);
                    if (this.o == null || !this.o.n() || forceInstall) {
                        this.o = this.p;
                        result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED);
                        break block11;
                    }
                    if (this.h == SonargraphProduct.SONARGRAPH_ECLIPSE) {
                        if (this.o.j().equals(this.p.j())) {
                            result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED);
                        } else {
                            result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED, "Please restart Eclipse for the new license to take effect!");
                        }
                        break block11;
                    }
                    result.addInfo((OperationResult.IMessageCause)SonargraphLicenseMessageCause.LICENSE_SUCCESSFULLY_INSTALLED, String.valueOf(this.h.getPresentationName()) + " will be restarted for the new license to take effect!");
                }
                catch (IOException ex) {
                    result.addError((OperationResult.IMessageCause)SonargraphLicenseMessageCause.FAILED_TO_INSTALL_LICENSE, (Throwable)ex);
                    this.p = null;
                }
            }
            finally {
                this.p = null;
            }
        }
        return result;
    }

    final Set<? extends h> a(Set<? extends h> commandIds) {
        assert (commandIds != null) : "Parameter 'commandIds' of method 'addAvailableCommandIds' must not be null";
        if (!this.o()) {
            return Collections.emptySet();
        }
        HashSet<h> licensedCommandIds = new HashSet<h>(commandIds.size());
        EnumSet<SonargraphFeature> features = this.o.f();
        EnumSet<SonargraphCategory> categories = this.o.g();
        for (h h2 : commandIds) {
            boolean isLanguageLicensed = false;
            if (h2.getLanguage() == null) {
                d.debug("Command [" + h2.getStandardName() + "] does not specify a language and is therefore available.");
                isLanguageLicensed = true;
            } else if (this.o.a(h2.getLanguage())) {
                d.debug("Command [" + h2.getStandardName() + "] is licensed for language [" + h2.getLanguage() + "] and is available.");
                isLanguageLicensed = true;
            } else {
                d.debug("Language [" + h2.getLanguage() + "] is not licensed, therefore command [" + h2.getStandardName() + "] won't be available.");
            }
            if (!isLanguageLicensed) continue;
            if (features.contains((Object)h2.getFeature()) && categories.contains((Object)h2.getCategory())) {
                licensedCommandIds.add(h2);
                continue;
            }
            if (!d.isDebugEnabled()) continue;
            d.debug("Command [" + h2.getStandardName() + "] is not licensed and won't be available.");
        }
        return licensedCommandIds;
    }

    public final boolean k() {
        return this.o != null;
    }

    public final SonargraphLicense l() {
        assert (this.k()) : "No license";
        return this.o;
    }

    @Override
    public final String m() {
        String license;
        if (this.o() && (license = this.o.a(SonargraphLicense.Property.LICENSE)) != null) {
            return license;
        }
        return "";
    }

    @Override
    public final void a(OperationResult.IMessageCause info, String message) {
        assert (this.k()) : "No license available";
        this.o.a(info, message);
    }

    @Override
    public final void n() {
        this.o.c();
    }

    public final boolean o() {
        return this.o != null && this.o.n();
    }

    public final boolean p() {
        return this.p != null;
    }

    public final SonargraphLicense q() {
        assert (this.p != null) : "Parameter 'm_licenseInValidation' of method 'getLicenseInValidation' must not be null";
        return this.p;
    }

    @Override
    public final List<String> r() {
        return this.l != null ? this.l.a() : Collections.emptyList();
    }

    @Override
    public final boolean a(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLanguageAvailable' must not be null";
        return this.o() ? this.o.a(language) : false;
    }

    @Override
    public final int b(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getLicensedSize' must not be null";
        return this.o() ? this.o.b(language) : -1;
    }

    @Override
    public final boolean a(SonargraphFeature feature) {
        assert (feature != null) : "Parameter 'feature' of method 'isFeatureAvailable' must not be null";
        return this.o() ? this.o.a(feature) : false;
    }

    public final boolean a(SonargraphCategory category) {
        assert (category != null) : "Parameter 'category' of method 'isCategoryAvailable' must not be null";
        return this.o() ? this.o.a(category) : false;
    }

    @Override
    public final EnumSet<SonargraphFeature> s() {
        return this.o() ? this.o.f() : EnumSet.noneOf(SonargraphFeature.class);
    }

    @Override
    public final EnumSet<SonargraphFeature> t() {
        EnumSet<SonargraphFeature> unavailableFeatures = EnumSet.allOf(SonargraphFeature.class);
        unavailableFeatures.removeAll(this.s());
        return unavailableFeatures;
    }

    public final IPathValidator u() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput != null) {
                    if (!newInput.exists()) {
                        result.addError("Invalid path");
                    } else if (!FileUtility.getExtension((TFile)newInput).equals(".license")) {
                        result.addError("Invalid file extension, expected .license");
                    }
                }
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.FILE;
            }
        };
    }

    public final ITextValidator v() {
        return new b(this.g);
    }

    public final void b(boolean renewLicenseTicketAutomatically) {
        this.q = renewLicenseTicketAutomatically;
    }

    public static interface a {
        public void handleLicenseLostEvent(String var1);
    }
}

