/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class SonargraphLicense {
    public static final String a = ".license";
    private final Map<Property, OperationResult.IMessageCause> c = new HashMap<Property, OperationResult.IMessageCause>();
    private final String d;
    private final Map<String, String> e;
    private final OperationResult f;
    private OperationResult g;
    private Map<Language, Integer> h;
    private EnumSet<SonargraphFeature> i;
    private EnumSet<SonargraphCategory> j;
    private Date k;
    private Date l;
    private Date m;

    SonargraphLicense(String signedContent, Map<String, String> licenseProperties, OperationResult contentStructureValidationResult) {
        assert (licenseProperties != null) : "Parameter 'properties' of method 'SonargraphLicense' must not be null";
        assert (contentStructureValidationResult != null) : "Parameter 'contentStructureValidationResult' of method 'SonargraphLicense' must not be null";
        this.d = signedContent;
        this.e = new LinkedHashMap<String, String>(licenseProperties);
        this.f = new OperationResult("License Validation");
        this.f.addMessagesFrom(contentStructureValidationResult);
    }

    public OperationResult a() {
        return this.f;
    }

    public Map<String, String> b() {
        return new LinkedHashMap<String, String>(this.e);
    }

    void c() {
        this.g = null;
    }

    void a(OperationResult.IMessageCause cause, String msg) {
        assert (cause != null) : "Parameter 'cause' of method 'addAdditionalValidationResultInfo' must not be null";
        assert (msg != null && msg.length() > 0) : "Parameter 'msg' of method 'addAdditionalValidationResultInfo' must not be empty";
        if (this.g == null) {
            this.g = new OperationResult("Additonal validation info");
        }
        this.g.addInfo(cause, msg);
    }

    public List<OperationResult> d() {
        ArrayList<OperationResult> all = new ArrayList<OperationResult>();
        all.add(this.f);
        OperationResult propertyResult = new OperationResult("Properties");
        this.c.values().stream().forEach(err -> propertyResult.addError(err, err.getPresentationName(), new Object[0]));
        all.add(propertyResult);
        if (this.g != null) {
            all.add(this.g);
        }
        return all;
    }

    public List<OperationResult> e() {
        ArrayList<OperationResult> all = new ArrayList<OperationResult>();
        all.add(this.f);
        if (this.g != null) {
            all.add(this.g);
        }
        return all;
    }

    void a(EnumSet<SonargraphFeature> features) {
        assert (features != null) : "Parameter 'features' of method 'setFeatures' must not be null";
        assert (this.i == null) : "'m_features' of method 'setFeatures' must be null";
        this.i = EnumSet.noneOf(SonargraphFeature.class);
        this.i.add(SonargraphFeature.PLATFORM);
        this.i.addAll(features);
    }

    void b(EnumSet<SonargraphCategory> disabledCategories) {
        assert (disabledCategories != null) : "Parameter 'disabledCategories' of method 'setDisabledCategories' must not be null";
        assert (this.j == null) : "'m_disabledCategories' of method 'setDisabledCategories' must be null";
        this.j = EnumSet.noneOf(SonargraphCategory.class);
        this.j.addAll(disabledCategories);
    }

    boolean a(SonargraphFeature feature) {
        assert (feature != null) : "Parameter 'feature' of method 'containsFeature' must not be null";
        if (this.i != null) {
            return this.i.contains((Object)feature);
        }
        return false;
    }

    EnumSet<SonargraphFeature> f() {
        if (this.i == null) {
            this.i = EnumSet.noneOf(SonargraphFeature.class);
            this.i.add(SonargraphFeature.PLATFORM);
        }
        return EnumSet.copyOf(this.i);
    }

    boolean a(SonargraphCategory category) {
        assert (category != null) : "Parameter 'category' of method 'containsCategory' must not be null";
        if (this.j != null) {
            return !this.j.contains((Object)category);
        }
        return true;
    }

    EnumSet<SonargraphCategory> g() {
        if (this.j == null) {
            this.j = EnumSet.noneOf(SonargraphCategory.class);
        }
        return EnumSet.complementOf(this.j);
    }

    void a(Map<Language, Integer> licensedLanguageToSize) {
        assert (licensedLanguageToSize != null) : "Parameter 'licensedLanguageToSize' of method 'setLanguages' must not be null";
        assert (this.h == null) : "'m_languageToSize' of method 'setLanguages' must be null";
        if (this.h == null) {
            this.h = new HashMap<Language, Integer>(licensedLanguageToSize);
        }
    }

    public boolean a(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLicensed' must not be null";
        if (this.h != null) {
            return this.h.containsKey(language);
        }
        return false;
    }

    public Set<SonargraphFeature> h() {
        return this.f();
    }

    public Set<Language> i() {
        if (this.h != null) {
            return Collections.unmodifiableSet(this.h.keySet());
        }
        return Collections.emptySet();
    }

    public String j() {
        ArrayList featuresAndLanguages = new ArrayList();
        this.i.forEach(f2 -> {
            boolean bl2 = featuresAndLanguages.add(f2.getStandardName());
        });
        this.h.keySet().forEach(l2 -> {
            boolean bl2 = featuresAndLanguages.add(l2.getStandardName());
        });
        return StringUtility.concat((Collection)featuresAndLanguages.stream().sorted().collect(Collectors.toList()), (String)", ");
    }

    public int b(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getLicensedSize' must not be null";
        if (this.h != null) {
            Integer size = this.h.get(language);
            return size != null ? size : -1;
        }
        return -1;
    }

    public String c(Language language) {
        Integer size;
        assert (language != null) : "Parameter 'language' of method 'getLicensedSizePresentationName' must not be null";
        if (this.h != null && (size = this.h.get(language)) != null) {
            if (size == 0) {
                return "Unlimited";
            }
            assert (size != -1) : "Unlicensed language entry: " + language;
            return size.toString();
        }
        return "Not licensed";
    }

    boolean k() {
        return this.e.containsKey("Languages") || this.e.containsKey("NodeId");
    }

    public boolean l() {
        return this.a(Property.LOGIN).equals("any");
    }

    public boolean m() {
        return this.a(Property.TICKET_ID) != null;
    }

    public String a(Property property) {
        assert (property != null) : "Parameter 'property' of method 'getValue' must not be null";
        return this.e.get(property.getStandardName());
    }

    void a(Property property, OperationResult.IMessageCause cause) {
        assert (property != null) : "Parameter 'property' of method 'setValidationResult' must not be null";
        assert (cause != null) : "Parameter 'cause' of method 'setValidationResult' must not be null";
        this.c.put(property, cause);
    }

    public OperationResult.IMessageCause b(Property property) {
        assert (property != null) : "Parameter 'property' of method 'getValidationError' must not be null";
        return this.c.get((Object)property);
    }

    public boolean n() {
        return this.f.isSuccess() && this.c.isEmpty();
    }

    public Date o() {
        return this.k;
    }

    public void a(Date expirationDate) {
        assert (expirationDate != null) : "Parameter 'expirationDate' of method 'setExpirationDate' must not be null";
        assert (this.k == null) : "'m_expirationDate' of method 'setExpirationDate' must be null";
        if (this.k == null) {
            this.k = expirationDate;
        }
    }

    public Date p() {
        return this.l;
    }

    public void b(Date supportExpirationDate) {
        assert (supportExpirationDate != null) : "Parameter 'supportExpirationDate' of method 'setSupportExpirationDate' must not be null";
        assert (this.l == null) : "'m_supportExpirationDate' of method 'setSupportExpirationDate' must be null";
        if (this.l == null) {
            this.l = supportExpirationDate;
        }
    }

    public Date q() {
        return this.m;
    }

    public void c(Date ticketExpirationDate) {
        assert (ticketExpirationDate != null) : "Parameter 'ticketExpirationDate' of method 'setTicketExpirationDate' must not be null";
        assert (this.m == null) : "'m_ticketExpirationDate' of method 'setTicketExpirationDate' must be null";
        if (this.m == null) {
            this.m = ticketExpirationDate;
        }
    }

    String r() {
        return this.d;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.n() ? "Valid license" : "License not valid");
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append(this.e);
        return builder.toString();
    }

    public static final class Property
    extends Enum<Property>
    implements IStandardEnumeration {
        public static final /* enum */ Property PRODUCT = new Property();
        public static final /* enum */ Property LICENSE = new Property();
        public static final /* enum */ Property LICENSOR = new Property();
        public static final /* enum */ Property COPYRIGHT = new Property();
        public static final /* enum */ Property LICENSEE = new Property();
        public static final /* enum */ Property USER = new Property();
        public static final /* enum */ Property CONTRACT = new Property();
        public static final /* enum */ Property CREATION = new Property();
        public static final /* enum */ Property EXPIRATION = new Property();
        public static final /* enum */ Property SUPPORT_EXPIRATION = new Property();
        public static final /* enum */ Property ACTIVATION_CODE = new Property();
        public static final /* enum */ Property TICKET_EXPIRATION = new Property();
        public static final /* enum */ Property VERSION = new Property();
        public static final /* enum */ Property BUILD_DATE = new Property();
        public static final /* enum */ Property LOGIN = new Property();
        public static final /* enum */ Property MAC_ADDRESSES = new Property();
        public static final /* enum */ Property SPECIAL_LICENSE_FEATURES = new Property("Features");
        public static final /* enum */ Property DISABLED_CATEGORIES = new Property();
        public static final /* enum */ Property TICKET_ID = new Property();
        public static final /* enum */ Property TICKET_MAGIC = new Property();
        public static final /* enum */ Property HEART_BEAT_SECONDS = new Property();
        private final String m_presentationName;
        private static final /* synthetic */ Property[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Property[]{PRODUCT, LICENSE, LICENSOR, COPYRIGHT, LICENSEE, USER, CONTRACT, CREATION, EXPIRATION, SUPPORT_EXPIRATION, ACTIVATION_CODE, TICKET_EXPIRATION, VERSION, BUILD_DATE, LOGIN, MAC_ADDRESSES, SPECIAL_LICENSE_FEATURES, DISABLED_CATEGORIES, TICKET_ID, TICKET_MAGIC, HEART_BEAT_SECONDS};
        }

        private Property(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'Property' must not be empty";
            this.m_presentationName = presentationName;
        }

        private Property() {
            this.m_presentationName = null;
        }

        public static Property fromStandardName(String standardName) {
            String name = StringUtility.convertStandardNameToConstantName((String)standardName);
            try {
                return Property.valueOf(name);
            }
            catch (IllegalArgumentException e2) {
                return null;
            }
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            if (this.m_presentationName == null) {
                return StringUtility.convertConstantNameToPresentationName((String)this.name());
            }
            return this.m_presentationName;
        }

        public static Property[] values() {
            Property[] propertyArray = ENUM$VALUES;
            int n2 = propertyArray.length;
            Property[] propertyArray2 = new Property[n2];
            System.arraycopy(ENUM$VALUES, 0, propertyArray2, 0, n2);
            return propertyArray2;
        }

        public static Property valueOf(String string) {
            return Enum.valueOf(Property.class, string);
        }
    }
}

