/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.DependencyKind;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IFieldAccess;
import com.hello2morrow.sonargraph.api.IMethodAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.ITypeAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.FieldAccess;
import com.hello2morrow.sonargraph.core.api.model.MethodAccess;
import com.hello2morrow.sonargraph.core.api.model.ProgrammingElementAccess;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.programming.IField;
import com.hello2morrow.sonargraph.core.model.programming.IMethod;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.ArrayList;
import java.util.List;

public class TypeAccess
extends ProgrammingElementAccess
implements ITypeAccess {
    public TypeAccess(IType element, ElementAccess.IAccessFactory factory) {
        super((ProgrammingElement)((Object)element));
        assert (factory != null) : "Parameter 'factory' of method 'TypeAccess' must not be null";
        this.setFactory(factory);
    }

    public TypeAccess(IType element) {
        super((ProgrammingElement)((Object)element));
    }

    @Override
    public Object getMetricLevel() {
        return CoreMetricLevel.TYPE;
    }

    public boolean isAbstract() {
        return ((IType)((Object)this.m_element)).isAbstract();
    }

    public boolean isAnonymous() {
        return ((IType)((Object)this.m_element)).isAnonymous();
    }

    public boolean isNested() {
        return ((IType)((Object)this.m_element)).isNested();
    }

    public boolean isInterface() {
        return ((IType)((Object)this.m_element)).isInterface();
    }

    public boolean isClass() {
        return ((IType)((Object)this.m_element)).isClass();
    }

    public Number getNumberOfStatementsMetric() {
        return this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.TYPE, CoreMetricId.CORE_STATEMENTS);
    }

    public Number getSourceElementCountMetric() {
        return this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.TYPE, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT);
    }

    public Number getLCOM4Metric() {
        return this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.TYPE, CoreMetricId.CORE_LCOM4);
    }

    public Number getMaxNestingMetric() {
        return this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.TYPE, CoreMetricId.CORE_MAX_NESTING);
    }

    public Number getAverageComplexityMetric() {
        return this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.TYPE, CoreMetricId.CORE_AVERAGE_COMPLEXITY);
    }

    public Number getAverageNestingMetric() {
        return this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.TYPE, CoreMetricId.CORE_AVERAGE_NESTING);
    }

    public List<? extends IMethodAccess> getMethods() {
        List<IMethod> methods = ((ProgrammingElement)this.m_element).getChildren(IMethod.class);
        ArrayList<MethodAccess> methodAccesses = new ArrayList<MethodAccess>(methods.size());
        for (IMethod nextMethod : methods) {
            methodAccesses.add((MethodAccess)this.m_factory.createAccessObject((NamedElement)((Object)nextMethod)));
        }
        return methodAccesses;
    }

    public List<? extends IFieldAccess> getFields() {
        List<IField> fields = ((ProgrammingElement)this.m_element).getChildren(IField.class);
        ArrayList<FieldAccess> fieldAccesses = new ArrayList<FieldAccess>(fields.size());
        for (IField nextField : fields) {
            fieldAccesses.add((FieldAccess)this.m_factory.createAccessObject((NamedElement)((Object)nextField)));
        }
        return fieldAccesses;
    }

    public boolean typeOf(String fqName) {
        assert (fqName != null) : "Parameter 'fqName' of method 'implementsInterface' must not be null";
        if (this.getName().equals(fqName)) {
            return true;
        }
        for (INamedElementAccess next : this.getReferencedElements(Aggregator.TYPE, true, new IDependencyKind[]{DependencyKind.IMPLEMENTS, DependencyKind.EXTENDS})) {
            if (!(next instanceof TypeAccess)) continue;
            TypeAccess type = (TypeAccess)next;
            if (type.getName().equals(fqName)) {
                return true;
            }
            if (!type.typeOf(fqName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void accept(INamedElementAccess.INamedElementAccessVisitor visitor) {
        if (visitor instanceof ITypeAccess.IVisitor) {
            ((ITypeAccess.IVisitor)visitor).visitTypeAccess((ITypeAccess)this);
        } else {
            super.accept(visitor);
        }
    }
}

