/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.foundation.collections.FixedSizeFiFoQueue;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IScmPeriod;
import com.hello2morrow.sonargraph.api.ISourceFileAccess;
import com.hello2morrow.sonargraph.api.ISourceLineAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.api.model.SourceLineAccess;
import com.hello2morrow.sonargraph.core.model.common.SourceLineWithContext;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SourceFileAccess
extends ElementAccess<SourceFile>
implements ISourceFileAccess {
    private static final int CONTEXT_SIZE = 3;

    public SourceFileAccess(SourceFile element) {
        super(element);
    }

    public final int getLinesOfCodeMetric() {
        int loc = ((SourceFile)this.m_element).getLinesOfCode();
        return loc == -1 ? 0 : loc;
    }

    public final int getTotalLinesMetric() {
        int loc = ((SourceFile)this.m_element).getTotalLines();
        return loc == -1 ? 0 : loc;
    }

    public final int getCommentLinesMetric() {
        int loc = ((SourceFile)this.m_element).getCommentLines();
        return loc == -1 ? 0 : loc;
    }

    public final int getCodeCommentLinesMetric() {
        int loc = ((SourceFile)this.m_element).getCodeCommentLines();
        return loc == -1 ? 0 : loc;
    }

    public int getMaxNestingMetric() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_MAX_NESTING);
        return val == null ? 0 : val.intValue();
    }

    public float getAverageComplexityMetric() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_AVERAGE_COMPLEXITY);
        return val == null ? 0.0f : val.floatValue();
    }

    public float getAverageNestingMetric() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_AVERAGE_NESTING);
        return val == null ? 0.0f : val.floatValue();
    }

    public int getDaysSinceLastCommit() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_DAYS_SINCE_LAST_COMMIT);
        return val == null ? 0 : val.intValue();
    }

    public int getChangeCount30() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CHANGES_30);
        return val == null ? 0 : val.intValue();
    }

    public int getChangeCount90() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CHANGES_90);
        return val == null ? 0 : val.intValue();
    }

    public int getChangeCount365() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CHANGES_365);
        return val == null ? 0 : val.intValue();
    }

    public int getChangeCount2y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CHANGES_2Y);
        return val == null ? 0 : val.intValue();
    }

    public int getChangeCount5y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CHANGES_5Y);
        return val == null ? 0 : val.intValue();
    }

    public int getChurn30() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_30);
        return val == null ? 0 : val.intValue();
    }

    public int getChurn90() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_90);
        return val == null ? 0 : val.intValue();
    }

    public int getChurn365() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_365);
        return val == null ? 0 : val.intValue();
    }

    public int getChurn2y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_2Y);
        return val == null ? 0 : val.intValue();
    }

    public int getChurn5y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_5Y);
        return val == null ? 0 : val.intValue();
    }

    public float getChurnRate30() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_RATE_30);
        return val == null ? 0.0f : val.floatValue();
    }

    public float getChurnRate90() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_RATE_90);
        return val == null ? 0.0f : val.floatValue();
    }

    public float getChurnRate365() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_RATE_365);
        return val == null ? 0.0f : val.floatValue();
    }

    public float getChurnRate2y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_RATE_2Y);
        return val == null ? 0.0f : val.floatValue();
    }

    public float getChurnRate5y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_CODE_CHURN_RATE_5Y);
        return val == null ? 0.0f : val.floatValue();
    }

    public int getNumberOfAuthors() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_NUMBER_OF_AUTHORS);
        return val == null ? 0 : val.intValue();
    }

    public int getNumberOfAuthors2y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_NUMBER_OF_AUTHORS_2Y);
        return val == null ? 0 : val.intValue();
    }

    public int getNumberOfAuthors5y() {
        Number val = this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricId.CORE_NUMBER_OF_AUTHORS_5Y);
        return val == null ? 0 : val.intValue();
    }

    public final String getPath() {
        TFile file = ((SourceFile)this.m_element).getFile();
        return file != null ? file.getPath() : null;
    }

    public final TFile getFile() {
        return ((SourceFile)this.m_element).getFile();
    }

    @Override
    public final Object getMetricLevel() {
        return CoreMetricLevel.SOURCE_FILE;
    }

    public final List<String> getSourceLines(boolean withLineBreaks) {
        TFile file = this.getFile();
        if (file != null) {
            try {
                if (withLineBreaks) {
                    return FileUtility.getFileLinesWithLineBreaks((TFile)file);
                }
                return FileUtility.getFileLinesWithoutLineBreaks((TFile)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public final List<ISourceLineAccess> getSourceLines() {
        TFile file = this.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        return SourceFileAccess.getSourceLinesWithContext(file, 3);
    }

    public boolean isModified() {
        FilePath physicalFilePath = ((SourceFile)this.m_element).getPhysicalFilePath();
        return physicalFilePath != null && physicalFilePath.isModified();
    }

    @Override
    public void accept(INamedElementAccess.INamedElementAccessVisitor visitor) {
        if (visitor instanceof ISourceFileAccess.IVisitor) {
            ((ISourceFileAccess.IVisitor)visitor).visitSourceFileAccess((ISourceFileAccess)this);
        } else {
            super.accept(visitor);
        }
    }

    static List<ISourceLineAccess> getSourceLinesWithContext(TFile file, int contextLength) {
        assert (file != null) : "Parameter 'file' of method 'getSourceLinesWithContext' must not be null";
        assert (contextLength > 0) : "Parameter 'contextLength' must be > 0";
        ArrayList<ISourceLineAccess> result = new ArrayList<ISourceLineAccess>();
        FixedSizeFiFoQueue prefix = new FixedSizeFiFoQueue(contextLength);
        FixedSizeFiFoQueue postfix = new FixedSizeFiFoQueue(contextLength);
        ArrayList lines = new ArrayList();
        try {
            lines.addAll(FileUtility.getFileLinesWithoutLineBreaks((TFile)file));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (lines.isEmpty()) {
            return result;
        }
        int i2 = 0;
        int j2 = contextLength * -1;
        while (i2 < lines.size() + contextLength) {
            if (i2 < lines.size()) {
                String line = (String)lines.get(i2);
                postfix.add((Object)line);
            } else if (j2 >= 0) {
                postfix.removeFirst();
            }
            if (j2 >= 0) {
                String currentLine = (String)lines.get(j2);
                SourceLineWithContext line = SourceFileAccess.createSourceLine((FixedSizeFiFoQueue<String>)prefix, currentLine, j2 + 1, (FixedSizeFiFoQueue<String>)postfix);
                SourceLineAccess sourceLineAccess = new SourceLineAccess(line);
                result.add(sourceLineAccess);
                prefix.add((Object)currentLine);
            }
            ++i2;
            ++j2;
        }
        result.trimToSize();
        return result;
    }

    private static SourceLineWithContext createSourceLine(FixedSizeFiFoQueue<String> prefix, String currentLine, int lineNumber, FixedSizeFiFoQueue<String> postfix) {
        String[] context = new String[prefix.getElements().size() + 1 + postfix.getElements().size()];
        int index = 0;
        Iterator iterator = prefix.getElements().iterator();
        while (iterator.hasNext()) {
            String next;
            context[index] = next = (String)iterator.next();
            ++index;
        }
        context[index] = currentLine;
        int linePos = index++;
        Iterator iterator2 = postfix.getElements().iterator();
        while (iterator2.hasNext()) {
            String next;
            context[index] = next = (String)iterator2.next();
            ++index;
        }
        SourceLineWithContext line = new SourceLineWithContext(context, linePos, lineNumber);
        return line;
    }

    public Set<String> getAuthors(IScmPeriod period) {
        return this.m_factory.getAuthors((NamedElement)this.m_element, period);
    }
}

