/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.foundation.collections.LightMap;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.api.Any;
import com.hello2morrow.sonargraph.api.IMetaClass;
import com.hello2morrow.sonargraph.api.IPluginElement;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElementWithChildren;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import java.util.Map;

public class PluginProgrammingElement
extends ProgrammingElementWithChildren
implements IPluginElement {
    private final Map<String, Any> m_properties = new LightMap();
    private final IMetaClass m_metaClass;
    private final IStructureItem m_structureItem;

    public PluginProgrammingElement(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber, IMetaClass metaClass, IStructureItem structureItem) {
        super(msp, parent, name, lineNumber);
        assert (metaClass != null) : "Parameter 'metaClass' of method 'GenericProgrammingElement' must not be null";
        assert (structureItem != null) : "Parameter 'structureItem' of method 'PluginProgrammingElement' must not be null";
        this.m_metaClass = metaClass;
        this.m_structureItem = structureItem;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public final IStructureItem getStructureItem() {
        return this.m_structureItem;
    }

    public final IMetaClass getMetaClass() {
        return this.m_metaClass;
    }

    @Override
    public final boolean isMember() {
        return this.m_metaClass.isMember();
    }

    public final String getElementName() {
        return super.getName();
    }

    @Override
    @Property
    public final String getName() {
        return this.m_metaClass.getElementName((IPluginElement)this);
    }

    @Override
    public final String getShortName() {
        return this.m_metaClass.getElementShortName((IPluginElement)this);
    }

    @Override
    public final String getPresentationName(boolean shortName) {
        return this.m_metaClass.getElementPresentationName((IPluginElement)this, shortName);
    }

    @Override
    public final String getDescription() {
        return this.m_metaClass.getDescription();
    }

    @Override
    public final String getImageResourceName() {
        return this.m_metaClass.getImageResourceName();
    }

    @Override
    public final <T> T getProperty(String property, Class<T> cls) {
        return super.getProperty(property, cls);
    }

    public final Any getProperty(String property) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'getProperty' must not be empty";
        return this.m_properties.get(property);
    }

    public final void setProperty(String property, Any value) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'setProperty' must not be empty";
        assert (value != null) : "Parameter 'value' of method 'setProperty' must not be null";
        this.m_properties.put(property, value);
    }

    public final void removeProperty(String property) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'removeProperty' must not be empty";
        this.m_properties.remove(property);
    }

    @Property
    public final String getPluginId() {
        return this.m_metaClass.getPluginId();
    }

    @Property
    public final String getPluginElementType() {
        return StringUtility.convertMixedCaseToHumanizedString((String)this.m_metaClass.getClass().getSimpleName());
    }

    @Property
    public final String getPluginInfo() {
        if (this.m_properties.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Any> next : this.m_properties.entrySet()) {
            result.append(StringUtility.capitalize((String)next.getKey())).append(": ").append(next.getValue().toString()).append("\n");
        }
        result.delete(result.length() - 1, result.length());
        return result.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGenericProgrammingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitGenericProgrammingElement(PluginProgrammingElement var1);
    }
}

