/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.IElementAccess;
import com.hello2morrow.sonargraph.api.IIssueAccess;
import com.hello2morrow.sonargraph.core.model.element.Issue;

public final class IssueAccess
implements IIssueAccess {
    private final Issue m_issue;
    private final IElementAccess m_affectedElement;

    public IssueAccess(Issue issue, IElementAccess affectedElement) {
        assert (issue != null) : "Parameter ' issue' of method 'IssueAccess' must not be null";
        assert (affectedElement != null) : "Parameter 'affectedElement' of method 'IssueAccess' must not be null";
        this.m_issue = issue;
        this.m_affectedElement = affectedElement;
    }

    public String getKey() {
        return this.m_issue.getKey();
    }

    public String getDescription() {
        return this.m_issue.getDescription();
    }

    public int getLineNumber() {
        return this.m_issue.getLineNumber();
    }

    public String getName() {
        return this.m_issue.getId().getStandardName();
    }

    public String getProviderName() {
        return this.m_issue.getId().getProviderName();
    }

    public boolean isIgnored() {
        return this.m_issue.isIgnored();
    }

    public IElementAccess getAffectedElement() {
        return this.m_affectedElement;
    }

    public String toString() {
        return String.valueOf(this.getProviderName()) + ":" + this.getName() + " '" + this.getDescription() + "' " + (this.isIgnored() ? "<ignored>" : "") + " (" + this.getLineNumber() + ") [" + this.getKey() + "] on element '" + this.getAffectedElement().getName() + "'";
    }
}

