/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.DependencyKind;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IIssueAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.api.IScmPeriod;
import com.hello2morrow.sonargraph.core.api.model.AggregatorImpl;
import com.hello2morrow.sonargraph.core.api.model.IAggregator;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ElementAccess<T extends Element>
implements INamedElementAccess {
    protected static final boolean DEFAULT_EXCLUDE_EXTERNALS = false;
    protected static final boolean DEFAULT_EXCLUDE_EXCLUDED = true;
    protected final T m_element;
    protected IAccessFactory m_factory;

    private static boolean hasType(ParserDependency dep, IDependencyKind ... types) {
        if (types.length == 0) {
            return true;
        }
        IDependencyKind[] iDependencyKindArray = types;
        int n2 = types.length;
        int n3 = 0;
        while (n3 < n2) {
            IDependencyKind type = iDependencyKindArray[n3];
            if (type instanceof DependencyKind ? dep.getGenericDependencyType().getKind() == type : dep.getDependencyType().getKind() == type) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static List<ParserDependency> collectOutgoingProgrammingElementDependencies(ProgrammingElement from, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        for (ProgrammingElement programmingElement : from.getParts()) {
            for (ParserDependency dep : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (!ElementAccess.hasType(dep, types) || dep.getRefactoringState().hasBeenDeleted() || excludeExcluded && dep.getTo().isExcluded() || excludeExternals && dep.getTo().isExternal()) continue;
                result.add(dep);
            }
        }
        return result;
    }

    static List<ParserDependency> collectIncomingProgrammingElementDependencies(ProgrammingElement to, boolean excludeExcluded, IDependencyKind ... types) {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        for (ProgrammingElement programmingElement : to.getParts()) {
            for (ParserDependency dep : programmingElement.getIncomingDependencies(new IStandardEnumeration[0])) {
                if (!ElementAccess.hasType(dep, types) || dep.getRefactoringState().hasBeenDeleted() || excludeExcluded && dep.getFrom().isExcluded()) continue;
                result.add(dep);
            }
        }
        return result;
    }

    static List<ParserDependency> collectOutgoingProgrammingElementDependenciesRecursively(ProgrammingElement from, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        for (ProgrammingElement programmingElement : from.getParts()) {
            for (ParserDependency dep : programmingElement.getOutgoingDependenciesRecursively()) {
                if (!ElementAccess.hasType(dep, types) || dep.getRefactoringState().hasBeenDeleted() || excludeExcluded && dep.getTo().isExcluded() || excludeExternals && dep.getTo().isExternal()) continue;
                result.add(dep);
            }
        }
        return result;
    }

    static List<ParserDependency> collectIncomingProgrammingElementDependenciesRecursively(ProgrammingElement to, boolean excludeExcluded, IDependencyKind ... types) {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        for (ProgrammingElement programmingElement : to.getParts()) {
            for (ParserDependency dep : programmingElement.getIncomingDependenciesRecursively()) {
                if (!ElementAccess.hasType(dep, types) || dep.getRefactoringState().hasBeenDeleted() || excludeExcluded && dep.getFrom().isExcluded()) continue;
                result.add(dep);
            }
        }
        return result;
    }

    static List<ParserDependency> collectOutgoingDependencies(NamedElement from, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        assert (!(from instanceof ProgrammingElement));
        List<ProgrammingElement> collectedElements = ProgrammingElementCollector.collect(from);
        return ElementAccess.collectOutgoingDependenciesForElements(excludeExternals, excludeExcluded, collectedElements, types);
    }

    static List<ParserDependency> collectOutgoingDependencies(NamedElement from, boolean excludeExternals, boolean excludeExcluded, Class<? extends Element> classToExclude, IDependencyKind ... types) {
        assert (!(from instanceof ProgrammingElement));
        List<ProgrammingElement> collectedElements = ProgrammingElementCollector.collect(from, classToExclude);
        return ElementAccess.collectOutgoingDependenciesForElements(excludeExternals, excludeExcluded, collectedElements, types);
    }

    private static List<ParserDependency> collectOutgoingDependenciesForElements(boolean excludeExternals, boolean excludeExcluded, List<ProgrammingElement> collectedElements, IDependencyKind ... types) {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        for (ProgrammingElement programmingElement : collectedElements) {
            for (ParserDependency dep : programmingElement.getOutgoingDependencies(new IParserDependencyType[0])) {
                if (!ElementAccess.hasType(dep, types) || dep.getRefactoringState().hasBeenDeleted() || excludeExternals && dep.getTo().isExternal() || excludeExcluded && dep.getTo().isExcluded()) continue;
                result.add(dep);
            }
        }
        return result;
    }

    static List<ParserDependency> collectIncomingDependencies(NamedElement to, boolean excludeExcluded, IDependencyKind ... types) {
        assert (!(to instanceof ProgrammingElement));
        List<ProgrammingElement> collectedElements = ProgrammingElementCollector.collect(to);
        return ElementAccess.collectIncomingDependenciesForElements(excludeExcluded, collectedElements, types);
    }

    static List<ParserDependency> collectIncomingDependencies(NamedElement to, boolean excludeExcluded, Class<? extends Element> classToExclude, IDependencyKind ... types) {
        assert (!(to instanceof ProgrammingElement));
        List<ProgrammingElement> collectedElements = ProgrammingElementCollector.collect(to, classToExclude);
        return ElementAccess.collectIncomingDependenciesForElements(excludeExcluded, collectedElements, types);
    }

    private static List<ParserDependency> collectIncomingDependenciesForElements(boolean excludeExcluded, List<ProgrammingElement> collectedElements, IDependencyKind ... types) {
        ArrayList<ParserDependency> result = new ArrayList<ParserDependency>();
        for (ProgrammingElement programmingElement : collectedElements) {
            for (ParserDependency dep : programmingElement.getIncomingDependencies(new IStandardEnumeration[0])) {
                if (!ElementAccess.hasType(dep, types) || dep.getRefactoringState().hasBeenDeleted() || excludeExcluded && dep.getFrom().isExcluded()) continue;
                result.add(dep);
            }
        }
        return result;
    }

    static List<IAggregatedDependencyAccess> aggregateIncomingDependencies(IAccessFactory factory, IAggregator aggr, NamedElement to, boolean excludeSelf, List<ParserDependency> dependencies) {
        HashMap<NamedElement, AggregatedDependency> fromMap = new HashMap<NamedElement, AggregatedDependency>();
        ArrayList<IAggregatedDependencyAccess> result = new ArrayList<IAggregatedDependencyAccess>();
        for (ParserDependency dep : dependencies) {
            ProgrammingElement from = dep.getFrom();
            NamedElement aggregatedFrom = aggr.aggregateTo(from);
            if (aggregatedFrom == null || excludeSelf && (aggregatedFrom == to || aggregatedFrom.hasAsParent(to, false))) continue;
            AggregatedDependency aggregatedDep = (AggregatedDependency)fromMap.get(aggregatedFrom);
            if (aggregatedDep == null) {
                aggregatedDep = new AggregatedDependency(aggregatedFrom, to);
                fromMap.put(aggregatedFrom, aggregatedDep);
                result.add(factory.createAccessObject(aggregatedDep));
            }
            aggregatedDep.add(dep);
        }
        return result;
    }

    static List<IAggregatedDependencyAccess> aggregateOutgoingDependencies(IAccessFactory factory, IAggregator aggr, NamedElement from, boolean excludeSelf, List<ParserDependency> dependencies) {
        HashMap<NamedElement, AggregatedDependency> toMap = new HashMap<NamedElement, AggregatedDependency>();
        ArrayList<IAggregatedDependencyAccess> result = new ArrayList<IAggregatedDependencyAccess>();
        for (ParserDependency dep : dependencies) {
            ProgrammingElement to = dep.getTo();
            NamedElement aggregatedTo = aggr.aggregateTo(to);
            if (aggregatedTo == null || excludeSelf && (aggregatedTo == from || aggregatedTo.hasAsParent(from, false))) continue;
            AggregatedDependency aggregatedDep = (AggregatedDependency)toMap.get(aggregatedTo);
            if (aggregatedDep == null) {
                aggregatedDep = new AggregatedDependency(from, aggregatedTo);
                toMap.put(aggregatedTo, aggregatedDep);
                result.add(factory.createAccessObject(aggregatedDep));
            }
            aggregatedDep.add(dep);
        }
        return result;
    }

    static List<INamedElementAccess> aggregateReferencedElements(IAccessFactory factory, IAggregator aggr, NamedElement from, boolean excludeSelf, List<ParserDependency> dependencies) {
        HashSet<NamedElement> targetSet = new HashSet<NamedElement>();
        for (ParserDependency dep : dependencies) {
            ProgrammingElement to = dep.getTo();
            NamedElement aggregatedTo = aggr.aggregateTo(to);
            if (aggregatedTo == null || excludeSelf && (aggregatedTo == from || aggregatedTo.hasAsParent(from, false))) continue;
            targetSet.add(aggregatedTo);
        }
        ArrayList<INamedElementAccess> result = new ArrayList<INamedElementAccess>();
        for (NamedElement e2 : targetSet) {
            result.add(factory.createAccessObject(e2));
        }
        return result;
    }

    static List<INamedElementAccess> aggregateReferencingElements(IAccessFactory factory, IAggregator aggr, NamedElement to, boolean excludeSelf, List<ParserDependency> dependencies) {
        HashSet<NamedElement> targetSet = new HashSet<NamedElement>();
        for (ParserDependency dep : dependencies) {
            ProgrammingElement from = dep.getFrom();
            NamedElement aggregatedFrom = aggr.aggregateTo(from);
            if (aggregatedFrom == null || excludeSelf && (aggregatedFrom == to || aggregatedFrom.hasAsParent(to, false))) continue;
            targetSet.add(aggregatedFrom);
        }
        ArrayList<INamedElementAccess> result = new ArrayList<INamedElementAccess>();
        for (NamedElement e2 : targetSet) {
            result.add(factory.createAccessObject(e2));
        }
        return result;
    }

    protected ElementAccess(T element, IAccessFactory factory) {
        assert (element != null) : "Parameter 'element' of method 'ElementAccess' must not be null";
        assert (factory != null) : "Parameter 'factory' of method 'ElementAccess' must not be null";
        this.m_element = element;
        this.m_factory = factory;
    }

    protected ElementAccess(T element) {
        assert (element != null) : "Parameter 'element' of method 'ElementAccess' must not be null";
        this.m_element = element;
    }

    public T getElement() {
        return this.m_element;
    }

    public Object getMetricLevel() {
        return null;
    }

    public void setFactory(IAccessFactory factory) {
        this.m_factory = factory;
    }

    public INamedElementAccess getParent() {
        if (this.m_element instanceof NamedElement) {
            NamedElement parent = ((NamedElement)this.m_element).getParent();
            if (parent == null) {
                return null;
            }
            return this.m_factory.createAccessObject(parent);
        }
        return null;
    }

    public final List<? extends INamedElementAccess> getChildren() {
        if (!(this.m_element instanceof NamedElement)) {
            return Collections.emptyList();
        }
        ArrayList<ElementAccess<? extends NamedElement>> result = new ArrayList<ElementAccess<? extends NamedElement>>();
        for (NamedElement e2 : ((NamedElement)this.m_element).getChildren()) {
            ElementAccess<? extends NamedElement> obj = this.m_factory.createAccessObject(e2);
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }

    public final String getName() {
        return ((Element)this.m_element).getRawPresentationName(false);
    }

    public final String getShortName() {
        return ((Element)this.m_element).getRawPresentationName(true);
    }

    public final String getNameWithSignature() {
        return ((Element)this.m_element).getPresentationName(false);
    }

    public final String getShortNameWithSignature() {
        return ((Element)this.m_element).getPresentationName(true);
    }

    public boolean isExternal() {
        return ((Element)this.m_element).isExternal();
    }

    public final boolean isExcluded() {
        return ((Element)this.m_element).isExcluded();
    }

    public final boolean ignoreIssues() {
        return ((Element)this.m_element).ignoreIssues();
    }

    public List<IAggregatedDependencyAccess> getOutgoingDependenciesRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        if (this.m_element instanceof NamedElement) {
            List<ParserDependency> deps = ElementAccess.collectOutgoingDependencies((NamedElement)this.m_element, excludeExternals, excludeExcluded, types);
            return ElementAccess.aggregateOutgoingDependencies(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
        }
        return Collections.emptyList();
    }

    public List<IAggregatedDependencyAccess> getOutgoingDependenciesRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, IDependencyKind ... types) {
        return this.getOutgoingDependenciesRecursively(aggr, excludeSelf, excludeExternals, true, types);
    }

    public List<IAggregatedDependencyAccess> getOutgoingDependenciesRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getOutgoingDependenciesRecursively(aggr, excludeSelf, false, true, types);
    }

    public List<IAggregatedDependencyAccess> getIncomingDependenciesRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExcluded, IDependencyKind ... types) {
        if (this.m_element instanceof NamedElement) {
            List<ParserDependency> deps = ElementAccess.collectIncomingDependencies((NamedElement)this.m_element, excludeExcluded, types);
            return ElementAccess.aggregateIncomingDependencies(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
        }
        return Collections.emptyList();
    }

    public List<IAggregatedDependencyAccess> getIncomingDependenciesRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getIncomingDependenciesRecursively(aggr, excludeSelf, true, types);
    }

    public List<INamedElementAccess> getReferencedElementsRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, boolean excludeExcluded, IDependencyKind ... types) {
        if (this.m_element instanceof NamedElement) {
            List<ParserDependency> deps = ElementAccess.collectOutgoingDependencies((NamedElement)this.m_element, excludeExternals, excludeExcluded, types);
            return ElementAccess.aggregateReferencedElements(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
        }
        return Collections.emptyList();
    }

    public List<INamedElementAccess> getReferencedElementsRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExternals, IDependencyKind ... types) {
        return this.getReferencedElementsRecursively(aggr, excludeSelf, excludeExternals, true, types);
    }

    public List<INamedElementAccess> getReferencedElementsRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getReferencedElementsRecursively(aggr, excludeSelf, false, true, types);
    }

    public List<INamedElementAccess> getReferencingElementsRecursively(Aggregator aggr, boolean excludeSelf, boolean excludeExcluded, IDependencyKind ... types) {
        if (this.m_element instanceof NamedElement) {
            List<ParserDependency> deps = ElementAccess.collectIncomingDependencies((NamedElement)this.m_element, excludeExcluded, types);
            return ElementAccess.aggregateReferencingElements(this.m_factory, AggregatorImpl.map(aggr), (NamedElement)this.m_element, excludeSelf, deps);
        }
        throw new IllegalArgumentException("Named element required");
    }

    public List<INamedElementAccess> getReferencingElementsRecursively(Aggregator aggr, boolean excludeSelf, IDependencyKind ... types) {
        return this.getReferencingElementsRecursively(aggr, excludeSelf, true, types);
    }

    public void accept(INamedElementAccess.INamedElementAccessVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("'visitor' must not be null");
        }
        if (!(this.m_element instanceof NamedElement)) {
            throw new IllegalArgumentException("Named element required");
        }
        visitor.visitNamedElementAccess((INamedElementAccess)this);
    }

    public final int getIssueCount(List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean includingSecondary, boolean recursive) {
        return this.m_factory.getNumberOfIssues((Element)this.m_element, categories, issueIds, providers, severities, includingSecondary, recursive);
    }

    public final int getIssueCount(List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean recursive) {
        return this.getIssueCount(categories, issueIds, providers, severities, false, recursive);
    }

    public final int getIssueCount(String category, String id, String provider, String severity, boolean recursive) {
        List<String> categories = category == null ? null : Arrays.asList(category);
        List<String> ids = id == null ? null : Arrays.asList(id);
        List<String> providers = provider == null ? null : Arrays.asList(provider);
        List<String> severities = severity == null ? null : Arrays.asList(severity);
        return this.getIssueCount(categories, ids, providers, severities, recursive);
    }

    public final int getIssueCount(boolean includingSecondary, boolean recursive) {
        return this.getIssueCount(null, null, null, null, includingSecondary, recursive);
    }

    public final int getIssueCount() {
        return this.getIssueCount(true, true);
    }

    public final List<IIssueAccess> getIssues(List<String> categories, List<String> issueIds, List<String> providers, List<String> severities, boolean includingSecondary, boolean recursive) {
        return this.m_factory.getIssues((Element)this.m_element, categories, issueIds, providers, severities, includingSecondary, recursive);
    }

    public final List<IIssueAccess> getIssues(boolean includingSecondary, boolean recursive) {
        return this.getIssues(null, null, null, null, includingSecondary, recursive);
    }

    public List<IIssueAccess> getIssues() {
        return this.getIssues(true, true);
    }

    public final <P extends INamedElementAccess> P getParent(Class<P> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getParent' must not be null";
        INamedElementAccess parent = this.getParent();
        if (parent == null) {
            return null;
        }
        if (clazz.isAssignableFrom(parent.getClass())) {
            return (P)parent;
        }
        return (P)parent.getParent(clazz);
    }

    public String toString() {
        return this.getNameWithSignature();
    }

    public int hashCode() {
        return this.m_element.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElementAccess other = (ElementAccess)obj;
        return this.m_element.equals(other.m_element);
    }

    public String getFullyQualifiedName() {
        if (this.m_element instanceof NamedElement) {
            return ((NamedElement)this.m_element).getFullyQualifiedName();
        }
        return null;
    }

    public static interface IAccessFactory {
        public ElementAccess<? extends NamedElement> createAccessObject(NamedElement var1);

        public IAggregatedDependencyAccess createAccessObject(AggregatedDependency var1);

        public Number getMetricValue(NamedElement var1, IMetricId var2);

        public Number getMetricValue(NamedElement var1, IMetricLevel var2, IMetricId var3);

        public Set<String> getAuthors(NamedElement var1, IScmPeriod var2);

        public int getNumberOfIssues(Element var1, List<String> var2, List<String> var3, List<String> var4, List<String> var5, boolean var6, boolean var7);

        public List<IIssueAccess> getIssues(Element var1, List<String> var2, List<String> var3, List<String> var4, List<String> var5, boolean var6, boolean var7);
    }

    private static class ProgrammingElementCollector
    extends NamedElementVisitor
    implements Artifact.IVisitor,
    LogicalNamespace.IVisitor,
    LogicalNamespaceRoot.IVisitor {
        private final List<ProgrammingElement> m_result = new ArrayList<ProgrammingElement>();
        private Class<? extends Element> m_classToExclude;

        private ProgrammingElementCollector() {
        }

        private ProgrammingElementCollector(Class<? extends Element> classToExclude) {
            assert (classToExclude != null) : "Parameter 'classToExclude' of method 'ProgrammingElementCollector' must not be null";
            this.m_classToExclude = classToExclude;
        }

        @Override
        public void visitChildrenOf(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
            if (!element.isProxy()) {
                List<NamedElement> children = element.getChildren();
                if (this.m_classToExclude != null) {
                    children = children.stream().filter(c2 -> !this.m_classToExclude.isAssignableFrom(c2.getClass())).collect(Collectors.toList());
                }
                for (NamedElement next : children) {
                    next.accept(this);
                    if (this.done()) break;
                }
            }
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (!element.getRefactoringState().hasBeenDeleted()) {
                for (ProgrammingElement next : this.getChildrenRecursively(element)) {
                    if (next.getRefactoringState().hasBeenDeleted()) continue;
                    this.m_result.add(next);
                }
            }
        }

        @Override
        public void visitLogicalNamespaceRoot(LogicalNamespaceRoot element) {
            assert (element != null) : "Parameter 'element' of method 'visitLogicalNamespaceRoot' must not be null";
            super.visitChildrenOf(element);
        }

        @Override
        public void visitLogicalNamespace(LogicalNamespace logicalNamespace) {
            assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'visitLogicalNamespace' must not be null";
            for (ProgrammingElement programmingElement : logicalNamespace.getProgrammingElements()) {
                if (programmingElement.getRefactoringState().hasBeenDeleted()) continue;
                this.m_result.add(programmingElement);
                for (ProgrammingElement next : this.getChildrenRecursively(programmingElement)) {
                    if (next.getRefactoringState().hasBeenDeleted()) continue;
                    this.m_result.add(next);
                }
            }
            this.visitChildrenOf(logicalNamespace);
        }

        @Override
        public void visitArtifact(Artifact element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifact' must not be null";
            for (IAssignableToArtifact nextAssignableToArtifact : element.getAssignedElements()) {
                ProgrammingElement nextProgrammingElement;
                NamedElement nextNamedElement = nextAssignableToArtifact.getNamedElement();
                if (nextNamedElement instanceof ProgrammingElement && !(nextProgrammingElement = (ProgrammingElement)nextNamedElement).getRefactoringState().hasBeenDeleted()) {
                    boolean add = true;
                    if (this.m_classToExclude != null) {
                        boolean bl2 = add = !this.m_classToExclude.isAssignableFrom(nextProgrammingElement.getClass());
                    }
                    if (add) {
                        this.m_result.add(nextProgrammingElement);
                    }
                }
                for (ProgrammingElement next : this.getChildrenRecursively(nextNamedElement)) {
                    if (next.getRefactoringState().hasBeenDeleted()) continue;
                    this.m_result.add(next);
                }
            }
            this.visitChildrenOf(element);
        }

        private static List<ProgrammingElement> collect(NamedElement from) {
            ProgrammingElementCollector collector = new ProgrammingElementCollector();
            from.accept(collector);
            return collector.m_result;
        }

        private static List<ProgrammingElement> collect(NamedElement from, Class<? extends Element> classToExclude) {
            ProgrammingElementCollector collector = new ProgrammingElementCollector(classToExclude);
            from.accept(collector);
            return collector.m_result;
        }

        private List<ProgrammingElement> getChildrenRecursively(NamedElement namedlement) {
            if (this.m_classToExclude != null) {
                return namedlement.getChildrenRecursively(new NamedElement.IFilter(){

                    @Override
                    public boolean accept(NamedElement namedElement) {
                        boolean matchesToExcludeClass = m_classToExclude.isAssignableFrom(namedElement.getClass());
                        return !matchesToExcludeClass;
                    }
                }, ProgrammingElement.class, new Class[0]);
            }
            return namedlement.getChildrenRecursively(ProgrammingElement.class, new Class[0]);
        }
    }
}

