"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ts_morph_1 = require("ts-morph");
const visitor_1 = require("./visitor");
let tsConfigFile = '../../../ts-morph/packages/ts-morph/tsconfig.json';
if (process.argv.length >= 3) {
    tsConfigFile = process.argv[2];
}
console.log("Parsing project");
const project = new ts_morph_1.Project({
    tsConfigFilePath: tsConfigFile
});
const sources = project.getSourceFiles();
console.log(sources.length);
for (let src of sources) {
    console.log(src.getFilePath());
}
try {
    const root = (0, visitor_1.visitSourceFiles)(project.getLanguageService(), tsConfigFile, sources);
    console.log(JSON.stringify(root.toJson()));
}
catch (e) {
    console.error(e);
}
//# sourceMappingURL=index.js.map