<%
 java.util.List<com.hello2morrow.sonargraph.core.model.element.Issue> unresolvedIssues = report.unresolvedIssues;
 java.util.List<com.hello2morrow.sonargraph.core.model.resolution.Resolution> resolutions = report.resolutions;
 java.util.Map<com.hello2morrow.sonargraph.core.model.common.IMetricLevel, 
 java.util.Map<com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory, 
 java.util.Map<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, 
 java.util.Set<com.hello2morrow.sonargraph.core.model.report.MetricRow>>>> metricValueRows = report.getElementMetricsForPrint(maxMetricValueRowCountPerMetric);
 
 boolean isScriptRunnerEnabled = report.getAvailableFeatures().contains(com.hello2morrow.sonargraph.core.model.common.SonargraphFeature.SCRIPTS_AUTOMATED);
 boolean isDuplicateCodeEnabled = report.getAvailableFeatures().contains(com.hello2morrow.sonargraph.core.model.common.SonargraphFeature.DUPLICATE_CODE);
 boolean isArchitectureCheckEnabled = report.getAvailableFeatures().contains(com.hello2morrow.sonargraph.core.model.common.SonargraphFeature.ARCHITECTURE);
 boolean isVirtualModelsEnabled = report.getAvailableFeatures().contains(com.hello2morrow.sonargraph.core.model.common.SonargraphFeature.VIRTUAL_MODELS);
 boolean isQualityGateEnabled = report.getAvailableFeatures().contains(com.hello2morrow.sonargraph.core.model.common.SonargraphFeature.ARCHITECTURE);
 boolean isSingleReport = (report.getFocus() == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.COMPLETE_REPORT);
%>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <style type="text/css" MEDIA="all">@import url("hello2morrow.css");</style>
        <script src="tablefilter/tablefilter.js"></script>
        <title>Sonargraph Architect Report - <%=report.title%></title>
        <link rel="icon" href="favicon.png">
    </head>

    <body>
    <script>
    	window.name = "<%=report.getTargetFile().getName()%>";
    </script>
        <a name="top"></a>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td width="200" bgcolor="#333333"><img src="spacer.gif" alt="" width="200" height="65" border="0"></td>
                <td width="23" bgcolor="E3E4E5"><img src="spacer.gif" width="23" height="1"></td>
                <td width="100%" bgcolor="E3E4E5">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td width="7" bgcolor="e3e4e5"><img src="spacer.gif" width="7" height="1"></td>
                            <td><img src="hello2morrow.gif" alt="hello2morrow" width="227" height="23" border="0"></td>
                            <td width="100%" align="right" bgcolor="e3e4e5"><img src="header.gif" alt="hello2morrow" width="543" height="65" border="0"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="3" bgcolor="#000000"></td>
            </tr>
            <tr>
<!-- start of navigation -->            
                <td bgcolor="#A7A9AC" valign="top">
                    <div class="leftNav">
                        <ul>
                            <li><a href="#system">System</a>
                            	<ul>
                            		<%
                            		if (isQualityGateEnabled)
                            		{                            			
                            		%>
                            		<li><a class="secondLevel" href="#qualitygates">Quality Gates (<%=report.getNumberOfFailedQualityGates()%>)</a></li>
                            		<%
                            		}
                            		%>
                            		<li><a class="secondLevel" href="#features">Features</a></li>
                            		<li><a class="secondLevel" href="#analyzers">Analyzers / Plugins</a></li>
                            		<li><a class="secondLevel" href="#systemmetrics">Metrics</a></li>
                            	</ul>                            
                            </li>
                            
                            <li><a href="#automatedScripts">Automated Scripts <% 
                            if (isScriptRunnerEnabled) 
                            { 
                                out.println("(" + report.getAutomatedScriptConfigurations().size() + ")")
                            }%></a></li>
                            <%
                            if (report.focus == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.SYSTEM_LEVEL)
                            {
                            %>
                            	<li><a href="#moduleReports">Module Reports</a></li>
                            <%
                            }
                            %>
                            <li><a href="#workspace">Workspace</a></li>
                            <li><a href="#openIssues">Unresolved Issues (<%= unresolvedIssues.size() %>)</a></li>
                            <%
                        	if (!splitIssuesSection)
                        	{
                            %>
	                            <li><a href="#cycleGroups">Cycle Groups (<%= report.getNumberOfUnresolvedCycleGroups() %>)</a></li>
	                            <li><a href="#duplicateBlocks">Duplicate Blocks <% 
	                            if (isDuplicateCodeEnabled) 
	                            { 
	                                out.println("(" + report.getUnresolvedDuplicateIssues().size() + ")")
	                            }%></a></li>
                            <%
                            }
                            %>
                            <li><a href="#issueRankings">Issue Ranking</a></li>
                            <li><a href="#resolutions">Resolutions <% 
                            if (isVirtualModelsEnabled) 
                            { 
                                out.println("(" + resolutions.size() + ")")
                            }%></a></li>
                            <li><a href="#elementMetrics">Element Level Metrics</a>
                                <ul>
                                    <% for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.common.IMetricLevel, java.util.Map<
                                               com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory, 
                                                java.util.Map<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, 
                                                java.util.Set<com.hello2morrow.sonargraph.core.model.report.MetricRow>>>> entry : metricValueRows.entrySet())
                                    {
                                    %>
                                    <li><a class="secondLevel" href="#elementMetrics_<%=entry.getKey().getStandardName()%>"><%=entry.getKey().getPresentationName()%> Level Metrics</a></li>
                                    <%
                                    }
                                    %>
                                </ul>
                            </li>
                            <li><a href="#metricInfos">Metric Infos</a></li>
                        </ul>
                    </div>
                </td>
<!-- end of navigation -->
                <!-- start of spacer -->
                <td width="23"><img src="spacer.gif" width="23" height="1"></td><!-- end of spacer -->
                
                <!-- real content -->
                <td width="100%">
                    <table width="100%" border="0">
                        <tr>
                            <td width="1%" height="80" valign="center">
                                <image src="logo.gif" width="350"></image>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <h1><a name="system"></a><%= report.title %></h1>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <strong>Path: </strong><%= report.systemDirectoryPath %><br/>
                                <%
                                if (report.getFocus() == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL)
                                {
                                	String mainReportFileName = ((com.hello2morrow.sonargraph.core.model.report.ModuleReport) report).mainReportTargetFile.name;
                                	out.println("<strong>Link to Main System Report: </strong><a href=\"./" + mainReportFileName + "\" target=\"" + mainReportFileName + "\">" + mainReportFileName + "</a><br/>");                                	
                                }
                                %>
                                <strong>System Description: </strong><%= report.softwareSystem.description %><br/>
                                <strong>Sonargraph Version: </strong><%= report.version %><br/>
                                <strong>Report Creation: </strong><%= report.timestampString %><br/>
                                <strong>Max. Values / Metric: </strong><%= maxMetricValueRowCountPerMetric %><br/>
                                <strong>Current Virtual Model: </strong><%= report.currentVirtualModel %> <br/>
                                <%
                                    if (report.getActiveProfile() != null && report.getActiveProfile().length() > 0)
                                    {
                                %>
                                        <strong>Workspace Profile: </strong><%= report.activeProfile %> <br/>
                                <%
                                    }
                                %>
                                <%
                                    if (report.getQualityModelPath() != null && report.getQualityModelPath().length() > 0)
                                    {
                                %>
                                        <strong>Quality Model: </strong><%= report.qualityModelPath %> <br/>
                                <%
                                    }
                                %>
                                <strong>Analyzer Execution Level: </strong><%= report.getAnalyzerExecutionLevel() %> <br/>
                                <%
                                if (diffReport != null)
                                {
                                %>
                                	<strong>System Diff Report: </strong><a href="<%= diffReport%>"><%= diffReport%></a> <br/>
                                <%
                                }
                                %> 
                            </td>
                        </tr>
                        
<!-- quality gates -->
					<%
					if (isQualityGateEnabled)
            		{
            		%>
						<tr>
							<td>
								<h2><a name="qualitygates"></a>Quality Gates (<%=report.getQualityGateToResultMap().size()%>)</h2>
								<% 
								if(report.getQualityGateToResultMap().isEmpty())
								{
								%>
									No active quality gates exist.
								<%
								} 
								else
								{
									for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate, com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult> entry : report.getQualityGateToResultMap())
									{
										com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate qualityGate = entry.getKey();
										com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult result = entry.getValue();
										String tableId = "qualitygates_" + qualityGate.getShortName();
										String qualityGateStatusImage = result.getResultStatus().getImageResourceName();
										if (qualityGateStatusImage != null)
										{
											out.println("<h3>Quality Gate \"" + qualityGate.getShortName() + "\" (<img style=\"vertical-align: middle;\" src=\"" + qualityGateStatusImage + ".gif\"/> " + result.getResultStatus().getPresentationName() 
												+ ")</h3>");
										}
										else
										{
											out.println("<h3>Quality Gate " + qualityGate.getShortName() + ", Status: " + result.getResultStatus().getPresentationName() + "</h3>");											
										} 										
								%>
								    <table class="techTable" id="<%=tableId%>" width="100%">
	                                    <thead>
		                                    <tr>
		                                        <th>Condition</th>
		                                    	<th>Status</th>
		                                    	<th>Information</th>
		                                    </tr>                                   
		                                </thead>
	                                    <%
	                                      boolean firstCurrentCondition = false;
	                                      boolean firstBaselineCondition = false;
	                                      
	                                      for (com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement qualityGateElement 
	                                      	: qualityGate.getChildrenRecursively(com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement.class, 
	                                      	  com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement.class))
	                                      {
	                                      	//This if-else block controls the info line for current and baseline conditions
	                                      	if (qualityGateElement.getParent(com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions.class) != null)
	                                      	{
	                                      		if (!firstCurrentCondition)
	                                      		{
	                                      			out.println("<tr>");
		                                        	out.println("<td colspan=\"3\">Current System Conditions");
		                                        	out.println("</td>");
		                                        	out.println("</tr>");
	                                      			firstCurrentCondition = true;
                                      			}
	                                      	}
	                                      	else
	                                      	{
	                                      		if (!firstBaselineCondition)
	                                      		{
		                                      		firstBaselineCondition = true;
	                                      	  		out.println("<tr>");
		                                        	out.println("<td colspan=\"3\">Baseline Conditions");
		                                        	out.println("</td>");
		                                        	out.println("</tr>");
		                                        }
		                                    }	
		                                                                            	
	                                        com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateResultElement resultElement = qualityGate.getResultElementFor(qualityGateElement);
	                                        out.println("<tr>");
	                                        out.println("<td>");
	                                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + qualityGateElement.getPresentationName(false));
	                                        out.println("</td>");
	                                        if (resultElement != null)
	                                        {
		                                        out.println("<td style=\"vertical-align: middle;\">");
		                                        if (resultElement.getResultStatus() != null)
		                                        {
			                                        StringBuilder line = new StringBuilder();
			                                        if (resultElement.getResultStatus().getImageResourceName() != null)
			                                        {
			                                        	line.append("<img style=\"vertical-align: middle;\" src=\"").append(resultElement.getResultStatus().getImageResourceName()).append(".gif\"/>");
			                                        }
			                                        line.append(" ").append(resultElement.getResultStatus().getPresentationName()); 
	                                        		out.println(line);
	                                        	}
		                                        out.println("</td>");
		                                        out.println("<td>");
	                                        	out.println(resultElement.getInformation());
		                                        out.println("</td>");
	                                        } 
	                                        else
	                                        {
	                                        	out.println("<td>");
	                                        	out.println("</td>");
		                                        out.println("<td>");
	                                        	out.println("</td>");
	                                        } 
	                                        out.println("</tr>");
	                                      } 
	                                    %>
	                                </table>
	                                <script>
	                            		var filtersConfig = {
											base_path: 'tablefilter/',
							        		alternate_rows: true,
							        		grid: false,
										    col_widths: ['', '200px', '450px'],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('<%=tableId%>', filtersConfig);
										tf.init();
									</script>
									<% 
									}
								}
								%> 
							</td>
						</tr>
                   <%
                   }
                   %>
<!-- features -->                        
                        <tr>
                            <td>
                                <h2><a name="features"></a>Licensed Features</h2>
                                <table class="techTable" id="features">
                                    <thead>
	                                    <tr>
	                                        <th width="450">Feature</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.common.SonargraphFeature feature : report.getAvailableFeatures())
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(feature.getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
						        		alternate_rows: true,
						        		grid: false,
									    col_widths: ['450px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('features', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                        <% 
                        if(report.getUnavailableFeatures().size() > 0)
                        { 
                        %> 
                        <tr>
                            <td>
                                <h2>Not Licensed Features</h2>
                                <table class="techTable" id="unlicensedFeatures">
                                    <tr>
                                        <th width="450">Feature</th>
                                    </tr>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.common.SonargraphFeature feature : report.getUnavailableFeatures())
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(feature.getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
						        		alternate_rows: true,
						        		grid: false,
									    col_widths: ['450px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('unlicensedFeatures', filtersConfig);
									tf.init();
								</script>    
                            </td>
                        </tr>
                        <%
                        }
                        %>
<!-- analyzers --> 
                        <tr>
                            <td>
                                <h2><a name="analyzers"></a>Executed Analyzers</h2>
                                <table class="techTable" id="analyzers">
                                    <thead>
                                        <tr>
                                            <th width="350">Analyzer</th>
                                            <th width="100">Execution Level</th>
                                        </tr>
                                    </thead>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.common.IAnalyzerId analyzer : report.getAnalyzers(true))
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(analyzer.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(analyzer.getExecutionLevel().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                                    var filtersConfig = {
                                        base_path: 'tablefilter/',
                                        alternate_rows: true,
                                        grid: false,
                                        col_widths: ['350px', '100px'],
                                        themes: [{ name: 'default' }]
                                    };
                                    var tf = new TableFilter('analyzers', filtersConfig);
                                    tf.init();
                                </script>
                            </td>
                        </tr>
                        <% 
                        if(report.getAnalyzers(false).size() > 0)
                        { 
                        %> 
                        <tr>
                            <td>
                                <h2>Not Executed Analyzers</h2>
                                <table class="techTable" id="notExecutedAnalyzers">
                                    <tr>
                                            <th width="350">Analyzer</th>
                                            <th width="100">Execution Level</th>
                                        </tr>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.common.IAnalyzerId analyzer : report.getAnalyzers(false))
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(analyzer.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(analyzer.getExecutionLevel().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                                    var filtersConfig = {
                                        base_path: 'tablefilter/',
                                        alternate_rows: true,
                                        grid: false,
                                        col_widths: ['350px', '100px'],
                                        themes: [{ name: 'default' }]
                                    };
                                    var tf = new TableFilter('notExecutedAnalyzers', filtersConfig);
                                    tf.init();
                                </script>    
                            </td>
                        </tr>
                        <%
                        }
                        %>
                        
<!-- plugins, enabled and disabled in one table --> 
                        <% 
                        if( ( report.getModelPlugins().size() + report.getAnalyzerPlugins().size() ) > 0)
                        {
                        %>
                        <tr>
                            <td>
                                <h2>Plugins</h2>
                                <table class="techTable" width="100%" id="plugins">
                                    <thead>
                                        <tr>
                                            <th width="100">Plugin</th>
                                            <th width="150">Description</th>
                                            <th width="100">Vendor</th>
                                            <th width="80">Version</th>
                                            <th width="50">Enabled</th>
                                            <th width="100">Supported Execution Phases</th>
                                            <th width="100">Active Execution Phases</th>
                                        </tr>
                                    </thead>
                                    <% 
                                      for (com.hello2morrow.sonargraph.plugin.SonargraphPlugin plugin : report.getModelPlugins())
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(plugin.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.getVendor());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.getVersion());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.isEnabled());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println("Model");
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.isEnabled() ? "Model" : "");
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                      
                                      for (com.hello2morrow.sonargraph.foundation.utilities.Pair<com.hello2morrow.sonargraph.plugin.SonargraphPlugin,com.hello2morrow.sonargraph.core.model.common.IAnalyzerId> next : report.getAnalyzerPlugins())
                                      {
                                        com.hello2morrow.sonargraph.plugin.SonargraphPlugin plugin = next.getFirst();
                                        com.hello2morrow.sonargraph.core.model.common.IAnalyzerId analyzerId = next.getSecond();
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(plugin.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.getVendor());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.getVersion());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(plugin.isEnabled());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println("Analyzer");
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println((plugin.isEnabled() && report.isExecuted(analyzerId.getExecutionLevel())) ? "Analyzer" : "");
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                                    var filtersConfig = {
                                        base_path: 'tablefilter/',
                                        alternate_rows: true,
                                        grid: false,
                                        col_widths: ['100px', '150px', '100px', '80px', '50px', '100px', '100px'],
                                        themes: [{ name: 'default' }]
                                    };
                                    var tf = new TableFilter('plugins', filtersConfig);
                                    tf.init();
                                </script>
                            </td>
                        </tr>
                    <%
                    }
                    %>
<!-- System Metrics -->
                        <tr>
                            <td><h2><a name="systemmetrics"></a>System Metrics</h2></td>
                        </tr>
						<%
						if (report.getFocus() == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL)
						{
							String mainReportFileName = ((com.hello2morrow.sonargraph.core.model.report.ModuleReport) report).mainReportTargetFile.name;
						%>
							<td><strong>Main System Report: </strong><%=mainReportFileName%> <a href="./<%=mainReportFileName%>" target="<%=mainReportFileName%>">(Open)</a><br/>
						<%
						}
						else
						{                        
	                        for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory, java.util.Map<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, com.hello2morrow.sonargraph.core.model.analysis.IMetricValue>> nextCategory : report.getSystemLevelMetrics())
	                        {
	                        %>
	                        <tr>
	                            <td><strong>Metric Category: <%= nextCategory.getKey().getPresentationName() %></strong><br/>
	                                <table class="techTable" id="system_<%=nextCategory.getKey().getStandardName()%>">
	                                	<thead>
		                                    <tr>
		                                        <th>Name</th>
		                                        <th>Value</th>
		                                        <%
		                                        if (report.isQualityGateCheckActive())
	                                        	{
	                                        	%>
	                                        		<th>Affecting Quality Gate(s)</th>
	                                        	<%
	                                        	}
	                                        	%>
		                                    </tr>
		                                </thead>
	                                    <% 
	                                        int i = 0;
	                                        for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, com.hello2morrow.sonargraph.core.model.analysis.IMetricValue> next : nextCategory.getValue().entrySet())
	                                        {
	                                            i++;
	                                            out.println("<tr>");
	                                            out.println("<td>");
	                                            out.println(next.getKey().getName());
	                                            out.println("</td>");
	                                            out.println("<td class=\"align-right\">");
	                                            out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(next.getValue().getValue()));
	                                            out.println("</td>");
	                                            if (report.isQualityGateCheckActive())
		                                        {
		                                        	boolean affecting = report.metricValueAffectingQualityGates(next.getValue());
		                                        	if (affecting)
		                                        	{
		                                        		out.println("<td class=\"qualityGateAffecting\">");
		                                        	}
		                                        	else
		                                        	{
		                                        		out.println("<td class=\"notQualityGateAffecting\">");
		                                        	}
		                                        	out.println(affecting);
		                                        	out.println("</td>");
		                                        }
	                                            out.println("</tr>");
	                                        }
	                                    %>
	                                </table>
	                                <% if (i > 0)
	                                {
	                                %>
	                                <script>
	                            		var filtersConfig = {
											base_path: 'tablefilter/',
							        		alternate_rows: true,
							        		grid: false,
							        		<%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		col_widths: ['450px', '150px', '180px'],
                                        	<%
                                        	} 
                                        	else 
                                        	{
                                        	%>
                                        		col_widths: ['450px', '150px'],
                                        	<%
                                        	}
                                        	%>
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('system_<%=nextCategory.getKey().getStandardName()%>', filtersConfig);
										tf.init();
									</script>  
	                                <%}%>
	                                <br/>
	                            </td>
	                        </tr>
	                        <%
	                        }
	                        %>
<!-- End of System Metrics -->
	                    <%
	                    }
	                    %>
<!-- Table with links to module reports -->                        
                        <% 
                        if (report.getFocus() == com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.SYSTEM_LEVEL)
                        {
                        	com.hello2morrow.sonargraph.core.model.report.SystemReport systemReport = (com.hello2morrow.sonargraph.core.model.report.SystemReport) report;
                        %>
	                        <tr>
	                            <td><h2><a name="moduleReports"></a>Module Reports <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
	                        </tr>
	                        <tr>
	                        	<td>
	                        		<strong>Reports:</strong><br/>
	                        		<table class="techTable" id="moduleReports" width="80%">
	                                    <thead>
		                                    <tr>
		                                        <th>Module</th>
		                                        <th>Link to Report</th>
		                                    </tr>
		                                </thead>
	                                    <% 
	                                        i = 0;
	                                        for (com.hello2morrow.sonargraph.core.model.report.IBasicReport moduleReport : systemReport.getModuleReports())
	                                        {
	                                        	out.println("<tr>");
	                                        	
	                                            out.println("<td>");
	                                            out.println(moduleReport.elementName);
	                                            out.println("</td>");
	                                            
	                                            out.println("<td>");
	                                            out.println("<a href=\"./" + moduleReport.targetFile.name + "\" target=\"" +  moduleReport.targetFile.name + "\">" + moduleReport.targetFile.name + "</a>");
	                                            out.println("</td>");
	                                            
	                                            out.println("</tr>");
	                                            i++;
	                                        } 
	                                    %>
	                                </table>
	                                <%
	                                	if (i > 0)
	                                	{
	                                	%>
	                                	<script>
	                                		var rowCount = <%=i%>;
	                                		var rowCounts = [25, 50];
	                                		if (rowCount > 50)
	                                		{
	                                			rowCounts = [25, 50, rowCount];
	                                		}
	                                		
	                                		var enablePaging = rowCount > 25;
	                                		
								    		var filtersConfig = {
												base_path: 'tablefilter/',
								        		extensions:[{
									          		name: 'sort',
									          		types: ['string', 'string']
								        		}],
												alternate_rows: true,
												rows_counter: true,
								            	rows_counter_text: 'Modules: ',
								            	btn_reset: true,
								            	status_bar: true,
								            	loader: true,
												mark_active_columns: true,
												highlight_keywords: true,
												paging: enablePaging,
										        results_per_page: ['Modules/Page: ', rowCounts],
										       	col_widths: ['40px', '50px'],
								        		themes: [{ name: 'default' }]
										    };
											var tf = new TableFilter('moduleReports', filtersConfig);
											tf.init();
										</script>
	                                	<%
	                                	}
	                                	%>
	                                <br/>
	                        	</td>
	                        </tr>
<!-- End of module reports -->	                        
                        <%
                        }
                        %>
                        <tr>
                            <td><h2><a name="workspace"></a>Workspace <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
                        <%
                        if (report.getFocus() != com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL && report.getWorkspaceFilters().size() > 0)
                        {
                        %>
                        <tr>
                            <td><strong>Workspace Filter:</strong><br/>
                                <table class="techTable" id="workspaceFilter">
                                    <thead>
	                                    <tr>
	                                        <th>Type</th>
	                                        <th>Pattern</th>
	                                        <th>Info</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                        i = 0;
                                        for (com.hello2morrow.sonargraph.core.model.filter.WildcardPattern pattern : report.getWorkspaceFilters())
                                        {
                                        	out.println("<tr>");
                                        	
                                            out.println("<td>");
                                            out.println(pattern.getPresentationKind());
                                            out.println("</td>");
                                            
                                            out.println("<td>");
                                            out.println(pattern.getName());
                                            out.println("</td>");
                                            
                                            out.println("<td>");
                                            out.println(pattern.getInformation());
                                            out.println("</td>");
                                            
                                            out.println("</tr>");
                                            i++;
                                        } 
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
						        		alternate_rows: true,
						        		grid: false,
									    col_widths: ['15px', '40px', '25px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('workspaceFilter', filtersConfig);
									tf.init();
								</script>
                                <br/>
                            </td>
                        </tr>
                        <%
                        }
                        %>
                        
                        <%
                        if (report.getFocus() != com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL && report.getProductionCodeFilters().size() > 0)
                        {
                        %>
                        <tr>
                            <td><strong>Production Code Filter:</strong><br/>
                                <table class="techTable" id="productionCodeFilter">
                                    <thead>
	                                    <tr>
	                                        <th>Type</th>
	                                        <th>Pattern</th>
	                                        <th>Info</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                        i = 0;
                                        for (com.hello2morrow.sonargraph.core.model.filter.WildcardPattern pattern : report.getProductionCodeFilters())
                                        {
                                        	out.println("<tr>");
                                        	
                                            out.println("<td>");
                                            out.println(pattern.getPresentationKind());
                                            out.println("</td>");
                                            
                                            out.println("<td>");
                                            out.println(pattern.getName());
                                            out.println("</td>");
                                            
                                            out.println("<td>");
                                            out.println(pattern.getInformation());
                                            out.println("</td>");
                                            
                                            out.println("</tr>");
                                            i++;
                                        } 
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
						        		alternate_rows: true,
						        		grid: false,
									    col_widths: ['15px', '40px', '25px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('productionCodeFilter', filtersConfig);
									tf.init();
								</script>
                                <br/>
                            </td>
                        </tr>
                        <%
                        }
                        %>

                        <%
                        if (report.getFocus() != com.hello2morrow.sonargraph.core.model.report.IBasicReport.Focus.MODULE_LEVEL && report.getIssueFilters().size() > 0)
                        {
                        %>
                        <tr>
                            <td><strong>Issue Filter:</strong><br/>
                                <table class="techTable" id="issueFilter">
                                    <thead>
	                                    <tr>
	                                        <th>Type</th>
	                                        <th>Pattern</th>
	                                        <th>Info</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                        i = 0;
                                        for (com.hello2morrow.sonargraph.core.model.filter.WildcardPattern pattern : report.getIssueFilters())
                                        {
                                        	out.println("<tr>");
                                        	
                                            out.println("<td>");
                                            out.println(pattern.getPresentationKind());
                                            out.println("</td>");
                                            
                                            out.println("<td>");
                                            out.println(pattern.getName());
                                            out.println("</td>");
                                            
                                            out.println("<td>");
                                            out.println(pattern.getInformation());
                                            out.println("</td>");
                                            
                                            out.println("</tr>");
                                            i++;
                                        } 
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
						        		alternate_rows: true,
						        		grid: false,
									    col_widths: ['15px', '40px', '25px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('issueFilter', filtersConfig);
									tf.init();
								</script>
                                <br/>
                            </td>
                        </tr>
                        <%
                        }
                        %>
                        <tr>
                            <td><strong>Root Directories:</strong><br/>
                                <table class="techTable" id="workspaceRoots" width="100%">
                                	<thead>
		                                <tr>
	                                        <th>Module</th>
	                                        <th>Root Path</th>
	                                        <th>Number of Files</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                        i = 0;
                                        for (com.hello2morrow.sonargraph.core.model.workspace.Module module : report.getModulesSorted())
                                        {
                                            for (com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath path : module.getChildren(com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath.class))
                                            {
                                                out.println("<tr>");
                                                out.println("<td>");
                                                out.println(module.getName());
                                                out.println("</td>");
                                                out.println("<td>");
                                                out.println(path.getName());
                                                out.println("</td>");
                                                out.println("<td class=\"align-right\">");
                                                out.println(path.getNumberOfFiles());
                                                out.println("</td>");
                                                out.println("</tr>");
                                                i++;
                                            }
                                        }
                                    %>
                                </table>
                                    <%
                                	if (i > 0)
                                	{
                                	%>
                                	<script>
                                		var rowCount = <%=i%>;
                                		var rowCounts = [25, 50];
                                		if (rowCount > 50)
                                		{
                                			rowCounts = [25, 50, rowCount];
                                		}
                                		var enablePaging = rowCount > 25;
                                		
							    		var filtersConfig = {
											base_path: 'tablefilter/',
							        		extensions:[{
								          		name: 'sort',
								          		types: ['string', 'string', 'number']
							        		}],
											alternate_rows: true,
											rows_counter: true,
							            	rows_counter_text: 'Root Directories: ',
							            	btn_reset: true,
							            	status_bar: true,
							            	loader: true,
											mark_active_columns: true,
											highlight_keywords: true,
											paging: enablePaging,
									        results_per_page: ['Directories/Page: ', rowCounts],
									       	col_widths: ['', '', '150px'],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('workspaceRoots', filtersConfig);
										tf.init();
									</script>
                                	<%
                                	}
                                	%>
                            </td>
                        </tr>
                        <tr>
                            <td><h2><a name="automatedScripts"></a>Automated Scripts <% 
                            if (isScriptRunnerEnabled) 
                            { 
                                out.println("(" + report.getAutomatedScriptConfigurations().size() + ")")
                            }%> <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
                        <tr>
                            <td>
                                <table class="techTable" width="100%" id="automatedScripts">
                                    <thead>
	                                    <tr>
	                                        <th>Script</th>
	                                        <th>Run Configuration</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                        i = 0;
                                        for (com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData data : report.getAutomatedScriptConfigurations())
                                        {
                                            i++;
                                            out.println("<tr>");
                                            out.println("<td>");
                                            out.println(data.getIdentifyingScriptPath());
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(data.getRunConfigurationName());
                                            out.println("</td>");
                                            out.println("</tr>");
                                        }
                                        
                                        if (i == 0)
                                        {
                                            out.println("<tr>");
                                            if (isScriptRunnerEnabled)
                                            {
                                                out.println("<td>No automated scripts</td><td></td>");
                                            }
                                            else
                                            {
                                                out.println("<td><font color=\"red\">Script runner not licensed</font></td><td></td>");
                                            }
                                        } 
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
						        		alternate_rows: true,
						        		grid: false,
									    col_widths: ['45px', '25px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('automatedScripts', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
<!-- All Unresolved Issues -->
                        <tr>
                            <td><h2><a name="openIssues"></a>Unresolved Issues (<%= unresolvedIssues.size() %>) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
					<% if (splitIssuesSection)
					{
					%>
<!-- Overview Table if threshold is exceeded -->
                       <tr>
                            <td>
                            <% 
                               i = 0;
                            %>
                                <table class="techTable" width="100%" id="unresolvedIssues">
                                	<thead>
	                                    <tr>
	                                        <th>Type</th>
	                                        <th>Severity</th>
	                                        <th>Category</th>
	                                        <th>Issue Count</th>
	                                        <th><!-- Details --></th>
	                                    </tr>
                                    </thead>
                                    <%                                    
                                    for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.common.IIssueId, List<com.hello2morrow.sonargraph.core.model.element.Issue>> issueEntry : unresolvedIssuesGroupedByIssueId)
                                    {
                                    	com.hello2morrow.sonargraph.core.model.common.IIssueId id = issueEntry.getKey();
                                    	out.println("<tr>");
                                        out.println("<td>");
                                        out.println(id.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(reportWriter.getSupportedSeveritiesAsString(id));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(id.getCategory().getPresentationName());
                                        out.println("</td>");                                        
                                        out.println("<td class=\"align-right\">");
                                        out.println(issueEntry.getValue().size());
                                        out.println("</td>");
                                        out.println("<td>");
                                        String fileName = issueIdToIssueFilenameMap.get(id);
                                        boolean truncated = maxNumberOfIssuesPerTypeOnDetailPage > 0 && issueEntry.getValue().size() > maxNumberOfIssuesPerTypeOnDetailPage;
                                        out.println("<a href=\"./" + fileName + "\" target=\"" + fileName + "\">Open" + (truncated ? " Truncated" : "") + " Detailed Report</a>");
                                        out.println("</td>");
                                        out.println("</tr>");
                                        i++;
                                    }
                                    %>
                                </table>                                	
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		types: ['string', 'string', 'string', 'number', 'string']
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Issues: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Issues/Page: ', rowCounts],
								       	col_widths: ['35px', '10px', '8px', '8px', '35px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('unresolvedIssues', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                        <%					
                    	if (unresolvedIssues.size() == 0)
                        {
                            out.println("<tr>");
                            out.println("<td>No unresolved issues</td>");
                            out.println("</tr>");
                        }
                        %>  
					<%
					} 
					else
					{
					%>
<!-- All unresolved issues within the report if number of issues is below threshold -->
                     <tr>
                            <td>
                            <% 
                               i = 0;
                            %>
                                <table class="techTable" width="100%" id="unresolvedIssues">
                                	<thead>
	                                    <tr>
	                                        <th>Type</th>
	                                        <%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		<th>Affecting<br/>Quality Gate(s)</th>
                                        	<%
                                        	}
                                        	%>
	                                        <th>Description</th>
	                                        <th>Severity</th>
	                                        <th>Category</th>
	                                        <th>Element</th>
	                                        <th>To Element</th>
	                                        <th>Provider</th>
	                                    </tr>
                                    </thead>
                                    <%                                    
                                    for (com.hello2morrow.sonargraph.core.model.element.Issue issue : report.getUnresolvedIssues())
                                    {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(issue.getName());
                                        out.println("</td>");
                                        if (report.isQualityGateCheckActive())
                                        {
                                        	boolean affecting = report.issueAffectingQualityGates(issue);
                                        	if (affecting)
                                        	{
                                        		out.println("<td class=\"qualityGateAffecting\">");
                                        	} 
                                        	else
                                        	{
                                        		out.println("<td class=\"notQualityGateAffecting\">");
                                        	}
                                        	out.println(affecting);
                                        	out.println("</td>");
                                        }
                                        out.println("<td>");
                                        out.println(issue.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(issue.getSeverity().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(issue.getId().getCategory().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getElementOrFrom(issue));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getTo(issue));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(issue.getProvider().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                        i++;
                                    }
                                    %>
                                </table>
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort'
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Issues: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Issues/Page: ', rowCounts],
								        <%
                                        if (report.isQualityGateCheckActive())
                                    	{
                                    	%>
                                    		col_widths: ['15px', '10px', '35px', '8px', '8px', '35px', '35px', '10px'],
                                    	<%
                                    	}
                                    	else
                                    	{
                                    	%>
                                    		col_widths: ['15px', '35px', '8px', '8px', '35px', '35px', '10px'],
                                    	<%
                                    	}
                                    	%>
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('unresolvedIssues', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                        <%					
                    	if (unresolvedIssues.size() == 0)
                        {
                            out.println("<tr>");
                            out.println("<td>No unresolved issues</td>");
                            out.println("</tr>");
                        }
                        %>


<!-- Unresolved Cycle Groups -->
                        <tr>
                            <td><h2><a name="cycleGroups"></a>Unresolved Cycle Groups (<%= report.getNumberOfUnresolvedCycleGroups() %>) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
                        <tr>
                            <td>
                                <% 
                                for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.common.IAnalyzerId, java.util.List<com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue>> entry : report.getUnresolvedCycleIssues().entrySet())
                                {
                                    i = 0;
                                %>
                                <h3><%= entry.getKey().getPresentationName() %> (<%= entry.getValue().size() %>) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
                                <table class="techTable" width="100%" id="<%=entry.getKey().getStandardName()%>">
                                	<thead>
	                                    <tr>
	                                        <th>Name</th>
	                                        <%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		<th>Affecting Quality Gate(s)</th>
                                        	<%
                                        	}
                                        	%>
	                                        <th>Scope</th>
	                                        <th>Size</th>
	                                        <th>Involved Elements</th>
	                                    </tr>
	                                 </thead>
                                    <%
                                    for (com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue nextCycleGroupIssue : entry.getValue())
                                    {
                                        com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup group = ((com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup) nextCycleGroupIssue.getAffectedElement())
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(nextCycleGroupIssue.getAffectedElement().getName());
                                        out.println("</td>");
                                        if (report.isQualityGateCheckActive())
                                        {
                                        	boolean affecting = report.issueAffectingQualityGates(nextCycleGroupIssue);
                                        	if (affecting)
                                        	{
                                        		out.println("<td class=\"qualityGateAffecting\">");
                                        	} 
                                        	else
                                        	{
                                        		out.println("<td class=\"notQualityGateAffecting\">");
                                        	}
                                        	out.println(affecting);
                                        	out.println("</td>");
                                        }
                                        out.println("<td>");
                                        out.println(group.getScope().getImageResourceName() + ": " + group.getScope().getPresentationName(true));
                                        out.println("</td>");
                                        out.println("<td class=\"align-right\">");
                                        out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(group.getNumberOfCyclicElements()));
                                        out.println("</td>");
                                        out.println("<td>");

                                        for (com.hello2morrow.sonargraph.core.model.element.NamedElement next : group.getCyclicNamedElements())
                                        {
                                            out.println(next.getPresentationName(false) + " <br/>");
                                        }    
                                        i++;
                                        out.println("</td>");
                                        out.println("</tr>");
                                    }
                                    %>
                                	</table>
                                    <script>
                                    	var rowCount = <%=entry.getValue().size()%>;
                                		var rowCounts = [25, 50];
                                		if (rowCount > 50)
                                		{
                                			rowCounts = [25, 50, rowCount];
                                		}
                                		
                                		var enablePaging = rowCount > 25;
                                		
							    		var filtersConfig = {
											base_path: 'tablefilter/',
							        		extensions:[{
								          		name: 'sort',
								          		<%
		                                        if (report.isQualityGateCheckActive())
		                                    	{
		                                    	%>
		                                    		types: ['string', 'string', 'string', 'number', 'string']
		                                    	<%
		                                    	}
		                                    	else
		                                    	{
		                                    	%>
		                                    		types: ['string', 'string', 'number', 'string']	
		                                    	<%
		                                    	}
		                                    	%>
							        		}],
											alternate_rows: true,
											rows_counter: true,
							            	rows_counter_text: 'Cycle Groups: ',
							            	btn_reset: true,
							            	status_bar: true,
							            	loader: true,
											mark_active_columns: true,
											highlight_keywords: true,
											paging: enablePaging,
									        results_per_page: ['Cycle Groups/Page: ', rowCounts],
									        
									        <%
	                                        if (report.isQualityGateCheckActive())
	                                    	{
	                                    	%>
	                                    		col_widths: ['12px', '8px', '15px', '5px', '30px'],
	                                    	<%
	                                    	}
	                                    	else
	                                    	{
	                                    	%>
	                                    		col_widths: ['12px', '15px', '5px', '30px'],	
	                                    	<%
	                                    	}
	                                    	%>
									        
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('<%=entry.getKey().getStandardName()%>', filtersConfig);
										tf.init();
                                    </script>
                                    <%
                                    if (entry.getValue().size() == 0)
                                    {
                                       out.println("<br/>No " + entry.getKey().getPresentationName() + "<br/>");
                                    }
                                    %>
                                <%
                                }
                                %>
                            </td>
                        </tr>
                        
<!-- Unresolved Duplicate Blocks -->                        
                        <tr>
                            <td><h2><a name="duplicateBlocks"></a>Unresolved Duplicate Blocks <% 
                            if (isDuplicateCodeEnabled) 
                            { 
                                out.println("(" + report.getUnresolvedDuplicateIssues().size() + ")")
                            }%> <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
                        <tr>
                            <td>
                                <table class="techTable" id="duplicates" width="100%">
                                    <thead>
	                                    <tr>
	                                        <th>Name</th>
	                                        <%
	                                        if (report.isQualityGateCheckActive())
                                        	{
                                        	%>
                                        		<th>Affecting Quality Gate(s)</th>
                                        	<%
                                        	}
                                        	%>
	                                        <th>File</th>
	                                        <th>Line Range</th>
	                                        <th>Block Length (Lines)</th>
	                                        <th>Tolerance (Lines)</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                    i = 0;
                                    for (com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue duplicateIssue : report.getUnresolvedDuplicateIssues())
                                    {
                                        com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock duplicate = (com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock) duplicateIssue.getAffectedElement();
                                        for (com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence occurrence : duplicate.getChildren(com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence.class))
                                        {
	                                        i++;
                                            out.println("<tr>");
                                            out.println("<td>");
	                                        out.println(duplicate.getName());
                                            out.println("</td>");
                                            
                                            if (report.isQualityGateCheckActive())
	                                        {
	                                        	boolean affecting = report.issueAffectingQualityGates(duplicateIssue);
	                                        	if (affecting)
	                                        	{
	                                        		out.println("<td class=\"qualityGateAffectin\">");
	                                        	} 
	                                        	else
	                                        	{
	                                        		out.println("<td>");
	                                        	}
	                                        	out.println(affecting);
	                                        	out.println("</td>");
	                                        }
                                            
                                            out.println("<td>");
                                            out.println(occurrence.getSourceFile().getPresentationName(false));
                                            out.println("</td>");
                                            out.println("<td class=\"align-right\">");
                                            out.println(occurrence.getLineRange());
                                            out.println("</td>");
                                            out.println("<td class=\"align-right\">");
                                            out.println(occurrence.getBlockSize());
                                            out.println("</td>");
                                            out.println("<td class=\"align-right\">");
                                            out.println(occurrence.getToleranceAsInt());
                                            out.println("</td>");
                                            out.println("</tr>");
                                        }
                                    }
                                    %>
                                </table>
								<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		<%
	                                        if (report.isQualityGateCheckActive())
	                                    	{
	                                    	%>
	                                    		types: ['string', 'string', 'string', 'string', 'number', 'number']
	                                    	<%
	                                    	}
	                                    	else
	                                    	{
	                                    	%>
	                                    		types: ['string', 'string', 'string', 'number', 'number']	
	                                    	<%
	                                    	}
	                                    	%>
							          										          		
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Duplicates: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Duplicates/Page: ', rowCounts],
								       	
								       	<%
                                        if (report.isQualityGateCheckActive())
                                    	{
                                    	%>
                                    		col_widths: ['8px', '8px', '40px', '5px', '5px', '5px'],
                                    	<%
                                    	}
                                    	else
                                    	{
                                    	%>
                                    		col_widths: ['8px', '40px', '5px', '5px', '5px'],	
                                    	<%
                                    	}
                                    	%>
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('duplicates', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                        <%
                        if (i == 0)
                        {
                            out.println("<tr>");
                            if (isDuplicateCodeEnabled)
                            {
                                out.println("<td>No duplicate blocks</td>");
                            }
                            else
                            {
                                out.println("<td><font color=\"red\">Duplicate code not licensed</font></td>");
                            }
                            out.println("</tr>");
                        }
                        %>
                   <%
                   } //end of split issues section 
                   %>
<!-- Issue Ranking -->                        
                    <tr>
                        <% 
                            int rankedIssueCount = report.getIssueRankings().size();                                 
                        %>                        
                        <td><h2><a name="issueRankings"></a>Ranked Issues (<%=rankedIssueCount %>) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                    </tr>
                    <tr>
                        <td>
                        <% 
                           i = 0;
                        %>
                            <table class="techTable" width="100%" id="issueRanking">
                                <thead>
                                    <tr>
                                        <th>Type</th>
                                        <th>Score</th>
                                        <th>Urgency</th>
                                        <th>Importance</th>
                                        <%
                                        if (report.isQualityGateCheckActive())
                                        {
                                        %>
                                            <th>Affecting<br/>Quality Gate(s)</th>
                                        <%
                                        }
                                        %>
                                        <th>Description</th>
                                        <th>Severity</th>
                                        <th>Category</th>
                                        <th>Element</th>
                                        <th>To Element</th>
                                        <th>Provider</th>
                                    </tr>
                                </thead>
                                <%                                    
                                for (com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank issueRank : report.getIssueRankings())
                                {
                                    com.hello2morrow.sonargraph.core.model.element.Issue issue = issueRank.getRankedElement();
                                    out.println("<tr>");
                                    out.println("<td>");
                                    out.println(issue.getName());
                                    out.println("<td>");
                                    out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(issueRank.getScoreValue()));
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(issueRank.getUrgencyValue()));
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(issueRank.getImportanceValue()));
                                    out.println("</td>");
                                    out.println("</td>");
                                    if (report.isQualityGateCheckActive())
                                    {
                                        boolean affecting = report.issueAffectingQualityGates(issue);
                                        if (affecting)
                                        {
                                            out.println("<td class=\"qualityGateAffecting\">");
                                        } 
                                        else
                                        {
                                            out.println("<td class=\"notQualityGateAffecting\">");
                                        }
                                        out.println(affecting);
                                        out.println("</td>");
                                    }
                                    out.println("<td>");
                                    out.println(issue.getDescription());
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(issue.getSeverity().getPresentationName());
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(issue.getId().getCategory().getPresentationName());
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(report.getElementOrFrom(issue));
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(report.getTo(issue));
                                    out.println("</td>");
                                    out.println("<td>");
                                    out.println(issue.getProvider().getPresentationName());
                                    out.println("</td>");
                                    out.println("</tr>");
                                    i++;
                                }
                                %>
                            </table>
                            <script>
                                var rowCount = <%=i%>;
                                var rowCounts = [25, 50];
                                if (rowCount > 50)
                                {
                                    rowCounts = [25, 50, rowCount];
                                }
                                
                                var enablePaging = rowCount > 25;
                                
                                var filtersConfig = {
                                    base_path: 'tablefilter/',
                                    extensions:[{
                                        name: 'sort',
                                        <%
                                        if (report.isQualityGateCheckActive())
                                        {
                                        %>
                                            types: ['string', 'number', 'number', 'number', 'string', 'string', 'string', 'string', 'string', 'string', 'string']
                                        <%
                                        }
                                        else
                                        {
                                        %>
                                            types: ['string', 'number', 'number', 'number', 'string', 'string', 'string', 'string', 'string', 'string'] 
                                        <%
                                        }
                                        %> 
                                    }],
                                    alternate_rows: true,
                                    rows_counter: true,
                                    rows_counter_text: 'Ranked Issues: ',
                                    btn_reset: true,
                                    status_bar: true,
                                    loader: true,
                                    mark_active_columns: true,
                                    highlight_keywords: true,
                                    paging: enablePaging,
                                    results_per_page: ['Ranked Issues/Page: ', rowCounts],
                                    <%
                                    if (report.isQualityGateCheckActive())
                                    {
                                    %>
                                        col_widths: ['15px', '10px', '10px', '10px', '10px', '35px', '8px', '8px', '35px', '35px', '10px'],
                                    <%
                                    }
                                    else
                                    {
                                    %>
                                        col_widths: ['15px', '10px', '10px', '10px', '35px', '8px', '8px', '35px', '35px', '10px'],
                                    <%
                                    }
                                    %>
                                    themes: [{ name: 'default' }]
                                };
                                var tf = new TableFilter('issueRanking', filtersConfig);
                                tf.init();
                            </script>
                        </td>
                    </tr>
                    <%                  
                    if (rankedIssueCount == 0)
                    {
                        out.println("<tr>");
                        out.println("<td>No ranked issues</td>");
                        out.println("</tr>");
                    }
                    %>                        
               
<!-- Resolutions -->    
                  <%  
                  if (!isVirtualModelsEnabled) 
                  { 
                  %>   
                    <tr>
                        <td><h2><a name="resolutions"></a>Resolutions  <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                    </tr>
                  <%
                  } 
                  else
                  {
                  %>
                    <tr>
                        <td><h2><a name="resolutions"></a>Resolutions (<%= resolutions.size() %>) of Virtual Model "<%= report.currentVirtualModel %>" <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                    </tr>
                    <%
                    }
                    %>
                    <%
                    if(splitResolutionSection)
                    {
                   	%>
                   		<tr>
                            <td>
                                <table width="100%" id="resolutions">
                                   	<thead>
	                                    <tr>
	                                        <th>Issue Type</th>
	                                        <th>Severity</th>
	                                        <th>Category</th>
	                                        <th>Resolution Count</th>
	                                        <th><!-- Details --></th>
	                                    </tr>
                                    </thead>
                                    <% 
                                    i = 0;
                                    for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.common.IIssueId, List<com.hello2morrow.sonargraph.core.model.resolution.Resolution>> resolutionEntry : resolutionsGroupedByIssueId)
                                    {
                                        i++;
                                        com.hello2morrow.sonargraph.core.model.common.IIssueId id = resolutionEntry.getKey();
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(id.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(reportWriter.getSupportedSeveritiesAsString(id));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(id.getCategory().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td class=\"align-right\">");
                                        out.println(resolutionEntry.getValue().size());
                                        out.println("</td>");
                                        out.println("<td>");
                                        String fileName = issueIdToResolutionFilenameMap.get(id);
                                        boolean truncated = maxNumberOfIssuesPerTypeOnDetailPage > 0 && resolutionEntry.getValue().size() > maxNumberOfIssuesPerTypeOnDetailPage;
                                        out.println("<a href=\"./" + fileName + "\" target=\"" + fileName + "\">Open" + (truncated ? " Truncated" : "") + " Detailed Report</a>");
                                        out.println("</td>");
                                        out.println("</tr>");
                                    }
                                    %>
                                </table>
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		types: ['string', 'string', 'string', 'number', 'string']								          		
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Resolutions: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Resolutions/Page: ', rowCounts],
								       	col_widths: ['35px', '10px', '8px', '8px', '35px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('resolutions', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                   	<%
                    }
                    else
                    {
                    	i = 0;
                    	if (report.getResolutions().size() > 0)
                    	{
                    %>
                        <tr>
                            <td>
                                <table width="100%" id="resolutions">
                                   	<thead>
	                                    <tr>
	                                        <th>Resolution Type</th>
	                                        <th>Issue Type</th>
	                                        <th>Description</th>
	                                        <th>Information</th>
	                                        <th>Date</th>
	                                        <th>Matched</th>
	                                        <th>Priority</th>
	                                        <th>Assignee</th>
	                                    </tr>
                                    </thead>
                                    <% 
                                    
                                    for (com.hello2morrow.sonargraph.core.model.resolution.Resolution resolution : report.getResolutions())
                                    {
                                        i++;
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(resolution.getPresentationKind());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getIssueType(resolution));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getInformation());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(report.getDate(resolution.getDate()));
                                        out.println("</td>");
                                        out.println("<td class=\"align-right\">");
                                        out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(resolution.getMatchingElementsCount()));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getPriority().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(resolution.getAssignee());
                                        out.println("</td>");
                                        out.println("</tr>");
                                    }
                                    %>
                                </table>
                                
                            	<script>
                            		var rowCount = <%=i%>;
                            		var rowCounts = [25, 50];
                            		if (rowCount > 50)
                            		{
                            			rowCounts = [25, 50, rowCount];
                            		}
                            		
                            		var enablePaging = rowCount > 25;
                            		
						    		var filtersConfig = {
										base_path: 'tablefilter/',
						        		extensions:[{
							          		name: 'sort',
							          		types: ['string', 'string', 'string', 'string', 'string', 'number', 'string', 'string']								          		
						        		}],
										alternate_rows: true,
										rows_counter: true,
						            	rows_counter_text: 'Resolutions: ',
						            	btn_reset: true,
						            	status_bar: true,
						            	loader: true,
										mark_active_columns: true,
										highlight_keywords: true,
										paging: enablePaging,
								        results_per_page: ['Resolutions/Page: ', rowCounts],
								       	col_widths: ['8px', '12px', '25px', '25px', '7px', '7px', '7px', '7px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('resolutions', filtersConfig);
									tf.init();
								</script>
                            </td>
                        </tr>
                        <%
                        	}
                        }
                        %>              
                        <%
 						out.println("<tr>");
                        if (!isVirtualModelsEnabled)
                        {
                            out.println("<td><font color=\"red\">Virtual models not licensed</font></td>");
                        }
                        else if (i == 0)
                        {
                            out.println("<td>No resolutions</td>");
                        }
                        out.println("</tr>");
                    %>
<!-- Element Metrics -->                                        
                        <tr>
                            <td><h2><a name="elementMetrics"></a>Element Level Metrics <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
                        <% for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.common.IMetricLevel, java.util.Map<
                               com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory, 
                                java.util.Map<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, 
                                java.util.Set<com.hello2morrow.sonargraph.core.model.report.MetricRow>>>> entry : metricValueRows.entrySet())
                        {
                        %>
                            <tr>
                                <td>
                                    <h3><a name="elementMetrics_<%=entry.getKey().getStandardName()%>"></a><%=entry.getKey().getPresentationName()%> Level Metrics <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
                                </td>
                            </tr>
                            <% for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory, 
                                java.util.Map<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, 
                                java.util.Set<com.hello2morrow.sonargraph.core.model.report.MetricRow>>> nextCategory : entry.getValue().entrySet())
                               {
                            %>
                            <tr>
                                <td>        
                                    <strong>Metric Category: <%= nextCategory.getKey().getPresentationName()%></strong> (Note: Only showing the top <%= maxMetricValueRowCountPerMetric %> values per metric.)<br/>
                                    <table class="techTable" width="100%" id="elementMetrics_<%=entry.getKey().getStandardName()%>_<%=nextCategory.getKey().getStandardName()%>">
	                                    <thead>
	                                        <tr>
	                                            <th>Metric</th>
	                                            <th><%=entry.getKey().getPresentationName()%></th>
	                                            <th>Value</th>
	                                        </tr>
				                        </thead>
                                        <%
                                        i = 0;
                                        String currentMetric = null;
                                        for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor, java.util.Set<com.hello2morrow.sonargraph.core.model.report.MetricRow>> rowMap : nextCategory.getValue().entrySet())
                                        {
                                            for (com.hello2morrow.sonargraph.core.model.report.MetricRow row : rowMap.getValue())
                                            {  
                                                out.println("<tr>");
                                                out.println("<td>");
                                                if (!row.getMetricName().equals(currentMetric))
                                                {
                                                    out.println(row.getMetricName());
                                                }
                                                out.println("</td>");
                                                out.println("<td>");
                                                out.println(row.getElementName());
                                                out.println("</td>");
                                                out.println("<td class=\"align-right\">");
                                                out.println(com.hello2morrow.sonargraph.foundation.utilities.NumberUtility.format(row.getMetricValue()));
                                                out.println("</td>");
                                                
                                                out.println("</tr>");
                                                i++;
                                                currentMetric = row.getMetricName();
                                            }
                                        } 
                                        %>
                                    </table>
                                    <script>
	                            		var filtersConfig = {
											base_path: 'tablefilter/',
							        		alternate_rows: true,
							        		grid: false,
										    col_widths: ['15px', '50px', '5px'],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('elementMetrics_<%=entry.getKey().getStandardName()%>_<%=nextCategory.getKey().getStandardName()%>', filtersConfig);
										tf.init();
									</script>
                                    <br/>
                                    <br/>
                                </td>
                            </tr>
                        <%
                            }
                        }
                        %>
<!-- Metric Information -->     
                        <tr>
                            <td><h2><a name="metricInfos"></a>Metric Info <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2></td>
                        </tr>
                        <tr>
                            <td>
                                <table class="techTable" width="100%" id="metricInfos">
                                    <thead>
	                                    <tr>
	                                        <th>Name</th>
	                                        <th>Description</th>
	                                        <th>Category</th>
	                                        <th>Provider</th>
	                                    </tr>
                                    </thead>
                                    <%
                                    i = 0;
                                    for (com.hello2morrow.sonargraph.core.model.analysis.IMetricId metric : report.getMetricIds())
                                    {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(metric.getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(metric.getDescription());
                                        out.println("</td>");
                                        out.println("<td>");
                                        java.util.List<String> categories = new java.util.ArrayList<String>();
                                        for (com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory next : metric.getCategories())
                                        {
                                            categories.add(next.getPresentationName());
                                        }
                                        out.println(com.hello2morrow.sonargraph.foundation.utilities.StringUtility.concat(categories, ", "));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(metric.getProvider().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                        i++;
                                    } 
                                    %>
                                </table>
                                <%
                            	if (i > 0)
                            	{
                            	%>
                                	<script>
                                		var filtersConfig = {
											base_path: 'tablefilter/',
							        		extensions:[{
								          		name: 'sort',
								          		types: ['string', 'string', 'string', 'string']								          		
							        		}],
											alternate_rows: true,
											rows_counter: true,
							            	rows_counter_text: 'Metrics: ',
							            	btn_reset: true,
							            	status_bar: true,
							            	loader: true,
											mark_active_columns: true,
											highlight_keywords: true,
									       	col_widths: ['25px', '35px', '18px', '25px'],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('metricInfos', filtersConfig);
										tf.init();
									</script>
                            	<%
                            	}
                            	%>
                            </td>
                        </tr>                                                                                                                        
                    </table>
                </td>
                
    <!-- end of real content -->
            </tr>
        </table>
    </body>
</html>