/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class XmlPrettyPrintWriter
implements XMLStreamWriter {
    private static final int INDENTATION_LENGTH = 1;
    private static final char INDENT_CHAR = '\t';
    private static final String LINEFEED_CHAR = System.getProperty("line.separator");
    private final Deque<IndentationInfo> indentationStack = new ArrayDeque<IndentationInfo>();
    private final XMLStreamWriter writer;

    XmlPrettyPrintWriter(XMLStreamWriter writer) {
        assert (writer != null) : "Parameter 'writer' of method 'XmlPrettyPrintWriter' must not be null";
        this.writer = writer;
        this.indentationStack.push(new IndentationInfo(0));
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndentationForStartElement();
        this.writer.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndentationForStartElement();
        this.writer.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndentationForStartElement();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElementPretty();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeEmptyElementPretty();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeEmptyElementPretty();
        this.writer.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writeIndentationForEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.writer.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.writer.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) {
        return this.writer.getProperty(name);
    }

    private char[] repeat(int d, char s) {
        char[] padding = new char[d];
        Arrays.fill(padding, 0, d, s);
        return padding;
    }

    private void writeIndentationForStartElement() throws XMLStreamException {
        IndentationInfo current = this.indentationStack.peek();
        if (this.indentationStack.size() > 0) {
            current.hasChild = true;
        }
        this.writer.writeCharacters(LINEFEED_CHAR);
        this.writePadding(current);
        int nextIndentationLevel = current.indentationLevel + 1;
        this.indentationStack.push(new IndentationInfo(nextIndentationLevel));
    }

    private void writeIndentationForEndElement() throws XMLStreamException {
        IndentationInfo current = this.indentationStack.pop();
        if (current.hasChild) {
            IndentationInfo parent = this.indentationStack.peek();
            this.writer.writeCharacters(LINEFEED_CHAR);
            this.writePadding(parent);
        }
    }

    private void writeEmptyElementPretty() throws XMLStreamException {
        IndentationInfo current;
        if (this.indentationStack.size() > 1) {
            current = this.indentationStack.pop();
            IndentationInfo parent = this.indentationStack.peek();
            parent.hasChild = true;
            this.indentationStack.push(current);
        }
        current = this.indentationStack.peek();
        this.writer.writeCharacters(LINEFEED_CHAR);
        this.writePadding(current);
    }

    private void writePadding(IndentationInfo indentationInfo) throws XMLStreamException {
        this.writer.writeCharacters(this.repeat(indentationInfo.indentationLevel, '\t'), 0, indentationInfo.indentationLevel);
    }

    private static class IndentationInfo {
        private final int indentationLevel;
        private boolean hasChild = false;

        public IndentationInfo(int indentationLevel) {
            this.indentationLevel = indentationLevel;
        }
    }
}

