/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IPhysicalRecursiveElement;
import com.hello2morrow.sonargraph.integration.access.model.IProgrammingElement;
import com.hello2morrow.sonargraph.integration.access.model.IProgrammingElementContainer;
import com.hello2morrow.sonargraph.integration.access.model.IRootDirectory;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementComparator;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SourceFileImpl;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class RootDirectoryImpl
extends NamedElementImpl
implements IProgrammingElementContainer,
IRootDirectory {
    private static final long serialVersionUID = -5510302644511647715L;
    private final Set<SourceFileImpl> sourceFileImpls = new TreeSet<INamedElement>(new NamedElementComparator());
    private final Set<IPhysicalRecursiveElement> physicalRecursiveElements = new TreeSet<INamedElement>(new NamedElementComparator());
    private final Set<IProgrammingElement> programmingElements = new TreeSet<INamedElement>(new NamedElementComparator());

    public RootDirectoryImpl(String kind, String presentationKind, String relativePath, String fqName, String imageResourceName) {
        super(kind, presentationKind, relativePath, relativePath, fqName, imageResourceName);
    }

    @Override
    public String getRelativePath() {
        return this.getPresentationName();
    }

    public void addSourceFile(SourceFileImpl sourceFileImpl) {
        assert (sourceFileImpl != null) : "Parameter 'sourceFileImpl' of method 'addSourceFile' must not be null";
        assert (!this.sourceFileImpls.contains(sourceFileImpl)) : "sourceFileImpl'" + sourceFileImpl.getFqName() + "' has already been added";
        this.sourceFileImpls.add(sourceFileImpl);
    }

    @Override
    public Set<ISourceFile> getSourceFiles() {
        return Collections.unmodifiableSet(this.sourceFileImpls);
    }

    @Override
    public void addPhysicalRecursiveElement(IPhysicalRecursiveElement physicalRecursiveElement) {
        assert (physicalRecursiveElement != null) : "Parameter 'physicalRecursiveElement' of method 'addPhysicalRecursiveElement' must not be null";
        assert (!this.physicalRecursiveElements.contains(physicalRecursiveElement)) : "Already added physical recursive element: " + physicalRecursiveElement.getFqName();
        this.physicalRecursiveElements.add(physicalRecursiveElement);
    }

    @Override
    public Set<IPhysicalRecursiveElement> getPhysicalRecursiveElements() {
        return Collections.unmodifiableSet(this.physicalRecursiveElements);
    }

    @Override
    public void addProgrammingElement(IProgrammingElement programmingElement) {
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'addProgrammingElement' must not be null";
        assert (!this.programmingElements.contains(programmingElement)) : "Already added programming element: " + programmingElement.getFqName();
        this.programmingElements.add(programmingElement);
    }

    @Override
    public Set<IProgrammingElement> getProgrammingElements() {
        return Collections.unmodifiableSet(this.programmingElements);
    }
}

