/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IMetaDataController;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.access.foundation.TestUtility;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IRootDirectory;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.internal.RootDirectoryImpl;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ModuleInfoProcessorTest {
    private static final String JAVA_INTERNAL_COMPILATION_UNIT = "JavaInternalCompilationUnit";
    private static final String JAVA_SOURCE_ROOT_DIRECTORY_PATH = "JavaSourceRootDirectoryPath";
    private static final String SRC_ROOT = "Workspace:Application:../../smallTestProject/Application/src/main/java";
    private ISonargraphSystemController m_controller;
    private IMetaDataController m_exportMetaDataController;
    private IExportMetaData m_exportMetaData;

    @Before
    public void before() {
        this.m_exportMetaDataController = ControllerFactory.createMetaDataController();
        ResultWithOutcome<IExportMetaData> loadMetaDataResult = this.m_exportMetaDataController.loadExportMetaData(new File("./src/test/resources/ExportMetaData.xml"));
        Assert.assertTrue((String)loadMetaDataResult.toString(), (boolean)loadMetaDataResult.isSuccess());
        this.m_exportMetaData = loadMetaDataResult.getOutcome();
        this.m_controller = ControllerFactory.createController();
        Result result = this.m_controller.loadSystemReport(new File("./src/test/resources/AlarmClock.xml"));
        Assert.assertTrue((String)result.toString(), (boolean)result.isSuccess());
        Assert.assertTrue((String)loadMetaDataResult.toString(), (boolean)loadMetaDataResult.isSuccess());
    }

    @Test
    public void testRootDirectoriesAndSourceFiles() {
        Optional<IModule> applicationOptional = this.m_controller.getSoftwareSystem().getModule("Application");
        Assert.assertTrue((String)"Module not found", (boolean)applicationOptional.isPresent());
        IModule application = applicationOptional.get();
        List<IRootDirectory> roots = application.getRootDirectories();
        Assert.assertEquals((String)"Wrong number of root directories", (long)2L, (long)roots.size());
        Map<String, INamedElement> classRoots = TestUtility.getFqNameToNamedElement(application, "JavaClassRootDirectoryPath");
        Assert.assertFalse((String)"No class roots found", (boolean)classRoots.isEmpty());
        INamedElement clsRoot = classRoots.get("Workspace:Application:../../smallTestProject/Application/target/classes");
        Assert.assertNotNull((String)"Class root not found", (Object)clsRoot);
        RootDirectoryImpl classes = (RootDirectoryImpl)clsRoot;
        Assert.assertEquals((String)"Wrong number of source files", (long)0L, (long)classes.getSourceFiles().size());
        Map<String, INamedElement> srcRoots = TestUtility.getFqNameToNamedElement(application, JAVA_SOURCE_ROOT_DIRECTORY_PATH);
        Assert.assertFalse((String)"No src roots found", (boolean)srcRoots.isEmpty());
        INamedElement srcRoot = srcRoots.get(SRC_ROOT);
        Assert.assertNotNull((String)"Src root not found", (Object)srcRoot);
        IRootDirectory src = (IRootDirectory)srcRoot;
        Assert.assertEquals((String)"Wrong number of source files", (long)2L, (long)src.getSourceFiles().size());
    }

    @Test
    public void testIsContainedInModule() {
        Optional<IModule> applicationOptional = this.m_controller.getSoftwareSystem().getModule("Application");
        Assert.assertTrue((String)"Module not found", (boolean)applicationOptional.isPresent());
        IModule application = applicationOptional.get();
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(application);
        INamedElement srcRoot = TestUtility.getFqNameToNamedElement(application, JAVA_SOURCE_ROOT_DIRECTORY_PATH).get(SRC_ROOT);
        Assert.assertNotNull((String)"src root not found", (Object)srcRoot);
        Assert.assertTrue((String)"Element must be contained in module!", (boolean)processor.isElementContainedInModule(srcRoot));
        INamedElement srcFile = TestUtility.getFqNameToNamedElement(application, JAVA_INTERNAL_COMPILATION_UNIT).get("Workspace:Application:../../smallTestProject/Application/src/main/java:com:h2m:alarm:application:Main.java");
        Assert.assertNotNull((String)"src file not found", (Object)srcFile);
        Assert.assertTrue((String)"Element must be contained in module!", (boolean)processor.isElementContainedInModule(srcFile));
        Optional<IModule> foundationOptional = this.m_controller.getSoftwareSystem().getModule("Foundation");
        Assert.assertTrue((String)"Module not found", (boolean)foundationOptional.isPresent());
        IModule foundation = foundationOptional.get();
        INamedElement srcRoot2 = TestUtility.getFqNameToNamedElement(foundation, JAVA_SOURCE_ROOT_DIRECTORY_PATH).get("Workspace:Foundation:../../smallTestProject/AlarmClock/Foundation/src/main/java");
        INamedElement srcFile2 = TestUtility.getFqNameToNamedElement(foundation, JAVA_INTERNAL_COMPILATION_UNIT).get("Workspace:Foundation:../../smallTestProject/AlarmClock/Foundation/src/main/java:com:h2m:common:observer:DuplicateInFoundation.java");
        Assert.assertFalse((String)"Element must not be contained in module", (boolean)processor.isElementContainedInModule(srcRoot2));
        Assert.assertFalse((String)"Element must not be contained in module", (boolean)processor.isElementContainedInModule(srcFile2));
    }

    @Test
    public void testGetSourceFileForArchitectureViolation() {
        Optional<IModule> applicationOptional = this.m_controller.getSoftwareSystem().getModule("Application");
        Assert.assertTrue((String)"Module not found", (boolean)applicationOptional.isPresent());
        IModule application = applicationOptional.get();
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(application);
        List<IIssue> unresolvedIssues = processor.getIssues(issue -> !issue.hasResolution());
        Assert.assertEquals((String)"Wrong number of unresolved issues", (long)11L, (long)unresolvedIssues.size());
        IIssueCategory architectureViolationCategory = this.m_exportMetaData.getIssueCategories().get("ArchitectureViolation");
        List<IIssue> architectureViolations = processor.getIssues(issue -> {
            boolean matchesCategory = issue.getIssueType().getCategory().getName().equals(architectureViolationCategory.getName());
            boolean matchesDescription = issue.getDescription().startsWith("[New]");
            return matchesCategory && matchesDescription;
        });
        Assert.assertEquals((String)"Wrong number of architecture violations", (long)1L, (long)architectureViolations.size());
        IIssue architectureViolation = architectureViolations.get(0);
        Assert.assertTrue((String)("Dependency issue expected - but was:" + architectureViolation.getClass().getName()), (boolean)(architectureViolation instanceof IDependencyIssue));
        Optional<ISourceFile> sourceOptional = application.getSourceForElement(((IDependencyIssue)architectureViolation).getFrom());
        Assert.assertTrue((String)"No source for element found", (boolean)sourceOptional.isPresent());
        ISourceFile source = sourceOptional.get();
        Assert.assertEquals((String)"Wrong source of architecture violation", (Object)"./com/h2m/alarm/application/Main.java", (Object)source.getPresentationName());
    }

    @Test
    public void testGetResolutionsForModule() {
        Optional<IModule> applicationOptional = this.m_controller.getSoftwareSystem().getModule("Application");
        Assert.assertTrue((String)"Module not found", (boolean)applicationOptional.isPresent());
        IModule application = applicationOptional.get();
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(application);
        Assert.assertEquals((String)("Wrong number of resolutions for module '" + application.getName() + "'"), (long)1L, (long)processor.getResolutions(null).size());
        Assert.assertEquals((String)"Wrong number of resolutions of type 'TODO'", (long)1L, (long)processor.getResolutions(r -> r.getType().equals(ResolutionType.TODO)).size());
        Assert.assertEquals((String)"Wrong number of resolutions of type 'Refactoring'", (long)0L, (long)processor.getResolutions(r -> r.getType().equals(ResolutionType.REFACTORING)).size());
        Assert.assertEquals((String)"Wrong number of unresolved resolutions", (long)0L, (long)processor.getResolutions(r -> !r.isApplicable()).size());
    }

    @Test
    public void testGetIssuesForSourceFiles() {
        Optional<IModule> applicationOptional = this.m_controller.getSoftwareSystem().getModule("Application");
        Assert.assertTrue((String)"Module not found", (boolean)applicationOptional.isPresent());
        IModule application = applicationOptional.get();
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(application);
        Map<ISourceFile, List<IIssue>> sourceFilesWithIssueMap = processor.getIssuesForSourceFiles(issue -> !issue.hasResolution());
        Assert.assertFalse((String)"Map must not be empty", (boolean)sourceFilesWithIssueMap.isEmpty());
        List files = sourceFilesWithIssueMap.keySet().stream().filter(file -> file.getFqName().endsWith("Main.java")).collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong number of files with issues (without resolution)", (long)1L, (long)files.size());
        ISourceFile main = (ISourceFile)files.get(0);
        Assert.assertEquals((String)"Wrong relative source file path", (Object)"./com/h2m/alarm/application/Main.java", (Object)main.getPresentationName());
        Assert.assertEquals((String)"Wrong relative root directory", (Object)"../../smallTestProject/Application/src/main/java", (Object)main.getRelativeRootDirectory());
        Assert.assertEquals((String)"Wrong absolute system directory", (Object)"D:/00_repos/00_e4-sgng/com.hello2morrow.sonargraph.language.provider.java/src/test/architecture/AlarmClockWithArchitecture", (Object)this.m_controller.getSoftwareSystem().getBaseDir());
        List<IIssue> issuesForMain = sourceFilesWithIssueMap.get(main);
        Assert.assertEquals((String)"Wrong number of unresolved issues for source file", (long)8L, (long)issuesForMain.size());
    }

    @Test
    public void testGetDuplicates() {
        Optional<IModule> applicationOptional = this.m_controller.getSoftwareSystem().getModule("Model");
        Assert.assertTrue((String)"Module not found", (boolean)applicationOptional.isPresent());
        IModule application = applicationOptional.get();
        IModuleInfoProcessor processor = this.m_controller.createModuleInfoProcessor(application);
        Map<ISourceFile, List<IIssue>> sourceFilesWithIssueMap = processor.getIssuesForSourceFiles(issue -> !issue.hasResolution());
        Assert.assertFalse((String)"Map must not be empty", (boolean)sourceFilesWithIssueMap.isEmpty());
        Optional<ISourceFile> duplicateInModel = sourceFilesWithIssueMap.keySet().stream().filter(s -> s.getFqName().endsWith("DuplicateInModel.java")).findFirst();
        Assert.assertTrue((String)"Source file with issues not present", (boolean)duplicateInModel.isPresent());
        List<IIssue> duplicatesInModelIssues = sourceFilesWithIssueMap.get(duplicateInModel.get());
        List duplicates = duplicatesInModelIssues.stream().filter(i -> i instanceof IDuplicateCodeBlockIssue).map(i -> (IDuplicateCodeBlockIssue)i).collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong number of duplicates", (long)2L, (long)duplicates.size());
    }
}

