/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.go.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.generic.GenericLanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericRootDirectory;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.controller.settings.GoSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.GoRefactoringAdapter;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.GoRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.GoWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser.GoRefreshJob;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.parser.GoSourceLineProcessor;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.plugin.PluginGoAccess;
import com.hello2morrow.sonargraph.languageprovider.go.controller.system.script.GoAccess;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoLanguage;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoMessageCause;
import com.hello2morrow.sonargraph.languageprovider.go.model.element.GoProviderId;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoFileType;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoConstant;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoFunction;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoInterface;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoMethod;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoStruct;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoTypeAlias;
import com.hello2morrow.sonargraph.languageprovider.go.model.programming.GoVariable;
import com.hello2morrow.sonargraph.languageprovider.go.model.system.GoIssueId;
import com.hello2morrow.sonargraph.languageprovider.go.model.system.GoMetricId;
import com.hello2morrow.sonargraph.languageprovider.go.model.system.GoMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.go.model.system.IGoSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoExternal;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModule;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModuleType;
import com.hello2morrow.sonargraph.languageprovider.go.persistence.system.GoPersistenceProvider;
import com.hello2morrow.sonargraph.plugin.go.IPluginGoAccess;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GoLanguageProvider
extends GenericLanguageProvider {
    private static final Set<String> KEYWORDS;
    private TFile m_userHome;
    private TFile m_goHome;
    private IGoSettingsProvider m_settingsProvider;
    private GoRefreshJob m_refreshJob;

    static {
        String[] keywords = new String[]{"break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var"};
        KEYWORDS = new HashSet<String>(keywords.length);
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String nextKeyword = stringArray[n2];
            KEYWORDS.add(nextKeyword);
            ++n2;
        }
    }

    public GoLanguageProvider() {
        super((Language)GoLanguage.INSTANCE, GoModule.class, (LanguageProviderRefactoringAdapter)new GoRefactoringAdapter(KEYWORDS));
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        super.initialize(installation, finishModelProcessor);
        installation.addExtension((Extension)new GoWorkspaceExtension(finishModelProcessor));
        if (this.m_userHome == null) {
            this.m_userHome = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        }
        this.m_goHome = new TFile((File)this.m_userHome, "go");
        if (!this.m_goHome.isDirectory()) {
            this.m_goHome.mkdirs();
        }
        GoSettingsExtension settings = new GoSettingsExtension(this.m_goHome);
        installation.addExtension((Extension)settings);
        this.m_settingsProvider = settings;
    }

    public void initialize(SoftwareSystem system, IFinishModelProcessor finishModelProcessor) {
        super.initialize(system, finishModelProcessor);
    }

    public IMetricLevel getNamespaceMetricLevel() {
        return GoMetricLevel.GO_PACKAGE;
    }

    public IMetricId getNamespacesMetricId() {
        return GoMetricId.GO_PACKAGES;
    }

    public IMetricId getFullyAnalyzedNamespacesMetricId() {
        return GoMetricId.GO_PACKAGES_FULLY_ANALYZED;
    }

    protected ISourceLineProcessor createSourceLineProcessor() {
        return new GoSourceLineProcessor();
    }

    public void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        super.aboutToCreateFirstModule(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        assert (!workspace.hasChildren(false, new Class[]{this.getExternalClass()})) : "Already created external node";
        workspace.addChild((NamedElement)new GoExternal((NamedElement)workspace));
    }

    public void addPluginAccess(Installation installation, SoftwareSystem softwareSystem, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (installation != null) : "Parameter 'installation' of method 'addPluginAccess' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addPluginAccess' must not be null";
        assert (access != null) : "Parameter 'access' of method 'addPluginAccess' must not be null";
        access.put(IPluginGoAccess.class, (IPluginCoreAccess)new PluginGoAccess(installation, softwareSystem));
    }

    public Set<String> getKeywords() {
        return KEYWORDS;
    }

    public CategoryProvider getPhysicalCategoryProvider() {
        CategoryProvider cp = new CategoryProvider();
        cp.setCategory(GoModule.class, 1);
        cp.setCategory(GoInterface.class, 20);
        cp.setCategory(GoStruct.class, 40);
        cp.setCategory(GoMethod.class, 45);
        cp.setCategory(GoFunction.class, 50);
        cp.setCategory(GoFunctionWithBody.class, 50);
        cp.setCategory(GoTypeAlias.class, 60);
        cp.setCategory(GoConstant.class, 70);
        cp.setCategory(GoVariable.class, 80);
        cp.setCategory(GenericRootDirectory.class, 10);
        cp.setCategory(GoExternal.class, 1000);
        return cp;
    }

    public CategoryProvider getLogicalCategoryProvider() {
        return super.getLogicalCategoryProvider();
    }

    public Set<? extends IIssueId> getIssueIds() {
        return EnumSet.allOf(GoIssueId.class);
    }

    public boolean prepareRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, PrepareRefreshResult result) {
        TFile goExeFile = this.m_settingsProvider.getGoFile();
        if (goExeFile == null) {
            result.addError((OperationResult.IMessageCause)GoMessageCause.CANNOT_FIND_GO, "Cannot locate the 'go' executable. Make sure it can be found via PATH", new Object[0]);
        } else {
            this.m_refreshJob = new GoRefreshJob(goExeFile.getParentFile().getAbsolutePath(), (IAddedOrChangedSourceFileProcessor)this, softwareSystem);
            result.setParserRefreshPossible((Language)GoLanguage.INSTANCE, true);
        }
        return false;
    }

    public boolean refreshSystem(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (this.m_refreshJob != null);
        boolean success = this.m_refreshJob.refreshSystem(workerContext, result);
        this.m_refreshJob = null;
        return success;
    }

    protected void clearModules(SoftwareSystem softwareSystem, boolean onRefresh) {
        for (GoModule module : ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(GoModule.class)) {
            module.removeOutgoingWorkspaceDependencies();
        }
        super.clearModules(softwareSystem, onRefresh);
    }

    public LanguageProviderRefactoringDescriptorProvider getRefactoringDescriptorProvider() {
        return new GoRefactoringDescriptorProvider();
    }

    protected RelevantSourceLinesScanner.ScannerInfo getScannerInfo() {
        return new RelevantSourceLinesScanner.ScannerInfo(new String[]{"import"});
    }

    protected Class<? extends External> getExternalClass() {
        return GoExternal.class;
    }

    public IAdditionalFileInfoProvider getPersistenceProvider(Installation installation) {
        return new GoPersistenceProvider(installation);
    }

    public IProviderId getProviderId() {
        return GoProviderId.INSTANCE;
    }

    protected Module.IModuleType getModuleType(String moduleTypeStandardName) {
        return GoModuleType.GO_MODULE;
    }

    protected Module createModule(SoftwareSystem system, Module.IModuleType type, String id, String name, String description) {
        Workspace workspace = (Workspace)system.getUniqueExistingChild(Workspace.class);
        GoModule result = new GoModule((NamedElement)workspace, name, id);
        workspace.addChild((NamedElement)result);
        result.setDescription(description);
        return result;
    }

    protected List<StructureItem> getPhysicalStructureItems() {
        return Arrays.asList(StructureItem.MODULE, StructureItem.ROOT_DIRECTORY, StructureItem.DIRECTORY_FRAGMENT, StructureItem.COMPONENT, StructureItem.PROGRAMMING_ELEMENT);
    }

    protected CoreAccess getSystemAccess(Installation installation, SoftwareSystem system, IMetricIdProvider metricIdProvider, ScriptApi api) {
        return new GoAccess(installation, system, metricIdProvider, api);
    }

    public String getBundleId() {
        return "com.hello2morrow.sonargraph.language.provider.go";
    }

    public Collection<String> getSourceExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        String[] stringArray = GoFileType.SOURCE_FILE.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        return extensions;
    }

    public final List<IAssignableAttributeRetriever> createAssignableAttributeRetrievers() {
        return List.of();
    }

    public boolean controlsParserModelRefresh() {
        return true;
    }

    public boolean checkWorkspaceDependenciesFromSnapshot() {
        return false;
    }

    public boolean moduleOrderIsRelevant() {
        return false;
    }

    public boolean supportsDeltaRefresh() {
        return false;
    }
}

