/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client.ant;

import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.IssueFilter;
import com.hello2morrow.sonargraph.build.api.ReportRequest;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.SystemOpenRequest;
import com.hello2morrow.sonargraph.build.client.CreateReportInteraction;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.Params;
import com.hello2morrow.sonargraph.build.client.ant.AbstractSonargraphTask;
import com.hello2morrow.sonargraph.build.client.ant.AntFilterSet;
import com.hello2morrow.sonargraph.build.client.ant.AntIssueFilter;
import java.util.Arrays;
import java.util.List;

public final class SonargraphReportTask
extends AbstractSonargraphTask {
    private String m_compilerDefinitionPath;
    private String m_pythonInterpreterPath;
    private String m_requiredInstallationProfiles;
    private String m_systemDir;
    private String m_languages;
    private String m_snapshotDirectory;
    private String m_snapshotFileName;
    private String m_virtualModel;
    private String m_workspaceProfile;
    private String m_qualityModelFile;
    private String m_reportDirectory;
    private String m_reportFileName;
    private String m_reportType;
    private String m_reportFormat;
    private String m_contextInfo;
    private String m_baselineReportPath;
    private boolean m_splitByModule;
    private int m_elementCountToSplitHtmlReport = 0;
    private int m_maxElementCountForHtmlDetailsPage = 0;
    private String m_branch;
    private String m_commitId;
    private String m_systemVersion;
    private String m_timestamp;
    private int m_numberOfDaemons = 0;
    private int m_daemonStackSize = 0;
    private AntFilterSet m_failSet;

    public void addConfiguredFailSet(AntFilterSet filterSet) {
        this.m_failSet = filterSet;
    }

    @Override
    protected List<ISonargraphBuildInteraction> createInteractions(StartupRequest startupRequest) {
        startupRequest.setLanguages(this.m_languages);
        if (this.m_compilerDefinitionPath != null && !this.m_compilerDefinitionPath.trim().isEmpty()) {
            startupRequest.addLanguageIfNotPresent("CPlusPlus");
        }
        SystemOpenRequest openRequest = this.createOpenRequest();
        ReportRequest reportRequest = this.createReportRequest();
        CreateReportInteraction createReport = new CreateReportInteraction(this, openRequest, reportRequest, this.convertFailSet());
        List<ISonargraphBuildInteraction> interactions = Arrays.asList(createReport);
        return interactions;
    }

    private FailSet convertFailSet() {
        FailSet filter = null;
        if (this.m_failSet != null) {
            filter = new FailSet();
            filter.setFailOnEmptyWorkspace(this.m_failSet.isFailOnEmptyWorkspace());
            filter.setFailOnIssues(this.m_failSet.isFailOnIssues());
            for (AntIssueFilter nextInclude : this.m_failSet.getIncludeFilters()) {
                filter.addIncludeIssueFilter((IssueFilter)new IssueFilter.Builder().issueType(nextInclude.getIssueType()).severity(nextInclude.getSeverity()).resolution(nextInclude.getResolution()).create());
            }
            for (AntIssueFilter nextExclude : this.m_failSet.getExcludeFilters()) {
                filter.addExcludeIssueFilter((IssueFilter)new IssueFilter.Builder().issueType(nextExclude.getIssueType()).severity(nextExclude.getSeverity()).resolution(nextExclude.getResolution()).create());
            }
        }
        return filter;
    }

    private SystemOpenRequest createOpenRequest() {
        SystemOpenRequest request = new SystemOpenRequest();
        request.setInstallationSpecificParameter(Params.COMPILER_DEFINITION_PATH.getParameterName(), this.m_compilerDefinitionPath);
        request.setInstallationSpecificParameter(Params.PYTHON_INTERPRETER_PATH.getParameterName(), this.m_pythonInterpreterPath);
        request.setInstallationSpecificParameter(Params.REQUIRED_INSTALLATION_PROFILES.getParameterName(), this.m_requiredInstallationProfiles);
        request.setInstallationSpecificParameter(Params.NUMBER_OF_DAEMONS.getParameterName(), String.valueOf(this.m_numberOfDaemons));
        request.setInstallationSpecificParameter(Params.DAEMON_STACK_SIZE.getParameterName(), String.valueOf(this.m_daemonStackSize));
        request.setSystemDirectory(this.m_systemDir);
        request.setWorkspaceProfile(this.m_workspaceProfile);
        request.setQualityModelFile(this.m_qualityModelFile);
        request.setVirtualModel(this.m_virtualModel);
        request.setSnaphotDirectory(this.m_snapshotDirectory);
        request.setSnapshotFileName(this.m_snapshotFileName);
        return request;
    }

    private ReportRequest createReportRequest() {
        ReportRequest request = new ReportRequest();
        request.setReportDirectory(this.m_reportDirectory);
        request.setReportFileName(this.m_reportFileName);
        request.setReportType(this.m_reportType);
        request.setReportFormat(this.m_reportFormat);
        request.setContextInfo(this.m_contextInfo);
        request.setSplitByModule(this.m_splitByModule);
        request.setElementCountToSplitHtmlReport(this.m_elementCountToSplitHtmlReport);
        request.setMaxElementCountForHtmlDetailsPage(this.m_maxElementCountForHtmlDetailsPage);
        request.setBaselineReportPath(this.m_baselineReportPath);
        request.setUploadHostUrl(this.getUploadHostUrl());
        request.setCreateAndUploadSnapshot(this.isCreateAndUploadSnapshot());
        request.setClientKey(this.getClientKey());
        request.setFailedUploadDirectory(this.getFailedUploadDirectory());
        request.setBranch(this.m_branch);
        request.setCommitId(this.m_commitId);
        request.setVersion(this.m_systemVersion);
        request.setTimestampAsString(this.m_timestamp);
        return request;
    }

    public void setLanguages(String languages) {
        assert (languages != null) : "Parameter 'languages' of method 'setLanguages' must not be null";
        this.m_languages = languages;
    }

    public void setCompilerDefinitionPath(String compilerDefinitionPath) {
        assert (compilerDefinitionPath != null) : "Parameter 'compilerDefinitionPath' of method 'setCompilerDefinitionPath' must not be null";
        this.m_compilerDefinitionPath = compilerDefinitionPath;
    }

    public void setPythonInterpreterPath(String pythonInterpreterPath) {
        assert (pythonInterpreterPath != null) : "Parameter 'pythonInterpreterPath' of method 'setCompilerDefinitionPath' must not be null";
        this.m_pythonInterpreterPath = pythonInterpreterPath;
    }

    public void setSystemDirectory(String path) {
        assert (path != null) : "Parameter 'path' of method 'setSystemDirectory' must not be null";
        this.m_systemDir = path;
    }

    public void setWorkspaceProfile(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setWorkspaceProfile' must not be empty";
        this.m_workspaceProfile = name;
    }

    public void setQualityModelFile(String path) {
        this.m_qualityModelFile = path;
    }

    public void setSnapshotDirectory(String snapshotDirectory) {
        assert (snapshotDirectory != null) : "Parameter 'snapshotDirectory' of method 'setSnapshotDirectory' must not be null";
        this.m_snapshotDirectory = snapshotDirectory;
    }

    public void setSnapshotFileName(String snapshotFileName) {
        assert (snapshotFileName != null) : "Parameter 'snapshotFileName' of method 'setSnapshotFileName' must not be null";
        this.m_snapshotFileName = snapshotFileName;
    }

    public void setVirtualModel(String virtualModel) {
        assert (virtualModel != null && virtualModel.length() > 0) : "Parameter 'virtualModel' of method 'setVirtualModel' must not be empty";
        this.m_virtualModel = virtualModel;
    }

    public void setReportDirectory(String path) {
        assert (path != null) : "Parameter 'path' of method 'setReportDirectory' must not be null";
        this.m_reportDirectory = path;
    }

    public void setReportFileName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setReportFileName' must not be empty";
        this.m_reportFileName = name;
    }

    public void setReportType(String reportType) {
        assert (reportType != null) : "Parameter 'reportType' of method 'setReportType' must not be null";
        this.m_reportType = reportType;
    }

    public void setReportFormat(String reportFormat) {
        assert (reportFormat != null) : "Parameter 'reportFormat' of method 'setReportFormat' must not be null";
        this.m_reportFormat = reportFormat;
    }

    public void setContextInfo(String contextInfo) {
        this.m_contextInfo = contextInfo;
    }

    public void setBaselineReportPath(String baselineReportPath) {
        assert (baselineReportPath != null) : "Parameter 'baselineReportPath' of method 'setBaselineReportPath' must not be null";
        this.m_baselineReportPath = baselineReportPath;
    }

    public void setSplitByModule(boolean splitByModule) {
        this.m_splitByModule = splitByModule;
    }

    public void setMaxElementCountForHtmlDetailsPage(int maxElementCountForHtmlDetailsPage) {
        this.m_maxElementCountForHtmlDetailsPage = maxElementCountForHtmlDetailsPage;
    }

    public void setElementCountToSplitHtmlReport(int elementCountToSplitHtmlReport) {
        this.m_elementCountToSplitHtmlReport = elementCountToSplitHtmlReport;
    }

    public void setBranch(String branch) {
        this.m_branch = branch;
    }

    public void setCommitId(String commitId) {
        this.m_commitId = commitId;
    }

    public void setVersion(String systemVersion) {
        this.m_systemVersion = systemVersion;
    }

    public void setTimestamp(String timestamp) {
        this.m_timestamp = timestamp;
    }

    public void setRequiredInstallationProfiles(String requiredInstallationProfiles) {
        this.m_requiredInstallationProfiles = requiredInstallationProfiles;
    }

    public void setNumberOfDaemons(int numberOfDaemons) {
        this.m_numberOfDaemons = numberOfDaemons;
    }

    public void setDaemonStackSize(int daemonStackSize) {
        this.m_daemonStackSize = daemonStackSize;
    }
}

