/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildProxy;
import com.hello2morrow.sonargraph.build.client.MemoryPrinter;
import com.hello2morrow.sonargraph.build.client.Params;
import com.hello2morrow.sonargraph.build.client.SonargraphBuildInstallationManager;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class SonargraphBuildTransaction {
    static final String STARTUP_REQUEST_PARAMETERS_ARE_VALID = "Startup request parameters are valid";
    static final String BOTH_LICENSEFILE_AND_ACTIVATIONCODE_DEFINED = String.format("Both '%s' and '%s' are defined. Using 'licenseFile'", Params.ACTIVATION_CODE.getParameterName(), Params.LICENSE_FILE.getParameterName());
    static final String MISSING_LICENSEFILE_AND_ACTIVATIONCODE = String.format("Either '%s' or '%s' must be defined\n", Params.LICENSE_FILE.getParameterName(), Params.ACTIVATION_CODE.getParameterName());
    private final StartupRequest m_startupRequest;
    private final List<ISonargraphBuildInteraction> m_interactions;
    private final ISonargraphBuildClient m_client;

    public SonargraphBuildTransaction(ISonargraphBuildClient client, StartupRequest startupRequest, List<ISonargraphBuildInteraction> interactions) {
        assert (client != null) : "Parameter 'client' of method 'SonargraphBuildTransaction' must not be null";
        assert (startupRequest != null) : "Parameter 'startupRequest' of method 'SonargraphBuildTransaction' must not be null";
        assert (interactions != null) : "Parameter 'interactions' of method 'SonargraphBuildTransaction' must not be null";
        this.m_client = client;
        this.m_startupRequest = startupRequest;
        this.m_interactions = interactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse execute() throws SonargraphBuildException {
        ServiceResponse currentResponse = this.validate();
        if (currentResponse.getStatusCode() == StatusCode.INPUT_VALIDATION_ERROR) {
            return currentResponse;
        }
        ISonargraphBuildProxy build = null;
        long startTime = System.currentTimeMillis();
        try {
            ServiceResponse start;
            this.m_client.info("Starting SonargraphBuild [Client: " + this.m_client.getClientName() + ", Version: " + String.valueOf(this.m_client.getVersion()) + "]");
            this.m_client.info(MemoryPrinter.getInfo());
            ISonargraphBuild.Version serviceVersion = SonargraphBuildInstallationManager.determineVersionOfInstallation(this.m_startupRequest.getInstallationDirectory());
            if (this.versionMismatch(this.m_client.getVersion(), serviceVersion)) {
                this.m_client.info("");
                this.m_client.info("Warning: Client version '" + this.m_client.getVersion().getVersionWithoutBuildNumber() + "' and service version '" + String.valueOf(serviceVersion) + "' do not match. Consider updating either client or service!");
                this.m_client.info("");
            }
            if ((start = (build = this.m_client.getProxyFactory().createProxy(this.m_startupRequest.getInstallationDirectory(), this.m_startupRequest, this.m_client)).start()).isFailure()) {
                ServiceResponse serviceResponse = start;
                return serviceResponse;
            }
            this.m_client.info("Started SonargraphBuild [" + String.valueOf(build.getServiceReference().getVersion()) + "]");
            int failureCount = 0;
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (ISonargraphBuildInteraction next : this.m_interactions) {
                currentResponse = next.execute(build.getServiceReference(), this.m_client);
                if (!currentResponse.isFailure()) continue;
                ++failureCount;
                String message = String.format("Task '%s' failed with error '%s'", next.getDescription(), currentResponse.getStatusMessage());
                errorMessages.add(message);
            }
            if (this.m_interactions.size() > 1) {
                if (failureCount > 0) {
                    String messages = errorMessages.stream().collect(Collectors.joining("\n\t"));
                    currentResponse = new ServiceResponse(StatusCode.FAILED, String.format("%d of %d tasks failed. Error messages: \n\t%s", failureCount, this.m_interactions.size(), messages));
                } else {
                    currentResponse = new ServiceResponse(StatusCode.OK, String.format("Successfully completed %d tasks", this.m_interactions.size()));
                }
            }
        }
        finally {
            if (build != null) {
                if (build.getServiceReference() != null) {
                    build.getServiceReference().close();
                }
                build.stop();
                this.m_client.info(MemoryPrinter.getInfo());
                this.m_client.info("Stopped SonargraphBuild after " + (System.currentTimeMillis() - startTime) + " ms.");
            }
        }
        return currentResponse;
    }

    private boolean versionMismatch(ISonargraphBuild.Version clientVersion, ISonargraphBuild.Version serviceVersion) {
        assert (clientVersion != null) : "Parameter 'clientVersion' of method 'versionMismatch' must not be null";
        assert (serviceVersion != null) : "Parameter 'serviceVersion' of method 'versionMismatch' must not be null";
        return clientVersion.getVersionWithoutBuildNumber().compareTo(serviceVersion.getVersionWithoutBuildNumber()) != 0;
    }

    public ServiceResponse validate() {
        ServiceResponse validate = this.validateStartupRequest(this.m_startupRequest);
        if (validate.getStatusCode() == StatusCode.INPUT_VALIDATION_ERROR) {
            return validate;
        }
        for (ISonargraphBuildInteraction next : this.m_interactions) {
            if (next.needsLicense() && this.m_startupRequest.getActivationCode() == null && this.m_startupRequest.getLicenseFile() == null) {
                return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, MISSING_LICENSEFILE_AND_ACTIVATIONCODE);
            }
            validate = next.validateInput(this.m_client);
            if (validate.getStatusCode() != StatusCode.INPUT_VALIDATION_ERROR) continue;
            return validate;
        }
        return validate;
    }

    private ServiceResponse validateStartupRequest(StartupRequest startupRequest) {
        String licenseServerUrl;
        String level;
        StringBuilder errorMsg = new StringBuilder();
        if (startupRequest.getInstallationDirectory() != null) {
            String installationPath = Paths.get(new File(startupRequest.getInstallationDirectory()).getAbsolutePath(), new String[0]).normalize().toString();
            startupRequest.setInstallationDirectory(installationPath);
            File installationDirectory = new File(installationPath);
            if (!installationDirectory.isDirectory()) {
                errorMsg.append(String.format("'%s' is not a directory: %s\n", Params.INSTALLATION_DIRECTORY.getParameterName(), installationPath));
            } else if (!installationDirectory.canRead()) {
                errorMsg.append(String.format("No read permission for '%s': %s\n", Params.INSTALLATION_DIRECTORY.getParameterName(), installationPath));
            } else if (!installationDirectory.canExecute()) {
                errorMsg.append(String.format("No execution permission for '%s': %s\n", Params.INSTALLATION_DIRECTORY.getParameterName(), installationPath));
            }
        }
        File logFile = startupRequest.getLogFile() == null ? new File(this.m_client.getDefaultOutputDirectory(), "sonargraph_build.log") : new File(startupRequest.getLogFile());
        startupRequest.setLogFile(logFile.getAbsolutePath());
        if (startupRequest.getLogLevel() != null && !Params.LOG_LEVEL.getValueInfo().contains(startupRequest.getLogLevel())) {
            errorMsg.append(String.format("'%s' is not supported: %s. Use one of: %s\n", Params.LOG_LEVEL.getParameterName(), startupRequest.getLogLevel(), Params.LOG_LEVEL.getParameterName()));
        }
        if (startupRequest.getActivationCode() != null && startupRequest.getActivationCode().trim().length() == 0) {
            startupRequest.setActivationCode(null);
        }
        if (startupRequest.getLicenseFile() != null && startupRequest.getLicenseFile().trim().length() == 0) {
            startupRequest.setLicenseFile(null);
        }
        if (startupRequest.getLicenseFile() != null && startupRequest.getActivationCode() != null) {
            this.m_client.info(BOTH_LICENSEFILE_AND_ACTIVATIONCODE_DEFINED);
        }
        if (!((level = startupRequest.getAnalyzerExecutionLevel()).equals("FULL") || level.equals("ADVANCED") || level.equals("BASIC") || level.equals("MINIMAL"))) {
            errorMsg.append(String.format("'%s' is invalid: %s (must be one of FULL, ADVANCED, BASIC, MINIMAL)\n", Params.ANALYZER_EXECUTION_LEVEL.getParameterName(), level));
        }
        if ((licenseServerUrl = startupRequest.getLicenseServerUrl()) != null) {
            if (!licenseServerUrl.startsWith("http://") && !licenseServerUrl.startsWith("https://")) {
                errorMsg.append(String.format("'%s' must start with 'http://' or 'https://'\n", Params.LICENSE_SERVER_URL.getParameterName()));
            } else {
                String host;
                String hostAndPort = licenseServerUrl.substring(licenseServerUrl.indexOf("://") + 3);
                if (hostAndPort.contains(":")) {
                    int colonPos = hostAndPort.lastIndexOf(58);
                    host = hostAndPort.substring(0, colonPos);
                    try {
                        Integer.valueOf(hostAndPort.substring(colonPos + 1));
                    }
                    catch (NumberFormatException e) {
                        errorMsg.append(String.format("Invalid port in URL '%s'\n", licenseServerUrl));
                    }
                } else {
                    host = hostAndPort;
                }
                if (host.contains(":") || host.contains("@") || host.contains("/")) {
                    errorMsg.append(String.format("Invalid host name '%s'\n", host));
                }
            }
        }
        try {
            startupRequest.initWaitForLicense();
        }
        catch (NumberFormatException ex) {
            errorMsg.append(String.format("'%s' is invalid: %s\n", Params.WAIT_FOR_LICENSE.getParameterName(), startupRequest.getWaitForLicenseString()));
        }
        if (errorMsg.length() > 0) {
            return new ServiceResponse(StatusCode.INPUT_VALIDATION_ERROR, errorMsg.toString());
        }
        return new ServiceResponse(StatusCode.OK, STARTUP_REQUEST_PARAMETERS_ARE_VALID);
    }
}

