/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.issues.csv;

import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.ISourceFileAccess;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.PluginMetricCharacteristic;
import com.hello2morrow.sonargraph.api.PluginMetricLevel;
import com.hello2morrow.sonargraph.api.PluginMetricRange;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.plugin.IAnalyzerPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import com.hello2morrow.sonargraph.plugin.issues.csv.RangeList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssuesCsvPlugin
extends SonargraphPlugin
implements IPluginAnalyzerContributor {
    public static final String ID = "com.hello2morrow.sonargraph.plugin.issues.csv";
    private static final Logger LOGGER = LoggerFactory.getLogger(IssuesCsvPlugin.class);
    private static final String TIMESTAMP_FILE_NAME = "timestamps.txt";
    private static final String ISSUE_ID_ERROR = "IssuesCsvError";
    private static final String ISSUE_ID_WARNING = "IssuesCsvWarning";
    private static final String ISSUE_ID_INFO = "IssuesCsvInfo";
    private static final String ISSUE_NAME_ERROR = "Issues csv error";
    private static final String ISSUE_NAME_WARNING = "Issues csv warning";
    private static final String ISSUE_NAME_INFO = "Issues csv info";
    private final SonargraphStringPluginAttribute m_files;
    private final SonargraphStringPluginAttribute m_errorRanges;
    private final SonargraphStringPluginAttribute m_warningRanges;
    private final SonargraphStringPluginAttribute m_infoRanges;
    private IPluginMetricId m_errorCounterMetricId;
    private IPluginMetricId m_warningCounterMetricId;
    private IPluginMetricId m_infoCounterMetricId;
    private Map<IModuleAccess, Integer> m_errorCounter;
    private Map<IModuleAccess, Integer> m_warningCounter;
    private Map<IModuleAccess, Integer> m_infoCounter;
    private Map<ISourceFileAccess, Integer> m_sourceErrorCounter;
    private Map<ISourceFileAccess, Integer> m_sourceWarningCounter;
    private Map<ISourceFileAccess, Integer> m_sourceInfoCounter;
    private IPluginIssueId m_errorIssue;
    private IPluginIssueId m_warningIssue;
    private IPluginIssueId m_infoIssue;
    private final Map<String, Long> m_timestamps = new HashMap<String, Long>();

    public IssuesCsvPlugin() {
        this.m_files = new SonargraphStringPluginAttribute("files", "Files", "Comma separated list of files containing the csv content (must be relative to Sonargraph system directory).)", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_files);
        this.m_errorRanges = new SonargraphStringPluginAttribute("errorRanges", "Error Ranges", "Comma separated list of integer based error ranges.", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_errorRanges);
        this.m_warningRanges = new SonargraphStringPluginAttribute("warningRanges", "Warning Ranges", "Comma separated list of integer based warning ranges.", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_warningRanges);
        this.m_infoRanges = new SonargraphStringPluginAttribute("infoRanges", "Info Ranges", "Comma separated list of integer based info ranges.", "Basic", "");
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_infoRanges);
        LOGGER.debug("[" + this.getId() + "] Instantiated: " + this.getHexReference());
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return ID;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Creates issues read from a file with csv content.";
    }

    public String getAvailableForLanguages() {
        return "All";
    }

    public String getPresentationName() {
        return "Sonargraph Issue Importer Plugin";
    }

    public IPluginAnalyzerContributor getAnalyzerContributor() {
        return this;
    }

    private void readTimestamps(File directory) {
        assert (directory != null && directory.isDirectory()) : "Parameter 'directory' of method 'writeTimestamps' must not be null";
        File input = new File(directory, TIMESTAMP_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(input));){
                String line;
                while ((line = reader.readLine()) != null) {
                    int lastSpacePos = line.lastIndexOf(32);
                    if (lastSpacePos < 0) {
                        throw new IOException("Invalid file format");
                    }
                    String path = line.substring(0, lastSpacePos);
                    try {
                        long timestamp = Long.valueOf(line.substring(lastSpacePos + 1));
                        this.m_timestamps.put(path, timestamp);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid file format");
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            LOGGER.error("Cannot read from " + input.getAbsolutePath(), (Throwable)e);
        }
    }

    private void writeTimestamps(File directory) {
        assert (directory != null && directory.isDirectory()) : "Parameter 'directory' of method 'writeTimestamps' must not be null";
        File output = new File(directory, TIMESTAMP_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(output));){
                for (Map.Entry<String, Long> entry : this.m_timestamps.entrySet()) {
                    writer.write(entry.getKey());
                    writer.write(" ");
                    writer.write(entry.getValue().toString());
                    writer.write(10);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot write to " + output.getAbsolutePath(), (Throwable)e);
        }
    }

    public boolean analyzerNeedsToRun(IPluginCoreAccess access) {
        assert (access != null) : "Parameter 'access' of method 'analyzerNeedsToRun' must not be null";
        if (this.m_timestamps.isEmpty()) {
            this.readTimestamps(access.getHiddenDataDirectory(this.getId()));
        }
        String files = this.m_files.getValue().trim();
        String[] filePaths = files.split(",");
        if (this.m_timestamps.size() != filePaths.length) {
            return true;
        }
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String relName = stringArray[n2];
            File file = new File(access.getBaseDirectory(), relName.trim());
            Long ts = this.m_timestamps.get(file.getAbsolutePath());
            if (ts == null || ts.longValue() != file.lastModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Set<String> getSupportedLanguages() {
        return null;
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        LOGGER.debug("[" + this.getId() + "] Initialize: " + this.getHexReference());
        this.m_errorIssue = contributor.createIssueId(ISSUE_ID_ERROR, ISSUE_NAME_ERROR, PluginIssueSeverity.ERROR, PluginIssueType.ELEMENT);
        this.m_warningIssue = contributor.createIssueId(ISSUE_ID_WARNING, ISSUE_NAME_WARNING, PluginIssueSeverity.WARNING, PluginIssueType.ELEMENT);
        this.m_infoIssue = contributor.createIssueId(ISSUE_ID_INFO, ISSUE_NAME_INFO, PluginIssueSeverity.INFO, PluginIssueType.ELEMENT);
        this.m_errorCounterMetricId = contributor.createMetricId("Imported Errors", "Number of imported issues with severity 'error'", false, PluginMetricRange.NULL_OR_POSITIVE, PluginMetricCharacteristic.HIGHER_WORSE, EnumSet.of(PluginMetricLevel.SYSTEM, PluginMetricLevel.MODULE, PluginMetricLevel.SOURCE));
        this.m_warningCounterMetricId = contributor.createMetricId("Imported Warnings", "Number of imported issues with severity 'warning'", false, PluginMetricRange.NULL_OR_POSITIVE, PluginMetricCharacteristic.HIGHER_WORSE, EnumSet.of(PluginMetricLevel.SYSTEM, PluginMetricLevel.MODULE, PluginMetricLevel.SOURCE));
        this.m_infoCounterMetricId = contributor.createMetricId("Imported Info Notes", "Number of imported issues with severity 'info'", false, PluginMetricRange.NULL_OR_POSITIVE, PluginMetricCharacteristic.HIGHER_WORSE, EnumSet.of(PluginMetricLevel.SYSTEM, PluginMetricLevel.MODULE, PluginMetricLevel.SOURCE));
        LOGGER.debug("[" + this.getId() + "] Initialize - done");
    }

    public void cleared(IPluginContext context) {
        LOGGER.debug("[" + this.getId() + "] Cleared");
    }

    public void analyze(IAnalyzerPluginContext context, ResultSet result) {
        assert (context != null) : "Parameter 'context' of method 'analyze' must not be null";
        assert (result != null) : "Parameter 'result' of method 'analyze' must not be null";
        LOGGER.info("[" + this.getId() + "] Analyze");
        long startTime = System.currentTimeMillis();
        IPluginCoreAccess coreAccess = context.getAccess(IPluginCoreAccess.class);
        assert (coreAccess != null) : "'coreAccess' of method 'analyze' must not be null";
        LOGGER.debug(this.m_files.getName() + ": " + this.m_files.getValue());
        LOGGER.debug(this.m_errorRanges.getName() + ": " + this.m_errorRanges.getValue());
        LOGGER.debug(this.m_warningRanges.getName() + ": " + this.m_warningRanges.getValue());
        LOGGER.debug(this.m_infoRanges.getName() + ": " + this.m_infoRanges.getValue());
        LOGGER.debug("Data directory: " + String.valueOf(coreAccess.getHiddenDataDirectory(this.getId())));
        this.m_errorCounter = new HashMap<IModuleAccess, Integer>();
        this.m_warningCounter = new HashMap<IModuleAccess, Integer>();
        this.m_infoCounter = new HashMap<IModuleAccess, Integer>();
        this.m_sourceErrorCounter = new HashMap<ISourceFileAccess, Integer>();
        this.m_sourceWarningCounter = new HashMap<ISourceFileAccess, Integer>();
        this.m_sourceInfoCounter = new HashMap<ISourceFileAccess, Integer>();
        for (IModuleAccess module : coreAccess.getModules()) {
            this.m_errorCounter.put(module, 0);
            this.m_warningCounter.put(module, 0);
            this.m_infoCounter.put(module, 0);
        }
        HashMap<String, ISourceFileAccess> sourceMap = new HashMap<String, ISourceFileAccess>();
        String files = this.m_files.getValue().trim();
        String[] filePaths = files.split(",");
        if (filePaths.length == 0) {
            throw new IllegalArgumentException("At least 1 file must be specified");
        }
        RangeList errorRanges = RangeList.buildRangeListFromString(this.m_errorRanges.getValue());
        RangeList warningRanges = RangeList.buildRangeListFromString(this.m_warningRanges.getValue());
        RangeList infoRanges = RangeList.buildRangeListFromString(this.m_infoRanges.getValue());
        if (errorRanges.overlaps(warningRanges)) {
            throw new IllegalArgumentException(String.format("%s overlaps with %s: (%s)(%s)", this.m_errorRanges.getName(), this.m_warningRanges.getName(), errorRanges.toString(), warningRanges.toString()));
        }
        if (errorRanges.overlaps(infoRanges)) {
            throw new IllegalArgumentException(String.format("%s overlaps with %s: (%s)(%s)", this.m_errorRanges.getName(), this.m_infoRanges.getName(), errorRanges.toString(), infoRanges.toString()));
        }
        if (warningRanges.overlaps(infoRanges)) {
            throw new IllegalArgumentException(String.format("%s overlaps with %s: (%s)(%s)", this.m_warningRanges.getName(), this.m_infoRanges.getName(), warningRanges.toString(), infoRanges.toString()));
        }
        coreAccess.getComponents(false).stream().forEach(c -> c.getSources().forEach(src -> {
            ISourceFileAccess iSourceFileAccess = sourceMap.put(src.getFile().getNormalizedAbsolutePath(), (ISourceFileAccess)src);
        }));
        sourceMap.values().forEach(src -> {
            this.m_sourceErrorCounter.put((ISourceFileAccess)src, 0);
            this.m_sourceWarningCounter.put((ISourceFileAccess)src, 0);
            this.m_sourceInfoCounter.put((ISourceFileAccess)src, 0);
        });
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            String name = filePath.trim();
            if (name.isEmpty()) {
                throw new IllegalArgumentException("File name cannot be empty");
            }
            File file = new File(name);
            if (file.isAbsolute()) {
                throw new IllegalArgumentException("File names must be relative to the Sonargraph system base directory");
            }
            file = new File(coreAccess.getBaseDirectory(), name);
            if (!file.canRead()) {
                throw new IllegalArgumentException(String.format("Cannot read file '%s'", file.getPath()));
            }
            this.processFile(result, coreAccess, sourceMap, file, errorRanges, warningRanges, infoRanges);
            ++n2;
        }
        for (ISourceFileAccess src2 : sourceMap.values()) {
            result.addMetricValue((INamedElementAccess)src2, this.m_errorCounterMetricId, this.m_sourceErrorCounter.get(src2).intValue());
            result.addMetricValue((INamedElementAccess)src2, this.m_warningCounterMetricId, this.m_sourceWarningCounter.get(src2).intValue());
            result.addMetricValue((INamedElementAccess)src2, this.m_infoCounterMetricId, this.m_sourceInfoCounter.get(src2).intValue());
        }
        for (IModuleAccess module : coreAccess.getModules()) {
            result.addMetricValue((INamedElementAccess)module, this.m_errorCounterMetricId, this.m_errorCounter.get(module).intValue());
            result.addMetricValue((INamedElementAccess)module, this.m_warningCounterMetricId, this.m_warningCounter.get(module).intValue());
            result.addMetricValue((INamedElementAccess)module, this.m_infoCounterMetricId, this.m_infoCounter.get(module).intValue());
        }
        int totalErrors = this.m_errorCounter.values().stream().collect(Collectors.summingInt(Integer::intValue));
        int totalWarnings = this.m_warningCounter.values().stream().collect(Collectors.summingInt(Integer::intValue));
        int totalInfos = this.m_infoCounter.values().stream().collect(Collectors.summingInt(Integer::intValue));
        result.addMetricValue((INamedElementAccess)coreAccess, this.m_errorCounterMetricId, totalErrors);
        result.addMetricValue((INamedElementAccess)coreAccess, this.m_warningCounterMetricId, totalWarnings);
        result.addMetricValue((INamedElementAccess)coreAccess, this.m_infoCounterMetricId, totalInfos);
        this.writeTimestamps(coreAccess.getHiddenDataDirectory(this.getId()));
        long millis = System.currentTimeMillis() - startTime;
        LOGGER.info("[" + this.getId() + "] Analyze - done [" + (context.hasBeenCanceled() ? "canceled" : "finished") + " after " + millis / 1000L + " seconds]");
        this.m_errorCounter = null;
        this.m_warningCounter = null;
        this.m_infoCounter = null;
        this.m_sourceErrorCounter = null;
        this.m_sourceWarningCounter = null;
        this.m_sourceInfoCounter = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFile(ResultSet result, IPluginCoreAccess coreAccess, Map<String, ISourceFileAccess> sourceMap, File file, RangeList errorRanges, RangeList warningRanges, RangeList infoRanges) {
        this.m_timestamps.put(file.getAbsolutePath(), file.lastModified());
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        return;
                    }
                    String[] values = line.split(";");
                    if (values.length != 5) continue;
                    try {
                        int lineNo = Integer.valueOf(values[0].trim());
                        int colNo = Integer.valueOf(values[1].trim());
                        File affectedFile = new File(values[2].trim());
                        int errorCode = Integer.valueOf(values[3].trim());
                        String msg = values[4].trim();
                        PluginIssueSeverity severity = null;
                        if (errorRanges.isInside(errorCode)) {
                            severity = PluginIssueSeverity.ERROR;
                        } else if (warningRanges.isInside(errorCode)) {
                            severity = PluginIssueSeverity.WARNING;
                        } else if (infoRanges.isInside(errorCode)) {
                            severity = PluginIssueSeverity.INFO;
                        }
                        if (!file.exists() || !file.isFile()) {
                            LOGGER.warn("File " + file.getPath() + " does not exist or is not a file");
                            continue;
                        }
                        if (severity == null) continue;
                        msg = String.format("[%d] %s", errorCode, msg);
                        this.createIssue(result, coreAccess, sourceMap, affectedFile, lineNo, colNo, severity, msg);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Cannot process input line (NumberFormatException): " + line);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException whil reading " + file.getPath(), (Throwable)e);
        }
    }

    private void createIssue(ResultSet result, IPluginCoreAccess coreAccess, Map<String, ISourceFileAccess> sourceMap, File affectedFile, int lineNo, int colNo, PluginIssueSeverity severity, String msg) {
        assert (coreAccess != null) : "Parameter 'coreAccess' of method 'createIssue' must not be null";
        assert (affectedFile != null) : "Parameter 'affectedFile' of method 'createIssue' must not be null";
        assert (severity != null) : "Parameter 'severity' of method 'createIssue' must not be null";
        assert (msg != null && msg.length() > 0) : "Parameter 'msg' of method 'createIssue' must not be empty";
        ISourceFileAccess src = sourceMap.get(affectedFile.getPath());
        if (src != null) {
            IPluginIssueId issueId = null;
            IModuleAccess module = (IModuleAccess)src.getParent(IModuleAccess.class);
            assert (module != null);
            switch (severity) {
                case ERROR: {
                    issueId = this.m_errorIssue;
                    this.m_errorCounter.put(module, 1 + this.m_errorCounter.get(module));
                    this.m_sourceErrorCounter.put(src, 1 + this.m_sourceErrorCounter.get(src));
                    break;
                }
                case WARNING: {
                    issueId = this.m_warningIssue;
                    this.m_warningCounter.put(module, 1 + this.m_warningCounter.get(module));
                    this.m_sourceWarningCounter.put(src, 1 + this.m_sourceWarningCounter.get(src));
                    break;
                }
                case INFO: {
                    issueId = this.m_infoIssue;
                    this.m_infoCounter.put(module, 1 + this.m_infoCounter.get(module));
                    this.m_sourceInfoCounter.put(src, 1 + this.m_sourceInfoCounter.get(src));
                }
            }
            if (colNo > 1) {
                msg = String.format("%s (column %d)", msg, colNo);
            }
            result.addElementIssue((INamedElementAccess)src, issueId, msg, lineNo, lineNo);
            assert (module != null);
        }
    }
}

