/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.service.impl;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReportUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUploader.class);
    private static final String FAILED_UPLOADS_DIR_NAME = "failedUploads";
    private static final String SNAPSHOT_EXTENSION = CoreFileType.SNAPSHOT.getDefaultExtension();
    private static final String USE_SONARGRAPH_ID_PREFIX = "U__";
    private static final String DONT_USE_SONARGRAPH_ID_PREFIX = "D__";
    private static final String BRANCH_PREFIX = "B__";
    private static final String BRANCH_DEFAULT = "default";
    private static final String VERSION_PREFIX = "V__";
    private static final String COMMIT_PREFIX = "C__";
    private static final String SUFFIX = "___";
    private static final Pattern BRANCH_EXTRACTOR = Pattern.compile(String.format(".+%s*(.+)%s.+", "B__", "___"));
    private static final Pattern VERSION_EXTRACTOR = Pattern.compile(String.format(".+%s*(.+)%s.+", "V__", "___"));
    private static final Pattern COMMIT_EXTRACTOR = Pattern.compile(String.format(".+%s*(.+)%s.+", "C__", "___"));
    private final TFile m_failedUploadsDirectory;

    ReportUploader(String failedUploadDirectory) {
        this.m_failedUploadsDirectory = failedUploadDirectory == null ? ReportUploader.getDefaultFailedUploadDirectory() : new TFile(failedUploadDirectory);
        if (!this.m_failedUploadsDirectory.isDirectory()) {
            this.m_failedUploadsDirectory.mkdirs();
        }
    }

    private static TFile getDefaultFailedUploadDirectory() {
        TFile root = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        return new TFile((File)root, FAILED_UPLOADS_DIR_NAME);
    }

    private boolean uploadSonargraphXmlReportAndSnapshot(String hostUrl, File reportFile, File snapshotFile, boolean useSonargraphId, String branch, String version, String commitId, String clientKey) {
        assert (hostUrl != null && hostUrl.length() > 0) : "Parameter 'hostUrl' of method 'uploadSonargraphXmlReport' must not be empty";
        assert (reportFile != null) : "Parameter 'reportFile' of method 'uploadSonargraphXmlReport' must not be null";
        assert (clientKey != null && clientKey.length() > 0) : "Parameter 'clientKey' of method 'uploadSonargraphXmlReportAndSnapshot' must not be empty";
        boolean success = false;
        String reportName = ReportUploader.cutPrefix(reportFile.getName());
        String serverReply = null;
        reportFile = new File(reportFile.getAbsolutePath());
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            URL host = new URL(hostUrl);
            URL url = new URL(host, "/upload/sonargraphXmlReport");
            HttpPost post = new HttpPost(url.toURI());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody("report", reportFile, ContentType.APPLICATION_XML, reportName);
            if (snapshotFile != null) {
                builder.addBinaryBody("snapshot", snapshotFile, ContentType.DEFAULT_BINARY, snapshotFile.getName());
            }
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            post.setHeader("X-SonargraphReportName", reportName);
            post.setHeader("X-UseSonargraphId", Boolean.toString(useSonargraphId));
            post.setHeader("X-SonargraphBranch", branch == null ? BRANCH_DEFAULT : branch);
            post.setHeader("X-ClientKey", clientKey);
            if (version != null && version.length() > 0) {
                post.setHeader("X-SonargraphVersion", version);
            }
            if (commitId != null && commitId.length() > 0) {
                post.setHeader("X-SonargraphCommitId", commitId);
            }
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                success = response.getStatusLine().getStatusCode() == 200;
                response.getEntity().writeTo((OutputStream)bos);
                serverReply = bos.toString();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.error(String.format("Invalid URL for uploading '%s' to '%s': %s", reportFile.getPath(), hostUrl, e.getMessage()), (Throwable)e);
        }
        catch (ClientProtocolException e) {
            LOGGER.error(String.format("Failed to create HTTP client for uploading '%s' to '%s': %s", reportFile.getPath(), hostUrl, e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(String.format("IOError while uploading '%s' to '%s': %s", reportFile.getPath(), hostUrl, e.getMessage()), (Throwable)e);
        }
        if (!success) {
            if (reportName.equals(reportFile.getName())) {
                Object prefix;
                Object object = prefix = useSonargraphId ? USE_SONARGRAPH_ID_PREFIX : DONT_USE_SONARGRAPH_ID_PREFIX;
                if (branch != null && branch.length() > 0) {
                    prefix = (String)prefix + BRANCH_PREFIX + branch + SUFFIX;
                }
                if (version != null && version.length() > 0) {
                    prefix = (String)prefix + VERSION_PREFIX + version + SUFFIX;
                }
                if (commitId != null && commitId.length() > 0) {
                    prefix = (String)prefix + COMMIT_PREFIX + commitId + SUFFIX;
                }
                String targetName = (String)prefix + reportFile.getName();
                File target = new File((File)this.m_failedUploadsDirectory, targetName);
                try {
                    LOGGER.error(String.format("Failed to upload '%s' to '%s'", reportName, hostUrl));
                    LOGGER.error("Server reply was: " + serverReply);
                    Files.copy(reportFile.toPath(), target.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    LOGGER.error(String.format("Failed to copy report '%s' for later retry", reportName), (Throwable)e);
                }
                if (snapshotFile != null) {
                    String snapshotTargetName = FileUtility.removeExtension((String)targetName) + SNAPSHOT_EXTENSION;
                    File snapshotTarget = new File((File)this.m_failedUploadsDirectory, snapshotTargetName);
                    try {
                        LOGGER.error(String.format("Failed to upload '%s' to '%s'", snapshotFile.getName(), hostUrl));
                        LOGGER.error("Server reply was: " + serverReply);
                        Files.copy(new File(snapshotFile.getAbsolutePath()).toPath(), snapshotTarget.toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        LOGGER.error(String.format("Failed to copy report '%s' for later retry", snapshotFile.getName()), (Throwable)e);
                    }
                }
            } else {
                LOGGER.error(String.format("Failed retry of upload of '%s' to '%s'", reportName, hostUrl));
                LOGGER.error("Server reply was: " + serverReply);
            }
        } else {
            LOGGER.info(String.format("Uploaded '%s' successfully to '%s'", reportName, hostUrl));
        }
        return success;
    }

    private static String cutRemainingPrefixes(String name) {
        int pos = name.lastIndexOf(SUFFIX);
        if (pos > 0) {
            return name.substring(pos + SUFFIX.length());
        }
        return name;
    }

    private static String cutPrefix(String name) {
        if (name.startsWith(DONT_USE_SONARGRAPH_ID_PREFIX)) {
            return ReportUploader.cutRemainingPrefixes(name.substring(DONT_USE_SONARGRAPH_ID_PREFIX.length()));
        }
        if (name.startsWith(USE_SONARGRAPH_ID_PREFIX)) {
            return ReportUploader.cutRemainingPrefixes(name.substring(USE_SONARGRAPH_ID_PREFIX.length()));
        }
        return name;
    }

    int uploadFailedReports(String hostUrl, String clientKey, Set<String> filesToIgnore) {
        assert (hostUrl != null && hostUrl.length() > 0) : "Parameter 'hostUrl' of method 'uploadFailedReports' must not be empty";
        assert (clientKey != null && clientKey.length() > 0) : "Parameter 'clientKey' of method 'uploadFailedReports' must not be empty";
        int count = 0;
        int successfullyUploadedFiles = 0;
        List<File> files = this.determineReportFiles();
        if (files.isEmpty()) {
            return 0;
        }
        for (File reportFile : files) {
            boolean done;
            String absolutePath = new TFile(reportFile).getNormalizedAbsolutePath();
            if (filesToIgnore.contains(absolutePath)) continue;
            String name = reportFile.getName();
            String branch = ReportUploader.extractBranchName(name);
            String version = ReportUploader.extractVersion(name);
            String commitId = ReportUploader.extractCommitId(name);
            File snapshotFile = new File((File)this.m_failedUploadsDirectory, FileUtility.removeExtension((String)name) + SNAPSHOT_EXTENSION);
            if (!snapshotFile.exists()) {
                snapshotFile = null;
            }
            if (name.startsWith(DONT_USE_SONARGRAPH_ID_PREFIX)) {
                done = this.uploadSonargraphXmlReportAndSnapshot(hostUrl, reportFile, snapshotFile, false, branch, version, commitId, clientKey);
                ++count;
                if (!done) continue;
                ++successfullyUploadedFiles;
                reportFile.delete();
                continue;
            }
            if (!name.startsWith(USE_SONARGRAPH_ID_PREFIX)) continue;
            done = this.uploadSonargraphXmlReportAndSnapshot(hostUrl, reportFile, snapshotFile, true, branch, version, commitId, clientKey);
            ++count;
            if (!done) continue;
            ++successfullyUploadedFiles;
            reportFile.delete();
        }
        LOGGER.info(String.format("Uploaded %d of %d reports successfully", successfullyUploadedFiles, count));
        return successfullyUploadedFiles;
    }

    private static String extractBranchName(String name) {
        Matcher matcher = BRANCH_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String extractVersion(String name) {
        Matcher matcher = VERSION_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String extractCommitId(String name) {
        Matcher matcher = COMMIT_EXTRACTOR.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private List<File> determineReportFiles() {
        TFile[] reportFiles = this.m_failedUploadsDirectory.listFiles((d, n) -> n.endsWith(".xml"));
        if (reportFiles == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(reportFiles);
    }
}

