/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.application;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.StartupRequest;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.application.SonargraphBuildActivator;
import com.hello2morrow.sonargraph.build.application.SonargraphBuildFactory;
import com.hello2morrow.sonargraph.build.ui.BuildUserInterfaceAdapter;
import com.hello2morrow.sonargraph.client.eclipse.application.EclipseApplication;
import com.hello2morrow.sonargraph.client.eclipse.application.EclipseLogListener;
import com.hello2morrow.sonargraph.client.eclipse.application.IExceptionHandler;
import com.hello2morrow.sonargraph.core.application.ILicenseHandlerProvider;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandlerProduction;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.logback.LogbackConfigurator;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.license.model.LicenseMessageCause;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphBuildApplication
extends EclipseApplication
implements IApplication,
IExceptionHandler,
ILicenseHandlerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphBuildApplication.class);
    private static final String SEPARATOR = "+++++++++++++++++++++++++++++++++++++++++++++++++++++";
    private String m_activationCode;
    private String m_licenseFile;
    private ServiceResponse m_licenseError;
    private StartupRequest m_startUpRequest;
    private ISoftwareSystemProvider m_provider;
    private EclipseLogListener m_logListener;
    private boolean m_stopped;

    public SonargraphBuildApplication() {
        super(EclipseApplication.BundleHandling.DYNAMIC, SonargraphProduct.SONARGRAPH_BUILD);
    }

    private ServiceResponse createAndLogResponse(StatusCode status, String msg) {
        if (status == StatusCode.OK || status == StatusCode.WARNINGS_EXIST) {
            LOGGER.info("Build status " + status.name() + ": " + msg);
        } else {
            LOGGER.error("Build status " + status.name() + ": " + msg);
        }
        return new ServiceResponse(status, msg);
    }

    public Object start(IApplicationContext context) throws Exception {
        assert (context != null) : "Parameter 'context' of method 'start' must not be null";
        Object argument = context.getArguments().get("application.args");
        assert (argument instanceof StartupRequest) : "Unexpected class: " + argument.getClass().getName();
        this.m_startUpRequest = (StartupRequest)argument;
        this.m_activationCode = this.m_startUpRequest.getActivationCode();
        this.m_licenseFile = this.m_startUpRequest.getLicenseFile();
        String logLevel = this.m_startUpRequest.getLogLevel();
        if (logLevel != null && logLevel.trim().length() > 0) {
            LogbackConfigurator.setRootLogLevel((String)logLevel);
        }
        this.m_logListener = new EclipseLogListener((IExceptionHandler)this);
        Platform.addLogListener((ILogListener)this.m_logListener);
        BuildUserInterfaceAdapter.createInstance();
        SonargraphBuildActivator activator = SonargraphBuildActivator.getInstance();
        if (activator == null) {
            LOGGER.error("Error initializing application: Activator is null");
            return null;
        }
        Bundle activatorBundle = activator.getBundle();
        if (activatorBundle == null) {
            LOGGER.error("Error initializing application: Activator bundle is null");
            return null;
        }
        BundleContext activatorBundleContext = activatorBundle.getBundleContext();
        if (activatorBundleContext == null) {
            LOGGER.error("Error initializing application: BundleContext of activator is null");
            return null;
        }
        AnalyzerExecutionLevel level = AnalyzerExecutionLevel.FULL;
        try {
            level = AnalyzerExecutionLevel.valueOf((String)this.m_startUpRequest.getAnalyzerExecutionLevel());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.m_provider = super.initialize(activator.getBundle().getBundleContext(), this.getOutputStreamProvider(), this.getSpecifiedLanguages(), level, (ILicenseHandlerProvider)this, null);
        if (this.m_licenseError != null) {
            return this.m_licenseError;
        }
        if (this.m_provider == null) {
            return this.createAndLogResponse(StatusCode.FAILED, "Initialization of '" + SonargraphProduct.SONARGRAPH_BUILD.getPresentationName() + "' failed. Please check the log for details.");
        }
        activatorBundleContext.registerService(ISonargraphBuild.class.getName(), (Object)SonargraphBuildFactory.create(this.m_provider, this.m_startUpRequest.getProgressInfo()), null);
        this.startupComplete();
        this.m_stopped = false;
        while (!this.m_stopped) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return null;
    }

    public void startupComplete() {
        super.startupComplete();
    }

    private ScriptOutputStreamProvider getOutputStreamProvider() {
        return new ScriptOutputStreamProvider();
    }

    public void stop() {
        LOGGER.debug("Stopping Sonargraph Build...");
        this.shutdownStarted(this.m_provider);
        this.m_stopped = true;
    }

    public void shutdownStarted(ISoftwareSystemProvider provider) {
        super.shutdownStarted(provider);
        Platform.removeLogListener((ILogListener)this.m_logListener);
        BuildUserInterfaceAdapter.getInstance().delete();
        TrueZipFacade.clear();
    }

    public SonargraphLicenseHandler initializeLicenseHandler(SonargraphProduct product, Set<Language> availableLanguages, SonargraphLicenseHandler.ILicenseLostEventHandler handler) {
        Object licenseSource;
        OperationResult result;
        SonargraphLicenseHandlerProduction licenseHandler;
        block19: {
            Object message;
            String licenseServerUrl;
            assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'initLicenseHandler' must not be null";
            licenseHandler = new SonargraphLicenseHandlerProduction(product, availableLanguages, handler);
            String host = this.m_startUpRequest.getProxyHost();
            if (host != null && host.trim().length() > 0) {
                ProxySettings proxySettings = ProxySettings.create((String)host, (String)this.m_startUpRequest.getProxyPort(), (String)this.m_startUpRequest.getProxyUsername(), (String)this.m_startUpRequest.getProxyPassword());
                if (proxySettings.isValid()) {
                    LOGGER.debug("Using proxy settings: " + proxySettings.toString());
                    licenseHandler.setProxySettings(proxySettings);
                } else {
                    this.m_licenseError = this.createAndLogResponse(StatusCode.FAILED, "Invalid proxy settings: " + proxySettings.toString());
                    return licenseHandler;
                }
            }
            if ((licenseServerUrl = this.m_startUpRequest.getLicenseServerUrl()) != null && licenseServerUrl.length() > 0) {
                LOGGER.info("Using license server URL: " + licenseServerUrl);
                LicenseServerHost licenseServer = new LicenseServerHost(licenseServerUrl, true);
                licenseHandler.setLicenseServer(licenseServer);
            }
            int ticketRequestCounter = 0;
            StartupRequest.WaitForLicenseTicket waitForLicense = this.m_startUpRequest.getWaitForLicense();
            result = null;
            licenseSource = "";
            block2: while (true) {
                if (ticketRequestCounter > 0) {
                    message = ticketRequestCounter + 1 + ". try to get a license ticket...";
                    System.out.print((String)message);
                    LOGGER.info((String)message);
                }
                if (this.m_licenseFile != null && !this.m_licenseFile.isEmpty()) {
                    licenseSource = "(using license file '" + this.m_licenseFile + "') ";
                    result = licenseHandler.initializeFromLicenseFile(this.m_licenseFile);
                } else if (this.m_activationCode != null && !this.m_activationCode.isEmpty()) {
                    licenseSource = "(using activation code '" + this.m_activationCode + "') ";
                    result = licenseHandler.initializeFromActivationCode(this.m_activationCode);
                } else {
                    licenseSource = "(using default license)";
                    licenseHandler.initializeFromDefaultLicense();
                }
                ++ticketRequestCounter;
                if (result == null || result.isSuccess()) {
                    if (ticketRequestCounter > 0) {
                        message = "Successfully obtained license ticket";
                        System.out.println("Successfully obtained license ticket");
                        LOGGER.info("Successfully obtained license ticket");
                    }
                    return licenseHandler;
                }
                if (!result.getErrorCauses().contains(LicenseMessageCause.NO_LICENSE_TICKETS_AVAILABLE) || waitForLicense == StartupRequest.WaitForLicenseTicket.NEVER) break block19;
                if (ticketRequestCounter > 1) {
                    message = "Failed to obtainlicense ticket";
                    System.out.println("Failed to obtainlicense ticket");
                    LOGGER.info("Failed to obtainlicense ticket");
                }
                if (waitForLicense == StartupRequest.WaitForLicenseTicket.INFINITE || ticketRequestCounter <= waitForLicense.getCount()) {
                    message = "Waiting for license ticket to become available. Pausing for 60 seconds before trying again...";
                    System.out.println("Waiting for license ticket to become available. Pausing for 60 seconds before trying again...");
                    LOGGER.info("Waiting for license ticket to become available. Pausing for 60 seconds before trying again...", (Object)60);
                    int i = 0;
                    while (true) {
                        if (i >= 60) continue block2;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            break block19;
                        }
                        ++i;
                    }
                }
                if (ticketRequestCounter > waitForLicense.getCount()) break;
            }
            message = "Aborting after waiting for " + waitForLicense.getCount() + " minutes";
            System.out.println((String)message);
            LOGGER.warn((String)message);
        }
        assert (result != null) : "result must not be null";
        this.m_licenseError = this.createAndLogResponse(StatusCode.FAILED, "No valid license detected " + (String)licenseSource + "- " + String.valueOf(result));
        return licenseHandler;
    }

    public void processException(IStatus status, String plugin, Throwable throwable) {
        if (this.m_provider != null && this.m_provider.hasSoftwareSystem()) {
            SoftwareSystem softwareSystem = this.m_provider.getSoftwareSystem();
            Collection languages = softwareSystem.getUsedLanguages().stream().map(language -> language.getPresentationName()).collect(Collectors.toList());
            LOGGER.error(StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR + "Error occurred while working with system [" + softwareSystem.getName() + "] using languages [" + StringUtility.concat((Collection)languages, (String)StringUtility.LINE_SEPARATOR) + "]" + StringUtility.LINE_SEPARATOR + SEPARATOR);
        } else {
            LOGGER.error(StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR + "Error occurred while working with no system opened." + StringUtility.LINE_SEPARATOR + SEPARATOR + StringUtility.LINE_SEPARATOR);
        }
    }

    protected Set<String> getSpecifiedLanguages() {
        if (this.m_startUpRequest.getLanguages() == null || this.m_startUpRequest.getLanguages().trim().length() == 0) {
            return super.getSpecifiedLanguages();
        }
        HashSet<String> languages = new HashSet<String>();
        String[] stringArray = this.m_startUpRequest.getLanguages().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            languages.add(next.trim().toLowerCase());
            ++n2;
        }
        return Collections.unmodifiableSet(languages);
    }
}

