/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CollectionUtility {
    private CollectionUtility() {
    }

    public static boolean collectionsContainSameElements(Collection<?> c1, Collection<?> c2) {
        assert (c1 != null) : "Parameter 'c1' of method 'collectionsContainSameElements' must not be null";
        assert (c2 != null) : "Parameter 'c2' of method 'collectionsContainSameElements' must not be null";
        if (c1.size() != c2.size()) {
            return false;
        }
        if (!c1.containsAll(c2)) {
            return false;
        }
        return c2.containsAll(c1);
    }

    public static <T> List<T> select(List<T> list, Predicate<T> selectCondition) {
        assert (list != null) : "Parameter 'collection' of method 'filter' must not be null";
        assert (selectCondition != null) : "Parameter 'selectCondition' of method 'select' must not be null";
        ArrayList<T> selected = new ArrayList<T>();
        for (T t : list) {
            if (!selectCondition.test(t)) continue;
            selected.add(t);
        }
        return selected;
    }

    public static <T, U> List<U> map(List<T> list, boolean includeNull, Function<T, U> function) {
        assert (list != null) : "Parameter 'list' of method 'map' must not be null";
        assert (function != null) : "Parameter 'function' of method 'map' must not be null";
        ArrayList<U> mappedElements = new ArrayList<U>();
        for (T t : list) {
            U mapped = function.apply(t);
            if (mapped == null && !includeNull) continue;
            mappedElements.add(mapped);
        }
        return mappedElements;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        assert (elements != null) : "Parameter 'elements' of method 'asSet' must not be null";
        HashSet<T> set = new HashSet<T>(elements.length);
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            set.add(t);
            ++n2;
        }
        return set;
    }
}

