/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.event;

import java.util.LinkedHashSet;
import java.util.Set;

public abstract class Event {
    private Set<String> m_debugInfo;

    public boolean forceDispatch() {
        return false;
    }

    public final void addDebugInfo(String debugInfo) {
        assert (debugInfo != null && debugInfo.length() > 0) : "Parameter 'debugInfo' of method 'addDebugInfo' must not be empty";
        if (this.m_debugInfo == null) {
            this.m_debugInfo = new LinkedHashSet<String>();
        }
        this.m_debugInfo.add(debugInfo);
    }

    public final void addDebugInfo(Set<String> debugInfo) {
        assert (debugInfo != null && !debugInfo.isEmpty()) : "Parameter 'debugInfo' of method 'addDebugInfo' must not be empty";
        if (this.m_debugInfo == null) {
            this.m_debugInfo = new LinkedHashSet<String>();
        }
        this.m_debugInfo.addAll(debugInfo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Event class: ");
        builder.append(this.getClass().getName());
        if (this.forceDispatch()) {
            builder.append(" [force dispatch]");
        }
        if (this.m_debugInfo == null || this.m_debugInfo.isEmpty()) {
            builder.append(" - no debug info available.");
        } else {
            builder.append(" - debug info:");
            for (String next : this.m_debugInfo) {
                builder.append("\n").append(next);
            }
        }
        return builder.toString();
    }
}

