/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IKeywordProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.ICloneable;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpLanguage;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpProjectFileDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpSourceFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpNamespaceFragment;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModule;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

final class CSharpRefactoringAdapter
extends LanguageProviderRefactoringAdapter {
    private final IKeywordProvider m_keywordProvider;

    CSharpRefactoringAdapter(IKeywordProvider keywordProvider) {
        assert (keywordProvider != null) : "Parameter 'keywordProvider' of method 'CSharpRefactoringAdapter' must not be null";
        this.m_keywordProvider = keywordProvider;
    }

    protected Language getLanguage() {
        return CSharpLanguage.INSTANCE;
    }

    protected Class<? extends Module> getModuleClass() {
        return CSharpModule.class;
    }

    protected Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> getRefactorables() {
        LinkedHashMap<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorables = new LinkedHashMap<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>>(3);
        refactorables.put(CSharpDirectoryFragment.class, new LinkedHashSet<Class>(Arrays.asList(CSharpDirectoryFragment.class, CSharpRootDirectoryPath.class, CSharpProjectFileDirectoryPath.class)));
        refactorables.put(CSharpSourceFile.class, new LinkedHashSet<Class>(Arrays.asList(CSharpDirectoryFragment.class, CSharpRootDirectoryPath.class, CSharpProjectFileDirectoryPath.class)));
        refactorables.put(CSharpType.class, Collections.singleton(CSharpNamespaceFragment.class));
        return refactorables;
    }

    protected NamespaceFragment createNamespaceFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        assert (msp != null) : "Parameter 'msp' of method 'createNamespaceFragment' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createNamespaceFragment' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createNamespaceFragment' must not be empty";
        return new CSharpNamespaceFragment(msp, parent, shortName);
    }

    protected DirectoryFragment createDirectoryFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        assert (msp != null) : "Parameter 'msp' of method 'createDirectoryFragment' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createDirectoryFragment' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createDirectoryFragment' must not be empty";
        return new CSharpDirectoryFragment(msp, parent, shortName);
    }

    private boolean isValidInIdentifier(char ch, boolean firstChar) {
        switch (Character.getType(ch)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 23: {
                return !firstChar;
            }
        }
        return false;
    }

    private boolean isValidIdentifier(String identifier, Set<String> keywords) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidIdentifier' must not be empty";
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidIdentifier' must not be null";
        if (keywords.contains(identifier)) {
            return false;
        }
        int i = 0;
        while (i < identifier.length()) {
            if (!this.isValidInIdentifier(identifier.charAt(i), i == 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidNamespaceName(String identifier, Set<String> keywords) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidNamespaceName' must not be empty";
        if (identifier.startsWith(".") || identifier.endsWith(".")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(identifier, ".");
        while (tokenizer.hasMoreTokens()) {
            String nextPartName = tokenizer.nextToken();
            if (this.isValidIdentifier(nextPartName, keywords)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDirectoryName(String identifier) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidDirectoryName' must not be empty";
        StringTokenizer tokenizer = new StringTokenizer(identifier, "/");
        while (tokenizer.hasMoreTokens()) {
            if (FileUtility.isValidName((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    protected ITextValidator getRenameRefactoringValidator(final NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getRenameRefactoringValidator' must not be null";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (newInputString == null || newInputString.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (result.inputModified()) {
                    if (namedElement instanceof CSharpType) {
                        if (!CSharpRefactoringAdapter.this.isValidIdentifier(newInputString, CSharpRefactoringAdapter.this.m_keywordProvider.getKeywords((IFileType)CSharpFileType.SOURCE_FILE))) {
                            result.addError("Type name '" + newInputString + "' not valid");
                            return result;
                        }
                    } else if (namedElement instanceof CSharpSourceFile) {
                        if (!FileUtility.isValidName((String)newInputString)) {
                            result.addError("Compilation unit name '" + newInputString + "' not valid");
                            return result;
                        }
                    } else if (namedElement instanceof CSharpDirectoryFragment && !FileUtility.isValidName((String)newInputString)) {
                        result.addError("Directory fragment name '" + newInputString + "' not valid");
                        return result;
                    }
                }
                return result;
            }
        };
    }

    protected ITextValidator getMoveToParentNameRefactoringValidator(List<NamedElement> namedElements, final MoveRenameRefactoringElementType elementType) {
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'getMoveToParentNameRefactoringValidator' must not be empty";
        assert (elementType != null) : "Parameter 'elementType' of method 'getMoveToParentNameRefactoringValidator' must not be null";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (newInputString == null) {
                    result.addError("Must not be 'null'");
                } else if (!newInputString.isEmpty()) {
                    switch (elementType) {
                        case COMPONENT: 
                        case DIRECTORY: {
                            if (CSharpRefactoringAdapter.this.isValidDirectoryName(newInputString)) break;
                            result.addError("Directory name '" + newInputString + "' not valid");
                            break;
                        }
                        case ELEMENT: 
                        case NAMESPACE: {
                            if (CSharpRefactoringAdapter.this.isValidNamespaceName(newInputString, CSharpRefactoringAdapter.this.m_keywordProvider.getKeywords((IFileType)CSharpFileType.SOURCE_FILE))) break;
                            result.addError("Namespace name '" + newInputString + "' not valid");
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)("Unhandled: " + String.valueOf(elementType)));
                            }
                            break;
                        }
                    }
                }
                return result;
            }
        };
    }

    private CSharpDirectoryFragment renameDirectory(CSharpDirectoryFragment directoryFragment, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (directoryFragment != null) : "Parameter 'directoryFragment' of method 'renameDirectory' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameDirectory' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameDirectory' must not be null";
        CSharpDirectoryFragment modifiableVersionOfDirectoryFragmentToBeRenamed = (CSharpDirectoryFragment)refactoringStateHandler.getModifiableVersionOf((ICloneable)directoryFragment);
        modifiableVersionOfDirectoryFragmentToBeRenamed.setShortName(newName);
        return modifiableVersionOfDirectoryFragmentToBeRenamed;
    }

    private CSharpType renameType(CSharpType type, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (type != null) : "Parameter 'type' of method 'renameType' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameType' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameType' must not be null";
        CSharpType toBeRenamed = (CSharpType)refactoringStateHandler.getModifiableVersionOf((ICloneable)type);
        TypeNameParts parts = TypeNameParts.create(type);
        parts.setName(newName);
        toBeRenamed.setShortName(parts.getFullName());
        return toBeRenamed;
    }

    private void moveType(CSharpType type, ICloneable target, RefactoringStateHandler refactoringStateHandler) {
        assert (type != null) : "Parameter 'type' of method 'moveType' must not be null";
        assert (target != null) : "Parameter 'target' of method 'moveType' must not be null";
        assert (type != target) : "Same instances";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveType' must not be null";
        ICloneable nextCloneable = (ICloneable)type.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
        refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)type, target);
        TypeNameParts parts = TypeNameParts.create(type);
        parts.setNamespace(target instanceof CSharpNamespaceFragment ? target.getNamedElement().getName() : "");
        type.setShortName(parts.getFullName());
    }

    private CSharpSourceFile renameSourceFile(CSharpSourceFile sourceFile, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (sourceFile != null) : "Parameter 'compilationUnit' of method 'renameCompilationUnit' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameCompilationUnit' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameCompilationUnit' must not be null";
        String path = sourceFile.getPath();
        int pathSepPos = path.lastIndexOf(47);
        assert (pathSepPos != -1) : "Path separator not found: " + path;
        int extensionPos = path.lastIndexOf(46);
        assert (extensionPos > pathSepPos) : "Invalid path: " + path;
        CSharpSourceFile modifiableVersionOfToBeRenamed = (CSharpSourceFile)refactoringStateHandler.getModifiableVersionOf((ICloneable)sourceFile);
        modifiableVersionOfToBeRenamed.setPath(path.substring(0, pathSepPos + 1) + newName + path.substring(extensionPos));
        return modifiableVersionOfToBeRenamed;
    }

    protected Set<NamedElement> move(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, RootDirectoryPath targetRootDirectory, String moveToParentName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'move' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'move' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'move' must not be empty";
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'move' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'move' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'move' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'move' must not be null";
        switch (elementType) {
            case ELEMENT: {
                for (NamedElement next : namedElements) {
                    assert (next instanceof CSharpType) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CSharpType nextType = (CSharpType)next;
                    CSharpSourceFile nextSource = (CSharpSourceFile)nextType.getParent(CSharpSourceFile.class, new Class[0]);
                    assert (nextSource != null) : "'nextSource' of method 'move' must not be null";
                    NamedElement nextTarget = this.getOrCreateTypeParent(msp, (ICloneable)nextSource, moveToParentName, refactoringStateHandler, null);
                    if (!this.checkCollisions(Collections.singletonList(nextType), statusInfo, (NamedElement)nextSource, null, elementType, nextTarget)) continue;
                    this.moveType(nextType, (ICloneable)nextTarget, refactoringStateHandler);
                }
                break;
            }
            case COMPONENT: {
                NamedElement targetDirectory = this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                this.checkCollisions(namedElements, statusInfo, targetDirectory, null, elementType, targetDirectory);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof CSharpSourceFile) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CSharpSourceFile nextCompilationUnit = (CSharpSourceFile)next;
                    ICloneable nextCloneable = (ICloneable)nextCompilationUnit.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextCompilationUnit, (ICloneable)targetDirectory);
                }
                break;
            }
            case DIRECTORY: {
                IRefactoringTarget target = this.getMoveToParent(targetRootDirectory, moveToParentName);
                this.checkCollisions(namedElements, statusInfo, target != null ? target.getNamedElement() : null, null, elementType, target != null ? target.getNamedElement() : null);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof CSharpDirectoryFragment) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CSharpDirectoryFragment nextDirectory = (CSharpDirectoryFragment)next;
                    CSharpDirectoryFragment existing = null;
                    if (target != null) {
                        existing = (CSharpDirectoryFragment)this.findByRelevantRenameName(this.getRelevantRenameName((NamedElement)nextDirectory), target.getNamedElement(), CSharpDirectoryFragment.class);
                    }
                    if (existing != null) {
                        this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, CSharpDirectoryFragment.class);
                        continue;
                    }
                    NamedElement nextNewParent = this.createNewPhysicalRecursiveTarget((PhysicalRecursiveElement)nextDirectory, moveToParentName) ? this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, (PhysicalRecursiveElement)nextDirectory) : this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                    ICloneable nextCloneable = (ICloneable)nextDirectory.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextDirectory, (ICloneable)nextNewParent);
                }
                break;
            }
            default: {
                assert (false) : "Unhandled 'elementType' in 'move':" + String.valueOf(elementType);
                break;
            }
        }
        return Collections.emptySet();
    }

    protected Set<NamedElement> moveRename(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, RootDirectoryPath targetRootDirectory, String moveToParentName, String newName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'moveRename' must not be null";
        assert (elementType != null) : "Parameter 'refactoringElementType' of method 'moveRename' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'moveRename' must not be empty";
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'moveRename' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'moveRename' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'moveRename' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveRename' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'moveRename' must not be null";
        switch (elementType) {
            case ELEMENT: {
                for (NamedElement next : namedElements) {
                    assert (next instanceof CSharpType) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CSharpType nextType = (CSharpType)next;
                    CSharpSourceFile nextSource = (CSharpSourceFile)nextType.getParent(CSharpSourceFile.class, new Class[0]);
                    assert (nextSource != null) : "'nextSource' of method 'move' must not be null";
                    NamedElement nextTarget = this.getOrCreateTypeParent(msp, (ICloneable)nextSource, moveToParentName, refactoringStateHandler, null);
                    if (!this.checkCollisions(Collections.singletonList(nextType), statusInfo, (NamedElement)nextSource, newName, elementType, nextTarget)) continue;
                    CSharpType nextRenamedType = this.renameType(nextType, newName, refactoringStateHandler);
                    this.moveType(nextRenamedType, (ICloneable)nextTarget, refactoringStateHandler);
                }
                break;
            }
            case COMPONENT: {
                NamedElement targetDirectory = this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                this.checkCollisions(namedElements, statusInfo, targetDirectory, newName, elementType, targetDirectory);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                assert (targetDirectory != null);
                for (NamedElement next : namedElements) {
                    assert (next instanceof CSharpSourceFile) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CSharpSourceFile nextSourceFile = (CSharpSourceFile)next;
                    nextSourceFile = this.renameSourceFile(nextSourceFile, newName, refactoringStateHandler);
                    ICloneable nextCloneable = (ICloneable)nextSourceFile.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextSourceFile, (ICloneable)targetDirectory);
                }
                break;
            }
            case DIRECTORY: {
                IRefactoringTarget target = this.getMoveToParent(targetRootDirectory, moveToParentName);
                this.checkCollisions(namedElements, statusInfo, target != null ? target.getNamedElement() : null, newName, elementType, target != null ? target.getNamedElement() : null);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof CSharpDirectoryFragment) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CSharpDirectoryFragment nextDirectory = (CSharpDirectoryFragment)next;
                    CSharpDirectoryFragment existing = null;
                    if (target != null) {
                        existing = (CSharpDirectoryFragment)this.findByRelevantRenameName(newName, target.getNamedElement(), CSharpDirectoryFragment.class);
                    }
                    if (existing != null) {
                        this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, CSharpDirectoryFragment.class);
                        continue;
                    }
                    boolean nextCreateNewDirectory = this.createNewPhysicalRecursiveTarget((PhysicalRecursiveElement)nextDirectory, moveToParentName);
                    nextDirectory = this.renameDirectory(nextDirectory, newName, refactoringStateHandler);
                    NamedElement nextNewParent = nextCreateNewDirectory ? this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, (PhysicalRecursiveElement)nextDirectory) : this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                    ICloneable nextCloneable = (ICloneable)nextDirectory.getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextDirectory, (ICloneable)nextNewParent);
                }
                break;
            }
            default: {
                assert (false) : "Unhandled 'elementType' in 'moveRename':" + String.valueOf(elementType);
                break;
            }
        }
        return Collections.emptySet();
    }

    protected Set<NamedElement> rename(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, String newName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'rename' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'rename' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'rename' must not be empty";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'rename' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'rename' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'rename' must not be null";
        this.checkCollisions(namedElements, statusInfo, null, newName, elementType, null);
        if (statusInfo.getStatus() == StatusInfo.Status.NONE || statusInfo.getStatus().isApplicable()) {
            switch (elementType) {
                case ELEMENT: {
                    for (NamedElement next : namedElements) {
                        assert (next instanceof CSharpType) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        this.renameType((CSharpType)next, newName, refactoringStateHandler);
                    }
                    break;
                }
                case COMPONENT: {
                    for (NamedElement next : namedElements) {
                        assert (next instanceof CSharpSourceFile) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        this.renameSourceFile((CSharpSourceFile)next, newName, refactoringStateHandler);
                    }
                    break;
                }
                case DIRECTORY: {
                    for (NamedElement next : namedElements) {
                        assert (next instanceof CSharpDirectoryFragment) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        CSharpDirectoryFragment nextDirectory = (CSharpDirectoryFragment)next;
                        NamedElement parentOfNextDirectory = nextDirectory.getParent();
                        CSharpDirectoryFragment existing = (CSharpDirectoryFragment)this.findByRelevantRenameName(newName, parentOfNextDirectory, CSharpDirectoryFragment.class);
                        if (existing != null) {
                            this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, CSharpDirectoryFragment.class);
                            continue;
                        }
                        this.renameDirectory(nextDirectory, newName, refactoringStateHandler);
                    }
                    break;
                }
                default: {
                    assert (false) : "Unhandled 'refactoringElementType' in 'rename':" + String.valueOf(elementType);
                    break;
                }
            }
        }
        return Collections.emptySet();
    }

    static final class TypeNameParts {
        private String m_namespace = "";
        private String m_name;

        TypeNameParts() {
        }

        void setNamespace(String name) {
            assert (name != null) : "Parameter 'name' of method 'setNamespace' must not be null";
            this.m_namespace = name;
        }

        void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        boolean isValid() {
            return this.m_namespace != null && this.m_name != null && this.m_name.length() > 0;
        }

        String getFullName() {
            assert (this.isValid()) : "Not valid: " + String.valueOf(this);
            return (String)(this.m_namespace.isEmpty() ? "" : this.m_namespace + ".") + this.m_name;
        }

        public String toString() {
            return "TypeNameParts [m_namespace=" + this.m_namespace + ", m_name=" + this.m_name + "]";
        }

        static TypeNameParts create(CSharpType type) {
            assert (type != null) : "Parameter 'type' of method 'getTypeNameParts' must not be null";
            TypeNameParts parts = new TypeNameParts();
            String name = type.getName();
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                parts.setNamespace(name.substring(0, pos));
                name = name.substring(pos + 1);
            }
            parts.setName(name);
            return parts;
        }
    }
}

