/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PythonSearchPath {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonSearchPath.class);
    public static final String PYTHON_EXT = ".py";
    private final PythonInterpreter m_interpreter;
    private final List<TFile> m_pythonPath = new ArrayList<TFile>();
    private final List<String> m_moduleNames = new ArrayList<String>();

    PythonSearchPath(PythonInterpreter interpreter) {
        assert (interpreter != null) : "Parameter 'interpreter' of method 'PythonSearchPath' must not be null";
        this.m_interpreter = interpreter;
    }

    void add(String dir) {
        assert (dir != null && dir.length() > 0) : "Parameter 'dir' of method 'add' must not be empty";
        TFile dirFile = new TFile(dir);
        if (dirFile.isDirectory()) {
            this.m_pythonPath.add(dirFile);
        }
    }

    void registerModuleName(String modName) {
        assert (modName != null && modName.length() > 0) : "Parameter 'modName' of method 'registerModuleName' must not be empty";
        this.m_moduleNames.add(modName);
    }

    /*
     * Enabled aggressive block sorting
     */
    TFile locateModule(String dottedName) {
        if (!$assertionsDisabled) {
            if (dottedName == null) throw new AssertionError((Object)"Parameter 'dottedName' of method 'locateModule' must not be empty");
            if (dottedName.length() <= 0) {
                throw new AssertionError((Object)"Parameter 'dottedName' of method 'locateModule' must not be empty");
            }
        }
        assert (this.m_pythonPath.size() > 0);
        if (this.m_interpreter.isBuiltinModuleName(dottedName)) {
            TFile result = new TFile((File)this.m_pythonPath.get(this.m_pythonPath.size() - 1), dottedName + PYTHON_EXT);
            if (result.isFile()) return result;
            LOGGER.error("Cannot locate builtin python module: " + dottedName);
            return null;
        }
        if (dottedName.contains(".")) {
            for (String modName : this.m_moduleNames) {
                if (!dottedName.startsWith(modName + ".")) continue;
                return null;
            }
        }
        String[] nameParts = dottedName.split("\\.");
        int parts = nameParts.length;
        TFile match = null;
        for (TFile pathDir : this.m_pythonPath) {
            int i = 0;
            while (i < parts) {
                TFile dir = pathDir;
                match = null;
                int j = 0;
                while (j <= i) {
                    block14: {
                        TFile file;
                        block15: {
                            file = new TFile((File)dir, nameParts[j]);
                            if (file.isDirectory()) break block15;
                            if (j == parts - 1) {
                                file = new TFile((File)dir, nameParts[j] + PYTHON_EXT);
                                if (file.isFile()) {
                                    this.registerModuleName(dottedName);
                                    match = file;
                                    break block14;
                                } else {
                                    dir = null;
                                }
                                break block14;
                            } else {
                                dir = null;
                                break;
                            }
                        }
                        dir = file;
                    }
                    ++j;
                }
                if (match == null && dir != null) {
                    match = dir;
                }
                ++i;
            }
            if (match == null) continue;
            return match;
        }
        return match;
    }
}

