/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.generic.GenericLanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.IDeltaDetector;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.RelativeCyclicityMetricIds;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLinesScanner;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.generic.GenericAdditionalInfoProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.IPythonInterpreterConsumer;
import com.hello2morrow.sonargraph.languageprovider.python.controller.settings.PythonSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.PythonDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.PythonDynamicSystemInfoProvider;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.PythonRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.PythonWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.analysis.PythonPackageCyclesInModuleAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.analysis.PythonPackageCyclesInModuleMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.analysis.PythonPackageCyclesInSystemMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.analysis.PythonSystemPackageCyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonRefreshJob;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonSourceLineProcessor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.plugin.PluginPythonAccess;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.script.PythonAccess;
import com.hello2morrow.sonargraph.languageprovider.python.controllerinterface.IPythonSettingsExtension;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonCause;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonIssueId;
import com.hello2morrow.sonargraph.languageprovider.python.model.element.PythonProviderId;
import com.hello2morrow.sonargraph.languageprovider.python.model.path.PythonFileType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonClass;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonField;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonFunction;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonMethod;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonMetricLevel;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonVariable;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInterpreter;
import com.hello2morrow.sonargraph.languageprovider.python.model.system.PythonAnalyzerId;
import com.hello2morrow.sonargraph.languageprovider.python.model.system.PythonMetricId;
import com.hello2morrow.sonargraph.languageprovider.python.model.workspace.PythonExternal;
import com.hello2morrow.sonargraph.languageprovider.python.model.workspace.PythonModule;
import com.hello2morrow.sonargraph.languageprovider.python.model.workspace.PythonModuleType;
import com.hello2morrow.sonargraph.plugin.python.IPluginPythonAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PythonLanguageProvider
extends GenericLanguageProvider
implements IPythonInterpreterConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonLanguageProvider.class);
    static final String[] IMPORT_START_TOKENS = new String[]{"import"};
    private PythonRefreshJob m_refreshJob;
    private Set<String> m_keywords;

    public PythonLanguageProvider() {
        super((Language)PythonLanguage.INSTANCE, PythonModule.class);
    }

    protected ISourceLineProcessor createSourceLineProcessor() {
        return new PythonSourceLineProcessor();
    }

    public IProviderId getProviderId() {
        return PythonProviderId.INSTANCE;
    }

    public IMetricLevel getNamespaceMetricLevel() {
        return PythonMetricLevel.PYTHON_PACKAGE;
    }

    public IMetricId getNamespacesMetricId() {
        return PythonMetricId.PYTHON_PACKAGES;
    }

    public Set<RelativeCyclicityMetricIds> getRelativeCyclicityMetricIds() {
        return Set.of(new RelativeCyclicityMetricIds((IMetricId)PythonMetricId.PYTHON_PACKAGES_FULLY_ANALYZED, (IMetricId)PythonMetricId.PYTHON_RELATIVE_CYCLICITY_PACKAGES, (IMetricId)PythonMetricId.PYTHON_AVERAGE_RELATIVE_CYCLICITY_PACKAGES));
    }

    public IMetricId getFullyAnalyzedNamespacesMetricId() {
        return PythonMetricId.PYTHON_PACKAGES_FULLY_ANALYZED;
    }

    public Set<IIssueId> getIssueIds() {
        return new HashSet<IIssueId>(Arrays.asList(PythonIssueId.values()));
    }

    public IAdditionalDynamicInfoProvider getDynamicSystemInfoProvider() {
        return new PythonDynamicSystemInfoProvider();
    }

    public String getBundleId() {
        return "com.hello2morrow.sonargraph.language.provider.python";
    }

    protected Class<? extends External> getExternalClass() {
        return PythonExternal.class;
    }

    protected List<StructureItem> getPhysicalStructureItems() {
        return Arrays.asList(StructureItem.MODULE, StructureItem.ROOT_DIRECTORY, StructureItem.NAMESPACE, StructureItem.COMPONENT, StructureItem.PROGRAMMING_ELEMENT);
    }

    public CategoryProvider getPhysicalCategoryProvider() {
        CategoryProvider cp = new CategoryProvider();
        cp.setCategory(PythonModule.class, 1);
        cp.setCategory(GenericPackage.class, 10);
        cp.setCategory(PythonSourceFile.class, 100);
        cp.setCategory(PythonField.class, 80);
        cp.setCategory(PythonVariable.class, 60);
        cp.setCategory(PythonMethod.class, 90);
        cp.setCategory(PythonFunction.class, 65);
        cp.setCategory(PythonClass.class, 70);
        cp.setCategory(PythonExternal.class, 1000);
        return cp;
    }

    public Set<String> getKeywords() {
        if (this.m_keywords == null) {
            SoftwareSystem softwareSystem = ((ISoftwareSystemProvider)this.getInstallation().getExtension(ISoftwareSystemProvider.class)).getSoftwareSystem();
            assert (softwareSystem != null) : "'softwareSystem' must not be null";
            Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
            PythonInterpreter interpreter = (PythonInterpreter)((Object)workspace.getUniqueExistingChild(PythonInterpreter.class));
            this.m_keywords = interpreter.getKeywords();
        }
        return this.m_keywords;
    }

    public void initialize(Installation installation, IFinishModelProcessor finishModelProcessor) {
        super.initialize(installation, finishModelProcessor);
        installation.addExtension((Extension)new PythonSettingsExtension(installation, this));
    }

    public void initialize(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        super.initialize(softwareSystem, finishModelProcessor);
        softwareSystem.addExtension((Extension)new PythonWorkspaceExtension(softwareSystem));
    }

    protected Module createModule(SoftwareSystem system, Module.IModuleType type, String id, String name, String description) {
        Workspace workspace = (Workspace)system.getUniqueExistingChild(Workspace.class);
        PythonModule result = new PythonModule((NamedElement)workspace, name, id);
        workspace.addChild((NamedElement)result);
        result.setDescription(description);
        return result;
    }

    public void aboutToCreateFirstModule(SoftwareSystem softwareSystem) {
        super.aboutToCreateFirstModule(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        assert (!workspace.hasChildren(false, new Class[]{this.getExternalClass()})) : "Already created external node";
        workspace.addChild((NamedElement)new PythonExternal((NamedElement)workspace));
    }

    public void lastModuleDeleted(SoftwareSystem softwareSystem) {
        super.lastModuleDeleted(softwareSystem);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        PythonInterpreter interpreter = (PythonInterpreter)((Object)workspace.getUniqueChild(PythonInterpreter.class));
        if (interpreter != null) {
            workspace.removeChild((NamedElement)interpreter);
        }
    }

    protected RelevantSourceLinesScanner.ScannerInfo getScannerInfo() {
        return new RelevantSourceLinesScanner.ScannerInfo(IMPORT_START_TOKENS, false, "#", "\"\"\"", "\"\"\"");
    }

    @Override
    public void pythonInstallationInterpreterPathChanged(String newInterpreterPath) {
        String systemInterpreterPath;
        assert (newInterpreterPath != null && newInterpreterPath.length() > 0) : "Parameter 'newInterpreterPath' of method 'pythonInstallationInterpreterPathChanged' must not be empty";
        ISoftwareSystemProvider systemProvider = (ISoftwareSystemProvider)this.getInstallation().getExtension(ISoftwareSystemProvider.class);
        if (systemProvider.hasSoftwareSystem() && (systemInterpreterPath = systemProvider.getSoftwareSystem().getSystemProperty("PythonInterpreter")) == null) {
            systemProvider.getSoftwareSystem().setNeedsReparse(true);
        }
    }

    public IAdditionalFileInfoProvider getPersistenceProvider(Installation installation) {
        return new GenericAdditionalInfoProvider(installation, this.getLanguage(), (Module.IModuleType)PythonModuleType.PYTHON_MANUAL_MODULE);
    }

    protected Module.IModuleType getModuleType(String moduleTypeStandardName) {
        assert (moduleTypeStandardName != null && moduleTypeStandardName.length() > 0) : "Parameter 'moduleTypeStandardName' of method 'getModuleType' must not be empty";
        if (PythonModuleType.PYTHON_MANUAL_MODULE.getStandardName().equals(moduleTypeStandardName)) {
            return PythonModuleType.PYTHON_MANUAL_MODULE;
        }
        return null;
    }

    public IDeltaDetector createDeltaDetector(IWorkerContext workerContext, IWorkspaceFilter filter, Module module, PrepareRefreshResult result) {
        return new PythonDeltaDetector(workerContext, (ILanguageProvider)this, filter, module, LanguageProvider.getIgnoreDirectories());
    }

    public boolean prepareRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, PrepareRefreshResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        OperationResult initInterpreter = this.initPythonInterpreter(workerContext, softwareSystem);
        result.addMessagesFrom(initInterpreter);
        result.setParserRefreshPossible(this.getLanguage(), initInterpreter.isSuccess());
        return false;
    }

    private OperationResult initPythonInterpreter(IWorkerContext workerContext, SoftwareSystem softwareSystem) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initPythonInterpreter' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initPythonInterpreter' must not be null";
        OperationResult result = new OperationResult("Init Python interpreter");
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        PythonInterpreter previous = (PythonInterpreter)((Object)workspace.getUniqueChild(PythonInterpreter.class));
        if (previous != null) {
            workspace.removeChild((NamedElement)previous);
        }
        IPythonSettingsExtension settingsExtension = (IPythonSettingsExtension)this.getInstallation().getExtension(IPythonSettingsExtension.class);
        String systemInterpreterPath = softwareSystem.getSystemProperty("PythonInterpreter");
        if (systemInterpreterPath != null) {
            OperationResultWithOutcome<PythonInterpreter> interpreterResult = settingsExtension.createSystemInterpreter(workerContext, softwareSystem, systemInterpreterPath, false);
            if (interpreterResult.isFailure()) {
                result.addMessagesFrom(interpreterResult);
                return result;
            }
            PythonInterpreter systemInterpreter = (PythonInterpreter)((Object)interpreterResult.getOutcome());
            workspace.addChild((NamedElement)systemInterpreter);
            return result;
        }
        PythonInstallationSettings installationSettings = (PythonInstallationSettings)((Object)this.getInstallation().getUniqueExistingChild(PythonInstallationSettings.class));
        PythonInterpreter installationInterpreter = (PythonInterpreter)((Object)installationSettings.getUniqueChild(PythonInterpreter.class));
        if (installationInterpreter == null) {
            LOGGER.info("Initializing python interpreter");
            OperationResultWithOutcome<PythonInterpreter> createResult = settingsExtension.initializePythonInterpreter(workerContext);
            if (createResult.isFailure()) {
                result.addError((OperationResult.IMessageCause)PythonCause.NO_PYTHON_INTERPRETER_CONFIGURED, "Please configure a valid Python 3 interpreter in the preferences dialog", new Object[0]);
                return result;
            }
            installationInterpreter = (PythonInterpreter)((Object)createResult.getOutcome());
        }
        if (installationSettings.getIssues().stream().filter(i -> i.getSeverity() == Severity.ERROR).count() > 0L || installationInterpreter == null) {
            result.addError((OperationResult.IMessageCause)PythonCause.NO_PYTHON_INTERPRETER_CONFIGURED, "Please configure a valid Python 3 interpreter in the preferences dialog", new Object[0]);
            return result;
        }
        PythonInterpreter systemInterpreter = installationInterpreter.copy((NamedElement)workspace);
        workspace.addChild((NamedElement)systemInterpreter);
        return result;
    }

    public void aboutToRefreshModules(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener listener) {
        super.aboutToRefreshModules(workerContext, softwareSystem, result, refreshOptions, moduleDeltas, listener);
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        PythonInterpreter interpreter = (PythonInterpreter)((Object)workspace.getUniqueExistingChild(PythonInterpreter.class));
        this.m_refreshJob = new PythonRefreshJob(softwareSystem, (IAddedOrChangedSourceFileProcessor)this, interpreter, listener);
        this.m_refreshJob.init(workerContext, moduleDeltas);
    }

    public void refreshModule(IWorkerContext workerContext, ModuleDelta delta, IFilePathListener listener, OperationResult result) {
        assert (this.m_refreshJob != null) : "'m_refreshJob' of method 'refreshModule' must not be null";
        this.m_refreshJob.refreshModule(workerContext, delta, listener);
    }

    public boolean finishRefresh(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result, boolean systemWillBeCleared) {
        this.m_refreshJob = null;
        return super.finishRefresh(workerContext, softwareSystem, result, systemWillBeCleared);
    }

    public Set<PythonAnalyzerId> getAnalyzerIds() {
        return EnumSet.allOf(PythonAnalyzerId.class);
    }

    public LanguageProviderRefactoringDescriptorProvider getRefactoringDescriptorProvider() {
        return new PythonRefactoringDescriptorProvider();
    }

    public List<? extends AnalyzerAdapter> getAnalyzerAdapters(IAnalyzerController controller, Set<IConfigurableAnalyzerId> licensedAnalyzerIds) {
        assert (controller != null) : "Parameter 'controller' of method 'getAnalyzerAdapters' must not be null";
        assert (licensedAnalyzerIds != null) : "Parameter 'licensedAnalyzerIds' of method 'getAnalyzerAdapters' must not be null";
        ArrayList<Object> result = new ArrayList<Object>();
        if (licensedAnalyzerIds.contains(PythonPackageCyclesInModuleAnalyzerAdapter.ID)) {
            result.add((Object)new PythonPackageCyclesInModuleAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(PythonSystemPackageCyclesAnalyzerAdapter.ID)) {
            result.add((Object)new PythonSystemPackageCyclesAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(PythonPackageCyclesInModuleMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new PythonPackageCyclesInModuleMetricsAnalyzerAdapter(controller));
        }
        if (licensedAnalyzerIds.contains(PythonPackageCyclesInSystemMetricsAnalyzerAdapter.ID)) {
            result.add((Object)new PythonPackageCyclesInSystemMetricsAnalyzerAdapter(controller));
        }
        return result;
    }

    protected CoreAccess getSystemAccess(Installation installation, SoftwareSystem system, IMetricIdProvider metricIdProvider, ScriptApi api) {
        return new PythonAccess(installation, system, metricIdProvider, api);
    }

    public void applyInstallationParameters(Map<String, String> instSpecificParameters, OperationResult result) {
        assert (instSpecificParameters != null) : "Parameter 'instSpecificParameters' of method 'applyInstallationParameters' must not be null";
        assert (result != null) : "Parameter 'result' of method 'applyInstallationParameters' must not be null";
        ((IPythonSettingsExtension)this.getInstallation().getExtension(IPythonSettingsExtension.class)).applyInstallationParameters(instSpecificParameters, result);
    }

    public Collection<String> getSourceExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        String[] stringArray = PythonFileType.SOURCE_FILE.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        return extensions;
    }

    public void addPluginAccess(Installation installation, SoftwareSystem softwareSystem, Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess> access) {
        assert (installation != null) : "Parameter 'installation' of method 'addPluginAccess' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addPluginAccess' must not be null";
        assert (access != null) : "Parameter 'access' of method 'addPluginAccess' must not be null";
        access.put(IPluginPythonAccess.class, (IPluginCoreAccess)new PluginPythonAccess(installation, softwareSystem));
    }
}

