/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.JavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.IJavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaSyntheticType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeltaRefreshJob
implements ModuleDelta.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeltaRefreshJob.class);
    private final Map<RootDirectoryPath, List<TFile>> m_rootDirectoryPathToClassFilesToParse = new LinkedHashMap<RootDirectoryPath, List<TFile>>();
    private final Map<JavaSourceRootDirectoryPath, List<TFile>> m_sourceRootDirectoryPathToSourceFilesToParse = new LinkedHashMap<JavaSourceRootDirectoryPath, List<TFile>>();
    private final Set<JavaInternalCompilationUnit> m_affectedInternalCompilationUnits = new THashSet();
    private final List<JavaFile> m_deletedFiles = new ArrayList<JavaFile>();
    private final IWorkerContext m_workerContext;
    private final ModuleDelta m_delta;
    private final JavaModuleModel m_moduleModel;
    private final IFilePathListener m_filePathListener;
    private int m_numberOfClassFilesToParse;
    private int m_numberOfSourceFilesToParse;

    DeltaRefreshJob(IWorkerContext workerContext, IAddedOrChangedSourceFileProcessor addedOrChangedSourceFileProcessor, JavaGlobalModel globalModel, ModuleDelta delta, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'DeltaRefreshJob' must not be null";
        assert (addedOrChangedSourceFileProcessor != null) : "Parameter 'addedOrChangedSourceFileProcessor' of method 'DeltaRefreshJob' must not be null";
        assert (globalModel != null) : "Parameter 'globalModel' of method 'DeltaRefreshJob' must not be null";
        assert (delta != null) : "Parameter 'softwareSystem' of method 'DeltaRefreshJob' must not be null";
        this.m_workerContext = workerContext;
        this.m_delta = delta;
        this.m_moduleModel = new JavaModuleModel(globalModel, (JavaModule)delta.getModule(), addedOrChangedSourceFileProcessor, listener);
        this.m_filePathListener = listener;
    }

    private void deleteFile(JavaFile file) {
        assert (file != null) : "Parameter 'file' of method 'deleteFile' must not be null";
        if (this.m_filePathListener != null) {
            this.m_filePathListener.filePathDeleted((IModule)this.m_moduleModel.getModule(), (FilePath)file);
        }
        file.remove();
    }

    private void addToFilesToBeParsed(RootDirectoryPath root, JavaFileType fileType, TFile file) {
        assert (root != null) : "Parameter 'root' of method 'addToFilesToBeParsed' must not be null";
        assert (fileType != null) : "Parameter 'fileType' of method 'addToFilesToBeParsed' must not be null";
        assert (file != null) : "Parameter 'file' of method 'addToFilesToBeParsed' must not be null";
        switch (fileType) {
            case CLASS_FILE: {
                List<TFile> classFiles = this.m_rootDirectoryPathToClassFilesToParse.get(root);
                if (classFiles == null) {
                    classFiles = new ArrayList<TFile>();
                    this.m_rootDirectoryPathToClassFilesToParse.put(root, classFiles);
                }
                classFiles.add(file);
                ++this.m_numberOfClassFilesToParse;
                break;
            }
            case JAVA_FILE: 
            case GROOVY_FILE: 
            case KOTLIN_FILE: 
            case ASPECTJ_FILE: 
            case SCALA_FILE: {
                List<TFile> sourceFiles = this.m_sourceRootDirectoryPathToSourceFilesToParse.get(root);
                if (sourceFiles == null) {
                    if (root instanceof JavaSourceRootDirectoryPath) {
                        sourceFiles = new ArrayList<TFile>();
                        this.m_sourceRootDirectoryPathToSourceFilesToParse.put((JavaSourceRootDirectoryPath)root, sourceFiles);
                    } else {
                        LOGGER.error("Ignore '" + file.getAbsolutePath() + "' [" + String.valueOf((Object)fileType) + "] to be reparsed underneath unexpected root directory '" + root.getAbsolutePath() + "' [" + root.getClass().getName() + "]");
                    }
                }
                if (sourceFiles == null) break;
                sourceFiles.add(file);
                ++this.m_numberOfSourceFilesToParse;
                break;
            }
            default: {
                assert (false) : "Unhandled file type: " + String.valueOf((Object)fileType) + " - " + String.valueOf(file);
                break;
            }
        }
    }

    private void parseClassFiles() {
        if (!this.m_workerContext.hasBeenCanceled() && this.m_numberOfClassFilesToParse > 0) {
            this.m_workerContext.beginBlockOfWork(this.m_numberOfClassFilesToParse);
            block0: for (Map.Entry<RootDirectoryPath, List<TFile>> nextEntry : this.m_rootDirectoryPathToClassFilesToParse.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                RootDirectoryPath nextRootDirectoryPath = nextEntry.getKey();
                for (TFile nextClassFile : nextEntry.getValue()) {
                    if (this.m_workerContext.hasBeenCanceled()) continue block0;
                    this.m_moduleModel.getClassFileParser().parse(nextRootDirectoryPath, nextClassFile, this.m_filePathListener);
                    this.m_workerContext.workItemCompleted();
                }
            }
            this.m_moduleModel.finishClassFileParsing();
        }
    }

    private void parseSourceFiles() {
        if (!this.m_workerContext.hasBeenCanceled() && this.m_numberOfSourceFilesToParse > 0) {
            this.m_workerContext.beginBlockOfWork(this.m_numberOfSourceFilesToParse);
            block8: for (Map.Entry<JavaSourceRootDirectoryPath, List<TFile>> nextEntry : this.m_sourceRootDirectoryPathToSourceFilesToParse.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                JavaSourceRootDirectoryPath nextRootDirectoryPath = nextEntry.getKey();
                for (TFile nextSourceFile : nextEntry.getValue()) {
                    if (this.m_workerContext.hasBeenCanceled()) continue block8;
                    JavaFileType fileType = JavaFileType.determine(nextSourceFile.getName());
                    if (fileType != null) {
                        switch (fileType) {
                            case JAVA_FILE: {
                                this.m_moduleModel.getJavaFileParser().parse(nextRootDirectoryPath, nextSourceFile);
                                break;
                            }
                            case KOTLIN_FILE: {
                                this.m_moduleModel.getKotlinFileParser().parse(nextRootDirectoryPath, nextSourceFile);
                                break;
                            }
                            case GROOVY_FILE: {
                                this.m_moduleModel.getGroovyFileProcessor().process(nextRootDirectoryPath, nextSourceFile);
                                break;
                            }
                            case ASPECTJ_FILE: {
                                this.m_moduleModel.getAspectJFileProcessor().process(nextRootDirectoryPath, nextSourceFile);
                                break;
                            }
                            case SCALA_FILE: {
                                this.m_moduleModel.getScaleFileProcessor().process(nextRootDirectoryPath, nextSourceFile);
                                break;
                            }
                            case CLASS_FILE: {
                                assert (false) : "Unexpected file type: " + nextSourceFile.getAbsolutePath();
                                break;
                            }
                            default: {
                                assert (false) : "Uhandled file type: " + String.valueOf((Object)fileType);
                                break;
                            }
                        }
                    }
                    this.m_workerContext.workItemCompleted();
                }
            }
        }
    }

    private void processAffectedInternalCompilationUnits() {
        if (!this.m_affectedInternalCompilationUnits.isEmpty()) {
            this.m_workerContext.working("Process affected internal compilation units", true);
            for (JavaInternalCompilationUnit nextInternalCompilationUnit : this.m_affectedInternalCompilationUnits) {
                nextInternalCompilationUnit.getChildrenRecursively(NamedElement.class, new Class[0]).forEach(c -> c.removeIssues());
                for (IJavaType nextType : nextInternalCompilationUnit.getChildrenRecursively(IJavaType.class, new Class[0])) {
                    NamedElement nextNamedElement = nextType.getNamedElement();
                    List nextClassFiles = nextNamedElement.getChildren(JavaClassFile.class);
                    if (nextNamedElement instanceof JavaType) {
                        JavaType nextJavaType = (JavaType)nextNamedElement;
                        if (nextClassFiles.isEmpty()) {
                            this.m_moduleModel.removedFromInternalCompilationUnit(nextJavaType);
                        } else {
                            this.m_moduleModel.setNeedsReparse(nextJavaType);
                        }
                    } else if (nextNamedElement instanceof JavaSyntheticType) {
                        if (nextClassFiles.isEmpty()) {
                            nextNamedElement.remove();
                        }
                    } else assert (false) : "Unhandled Java type: " + String.valueOf(nextType);
                    for (JavaClassFile nextClassFile : nextClassFiles) {
                        RootDirectoryPath root = nextClassFile.getBaseDirectory();
                        assert (root != null) : "'root' of method 'processDeleted' must not be null";
                        this.addToFilesToBeParsed(root, JavaFileType.CLASS_FILE, nextClassFile.getFile());
                        this.deleteFile(nextClassFile);
                    }
                }
                for (JavaSourceFile nextSourceFile : nextInternalCompilationUnit.getChildren(JavaSourceFile.class)) {
                    JavaSourceRootDirectoryPath sourceRoot = (JavaSourceRootDirectoryPath)nextSourceFile.getBaseDirectory();
                    assert (sourceRoot != null) : "'sourceRoot' of method 'processAffectedInternalCompilationUnits' must not be null";
                    JavaFileType fileType = JavaFileType.determine(nextSourceFile.getName());
                    assert (fileType != null) : "'fileType' of " + nextSourceFile.getName() + " in method 'processAffectedInternalCompilationUnits' must not be null";
                    assert (fileType != JavaFileType.CLASS_FILE) : "Unexpected file type: " + nextSourceFile.getAbsolutePath();
                    this.addToFilesToBeParsed(sourceRoot, fileType, nextSourceFile.getFile());
                    this.deleteFile(nextSourceFile);
                }
                nextInternalCompilationUnit.remove();
            }
            this.m_affectedInternalCompilationUnits.clear();
        }
    }

    private void processDeleted() {
        if (!this.m_deletedFiles.isEmpty()) {
            Collections.sort(this.m_deletedFiles, new Comparator<JavaFile>(){

                @Override
                public int compare(JavaFile f1, JavaFile f2) {
                    if (!$assertionsDisabled && f1 == null) {
                        throw new AssertionError((Object)"Parameter 'f1' of method 'compare' must not be null");
                    }
                    if (!$assertionsDisabled && f2 == null) {
                        throw new AssertionError((Object)"Parameter 'f2' of method 'compare' must not be null");
                    }
                    return f2.getName().length() - f1.getName().length();
                }
            });
            for (JavaFile nextFile : this.m_deletedFiles) {
                assert (nextFile.isValid()) : "'nextFile' of method 'processDeleted' must be valid: " + FileUtility.getIdentifyingPath((TFile)nextFile.getFile());
                JavaInternalCompilationUnit nextInternalCompilationUnit = (JavaInternalCompilationUnit)((Object)nextFile.getParent(JavaInternalCompilationUnit.class, new Class[0]));
                if (nextInternalCompilationUnit != null) {
                    this.m_affectedInternalCompilationUnits.add(nextInternalCompilationUnit);
                }
                nextFile.removeIssues();
                this.deleteFile(nextFile);
            }
        }
    }

    public void deleted(ModuleDelta delta, FilePath filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'deleted' must not be null";
        assert (filePath instanceof JavaFile) : "Unexpected class in method 'deleted': " + String.valueOf(filePath);
        if (filePath.isValid()) {
            this.m_deletedFiles.add((JavaFile)filePath);
        } else {
            LOGGER.warn("The file path to be deleted is already invalid: " + String.valueOf(filePath));
        }
    }

    public void modified(ModuleDelta delta, FilePath filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'modified' must not be null";
        assert (filePath instanceof JavaFile) : "Unexpected class in method 'modified': " + String.valueOf(filePath);
        if (filePath.isValid()) {
            filePath.removeIssues();
            JavaInternalCompilationUnit internalCompilationUnit = (JavaInternalCompilationUnit)((Object)filePath.getParent(JavaInternalCompilationUnit.class, new Class[0]));
            if (internalCompilationUnit != null) {
                this.m_affectedInternalCompilationUnits.add(internalCompilationUnit);
            } else {
                RootDirectoryPath root = (RootDirectoryPath)filePath.getBaseDirectory();
                assert (root != null) : "'root' of method 'modified' must not be null";
                this.addToFilesToBeParsed(root, (JavaFileType)filePath.getFileType(), filePath.getFile());
                this.deleteFile((JavaFile)filePath);
            }
        } else {
            LOGGER.warn("The file path to be modified is already invalid: " + String.valueOf(filePath));
        }
    }

    public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
        assert (root != null) : "Parameter 'root' of method 'added' must not be null";
        assert (fileType != null) : "Parameter 'fileType' of method 'added' must not be null";
        assert (file != null) : "Parameter 'file' of method 'added' must not be null";
        this.addToFilesToBeParsed(root, (JavaFileType)fileType, file);
    }

    public void start() {
        this.m_workerContext.setNumberOfSteps(3);
        this.m_delta.visitDeleted((ModuleDelta.IVisitor)this);
        this.processDeleted();
        this.m_delta.visitModified((ModuleDelta.IVisitor)this);
        this.m_delta.visitAdded((ModuleDelta.IVisitor)this);
        this.processAffectedInternalCompilationUnits();
        this.m_workerContext.endStep();
        this.parseClassFiles();
        this.m_workerContext.endStep();
        this.parseSourceFiles();
        this.m_workerContext.endStep();
    }
}

