/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public class InstCompilerDefinitionFromFile
extends InstCompilerDefinition
implements IBaseDirectory {
    private TFile m_file;

    public InstCompilerDefinitionFromFile(NamedElement parent, TFile file, String compiler) {
        super(parent, compiler);
        assert (compiler != null && compiler.length() > 0) : "Parameter 'compiler' of method 'InstCompilerDefinition' must not be empty";
        assert (file == null || file.getName().endsWith(this.getCompiler() + CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension())) : "If file is provided its name must match the name of the compiler";
        this.m_file = file;
    }

    public InstCompilerDefinitionFromFile(NamedElement parent, String compiler) {
        this(parent, null, compiler);
    }

    public final void setFile(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'setFile' must not be null";
        assert (file.getName().endsWith(this.getCompiler() + CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension()));
        this.m_file = file;
    }

    public final TFile getFile() {
        return this.m_file;
    }

    public final String getShortName() {
        if (this.m_file == null) {
            return this.getCompiler();
        }
        String fileName = this.m_file.getName();
        int dotPos = fileName.lastIndexOf(".");
        if (dotPos < 0) {
            return fileName;
        }
        return fileName.substring(0, dotPos);
    }

    public final void setPath(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'setPath' must not be empty";
        TFile dir = new TFile(path);
        assert (dir.exists()) : "specified path '" + path + "' does not exist";
        this.m_file = new TFile((File)dir, this.getCompiler() + CPlusPlusResourceProviderAdapter.CPlusPlusResourceType.COMPILER_DEFINITION.getExtension());
    }

    public final NamedElement getNamedElement() {
        return this;
    }

    public final TFile getDirectoryFile() {
        assert (this.m_file != null) : "File must have been specified";
        return this.m_file.getParentFile();
    }
}

