/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public final class DirectoryBean {
    private final List<SourceFileBean> m_sources = new ArrayList<SourceFileBean>();
    private final List<DirectoryBean> m_subDirectories = new ArrayList<DirectoryBean>();
    private final TFile m_directory;
    private DirectoryBean m_parent;
    private boolean m_isRoot;
    private boolean m_isExcluded;
    private boolean m_isLocked;

    public DirectoryBean(DirectoryBean parent, TFile dir) {
        this.m_directory = dir;
        if (parent != null) {
            parent.addSubDirectory(this);
        }
    }

    public boolean isExcluded() {
        return this.m_isExcluded || this.m_parent != null && this.m_parent.isExcluded();
    }

    public boolean isExcludedRoot() {
        return this.m_isExcluded;
    }

    public boolean hasRootParentThatAllowsExludedChildren() {
        if (this.m_parent == null) {
            return false;
        }
        if (this.m_parent.isRoot()) {
            return true;
        }
        return this.m_parent.hasRootParentThatAllowsExludedChildren();
    }

    private boolean hasRootChildren() {
        for (DirectoryBean sub : this.m_subDirectories) {
            if (sub.isRoot()) {
                return true;
            }
            if (!sub.hasRootChildren()) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedChildren() {
        for (DirectoryBean sub : this.m_subDirectories) {
            if (sub.isRoot()) {
                return true;
            }
            if (!sub.hasRootChildren()) continue;
            return true;
        }
        return false;
    }

    public boolean canBeRoot() {
        if (this.m_isRoot || this.m_isLocked || this.hasRootParentThatAllowsExludedChildren()) {
            return false;
        }
        return !this.hasRootChildren();
    }

    public boolean canBeExcluded() {
        if (this.m_isRoot || this.hasExcludedChildren()) {
            return false;
        }
        return this.hasRootParentThatAllowsExludedChildren() && !this.isExcluded();
    }

    public void setExcluded(boolean isExcluded) {
        this.m_isExcluded = isExcluded;
        if (!isExcluded) {
            for (DirectoryBean sub : this.m_subDirectories) {
                sub.setExcluded(false);
            }
        }
    }

    private void getSourceFiles(List<SourceFileBean> collector) {
        if (!this.m_isExcluded) {
            collector.addAll(this.m_sources);
            for (DirectoryBean dir : this.m_subDirectories) {
                dir.getSourceFiles(collector);
            }
        }
    }

    private void getExcludedDirectories(List<TFile> collector) {
        if (this.m_isExcluded) {
            if (this.m_directory != null) {
                collector.add(this.m_directory);
            }
        } else {
            for (DirectoryBean dir : this.m_subDirectories) {
                dir.getExcludedDirectories(collector);
            }
        }
    }

    public DirectoryBean findDirectory(Predicate<TFile> pred) {
        assert (pred != null) : "Parameter 'pred' of method 'findDirectory' must not be null";
        if (this.m_directory != null && pred.test(this.m_directory)) {
            return this;
        }
        for (DirectoryBean sub : this.m_subDirectories) {
            DirectoryBean result = sub.findDirectory(pred);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean isLocked() {
        return this.m_isLocked;
    }

    private void lock() {
        this.m_isLocked = true;
    }

    public DirectoryBean markAndLockRoot(TFile root, List<String> exclusions) {
        assert (root != null) : "Parameter 'root' of method 'findRoot' must not be null";
        assert (exclusions != null) : "Parameter 'exlusions' of method 'findRoot' must not be null";
        DirectoryBean result = this.findDirectory(dir -> root.getNormalizedAbsolutePath().equals(dir.getNormalizedAbsolutePath()));
        if (result != null) {
            result.setRoot(true);
            result.lock();
            for (String path : exclusions) {
                if (!path.startsWith("./")) continue;
                path = path.substring(2);
                TFile exludedDir = new TFile((File)result.getDirectory(), path);
                DirectoryBean excludedBean = result.findDirectory(dir -> exludedDir.getNormalizedAbsolutePath().equals(dir.getNormalizedAbsolutePath()));
                if (excludedBean == null) continue;
                excludedBean.setExcluded(true);
            }
        }
        return result;
    }

    public List<SourceFileBean> getAllSourceFiles() {
        ArrayList<SourceFileBean> result = new ArrayList<SourceFileBean>();
        this.getSourceFiles(result);
        return result;
    }

    public List<TFile> getAllExcludedDirectories() {
        ArrayList<TFile> result = new ArrayList<TFile>();
        this.getExcludedDirectories(result);
        return result;
    }

    public boolean isRoot() {
        return this.m_isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.m_isRoot = isRoot;
    }

    public void setParent(DirectoryBean parent) {
        this.m_parent = parent;
    }

    public void addFile(SourceFileBean source) {
        this.m_sources.add(source);
    }

    public void addSubDirectory(DirectoryBean dir) {
        assert (dir.m_parent == null);
        dir.m_parent = this;
        this.m_subDirectories.add(dir);
    }

    public List<SourceFileBean> getSources() {
        return Collections.unmodifiableList(this.m_sources);
    }

    public List<DirectoryBean> getSubDirectories() {
        return Collections.unmodifiableList(this.m_subDirectories);
    }

    public boolean hasSubDirectories() {
        return this.m_subDirectories.size() > 0;
    }

    public boolean hasSources() {
        return this.m_sources.size() > 0;
    }

    public DirectoryBean getParent() {
        return this.m_parent;
    }

    public void remove() {
        if (this.m_parent != null) {
            this.m_parent.m_subDirectories.remove(this);
            DirectoryBean parent = this.m_parent;
            do {
                parent.m_isLocked = true;
            } while ((parent = parent.m_parent) != null);
        }
    }

    public TFile getDirectory() {
        return this.m_directory;
    }

    public String toString() {
        return this.m_directory != null ? this.m_directory.getPath() : "No directory specified";
    }
}

