/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CxxConfigSettingsBlock;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICxxConfigFile;

public final class CxxConfigFile
implements ICxxConfigFile {
    private String m_presentationName;
    private String m_version;
    private final CxxConfigSettingsBlock m_cppSettings = new CxxConfigSettingsBlock();
    private final CxxConfigSettingsBlock m_cSettings = new CxxConfigSettingsBlock();
    private boolean m_microsoftMode;
    private boolean m_gnuMode;
    private String m_microsoftVersion;
    private String m_gnuVersion;

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public void setPresentationName(String presentationName) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'setPresentationName' must not be empty";
        this.m_presentationName = presentationName;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'setVersion' must not be empty";
        this.m_version = version;
    }

    public CxxConfigSettingsBlock getCppSettings() {
        return this.m_cppSettings;
    }

    public CxxConfigSettingsBlock getCSettings() {
        return this.m_cSettings;
    }

    @Override
    public void activateMicrosoftMode() {
        this.m_microsoftMode = true;
    }

    @Override
    public void activateGnuMode() {
        this.m_gnuMode = true;
    }

    @Override
    public void setMicrosoftVersion(String version) {
        this.m_microsoftVersion = version;
    }

    @Override
    public void setGnuVersion(String versionEncoded) {
        int v = Integer.valueOf(versionEncoded);
        this.m_gnuVersion = String.format("%d.%d.%d", v / 10000, v % 10000 / 100, v % 100);
    }

    boolean isMicrosoftMode() {
        return this.m_microsoftMode;
    }

    boolean isGnuMode() {
        return this.m_gnuMode;
    }

    String getMicrosoftVersion() {
        return this.m_microsoftVersion;
    }

    String getGnuVersion() {
        return this.m_gnuVersion;
    }
}

