/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppHasSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.NameHelper;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureParser;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.OldSignatureHelper;
import java.io.IOException;

public final class CppTypedef
extends ProgrammingElement
implements ICppHasSignature,
ICppNamespaceMember {
    private String m_signature = CppSignature.UNDEFINED;
    private boolean m_residesInAnonymousNamespace = false;

    public CppTypedef(NamedElement parent) {
        super(parent);
    }

    public CppTypedef(IModelServiceProvider msp, NamedElement parent, String name, String signature, int lineNumber, boolean residesinAnonymousNamespace) {
        super(msp, parent, name, lineNumber);
        this.m_signature = signature;
        this.m_residesInAnonymousNamespace = residesinAnonymousNamespace;
    }

    @Override
    public boolean residesInAnonymousNamespace() {
        if (this.getParent() instanceof ICppNamespaceMember) {
            return ICppNamespaceMember.super.residesInAnonymousNamespace();
        }
        return this.m_residesInAnonymousNamespace;
    }

    public ProgrammingElement getOriginal() {
        return (ProgrammingElement)this.getOriginal(this.getModelServiceProvider());
    }

    public ProgrammingElement getRepresentative() {
        return (ProgrammingElement)this.getRepresentative(this.getModelServiceProvider());
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Override
    public ProgrammingElement getProgrammingElement() {
        return this;
    }

    public String getName() {
        return NameHelper.getFullName((NamedElement)this);
    }

    public String getFullyQualifiedNamePart() {
        return "(td" + this.getLineNumber() + ")" + this.getPresentationName(true).replace("::", ".");
    }

    public boolean isMember() {
        return false;
    }

    public String getPresentationName(boolean parentIsPresented) {
        if (parentIsPresented) {
            return this.getShortName();
        }
        return this.getName();
    }

    @Override
    public String getSignature() {
        return this.m_signature;
    }

    @Override
    public void setSignature(String signature) {
        this.m_signature = signature;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_signature);
        writer.writeBoolean(this.m_residesInAnonymousNamespace);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        if (reader.getVersion() <= 16) {
            CppSignature sig = new CppSignature(reader);
            this.m_signature = OldSignatureHelper.convert(sig, CppSignatureParser.UNDEFINED);
        } else {
            this.m_signature = reader.readString();
        }
        if (reader.getVersion() >= 22) {
            this.m_residesInAnonymousNamespace = reader.readBoolean();
        }
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppTypedef(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppTypedef(CppTypedef var1);
    }
}

