/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;

public final class Operator
extends Enum<Operator>
implements IStandardEnumeration {
    public static final /* enum */ Operator LESS = new Operator("<", "Less than");
    public static final /* enum */ Operator LESS_OR_EQUAL = new Operator("<=", "At most");
    public static final /* enum */ Operator EQUAL = new Operator("==", "Exactly");
    public static final /* enum */ Operator GREATER_OR_EQUAL = new Operator(">=", "At least");
    public static final /* enum */ Operator GREATER = new Operator(">", "More than");
    public static final /* enum */ Operator N_A = new Operator("n/a", "n/a");
    private String m_description;
    private String m_symbol;
    private static final /* synthetic */ Operator[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Operator[]{LESS, LESS_OR_EQUAL, EQUAL, GREATER_OR_EQUAL, GREATER, N_A};
    }

    private Operator(String symbol, String description) {
        assert (symbol != null && symbol.length() > 0) : "Parameter 'symbol' of method 'Operator' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'Operator' must not be empty";
        this.m_symbol = symbol;
        this.m_description = description;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_symbol;
    }

    public String getSymbol() {
        return this.m_symbol;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String toString() {
        return this.getSymbol();
    }

    public static Operator fromStandardName(String value) {
        assert (value != null) : "Parameter 'value' of method 'fromString' must not be null";
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator next = operatorArray[n2];
            if (next.getStandardName().equals(value)) {
                return next;
            }
            ++n2;
        }
        assert (false) : "Unsupported standardName: " + value;
        return null;
    }

    public static Operator[] values() {
        Operator[] operatorArray = ENUM$VALUES;
        int n = operatorArray.length;
        Operator[] operatorArray2 = new Operator[n];
        System.arraycopy(ENUM$VALUES, 0, operatorArray2, 0, n);
        return operatorArray2;
    }

    public static Operator valueOf(String string) {
        return Enum.valueOf(Operator.class, string);
    }
}

