/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;

public final class AssignableTargetInfo {
    private final IAssignableTarget m_target;
    private final int m_relativeIndex;

    public AssignableTargetInfo(IAssignableTarget target, int relativeIndex) {
        assert (target != null) : "Parameter 'target' of method 'AssignableTargetInfo' must not be null";
        assert (relativeIndex >= -1) : "Invalid 'relativeIndex' in method 'AssignableTargetInfo': " + relativeIndex;
        this.m_target = target;
        this.m_relativeIndex = relativeIndex;
    }

    public IAssignableTarget getTarget() {
        return this.m_target;
    }

    public int getRelativeIndex() {
        return this.m_relativeIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_target.hashCode();
        result = 31 * result + this.m_relativeIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AssignableTargetInfo other = (AssignableTargetInfo)obj;
        return this.m_target == other.m_target && this.m_relativeIndex == other.m_relativeIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Target class: ").append(this.m_target.getClass().getSimpleName()).append("\n");
        builder.append("target name: ").append(this.m_target.getArchitecturalViewElement().getName()).append("\n");
        builder.append("Relative index: ").append(this.m_relativeIndex);
        return builder.toString();
    }
}

