/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.dependenciesview;

import com.hello2morrow.sonargraph.core.model.dependenciesview.CausesAndResolutionInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DeprecationInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ParserDependencyNumbers;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DependenciesViewRepresentationInfo {
    private final Map<ParserDependency, List<Issue>> m_parserDependencyToIssues = new THashMap();
    private final Map<ParserDependency, Set<String>> m_violationToCauses = new THashMap();
    private final Map<ParserDependency, Set<String>> m_deprecationToCauses = new THashMap();
    private final Set<ParserDependency> m_violationsToBeFixed = new THashSet();
    private final Set<ParserDependency> m_violationsIgnored = new THashSet();
    private final Set<ParserDependency> m_deprecationsIgnored = new THashSet();
    private final Set<ParserDependency> m_deprecationsToBeFixed = new THashSet();

    public final synchronized boolean hasIssuesOrViolationsOrDeprecations() {
        return !this.m_parserDependencyToIssues.isEmpty() || !this.m_violationToCauses.isEmpty() || !this.m_deprecationToCauses.isEmpty();
    }

    public final synchronized void clear() {
        this.m_violationsIgnored.clear();
        this.m_violationsToBeFixed.clear();
        this.m_deprecationsIgnored.clear();
        this.m_deprecationsToBeFixed.clear();
        this.m_parserDependencyToIssues.clear();
    }

    public synchronized boolean clearDependencyInfo(boolean clearIgnoredAndToBeFixed) {
        boolean somethingCleared = !this.m_parserDependencyToIssues.isEmpty() || !this.m_violationToCauses.isEmpty() || !this.m_deprecationToCauses.isEmpty();
        this.m_parserDependencyToIssues.clear();
        this.m_violationToCauses.clear();
        this.m_deprecationToCauses.clear();
        if (clearIgnoredAndToBeFixed) {
            this.m_violationsIgnored.clear();
            this.m_violationsToBeFixed.clear();
            this.m_deprecationsIgnored.clear();
            this.m_deprecationsToBeFixed.clear();
        }
        return somethingCleared;
    }

    public synchronized void addIssues(Map<ParserDependency, List<Issue>> parserDependencyToIssues) {
        assert (parserDependencyToIssues != null) : "Parameter 'parserDependencyToIssues' of method 'addIssues' must not be null";
        this.m_parserDependencyToIssues.putAll(parserDependencyToIssues);
    }

    public synchronized void addViolationsToBeFixed(Collection<ParserDependency> toBeFixed) {
        assert (toBeFixed != null && !toBeFixed.isEmpty()) : "Parameter 'toBeFixed' of method 'addViolationsToBeFixed' must not be empty";
        this.m_violationsToBeFixed.addAll(toBeFixed);
    }

    public synchronized void addViolationsIgnored(Collection<ParserDependency> ignoring) {
        assert (ignoring != null && !ignoring.isEmpty()) : "Parameter 'ignoring' of method 'addViolationsIgnored' must not be empty";
        this.m_violationsIgnored.addAll(ignoring);
    }

    public synchronized void addDeprecationsIgnored(Collection<ParserDependency> ignoring) {
        assert (ignoring != null && !ignoring.isEmpty()) : "Parameter 'ignoring' of method 'addDeprecationsIgnored' must not be empty";
        this.m_deprecationsIgnored.addAll(ignoring);
    }

    public synchronized void addDeprecationsToBeFixed(Collection<ParserDependency> toBeFixed) {
        assert (toBeFixed != null && !toBeFixed.isEmpty()) : "Parameter 'ignoring' of method 'addDeprecationsToBeFixed' must not be empty";
        this.m_deprecationsToBeFixed.addAll(toBeFixed);
    }

    public synchronized Map<ParserDependency, Set<String>> getViolations(boolean includeIgnored) {
        if (includeIgnored || this.m_violationsIgnored.isEmpty() || this.m_violationToCauses.isEmpty()) {
            return Collections.unmodifiableMap(this.m_violationToCauses);
        }
        THashMap nonIgnored = new THashMap();
        for (Map.Entry<ParserDependency, Set<String>> nextEntry : this.m_violationToCauses.entrySet()) {
            ParserDependency nextParserDependency = nextEntry.getKey();
            if (this.m_violationsIgnored.contains(nextParserDependency)) continue;
            nonIgnored.put(nextParserDependency, nextEntry.getValue());
        }
        return nonIgnored;
    }

    public synchronized Map<ParserDependency, Set<String>> getDeprecations(boolean includeIgnored) {
        if (includeIgnored || this.m_deprecationsIgnored.isEmpty() || this.m_deprecationToCauses.isEmpty()) {
            return Collections.unmodifiableMap(this.m_deprecationToCauses);
        }
        THashMap nonIgnored = new THashMap();
        for (Map.Entry<ParserDependency, Set<String>> nextEntry : this.m_deprecationToCauses.entrySet()) {
            ParserDependency nextParserDependency = nextEntry.getKey();
            if (this.m_deprecationsIgnored.contains(nextParserDependency)) continue;
            nonIgnored.put(nextParserDependency, nextEntry.getValue());
        }
        return nonIgnored;
    }

    public synchronized boolean addArchitectureViolation(List<ParserDependency> parserDependencies, String cause) {
        assert (parserDependencies != null && !parserDependencies.isEmpty()) : "Parameter 'parserDependencies' of method 'addArchitectureViolation' must not be empty";
        assert (cause != null && cause.length() > 0) : "Parameter 'cause' of method 'addArchitectureViolation' must not be empty";
        boolean containsAtLeastOneNonIgnoredViolation = false;
        for (ParserDependency nextParserDependency : parserDependencies) {
            THashSet nextCauses = this.m_violationToCauses.get(nextParserDependency);
            if (nextCauses == null) {
                nextCauses = new THashSet();
                this.m_violationToCauses.put(nextParserDependency, (Set<String>)nextCauses);
            }
            nextCauses.add((String)cause);
            if (containsAtLeastOneNonIgnoredViolation || this.m_violationsIgnored.contains(nextParserDependency)) continue;
            containsAtLeastOneNonIgnoredViolation = true;
        }
        return containsAtLeastOneNonIgnoredViolation;
    }

    public synchronized void addArchitectureDeprecation(List<ParserDependency> parserDependencies, String cause) {
        assert (parserDependencies != null && !parserDependencies.isEmpty()) : "Parameter 'parserDependencies' of method 'addArchitectureDeprecation' must not be empty";
        assert (cause != null && cause.length() > 0) : "Parameter 'cause' of method 'addArchitectureDeprecation' must not be empty";
        for (ParserDependency nextParserDependency : parserDependencies) {
            THashSet nextCauses = this.m_deprecationToCauses.get(nextParserDependency);
            if (nextCauses == null) {
                nextCauses = new THashSet();
                this.m_deprecationToCauses.put(nextParserDependency, (Set<String>)nextCauses);
            }
            nextCauses.add((String)cause);
        }
    }

    public synchronized ParserDependencyNumbers getParserDependencyNumbers(int numberOfParserDependencies) {
        int violations = 0;
        int ignoredViolations = 0;
        if (!this.m_violationToCauses.isEmpty()) {
            if (this.m_violationsIgnored.isEmpty()) {
                violations = this.m_violationToCauses.size();
                ignoredViolations = 0;
            } else {
                for (ParserDependency nextDependency : this.m_violationToCauses.keySet()) {
                    if (!this.m_violationsIgnored.contains(nextDependency)) continue;
                    ++ignoredViolations;
                }
                violations = this.m_violationToCauses.size() - ignoredViolations;
            }
        }
        int deprecations = 0;
        int ignoredDeprecations = 0;
        if (!this.m_deprecationToCauses.isEmpty()) {
            if (this.m_deprecationsIgnored.isEmpty()) {
                deprecations = this.m_deprecationToCauses.size();
                ignoredDeprecations = 0;
            } else {
                for (ParserDependency nextDependency : this.m_deprecationToCauses.keySet()) {
                    if (!this.m_deprecationsIgnored.contains(nextDependency)) continue;
                    ++ignoredDeprecations;
                }
                deprecations = this.m_deprecationToCauses.size() - ignoredDeprecations;
            }
        }
        return new ParserDependencyNumbers(numberOfParserDependencies, violations, ignoredViolations, deprecations, ignoredDeprecations);
    }

    public synchronized Collection<Issue> getIssues(ParserDependency parserDependency) {
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'getIssues' must not be null";
        return this.m_parserDependencyToIssues.get(parserDependency);
    }

    public synchronized boolean hasViolations() {
        return !this.m_violationToCauses.isEmpty();
    }

    public synchronized Set<ParserDependency> getViolating() {
        return new THashSet(this.m_violationToCauses.keySet());
    }

    public synchronized Set<ParserDependency> getViolatingIgnored() {
        return new THashSet(this.m_violationsIgnored);
    }

    public synchronized Set<ParserDependency> getViolatingToBeFixed() {
        return new THashSet(this.m_violationsToBeFixed);
    }

    private CausesAndResolutionInfo.Resolution getResolution(ParserDependency parserDependency, Set<ParserDependency> toBeFixed, Set<ParserDependency> ignored) {
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'getResolution' must not be null";
        assert (toBeFixed != null) : "Parameter 'toBeFixed' of method 'getResolution' must not be null";
        assert (ignored != null) : "Parameter 'ignored' of method 'getResolution' must not be null";
        if (toBeFixed.contains(parserDependency)) {
            return CausesAndResolutionInfo.Resolution.FIX;
        }
        return ignored.contains(parserDependency) ? CausesAndResolutionInfo.Resolution.IGNORE : CausesAndResolutionInfo.Resolution.NONE;
    }

    public synchronized ViolationInfo isViolation(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'isViolation' must not be null";
        Set<String> causes = this.m_violationToCauses.get(dependency);
        return causes != null ? new ViolationInfo(causes, this.getResolution(dependency, this.m_violationsToBeFixed, this.m_violationsIgnored)) : null;
    }

    public synchronized DeprecationInfo isDeprecation(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'isDeprecation' must not be null";
        Set<String> causes = this.m_deprecationToCauses.get(dependency);
        return causes != null ? new DeprecationInfo(causes, this.getResolution(dependency, this.m_deprecationsToBeFixed, this.m_deprecationsIgnored)) : null;
    }
}

