/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureProviderId;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactClass;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureCheckStatusProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureDefinitionElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.RequiredConnection;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedExternal;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedInternal;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.EditableModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ArchitectureFile
extends EditableModifiableFile
implements ISoftwareSystemDefinitionElement,
IArchitectureDefinitionElement,
IArchitectureElementContainer,
IArchitectureCheckStatusProvider,
IDomainRoot,
IArchitecturalModelProvider,
IPhysicalArchitectureElement {
    private final Set<RequiredConnection> m_requiredConnections = new THashSet();
    private List<Artifact> m_sortedArtifacts;
    private List<Artifact> m_allArtifacts;
    private Boolean m_canBeChecked;
    private String m_content;
    private IArchitecturalModelProvider.ArchitectureModel m_model = IArchitecturalModelProvider.ArchitectureModel.PHYSICAL;
    private IProviderId m_issueProviderId;
    private boolean m_modelLoaded;
    private boolean m_usedInApplyOrRequire;
    private boolean m_checked;
    private boolean m_hasViolations;
    private boolean m_hasDeprecations;

    public ArchitectureFile(NamedElement parent, TFile file, long timestamp, IModifiablePathListener listener) {
        super(parent, file, listener);
        this.setTimestamp(timestamp);
        this.m_content = "";
        this.m_issueProviderId = new ArchitectureProviderId(this.getIdentifyingPath());
    }

    public ArchitectureFile(NamedElement parent, TFile file, long timestamp, IModifiablePathListener listener, String content) {
        super(parent, file, listener);
        assert (content != null) : "Parameter 'content' of method 'ArchitectureFile' must not be null";
        this.setTimestamp(timestamp);
        this.m_content = content;
        this.m_issueProviderId = new ArchitectureProviderId(this.getIdentifyingPath());
    }

    public ArchitectureFile(NamedElement parent, ArchitectureFile other) {
        super(parent, other);
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public String getInformation() {
        return this.m_model.getPresentationName() + (this.isChecked() ? ", Checked" : "");
    }

    @Override
    public IArchitecturalModelProvider.ArchitectureModel getModel() {
        return this.m_model;
    }

    @Override
    public String getFullFileName(String proposedName) {
        return proposedName + CoreFileType.ARCHITECTURE.getDefaultExtension();
    }

    public void setModel(IArchitecturalModelProvider.ArchitectureModel model) {
        assert (model != null) : "Parameter 'model' of method 'setModel' must not be null";
        if (!this.m_model.equals((Object)model)) {
            this.m_model = model;
            if (this.m_checked) {
                this.getUniqueExistingChild(UnassignedInternal.class).setModel(this.m_model);
                this.getUniqueExistingChild(UnassignedExternal.class).setModel(this.m_model);
            }
            this.additionalInformationModified();
        }
    }

    public Collection<Artifact> getArtifacts() {
        if (this.m_allArtifacts == null) {
            this.m_allArtifacts = new ArrayList<Artifact>();
            for (Artifact artifact : this.getChildren(Artifact.class)) {
                this.m_allArtifacts.add(artifact);
                artifact.collectNestedArtifacts(this.m_allArtifacts);
            }
        }
        return this.m_allArtifacts;
    }

    public void addRequiredConnection(RequiredConnection requiredConnection) {
        assert (requiredConnection != null) : "Parameter 'requiredConnection' of method 'addRequiredConnection' must not be null";
        this.m_requiredConnections.add(requiredConnection);
    }

    public Collection<RequiredConnection> getRequiredConnections() {
        return Collections.unmodifiableCollection(this.m_requiredConnections);
    }

    @Override
    public ArchitectureFile getContainer() {
        return this;
    }

    public IProviderId getIssueProviderId() {
        return this.m_issueProviderId;
    }

    @Override
    public String getDomainInfo() {
        return this.getIdentifyingPath() + " [" + this.getDomain().getPresentationName() + "]";
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return this.m_model.getDomain();
    }

    @Override
    public void setPath(TFile path) {
        super.setPath(path);
        this.m_issueProviderId = new ArchitectureProviderId(this.getIdentifyingPath());
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.ARCHITECTURE;
    }

    @Override
    public String getEditName() {
        return FileUtility.getFileNameWithoutExtension((TFile)this.getFile());
    }

    @Override
    public List<String> getApplyNames() {
        String identifyingPath = this.getIdentifyingPath();
        ArrayList<String> applyNames = new ArrayList<String>(4);
        String defaultApplyname = FileUtility.removeExtension((String)identifyingPath);
        applyNames.add(defaultApplyname);
        applyNames.add(defaultApplyname.substring("./".length()));
        applyNames.add(identifyingPath);
        applyNames.add(identifyingPath.substring("./".length()));
        return applyNames;
    }

    private String getNewApplyName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getNewApplyName' must not be empty";
        String currentApplyName = this.getApplyNames().get(1);
        int pos = currentApplyName.lastIndexOf("/");
        if (pos == -1) {
            return name;
        }
        return currentApplyName.substring(0, pos + 1) + name;
    }

    @Override
    public Map<String, String> getNameChangeMap(String newName) {
        String applyName = this.getNewApplyName(newName);
        HashMap<String, String> nameChangeMap = new HashMap<String, String>();
        for (String name : this.getApplyNames()) {
            nameChangeMap.put(name, applyName);
        }
        return nameChangeMap;
    }

    @Override
    public Map<String, String> getNameChangeMapForMove(String newParentPath) {
        HashMap<String, String> nameChangeMap = new HashMap<String, String>();
        if (newParentPath.startsWith("./")) {
            newParentPath = newParentPath.substring("./".length());
        }
        Object newApplyName = newParentPath.isEmpty() ? FileUtility.removeExtension((String)this.getShortName()) : newParentPath + FileUtility.removeExtension((String)this.getShortName());
        for (String name : this.getApplyNames()) {
            nameChangeMap.put(name, (String)newApplyName);
        }
        return nameChangeMap;
    }

    @Override
    public TFile getTargetFile(String newName) {
        TFile parentDir = this.getParent(DirectoryPath.class, new Class[0]).getFile();
        return new TFile((File)parentDir, newName + CoreFileType.ARCHITECTURE.getDefaultExtension());
    }

    @Override
    public String getPresentationKind() {
        return "Architecture File";
    }

    @Override
    public <T> T getArchitectureElement(String name, Class<T> clazz) {
        return this.getFirstChild(new ShortNameFilter(name), clazz);
    }

    @Override
    public <T> T resolveName(String name, Class<T> clazz) {
        return this.getFirstChild(new ShortNameFilter(name), clazz);
    }

    public void setContent(String content, boolean modified) {
        assert (content != null) : "Parameter 'content' of method 'setContent' must not be null";
        this.m_content = content;
        if (modified) {
            this.modified();
        }
    }

    public String getContent() {
        return this.m_content;
    }

    public void modelLoaded(boolean loaded) {
        if (this.m_modelLoaded != loaded) {
            this.m_modelLoaded = loaded;
            this.additionalInformationModified();
        }
    }

    public boolean modelLoaded() {
        return this.m_modelLoaded;
    }

    public void usedInApplyOrRequire(boolean used) {
        if (this.m_usedInApplyOrRequire != used) {
            this.m_usedInApplyOrRequire = used;
            this.additionalInformationModified();
        }
    }

    @Property
    public boolean usedInApplyOrRequire() {
        return this.m_usedInApplyOrRequire;
    }

    public void checked(boolean checked) {
        if (this.m_checked != checked) {
            this.m_checked = checked;
            if (this.m_checked) {
                this.addChild(new UnassignedInternal(this, this.m_model));
                this.addChild(new UnassignedExternal(this, this.m_model));
            } else {
                this.removeChildren(UnassignedElements.class);
            }
            this.additionalInformationModified();
        }
    }

    @Override
    public boolean isChecked() {
        return this.m_checked;
    }

    public boolean canBeChecked() {
        if (this.m_canBeChecked == null) {
            this.m_canBeChecked = this.getChildrenRecursively(Artifact.class, new Class[0]).stream().noneMatch(a -> a.isRequired());
        }
        return this.m_canBeChecked;
    }

    @Property
    public String getCheckability() {
        if (this.isChecked()) {
            return null;
        }
        return this.canBeChecked() ? "Can be added to Architecture Check" : "Cannot be added to Architecture Check";
    }

    @Override
    public final boolean hasViolations() {
        return this.m_hasViolations;
    }

    @Override
    public final void setHasViolations(boolean hasViolations) {
        this.m_hasViolations = hasViolations;
    }

    @Override
    public final boolean hasDeprecations() {
        return this.m_hasDeprecations;
    }

    @Override
    public final void setHasDeprecations(boolean hasDeprecations) {
        this.m_hasDeprecations = hasDeprecations;
    }

    public List<Artifact> getArtifactsByPriority() {
        if (this.m_sortedArtifacts == null) {
            List<Artifact> children = this.getChildren(Artifact.class);
            this.m_sortedArtifacts = new ArrayList<Artifact>(children.size());
            THashMap orderMap = new THashMap();
            int i = 0;
            while (i < children.size()) {
                orderMap.put(children.get(i), i);
                ++i;
            }
            children.sort((arg_0, arg_1) -> ArchitectureFile.lambda$1((Map)orderMap, arg_0, arg_1));
            this.m_sortedArtifacts = children;
        }
        return Collections.unmodifiableList(this.m_sortedArtifacts);
    }

    public void clear(boolean clearAssignmentOnly) {
        this.m_sortedArtifacts = null;
        this.m_allArtifacts = null;
        this.m_canBeChecked = null;
        if (!clearAssignmentOnly) {
            this.removeIssues();
            this.removeChildren(IArchitectureElement.class, ConnectionScheme.class, ArtifactClass.class);
            this.modelLoaded(false);
            this.usedInApplyOrRequire(false);
            this.m_hasViolations = false;
            this.m_hasDeprecations = false;
            this.m_requiredConnections.clear();
        }
    }

    @Override
    public boolean hasUnresolvedErrorIssues() {
        return this.m_hasViolations || super.hasUnresolvedErrorIssues();
    }

    @Override
    public boolean hasUnresolvedWarningIssues() {
        return this.m_hasDeprecations || super.hasUnresolvedWarningIssues();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArchitectureFile(this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ int lambda$1(Map map, Artifact c1, Artifact c2) {
        return c1.getPriority() == c2.getPriority() ? (Integer)map.get(c1) - (Integer)map.get(c2) : c2.getPriority() - c1.getPriority();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArchitectureFile(ArchitectureFile var1);
    }
}

