/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerIdImplementation;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurationCreator;
import com.hello2morrow.sonargraph.core.model.analysis.LogicalToplevelElementCyclesAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.QualityGateCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScmAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.SystemDiffAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ThresholdAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public enum CoreAnalyzerId implements IConfigurableAnalyzerId
{
    SIZE_METRICS(SonargraphFeature.PLATFORM, "Size Metrics", "Calculates size metrics", null, AnalyzerExecutionLevel.MINIMAL, AnalyzerGroup.SIZE_METRICS, Arrays.asList(AnalyzerGroup.ARCHITECTURE_METRICS, AnalyzerGroup.COMPLEXITY_METRICS, AnalyzerGroup.THRESHOLDS)),
    ARCHITECTURE_CHECK(SonargraphFeature.ARCHITECTURE, "Architecture Check", "Checks for architecture violations", ArchitectureCheckConfiguration.CREATOR, AnalyzerExecutionLevel.MINIMAL, AnalyzerGroup.ARCHITECTURE, Arrays.asList(AnalyzerGroup.ARCHITECTURE_METRICS)),
    METRIC_THRESHOLDS(SonargraphFeature.PLATFORM, "Metric Thresholds", "Checks for metric threshold violations", ThresholdAnalyzerConfiguration.CREATOR, AnalyzerExecutionLevel.MINIMAL, AnalyzerGroup.THRESHOLDS, Collections.singletonList(AnalyzerGroup.COMPLEXITY_METRICS)),
    CODE_ORGANIZATION(SonargraphFeature.PLATFORM, "Code Organization", "Checks for code in large files", null, AnalyzerExecutionLevel.MINIMAL, AnalyzerGroup.THRESHOLDS, Collections.emptyList()),
    MODULE_CYCLES_SYSTEM(SonargraphFeature.PLATFORM, "Module Cycles", "Analyzes module cycles on system level", CycleAnalyzerConfiguration.CREATOR_MODULE_CYCLES, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS, AnalyzerGroup.ENTANGLEMENT)),
    COHESION_AND_COUPLING_METRICS_SYSTEM(SonargraphFeature.COHESION_AND_COUPLING_METRICS, "Cohesion and Coupling Metrics (System)", "Calculates cohesion and coupling metrics on system level", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    COHESION_AND_COUPLING_METRICS_MODULE(SonargraphFeature.COHESION_AND_COUPLING_METRICS, "Cohesion and Coupling Metrics (Module)", "Calculates cohesion and coupling metrics on module level", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    AVERAGE_COMPLEXITY_METRICS(SonargraphFeature.PLATFORM, "Average Complexity Metrics", "Calculates average complexity metrics", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.COMPLEXITY_METRICS, Collections.emptyList()),
    COMPLEXITY_SYSTEM_METRICS(SonargraphFeature.PLATFORM, "System Complexity Metrics", "Calculates system complexity metrics", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.COMPLEXITY_METRICS, Collections.emptyList()),
    ARCHITECTURE_SOURCECODE_METRICS(SonargraphFeature.PLATFORM, "Architecture Metrics", "Computes metrics related to source code and architecture violations", null, AnalyzerExecutionLevel.BASIC, AnalyzerGroup.ARCHITECTURE_METRICS, Collections.emptyList()),
    COMPONENT_CYCLES_SYSTEM(SonargraphFeature.PLATFORM, "Component Cycles (System)", "Analyzes component / compilation unit cycles on system level", CycleAnalyzerConfiguration.CREATOR_COMPONENT_CYCLES, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS, AnalyzerGroup.ENTANGLEMENT)),
    COMPONENT_CYCLES_SYSTEM_METRICS(SonargraphFeature.PLATFORM, "Component Cycle Metrics (System)", "Computes component cycle metrics on system level", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.CYCLE_METRICS, Collections.singletonList(AnalyzerGroup.ENTANGLEMENT)),
    COMPONENT_CYCLES_MODULE(SonargraphFeature.PLATFORM, "Component Cycles (Module)", "Analyzes component / compilation unit cycles on module level", CycleAnalyzerConfiguration.CREATOR_COMPONENT_CYCLES, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.CYCLES, Arrays.asList(AnalyzerGroup.CYCLE_METRICS, AnalyzerGroup.ENTANGLEMENT)),
    COMPONENT_CYCLES_MODULE_METRICS(SonargraphFeature.PLATFORM, "Component Cycle Metrics (Module)", "Computes component cycle metrics on module level", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.CYCLE_METRICS, Collections.singletonList(AnalyzerGroup.ENTANGLEMENT)),
    LOGICAL_TOPLEVEL_ELEMENT_CYCLES(SonargraphFeature.PLATFORM, "Logical Toplevel Element Cycles", "Analyzes logical toplevel element cycles", LogicalToplevelElementCyclesAnalyzerConfiguration.CREATOR_LOGICAL_TOPLEVEL_ELEMENT_CYCLES, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.CYCLES, Collections.singletonList(AnalyzerGroup.ENTANGLEMENT)),
    ENTANGLEMENT(SonargraphFeature.PLATFORM, "Entanglement", "Calculates summary metrics about entangled code", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.ENTANGLEMENT, Collections.emptyList()),
    INCOMING_DEPENDENCY_METRICS_SYSTEM(SonargraphFeature.PLATFORM, "Incoming Dependency Metrics (System)", "Calculates incoming dependency metrics on system level", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    OUTGOING_DEPENDENCY_METRICS_SYSTEM(SonargraphFeature.PLATFORM, "Ougoing Dependency Metrics (System)", "Calculates outgoing dependency metrics on system level", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    INCOMING_DEPENDENCY_METRICS_MODULE(SonargraphFeature.PLATFORM, "Incoming Dependency Metrics (Module)", "Calculates incoming dependency metrics on module level", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    OUTGOING_DEPENDENCY_METRICS_MODULE(SonargraphFeature.PLATFORM, "Ougoing Dependency Metrics (Module)", "Calculates outgoing dependency metrics on module level", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    MAINTAINABILITY_LEVEL(SonargraphFeature.PLATFORM, "Maintainability Level", "Calculates maintainability level metrics", null, AnalyzerExecutionLevel.ADVANCED, AnalyzerGroup.DEPENDENCY_METRICS, Collections.emptyList()),
    DUPLICATE_CODE(SonargraphFeature.DUPLICATE_CODE, "Duplicate Code", "Search duplicate code on system level", DuplicateCodeAnalyzerConfiguration.CREATOR, AnalyzerExecutionLevel.FULL, AnalyzerGroup.DUPLICATE_CODE, Arrays.asList(AnalyzerGroup.DUPLICATE_CODE_METRICS)),
    DUPLICATE_CODE_METRICS(SonargraphFeature.DUPLICATE_CODE, "Duplicate Code Metrics", "Calculates duplicate code metrics", null, AnalyzerExecutionLevel.FULL, AnalyzerGroup.DUPLICATE_CODE_METRICS, Collections.emptyList()),
    SCM_METRICS(SonargraphFeature.ARCHITECTURE, "SCM Metrics", "Calculates source code management based metrics", ScmAnalyzerConfiguration.CREATOR, AnalyzerExecutionLevel.FULL, AnalyzerGroup.SCM, Arrays.asList(AnalyzerGroup.SCRIPTS)),
    SCRIPT_RUNNER(SonargraphFeature.SCRIPTS_AUTOMATED, "Script Runner", "Runs scripts configured for automated execution", ScriptRunnerConfiguration.CREATOR, AnalyzerExecutionLevel.FULL, AnalyzerGroup.SCRIPTS, Arrays.asList(AnalyzerGroup.ISSUE_DENSITY, AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.QUALITY_GATE)),
    ISSUE_DENSITY(SonargraphFeature.ARCHITECTURE, "Issue Density", "Calculates issue density per 1000 source elements", null, AnalyzerExecutionLevel.FULL, AnalyzerGroup.ISSUE_DENSITY, Arrays.asList(AnalyzerGroup.SYSTEM_DIFF, AnalyzerGroup.ISSUE_RANKING)),
    SYSTEM_DIFF(SonargraphFeature.ARCHITECTURE, "System Diff", "Computes the system diff against a baseline", SystemDiffAnalyzerConfiguration.CREATOR, AnalyzerExecutionLevel.FULL, AnalyzerGroup.SYSTEM_DIFF, Arrays.asList(AnalyzerGroup.QUALITY_GATE, AnalyzerGroup.ISSUE_RANKING)),
    ISSUE_RANKING(SonargraphFeature.ARCHITECTURE, "Issue Ranking", "Computes urgency and importance of issues and ranks them globally", null, AnalyzerExecutionLevel.FULL, AnalyzerGroup.ISSUE_RANKING, Collections.emptyList()),
    QUALITY_GATES(SonargraphFeature.ARCHITECTURE, "Quality Gate", "Checks compliance against defined quality gates", QualityGateCheckConfiguration.CREATOR, AnalyzerExecutionLevel.FULL, AnalyzerGroup.QUALITY_GATE, Collections.emptyList());

    private final AnalyzerIdImplementation m_implementation;

    private CoreAnalyzerId(SonargraphFeature feature, String presentationName, String description, IConfigurationCreator creator, AnalyzerExecutionLevel level, AnalyzerGroup group, List<AnalyzerGroup> affectedGroups) {
        this.m_implementation = new AnalyzerIdImplementation(feature, presentationName, description, creator, level, group, affectedGroups);
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_implementation.getPresentationName();
    }

    @Override
    public String getDescription() {
        return this.m_implementation.getDescription();
    }

    @Override
    public boolean hasConfiguration() {
        return this.m_implementation.hasConfiguration();
    }

    @Override
    public IConfigurationCreator getConfigurationCreator() {
        return this.m_implementation.getConfigurationCreator();
    }

    @Override
    public Language getLanguage() {
        return null;
    }

    @Override
    public SonargraphFeature getFeature() {
        return this.m_implementation.getFeature();
    }

    @Override
    public AnalyzerExecutionLevel getExecutionLevel() {
        return this.m_implementation.getExecutionLevel();
    }

    @Override
    public AnalyzerGroup getGroup() {
        return this.m_implementation.getGroup();
    }

    @Override
    public Set<AnalyzerGroup> getAffectedGroups() {
        return this.m_implementation.getAffectedGroups();
    }
}

