/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.AlignmentLine;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapLayout;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HorizontalLayout<E, D>
extends TreeMapLayout<E, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HorizontalLayout.class);

    HorizontalLayout() {
    }

    private List<TreeMapNode<E, D>> sortChildrenForAlignment(List<TreeMapNode<E, D>> children) {
        assert (children != null && !children.isEmpty()) : "Parameter 'children' of method 'sortChildrenForAlignment' must not be empty";
        return children.parallelStream().sorted(Comparator.comparingInt(TreeMapNode::getHeight).thenComparing(TreeMapNode::getWidth).reversed()).collect(Collectors.toList());
    }

    private void layoutChildrenOfNonLeaf(TreeMapNode<E, D> node) {
        assert (node != null) : "Parameter 'node' of method 'layoutChildrenOfNonLeaf' must not be null";
        assert (!node.isLeaf()) : "Is leaf: " + String.valueOf(node);
        assert (node.hasChildren()) : "Non leaf must have children: " + String.valueOf(node);
        LOGGER.debug("Layout children of '" + String.valueOf(node) + "'");
        List<TreeMapNode<E, D>> currentChildren = this.sortChildrenForAlignment(node.getChildren());
        float totalArea = (float)currentChildren.parallelStream().mapToDouble(c -> c.getWidth() * c.getHeight()).sum();
        float aspectRatio = 1.6f;
        int ceiledSqrtOfTotalArea = (int)Math.ceil(Math.sqrt(totalArea * 1.6f));
        int ceiledNumberOfChildrenInSquare = (int)Math.ceil(Math.sqrt(currentChildren.size()));
        int widthOfAlignmentLines = Math.max(ceiledSqrtOfTotalArea + (ceiledNumberOfChildrenInSquare + 1) * 2, currentChildren.get(0).getWidth());
        MainHorizontalAlignmentLine<E, D> currentAlignmentLine = new MainHorizontalAlignmentLine<E, D>(2, 2, widthOfAlignmentLines, currentChildren.get(0).getHeight());
        while (!currentChildren.isEmpty()) {
            assert (currentChildren.get(0).getWidth() <= currentAlignmentLine.getLength());
            assert (currentChildren.get(0).getHeight() <= currentAlignmentLine.getHeight());
            if ((currentChildren = currentAlignmentLine.align(currentChildren)).isEmpty()) continue;
            currentChildren = this.sortChildrenForAlignment(currentChildren);
            currentAlignmentLine = new MainHorizontalAlignmentLine(2, currentAlignmentLine.getRelativeY() + currentAlignmentLine.getHeight() + 2, widthOfAlignmentLines, currentChildren.get(0).getHeight());
        }
        int width = 0;
        int height = 0;
        for (TreeMapNode<E, D> nextChild : node.getChildren()) {
            width = Math.max(nextChild.getRelativeX() + nextChild.getWidth(), width);
            height = Math.max(nextChild.getRelativeY() + nextChild.getHeight(), height);
        }
        node.setDimensions(width + 2, height + 2);
        LOGGER.debug("Calculated dimensions of non-leaf '" + String.valueOf(node) + "'");
        LOGGER.debug("Layout children of '" + String.valueOf(node) + "' - done");
    }

    @Override
    void layout(TreeMap<E, D> treeMap, float minimumSize) {
        assert (treeMap != null) : "Parameter 'treeMap' of method 'layout' must not be null";
        final TreeSet nonLeafNodes = new TreeSet(new Comparator<TreeMapNode<E, D>>(){

            @Override
            public int compare(TreeMapNode<E, D> n1, TreeMapNode<E, D> n2) {
                if (!$assertionsDisabled && n1 == null) {
                    throw new AssertionError((Object)"Parameter 'n1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && n2 == null) {
                    throw new AssertionError((Object)"Parameter 'n2' of method 'compare' must not be null");
                }
                int levelDelta = n2.getLevel() - n1.getLevel();
                if (levelDelta != 0) {
                    return levelDelta;
                }
                float sizeDelta = n2.getSize() - n1.getSize();
                if (sizeDelta != 0.0f) {
                    return sizeDelta < 0.0f ? -1 : 1;
                }
                if (n1.equals(n2)) {
                    return 0;
                }
                return 1;
            }
        });
        final float sizeFactor = minimumSize != 1.0f ? 1.0f / minimumSize : 1.0f;
        treeMap.accept(new TreeMapNode.IVisitor<E, D>(){

            @Override
            public boolean visitNode(TreeMapNode<E, D> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'visitNode' must not be null");
                }
                if (!node.isLeaf()) {
                    nonLeafNodes.add(node);
                } else {
                    int side = HorizontalLayout.this.calculateSquareLengthOfSide(node, sizeFactor);
                    node.setDimensions(side, side);
                }
                return true;
            }
        });
        nonLeafNodes.forEach(n -> this.layoutChildrenOfNonLeaf((TreeMapNode<E, D>)n));
    }

    private static final class AuxiliaryHorizontalAlignmentLine<E, D>
    extends HorizontalAlignmentLine<E, D> {
        AuxiliaryHorizontalAlignmentLine(int x, int y, int width, int height) {
            super(x, y, width, height);
        }
    }

    private static abstract class HorizontalAlignmentLine<E, D>
    extends AlignmentLine<E, D> {
        private final int m_height;

        HorizontalAlignmentLine(int x, int y, int width, int height) {
            super(x, y, width);
            assert (height > 0) : "'height' must be greater than 0";
            this.m_height = height;
        }

        @Override
        final AlignmentLine.Direction getDirection() {
            return AlignmentLine.Direction.HORIZONTAL;
        }

        final int getHeight() {
            return this.m_height;
        }

        @Override
        public final String toString() {
            return super.toString() + ", height:" + this.m_height;
        }
    }

    private static final class MainHorizontalAlignmentLine<E, D>
    extends HorizontalAlignmentLine<E, D> {
        private final ArrayDeque<AuxiliaryHorizontalAlignmentLine<E, D>> m_auxiliaryAlignmentLines = new ArrayDeque();

        MainHorizontalAlignmentLine(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        private void addAuxAlignmentLineIfPossible(TreeMapNode<E, D> addedNode, HorizontalAlignmentLine<E, D> toLine) {
            assert (addedNode != null) : "Parameter 'addedNode' of method 'addAuxAlignmentLineIfPossible' must not be null";
            assert (toLine != null) : "Parameter 'toLine' of method 'addAuxAlignmentLineIfPossible' must not be null";
            int leftoverHeight = toLine.getHeight() - addedNode.getRelativeY() + toLine.getRelativeY() - addedNode.getHeight();
            if (leftoverHeight > 2) {
                this.m_auxiliaryAlignmentLines.add(new AuxiliaryHorizontalAlignmentLine(addedNode.getRelativeX(), addedNode.getRelativeY() + addedNode.getHeight() + 2, addedNode.getWidth(), leftoverHeight - 2));
            }
        }

        private boolean process(TreeMapNode<E, D> node) {
            assert (node != null) : "Parameter 'node' of method 'process' must not be null";
            assert (node.hasDimensions()) : "Has no dimensions set: " + String.valueOf(node);
            if (this.getUsedLength() + node.getWidth() <= this.getLength()) {
                int x = this.getRelativeX() + this.getUsedLength();
                int y = this.getRelativeY();
                node.setLocation(x, y);
                this.incrementUsedLength(node.getWidth() + 2);
                this.addAuxAlignmentLineIfPossible(node, this);
                return true;
            }
            if (!this.m_auxiliaryAlignmentLines.isEmpty()) {
                Iterator<AuxiliaryHorizontalAlignmentLine<E, D>> iterator = this.m_auxiliaryAlignmentLines.iterator();
                while (iterator.hasNext()) {
                    HorizontalAlignmentLine nextAuxLine = iterator.next();
                    if (nextAuxLine.getHeight() < node.getHeight() || nextAuxLine.getUsedLength() + node.getWidth() > nextAuxLine.getLength()) continue;
                    int x = nextAuxLine.getRelativeX() + nextAuxLine.getUsedLength();
                    int y = nextAuxLine.getRelativeY();
                    node.setLocation(x, y);
                    nextAuxLine.incrementUsedLength(node.getWidth() + 2);
                    if (nextAuxLine.getUsedLength() + 2 >= nextAuxLine.getLength()) {
                        iterator.remove();
                    }
                    this.addAuxAlignmentLineIfPossible(node, nextAuxLine);
                    return true;
                }
            }
            return false;
        }

        List<TreeMapNode<E, D>> align(List<TreeMapNode<E, D>> nodes) {
            assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'align' must not be empty";
            TreeMapNode<E, D> firstNode = nodes.get(0);
            assert (firstNode.hasDimensions()) : "Has no dimensions set: " + String.valueOf(firstNode);
            assert (firstNode.getWidth() <= this.getLength()) : "Not enough length for first node: " + String.valueOf(firstNode);
            firstNode.setLocation(this.getRelativeX(), this.getRelativeY());
            this.incrementUsedLength(firstNode.getWidth() + 2);
            nodes.remove(0);
            Iterator<TreeMapNode<E, D>> iterator = nodes.iterator();
            while (iterator.hasNext()) {
                TreeMapNode<E, D> nextNode = iterator.next();
                if (!this.process(nextNode)) continue;
                iterator.remove();
            }
            this.m_auxiliaryAlignmentLines.clear();
            return nodes;
        }
    }
}

