/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controllerinterface.system;

import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemProviderCreator;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SoftwareSystemProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoftwareSystemProviderFactory.class);
    private static final String PROPERTIES = "SoftwareSystemProviderFactory.properties";

    private SoftwareSystemProviderFactory() {
    }

    public static ISoftwareSystemProvider create(ILicenseProvider licenseProvider, List<ILanguageProvider> languageProviders, ScriptOutputStreamProvider outputProvider, String productStandardName, AnalyzerExecutionLevel level) {
        assert (licenseProvider != null) : "Parameter 'licenseProvider' of method 'create' must not be null";
        assert (languageProviders != null) : "Parameter 'languageProviders' of method 'create' must not be null";
        assert (outputProvider != null) : "Parameter 'outputProvider' of method 'create' must not be null";
        assert (productStandardName != null && productStandardName.length() > 0) : "Parameter 'productStandardName' of method 'create' must not be empty";
        assert (level != null) : "Parameter 'level' of method 'create' must not be null";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = SoftwareSystemProviderFactory.class.getResourceAsStream(PROPERTIES);){
                Object creator;
                block25: {
                    assert (in != null) : "Properties could not be found: SoftwareSystemProviderFactory.properties";
                    Properties properties = new Properties();
                    properties.load(in);
                    String creatorClass = properties.getProperty(productStandardName);
                    assert (creatorClass != null && creatorClass.length() > 0) : "No value found for product '" + productStandardName + "'";
                    LOGGER.debug("Using creator class: " + creatorClass);
                    creator = null;
                    try {
                        Class<?> clazz = Class.forName(creatorClass);
                        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                        creator = ctor.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        LOGGER.error(ExceptionUtility.collectAll((Throwable)e));
                        assert (false) : ExceptionUtility.collectAll((Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error(ExceptionUtility.collectAll((Throwable)e));
                        if ($assertionsDisabled) break block25;
                        throw new AssertionError((Object)ExceptionUtility.collectAll((Throwable)e));
                    }
                }
                assert (creator != null) : "Created object must not be null";
                assert (ISoftwareSystemProviderCreator.class.isAssignableFrom(creator.getClass())) : "Created object is not a subtype of '" + ISoftwareSystemProviderCreator.class.getName() + "'";
                return ((ISoftwareSystemProviderCreator)creator).create(licenseProvider, languageProviders, outputProvider, level);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error(ExceptionUtility.collectAll((Throwable)e));
            assert (false) : ExceptionUtility.collectAll((Throwable)e);
            return null;
        }
    }
}

