/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.PotentialDependencyCollector;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureItem;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;

public final class DependencyAdditionalsCollector
extends PotentialDependencyCollector {
    public DependencyAdditionalsCollector(IRepresentationProvider representationProvider, StructureInfo structureInfo, Representation representation, NamedElement elementForAdditionals, NamedElement endpoint, IDomainRoot.Domain domain) {
        super(representationProvider, structureInfo, representation, elementForAdditionals, endpoint, domain);
    }

    @Override
    public void visitProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
        if (this.getElementForAdditionals() instanceof ProgrammingElement) {
            this.addElementToCalculated(element, PotentialDependencyCollector.MatchingType.EXACT);
            this.visitChildrenOf(element);
        } else {
            this.visitNamedElement(element);
        }
    }

    @Override
    public void visitLogicalProgrammingElement(LogicalProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitProgrammingElementProxy' must not be null";
        StructureItem elementStructureItem = element.getStructureItem();
        if (this.getElementForAdditionals() instanceof LogicalProgrammingElement) {
            this.addElementToCalculated(element, PotentialDependencyCollector.MatchingType.EXACT);
            this.visitChildrenOf(element);
        } else if (this.getStructureInfo().compare(this.getReferenceStructureItem(), elementStructureItem) < 0 && !this.getCalculatedAdditionals().containsKey(element.getParent())) {
            PotentialDependencyCollector.MatchingType matchingType = PotentialDependencyCollector.MatchingType.UNMATCHED;
            NamedElement currentParent = element.getParent();
            while (currentParent != null) {
                if (currentParent.isOfStructureItem(this.getReferenceStructureItem())) {
                    matchingType = PotentialDependencyCollector.MatchingType.EXACT;
                    break;
                }
                currentParent = currentParent.getParent();
            }
            this.addElementToCalculated(element.getParent(), matchingType);
        }
    }
}

