/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollector;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.DependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class BalancedDependencyInternalCollector
extends ExtendableEndpointCollector {
    private final NamedElement m_from;
    private final NamedElement m_to;
    private final Set<NamedElement> m_fromChildren;
    private final Set<NamedElement> m_toChildren;
    private final boolean m_allowSelfDependencies;

    public BalancedDependencyInternalCollector(SoftwareSystem softwareSystem, Set<NamedElement> inputForNodeAdapterSet, NamedElement from, NamedElement to, Set<NamedElement> fromChildren, Set<NamedElement> toChildren, Map<NamedElement, NamedElement> namedElementToProxy, IDomainRoot.Domain domain, DependencyType dependencyType, boolean allowSelfDependencies) {
        super(softwareSystem, inputForNodeAdapterSet, Collections.emptySet(), namedElementToProxy, (Set<CoreParserDependencyType>)new THashSet(Arrays.asList(CoreParserDependencyType.values())), domain, PresentationMode.FLAT, true, false, EndpointType.PARSER_DEPENDENCY);
        assert (from != null) : "Parameter 'from' of method 'SymmetricDependencyInternalOrExpandCollector' must not be null";
        assert (to != null) : "Parameter 'to' of method 'SymmetricDependencyInternalOrExpandCollector' must not be null";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'SymmetricDependencyInternalOrExpandCollector' must not be null";
        assert (fromChildren != null) : "Parameter 'fromChildren' of method 'SymmetricDependencyInternalOrExpandCollector' must not be null";
        this.m_from = from;
        this.m_to = to;
        this.m_fromChildren = fromChildren;
        this.m_toChildren = toChildren;
        this.m_allowSelfDependencies = allowSelfDependencies;
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        assert (dependency != null && dependency instanceof ParserDependency) : "Unexpected class in method 'addDependency': " + String.valueOf(dependency);
        if (super.addDependency(from, to, dependency)) {
            return !(!this.m_allowSelfDependencies && from.equals(to) || !this.m_fromChildren.contains(from) || !this.m_toChildren.contains(to) || from.equals(this.m_from) && to.equals(this.m_to));
        }
        return false;
    }
}

