/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilterOperation;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EditArtifactsChangesDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditArtifactsChangesDetector.class);
    private boolean m_parentChanged;
    private boolean m_relativeParentPositionChanged;
    private boolean m_nameChanged;
    private boolean m_propertiesChanged;
    private ManualFilterOperation m_filterOperation = ManualFilterOperation.NONE;

    EditArtifactsChangesDetector(ArtifactNode artifact, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter) {
        assert (artifact != null) : "Parameter 'artifact' of method 'EditArtifactsChangesDetector' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'EditArtifactsChangesDetector' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'EditArtifactsChangesDetector' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'EditArtifactsChangesDetector' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'EditArtifactsChangesDetector' must not be null";
        assert (FilterHandler.isFilterValid(filter) == null) : "Filter not valid: " + String.valueOf(filter);
        this.m_parentChanged |= artifact.getParent() != targetInfo.getTarget();
        this.m_relativeParentPositionChanged |= artifact.getRelativeIndex() != targetInfo.getRelativeIndex();
        this.m_nameChanged |= !artifact.getShortName().equals(shortName);
        this.m_propertiesChanged |= !artifact.getIncomingDependencyMode().equals(properties.getIncomingDependencyMode());
        this.m_propertiesChanged |= !artifact.getOutgoingDependencyMode().equals(properties.getOutgoingDependencyMode());
        this.m_propertiesChanged |= !artifact.getAssignmentMode().equals(properties.getAssignmentMode());
        this.m_propertiesChanged |= !artifact.getVisibility().equals(properties.getVisibility());
        if (!artifact.hasManualFilter() && !filter.isEmpty()) {
            this.m_filterOperation = ManualFilterOperation.ADDED;
        } else if (artifact.hasManualFilter() && artifact.hasAssignedElement(false) && filter.isEmpty()) {
            this.m_filterOperation = ManualFilterOperation.REMOVED;
        } else if (!ArtifactNodeFilter.areEqual(artifact.getFilter(), filter)) {
            ManualFilterOperation manualFilterOperation = this.m_filterOperation = filter.isEmpty() ? ManualFilterOperation.REMOVED : ManualFilterOperation.MODIFIED;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.toString());
        }
    }

    EditArtifactsChangesDetector(Collection<ArtifactNode> artifacts, AssignableTargetInfo targetInfo, ArtifactProperties properties) {
        assert (artifacts != null && !artifacts.isEmpty()) : "Parameter 'artifacts' of method 'EditArtifactsChangesDetector' must not be empty";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'EditArtifactsChangesDetector' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'EditArtifactsChangesDetector' must not be null";
        IAssignableTarget targetParent = targetInfo.getTarget();
        for (ArtifactNode nextArtifact : artifacts) {
            this.m_parentChanged |= nextArtifact.getParent() != targetParent;
            this.m_propertiesChanged |= !nextArtifact.getIncomingDependencyMode().equals(properties.getIncomingDependencyMode());
            this.m_propertiesChanged |= !nextArtifact.getOutgoingDependencyMode().equals(properties.getOutgoingDependencyMode());
            this.m_propertiesChanged |= !nextArtifact.getAssignmentMode().equals(properties.getAssignmentMode());
            this.m_propertiesChanged |= !nextArtifact.getVisibility().equals(properties.getVisibility());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.toString());
        }
    }

    boolean parentChanged() {
        return this.m_parentChanged;
    }

    boolean relativeParentPositionChanged() {
        return this.m_relativeParentPositionChanged;
    }

    boolean parentOrRelativeParentPositionChanged() {
        return this.m_parentChanged || this.m_relativeParentPositionChanged;
    }

    boolean nameChanged() {
        return this.m_nameChanged;
    }

    boolean propertiesChanged() {
        return this.m_propertiesChanged;
    }

    boolean filterChanged() {
        return this.m_filterOperation != ManualFilterOperation.NONE;
    }

    ManualFilterOperation getFilterOperation() {
        return this.m_filterOperation;
    }

    boolean hasChanges() {
        return this.m_parentChanged || this.m_relativeParentPositionChanged || this.m_nameChanged || this.m_propertiesChanged || this.filterChanged();
    }

    public String toString() {
        if (!this.hasChanges()) {
            return this.getClass().getSimpleName() + " [No changes detected]";
        }
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [Changes detected]");
        if (this.m_parentChanged) {
            builder.append("\n").append("-> Parent changed");
        }
        if (this.m_relativeParentPositionChanged) {
            builder.append("\n").append("-> Relative parent position changed");
        }
        if (this.m_nameChanged) {
            builder.append("\n").append("-> Name changed");
        }
        if (this.m_propertiesChanged) {
            builder.append("\n").append("-> Properties changed");
        }
        if (this.m_filterOperation != ManualFilterOperation.NONE) {
            builder.append("\n").append("-> " + this.m_filterOperation.getPresentationName());
        }
        return builder.toString();
    }
}

