/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IProvidesCount;
import com.hello2morrow.sonargraph.core.model.explorationview.IProvidesLinesOfCode;
import com.hello2morrow.sonargraph.core.model.explorationview.IProvidesSourceElementCount;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitecturalViewNodeSorter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewNodeSorter.class);

    private static int compareAlpha(ArchitecturalViewNode n1, ArchitecturalViewNode n2) {
        boolean n2IsExternal;
        assert (n1 != null) : "Parameter 'n1' of method 'compareAlpha' must not be null";
        assert (n2 != null) : "Parameter 'n2' of method 'compareAlpha' must not be null";
        boolean n1IsExternal = n1.isExternal();
        if (n1IsExternal == (n2IsExternal = n2.isExternal())) {
            boolean n1IsArtifact = n1 instanceof ArtifactPropertiesNode;
            boolean n2IsArtifact = n2 instanceof ArtifactPropertiesNode;
            if (n1IsArtifact == n2IsArtifact) {
                return n1.getPresentationName(true).compareTo(n2.getPresentationName(true));
            }
            return n1IsArtifact ? -1 : 1;
        }
        return n1IsExternal ? 1 : -1;
    }

    private static int compareSec(IProvidesSourceElementCount p1, IProvidesSourceElementCount p2) {
        boolean p2External;
        assert (p1 != null) : "Parameter 'p1' of method 'compareAlpha' must not be null";
        assert (p2 != null) : "Parameter 'p2' of method 'compareAlpha' must not be null";
        boolean p1External = p1.getArchitecturalViewNode().isExternal();
        if (p1External == (p2External = p2.getArchitecturalViewNode().isExternal())) {
            boolean p1IsArtifact = p1.getArchitecturalViewNode() instanceof ArtifactPropertiesNode;
            boolean p2IsArtifact = p2.getArchitecturalViewNode() instanceof ArtifactPropertiesNode;
            int compare = 0;
            if (p1IsArtifact == p2IsArtifact) {
                compare = p2.getSourceElementCount() - p1.getSourceElementCount();
                if (compare == 0) {
                    compare = ArchitecturalViewNodeSorter.compareAlpha(p1.getArchitecturalViewNode(), p2.getArchitecturalViewNode());
                }
            } else {
                compare = p1IsArtifact ? -1 : 1;
            }
            return compare;
        }
        return p1External ? 1 : -1;
    }

    private static int compareLoc(IProvidesLinesOfCode p1, IProvidesLinesOfCode p2) {
        boolean p2External;
        assert (p1 != null) : "Parameter 'p1' of method 'compareLoc' must not be null";
        assert (p2 != null) : "Parameter 'p2' of method 'compareLoc' must not be null";
        boolean p1External = p1.getArchitecturalViewNode().isExternal();
        if (p1External == (p2External = p2.getArchitecturalViewNode().isExternal())) {
            boolean p1IsArtifact = p1.getArchitecturalViewNode() instanceof ArtifactPropertiesNode;
            boolean p2IsArtifact = p2.getArchitecturalViewNode() instanceof ArtifactPropertiesNode;
            int compare = 0;
            if (p1IsArtifact == p2IsArtifact) {
                compare = p2.getLinesOfCode() - p1.getLinesOfCode();
                if (compare == 0) {
                    compare = ArchitecturalViewNodeSorter.compareAlpha(p1.getArchitecturalViewNode(), p2.getArchitecturalViewNode());
                }
            } else {
                compare = p1IsArtifact ? -1 : 1;
            }
            return compare;
        }
        return p1External ? 1 : -1;
    }

    private static List<ArchitecturalViewNode> getNodeChildren(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'getNodeChildren' must not be null";
        if (element instanceof ExplorationViewRepresentation) {
            return new ArrayList<ArchitecturalViewNode>(((ExplorationViewRepresentation)element).getAllNodeChildren(n -> true, false));
        }
        assert (element != null && element instanceof ArchitecturalViewNode) : "Unexpected class in method 'sortByLoc': " + String.valueOf(element);
        return new ArrayList<ArchitecturalViewNode>(((ArchitecturalViewNode)element).getNodeChildren(n -> true, false));
    }

    private ArchitecturalViewNodeSorter() {
    }

    static void sortCreatedProgrammingElementNodes(IWorkerContext workerContext, List<ProgrammingElementNode> created, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'sortCreatedProgrammingElementNodes' must not be null";
        assert (created != null && !created.isEmpty()) : "Parameter 'created' of method 'sortCreatedProgrammingElementNodes' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'sortCreatedProgrammingElementNodes' must not be null";
        ArrayList<ProgrammingElementNode> sorted = new ArrayList<ProgrammingElementNode>(created);
        ExplorationViewSortMode sortMode = representation.getSortMode();
        switch (sortMode) {
            case ALPHA: 
            case LOC: {
                Collections.sort(sorted, new Comparator<ProgrammingElementNode>(){

                    @Override
                    public int compare(ProgrammingElementNode p1, ProgrammingElementNode p2) {
                        return ArchitecturalViewNodeSorter.compareAlpha(p1, p2);
                    }
                });
                break;
            }
            case SEC: {
                Collections.sort(sorted, new Comparator<ProgrammingElementNode>(){

                    @Override
                    public int compare(ProgrammingElementNode p1, ProgrammingElementNode p2) {
                        return ArchitecturalViewNodeSorter.compareSec(p1, p2);
                    }
                });
                break;
            }
            default: {
                assert (false) : "Unexpected sort mode: " + String.valueOf((Object)sortMode);
                break;
            }
        }
        int index = 0;
        for (ProgrammingElementNode next : sorted) {
            next.setRelativeIndex(index);
            ++index;
        }
    }

    private static void sortByLoc(ArchitecturalViewElement element, Counter counter, final Map<ArchitecturalViewNode, Counter> nodeToCounter) {
        assert (element != null) : "Parameter 'element' of method 'sortByLoc' must not be null";
        assert (nodeToCounter != null) : "Parameter 'nodeToCounter' of method 'sortByLoc' must not be null";
        List<ArchitecturalViewNode> nodeChildren = ArchitecturalViewNodeSorter.getNodeChildren(element);
        if (!nodeChildren.isEmpty()) {
            if (counter != null && !(element instanceof IProvidesLinesOfCode)) {
                for (ArchitecturalViewNode nextNode : nodeChildren) {
                    IProvidesLinesOfCode nextProvidesLinesOfCode = nextNode instanceof IProvidesLinesOfCode ? (IProvidesLinesOfCode)((Object)nextNode) : (IProvidesLinesOfCode)nodeToCounter.get(nextNode);
                    assert (nextProvidesLinesOfCode != null) : "'nextProvidesLinesOfCode' of method 'sortByLoc' must not be null";
                    counter.inc(nextProvidesLinesOfCode.getLinesOfCode());
                }
            }
            Collections.sort(nodeChildren, new Comparator<ArchitecturalViewNode>(){

                @Override
                public int compare(ArchitecturalViewNode n1, ArchitecturalViewNode n2) {
                    IProvidesLinesOfCode p1 = n1 instanceof IProvidesLinesOfCode ? (IProvidesLinesOfCode)((Object)n1) : (IProvidesLinesOfCode)nodeToCounter.get(n1);
                    if (!$assertionsDisabled && p1 == null) {
                        throw new AssertionError((Object)"'p1' of method 'compare' must not be null");
                    }
                    IProvidesLinesOfCode p2 = n2 instanceof IProvidesLinesOfCode ? (IProvidesLinesOfCode)((Object)n2) : (IProvidesLinesOfCode)nodeToCounter.get(n2);
                    if (!$assertionsDisabled && p2 == null) {
                        throw new AssertionError((Object)"'p2' of method 'compare' must not be null");
                    }
                    return ArchitecturalViewNodeSorter.compareLoc(p1, p2);
                }
            });
            int index = 0;
            for (ArchitecturalViewNode next : nodeChildren) {
                next.setRelativeIndex(index);
                ++index;
            }
        }
    }

    private static void sortBySec(ArchitecturalViewElement element, Counter counter, final Map<ArchitecturalViewNode, Counter> nodeToCounter) {
        assert (element != null) : "Parameter 'element' of method 'sortBySec' must not be null";
        assert (nodeToCounter != null) : "Parameter 'nodeToCounter' of method 'sortBySec' must not be null";
        List<ArchitecturalViewNode> nodeChildren = ArchitecturalViewNodeSorter.getNodeChildren(element);
        if (!nodeChildren.isEmpty()) {
            if (counter != null && !(element instanceof IProvidesSourceElementCount)) {
                for (ArchitecturalViewNode nextNode : nodeChildren) {
                    IProvidesSourceElementCount nextProvidesSourceElementCount = nextNode instanceof IProvidesSourceElementCount ? (IProvidesSourceElementCount)((Object)nextNode) : (IProvidesSourceElementCount)nodeToCounter.get(nextNode);
                    assert (nextProvidesSourceElementCount != null) : "'nextProvidesSourceElementCount' of method 'sortBySec' must not be null";
                    counter.inc(nextProvidesSourceElementCount.getSourceElementCount());
                }
            }
            Collections.sort(nodeChildren, new Comparator<ArchitecturalViewNode>(){

                @Override
                public int compare(ArchitecturalViewNode n1, ArchitecturalViewNode n2) {
                    IProvidesSourceElementCount p1 = n1 instanceof IProvidesSourceElementCount ? (IProvidesSourceElementCount)((Object)n1) : (IProvidesSourceElementCount)nodeToCounter.get(n1);
                    if (!$assertionsDisabled && p1 == null) {
                        throw new AssertionError((Object)"'p1' of method 'compare' must not be null");
                    }
                    IProvidesSourceElementCount p2 = n2 instanceof IProvidesSourceElementCount ? (IProvidesSourceElementCount)((Object)n2) : (IProvidesSourceElementCount)nodeToCounter.get(n2);
                    if (!$assertionsDisabled && p2 == null) {
                        throw new AssertionError((Object)"'p2' of method 'compare' must not be null");
                    }
                    return ArchitecturalViewNodeSorter.compareSec(p1, p2);
                }
            });
            int index = 0;
            for (ArchitecturalViewNode next : nodeChildren) {
                next.setRelativeIndex(index);
                ++index;
            }
        }
    }

    private static <K, V> Iterator<Map.Entry<K, V>> getReversedEntrySetIterator(LinkedHashMap<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.reverse(entries);
        return entries.iterator();
    }

    static void sortLeafNodes(IWorkerContext workerContext, List<ArchitecturalViewNode> leafNodes, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'sortLeafNodes' must not be null";
        assert (leafNodes != null && !leafNodes.isEmpty()) : "Parameter 'leafNodes' of method 'sortLeafNodes' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'sortLeafNodes' must not be null";
        ExplorationViewSortMode sortMode = representation.getSortMode();
        LOGGER.debug("Sort leaf nodes [" + String.valueOf((Object)sortMode) + "]");
        switch (sortMode) {
            case ALPHA: {
                representation.accept(new SortAlphaVisitor());
                break;
            }
            case LOC: {
                LinkedHashMap<ArchitecturalViewNode, Counter> parentToCounter = new LinkedHashMap<ArchitecturalViewNode, Counter>(500);
                representation.accept(new ParentCollector(parentToCounter, IProvidesLinesOfCode.class));
                Iterator<Map.Entry<ArchitecturalViewNode, Counter>> iter = ArchitecturalViewNodeSorter.getReversedEntrySetIterator(parentToCounter);
                while (iter.hasNext()) {
                    Map.Entry<ArchitecturalViewNode, Counter> nextEntry = iter.next();
                    ArchitecturalViewNodeSorter.sortByLoc(nextEntry.getKey(), nextEntry.getValue(), parentToCounter);
                }
                ArchitecturalViewNodeSorter.sortByLoc(representation, null, parentToCounter);
                break;
            }
            case SEC: {
                LinkedHashMap<ArchitecturalViewNode, Counter> elementToCounter = new LinkedHashMap<ArchitecturalViewNode, Counter>(500);
                representation.accept(new ParentCollector(elementToCounter, IProvidesSourceElementCount.class));
                Iterator<Map.Entry<ArchitecturalViewNode, Counter>> iter = ArchitecturalViewNodeSorter.getReversedEntrySetIterator(elementToCounter);
                while (iter.hasNext()) {
                    Map.Entry<ArchitecturalViewNode, Counter> nextEntry = iter.next();
                    ArchitecturalViewNodeSorter.sortBySec(nextEntry.getKey(), nextEntry.getValue(), elementToCounter);
                }
                ArchitecturalViewNodeSorter.sortBySec(representation, null, elementToCounter);
                break;
            }
            default: {
                assert (false) : "Unexpected sort mode: " + String.valueOf((Object)sortMode);
                break;
            }
        }
        LOGGER.debug("Sort leaf nodes [" + String.valueOf((Object)sortMode) + "] - done");
    }

    static final class Counter
    implements IProvidesSourceElementCount,
    IProvidesLinesOfCode {
        private final ArchitecturalViewNode m_node;
        private int m_counter = -1;

        Counter(ArchitecturalViewNode node) {
            assert (node != null) : "Parameter 'node' of method 'Counter' must not be null";
            this.m_node = node;
        }

        void inc(int inc) {
            if (inc != -1) {
                if (this.m_counter == -1) {
                    this.m_counter = 0;
                }
                this.m_counter += inc;
            }
        }

        int getCounter() {
            return this.m_counter;
        }

        @Override
        public ArchitecturalViewNode getArchitecturalViewNode() {
            return this.m_node;
        }

        @Override
        public int getLinesOfCode() {
            return this.m_counter;
        }

        @Override
        public int getSourceElementCount() {
            return this.m_counter;
        }
    }

    static final class ParentCollector
    extends ArchitecturalViewVisitor
    implements ArchitecturalViewNode.IVisitor {
        private final Map<ArchitecturalViewNode, Counter> m_parentToCounter;
        private final Class<? extends IProvidesCount> m_providerClass;

        ParentCollector(Map<ArchitecturalViewNode, Counter> parentToCounter, Class<? extends IProvidesCount> providerClass) {
            assert (parentToCounter != null) : "Parameter 'parentToCounter' of method 'SourceElementCountParentCollector' must not be null";
            assert (providerClass != null) : "Parameter 'providerClass' of method 'ParentCollector' must not be null";
            this.m_parentToCounter = parentToCounter;
            this.m_providerClass = providerClass;
        }

        @Override
        public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            if (!element.isSuppressed()) {
                Counter counter = this.m_providerClass.isAssignableFrom(element.getClass()) ? null : new Counter(element);
                Counter previous = this.m_parentToCounter.put(element, counter);
                assert (previous == null) : "'previous' of method 'visitArchitecturalViewNode' must be null";
            }
            this.visitChildrenOf(element);
        }
    }

    static final class SortAlphaVisitor
    extends ArchitecturalViewVisitor {
        SortAlphaVisitor() {
        }

        private void sort(ArchitecturalViewElement element) {
            assert (element != null) : "Parameter 'element' of method 'sort' must not be null";
            List<ArchitecturalViewNode> children = ArchitecturalViewNodeSorter.getNodeChildren(element);
            if (!children.isEmpty()) {
                ArrayList<ArchitecturalViewNode> sorted = new ArrayList<ArchitecturalViewNode>(children);
                Collections.sort(sorted, new Comparator<ArchitecturalViewNode>(){

                    @Override
                    public int compare(ArchitecturalViewNode n1, ArchitecturalViewNode n2) {
                        if (!$assertionsDisabled && n1 == null) {
                            throw new AssertionError((Object)"Parameter 'n1' of method 'compare' must not be null");
                        }
                        if (!$assertionsDisabled && n2 == null) {
                            throw new AssertionError((Object)"Parameter 'n2' of method 'compare' must not be null");
                        }
                        return ArchitecturalViewNodeSorter.compareAlpha(n1, n2);
                    }
                });
                int index = 0;
                for (ArchitecturalViewNode next : sorted) {
                    next.setRelativeIndex(index);
                    ++index;
                }
            }
        }

        @Override
        public void visitArchitecturalViewElement(ArchitecturalViewElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewElement' must not be null";
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            if (!element.isSuppressed()) {
                this.sort(element);
            }
            this.visitChildrenOf(element);
        }
    }
}

