/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.javapg.runtime.messaging.MessageReporter;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Node;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureFileNameReplaceStrategy;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureParser;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureVisitor;
import com.hello2morrow.sonargraph.core.controller.system.architecture.IReplaceStrategy;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IPhysicalArchitectureElement;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplyAndRequireSupport
extends ArchitectureVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplyAndRequireSupport.class);
    private final Collection<String> m_names;
    private final List<Node> m_stringNodes = new ArrayList<Node>();

    private ApplyAndRequireSupport(Collection<String> names) {
        assert (names != null && !names.isEmpty()) : "Parameter 'names' of method 'ApplyAndRequireSupport' must not be null";
        this.m_names = names;
    }

    @Override
    public void visitApplyDecl(InnerNode arg) {
        this.checkNode(arg);
    }

    @Override
    public void visitRequireDecl(InnerNode arg) {
        this.checkNode(arg);
    }

    private void checkNode(InnerNode arg) {
        Node node = arg.getChild("STRING");
        assert (node != null);
        String fileName = node.getLexeme();
        assert (fileName != null && fileName.length() >= 2);
        fileName = fileName.substring(1, fileName.length() - 1);
        if (this.m_names.contains(fileName = FileUtility.removeExtension((String)fileName))) {
            this.m_stringNodes.add(node);
        }
    }

    private List<Node> getStringNodes() {
        return new ArrayList<Node>(this.m_stringNodes);
    }

    private int getOccurrences() {
        return this.m_stringNodes.size();
    }

    private void reset() {
        this.m_stringNodes.clear();
    }

    private static String replace(String content, List<Node> nodes, IReplaceStrategy replaceStrategy) {
        assert (content != null && content.length() > 0) : "Parameter 'content' of method 'replace' must not be empty";
        assert (nodes != null) : "Parameter 'nodes' of method 'replace' must not be null";
        assert (replaceStrategy != null) : "Parameter 'replaceStrategy' of method 'replace' must not be null";
        Collections.reverse(nodes);
        StringBuilder sb = new StringBuilder(content);
        for (Node node : nodes) {
            Position position = node.getPosition();
            sb.replace(position.getOffset(), position.getOffset() + position.getLength(), replaceStrategy.replace(node.getLexeme()));
        }
        return sb.toString();
    }

    private static void applyVisitor(ApplyAndRequireSupport visitor, final ArchitectureFile architectureFile) {
        assert (visitor != null) : "Parameter 'visitor' of method 'applyVisitor' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'applyVisitor' must not be null";
        ArchitectureParser parser = new ArchitectureParser(new MessageReporter(){

            public void reportMessage(int severity, Position pos, String msg) {
                LOGGER.warn("{}: '{}' in architecture file {} at line {} position {}", new Object[]{severity, msg, architectureFile, pos.getLine(), pos.getColumn()});
                LOGGER.warn("###" + StringUtility.showWhitespace((String)architectureFile.getContent()) + "###");
            }
        });
        try {
            InnerNode root = parser.parse(new StringReader(architectureFile.getContent()), architectureFile.getName());
            if (root != null) {
                visitor.reset();
                root.accept((Visitor)visitor);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Parsing architecture file " + String.valueOf(architectureFile), (Throwable)e);
        }
    }

    private static Collection<String> getNames(Collection<? extends IPhysicalArchitectureElement> elements) {
        ArrayList<String> result = new ArrayList<String>();
        for (IPhysicalArchitectureElement iPhysicalArchitectureElement : elements) {
            result.addAll(iPhysicalArchitectureElement.getApplyNames());
        }
        return result;
    }

    private static Map<String, String> getNamesChangeMap(Collection<? extends IPhysicalArchitectureElement> elements, DirectoryPath targetDirectory) {
        HashMap<String, String> result = new HashMap<String, String>();
        Object targetDirectoryPath = targetDirectory instanceof Architecture ? "" : targetDirectory.getIdentifyingPath() + "/";
        for (IPhysicalArchitectureElement iPhysicalArchitectureElement : elements) {
            result.putAll(iPhysicalArchitectureElement.getNameChangeMapForMove((String)targetDirectoryPath));
        }
        return result;
    }

    public static Map<ArchitectureFile, String> processApplyAndRequireStatementsForMove(List<ArchitectureFile> availableArchitectureFiles, List<? extends IPhysicalArchitectureElement> elements, DirectoryPath targetDirectory) {
        assert (availableArchitectureFiles != null) : "Parameter 'availableArchitectureFiles' of method 'processApplyAndRequireStatementsForMove' must not be null";
        assert (elements != null && elements.size() > 0) : "Parameter 'elements' of method 'changeApplyStatementsForMove' must not be empty";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'processApplyStatementsForMove' must not be null";
        HashMap<ArchitectureFile, String> result = new HashMap<ArchitectureFile, String>();
        ApplyAndRequireSupport visitor = new ApplyAndRequireSupport(ApplyAndRequireSupport.getNames(elements));
        Map<String, String> applyMap = ApplyAndRequireSupport.getNamesChangeMap(elements, targetDirectory);
        for (ArchitectureFile nextArchitectureFile : availableArchitectureFiles) {
            ApplyAndRequireSupport.applyVisitor(visitor, nextArchitectureFile);
            if (visitor.getOccurrences() <= 0) continue;
            ArchitectureFileNameReplaceStrategy replaceStrategy = new ArchitectureFileNameReplaceStrategy(applyMap);
            String newContent = ApplyAndRequireSupport.replace(nextArchitectureFile.getContent(), visitor.getStringNodes(), replaceStrategy);
            result.put(nextArchitectureFile, newContent);
        }
        return result;
    }

    public static Map<ArchitectureFile, String> processApplyAndRequireStatements(List<ArchitectureFile> availableArchitectureFiles, IPhysicalArchitectureElement renamedArchitectureElement, String newName) {
        assert (availableArchitectureFiles != null) : "Parameter 'availableArchitectureFiles' of method 'processApplyAndRequireStatements' must not be null";
        assert (renamedArchitectureElement != null) : "Parameter 'renamedArchitectureFile' of method 'changeApplyStatements' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'processApplyStatements' must not be null";
        HashMap<ArchitectureFile, String> result = new HashMap<ArchitectureFile, String>();
        ApplyAndRequireSupport visitor = new ApplyAndRequireSupport(renamedArchitectureElement.getApplyNames());
        Map<String, String> applyMap = renamedArchitectureElement.getNameChangeMap(newName);
        for (ArchitectureFile nextArchitectureFile : availableArchitectureFiles) {
            if (nextArchitectureFile == renamedArchitectureElement) continue;
            ApplyAndRequireSupport.applyVisitor(visitor, nextArchitectureFile);
            if (visitor.getOccurrences() <= 0) continue;
            ArchitectureFileNameReplaceStrategy replaceStrategy = new ArchitectureFileNameReplaceStrategy(applyMap);
            String newContent = ApplyAndRequireSupport.replace(nextArchitectureFile.getContent(), visitor.getStringNodes(), replaceStrategy);
            result.put(nextArchitectureFile, newContent);
        }
        return result;
    }

    public static Collection<ArchitectureFile> getApplyingAndRequiringFiles(List<ArchitectureFile> availableArchitectureFiles, Collection<? extends IPhysicalArchitectureElement> architectureElements) {
        assert (availableArchitectureFiles != null) : "Parameter 'availableArchitectureFiles' of method 'getApplyingAndRequiringFiles' must not be null";
        assert (architectureElements != null && !architectureElements.isEmpty()) : "Parameter 'architectureElements' of method 'getApplyingFiles' must not be empty";
        ArrayList<ArchitectureFile> result = new ArrayList<ArchitectureFile>();
        ApplyAndRequireSupport visitor = new ApplyAndRequireSupport(ApplyAndRequireSupport.getNames(architectureElements));
        for (ArchitectureFile other : availableArchitectureFiles) {
            if (architectureElements.size() <= 1 && architectureElements.contains(other)) continue;
            ApplyAndRequireSupport.applyVisitor(visitor, other);
            if (visitor.getOccurrences() <= 0) continue;
            result.add(other);
        }
        return result;
    }
}

